/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSumFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterCheckSumListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InterCheckNewListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InterCheckSumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;

public class InterCheckSumListUI
extends AbstractInterCheckSumListUI
implements ICSLContextUI {
    private static final String TOTAL_ROW_ID = "zzzzzzzzzzzz";
    private InterCheckSumFilterUI queryPanel = new InterCheckSumFilterUI();
    private ArrayList currencyList = new ArrayList();
    private int currencyIndex;
    ICSLContext ctx = CSLContextHelper.getCSLContext();
    private int mergeType;

    public InterCheckSumListUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.tblMain);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            CSLSysParamanager paramnager = CSLContextHelper.getSysParamanager();
            if (paramnager != null) {
                this.mergeType = paramnager.getMergeType();
            }
            if (this.mergeType == -1) {
                throw new AdjustException(AdjustException.PLEASE_SET_SYSPARAMS);
            }
        } else {
            SysUtil.abort();
        }
        Map uiContext = this.getUIContext();
        if (uiContext.containsKey("currencyId")) {
            String currencyId = (String)uiContext.get("currencyId");
            if (this.pp == null) {
                this.pp = new RptProperties();
            }
            if (StringUtils.isEmpty((String)currencyId)) {
                this.pp.setString("currencyId", "all");
            } else {
                this.pp.setString("currencyId", currencyId);
            }
        }
        super.onLoad();
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.setDecimalFormat();
        this.menuView.setMnemonic('V');
    }

    private void setDecimalFormat() {
        this.tblMain.getColumn("comeA").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("goA").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("sumA").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("comeB").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("goB").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("sumB").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("diff").getStyleAttributes().setNumberFormat("#,##0.00");
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    @Override
    public IRptBase getInitRemoteInstance() throws BOSException {
        return InterCheckSumFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getPrintTable() {
        return this.tblMain;
    }

    @Override
    protected Variant getPrintVariant(String varName) {
        return null;
    }

    @Override
    public void query(Object condition) {
        this.pp = (RptProperties)condition;
        super.doLayout();
        this.tblMain.removeRows();
    }

    @Override
    public Object afterQueryConditionChange(Object condition) throws Exception {
        this.pp = (RptProperties)super.afterQueryConditionChange(condition);
        this.currencyList.clear();
        this.getUIContext().put("currencyId", this.pp.getString("currencyId"));
        if (this.pp.getString("currencyId").equals("all")) {
            CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
            for (int i = 0; i < currencies.size(); ++i) {
                this.currencyList.add(currencies.get(i).getId().toString());
            }
            this.currencyIndex = 0;
            this.pp.setString("currencyId", (String)this.currencyList.get(this.currencyIndex));
        } else {
            this.currencyList.add(this.pp.getString("currencyId"));
            this.currencyIndex = 0;
        }
        this.btnFirst.setEnabled(false);
        this.btnPre.setEnabled(false);
        if (this.currencyList.size() <= 1) {
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else {
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        }
        return this.pp;
    }

    @Override
    public CslBaseConditionUI getQueryDialogUserPanel() {
        return this.queryPanel;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query(this.pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            this.pp.setInt("from", from);
            this.pp.setInt("length", length);
            this.pp.setInt("MERGETYPE", this.mergeType);
            this.pp.setBoolean("showZeroDiff", this.pp.getBoolean("showZeroDiff"));
            this.pp.setString("authicateSql", this.getAuthenticUnits());
            this.pp.setBoolean("isQueryHisBudget", (Boolean)this.ctx.isQueryBudget());
            if (from == 0) {
                RptRowSet rst = InterCheckSumFactory.getRemoteInstance().createInterCheckSumTempTable(this.pp);
                String tableName = (String)rst.getProperty("tableName");
                this.pp.setString("tableName", tableName);
                String currencyName = (String)rst.getProperty("currencyName");
                this.txtCurrency.setText(currencyName);
            }
            boolean showZeroDiff = this.pp.getBoolean("showZeroDiff");
            RptRowSet rst = InterCheckSumFactory.getRemoteInstance().queryInterCheckSum(this.pp.getString("tableName"), from, length, showZeroDiff);
            if (from == 0) {
                this.tblMain.setRowCount(rst.getVirtualRowCount());
            }
            KDTableUtil.insertRows((Object[][])rst.toArray(), null, (int)from, (KDTable)this.tblMain);
            if (rst.getRowCount() > 0) {
                int countRowIndex = from + rst.getRowCount() - 1;
                rst.moveTo(rst.getRowCount() - 1);
                String recordType = rst.getString("companyId");
                if (recordType.equals(TOTAL_ROW_ID)) {
                    IRow row = this.tblMain.getRow(countRowIndex);
                    row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
                    row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                }
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (ReportBizException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
            this.close();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    @Override
    public void actionViewCheckDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewCheckDetail_actionPerformed(e);
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"checkDetail", (Object)new Boolean(true));
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        String currencyId = this.pp.getString("currencyId");
        uiContext.put((Object)"currencyId", (Object)currencyId);
        int rowindex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowindex);
        ICell cell = row.getCell(0);
        String companyId = (String)cell.getValue();
        if (StringUtils.equals((String)companyId, (String)TOTAL_ROW_ID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CannotSelecteTotal"));
            SysUtil.abort();
        }
        uiContext.put((Object)"companyId", (Object)companyId);
        cell = row.getCell(2);
        String targetCompanyId = (String)cell.getValue();
        uiContext.put((Object)"targetCompanyId", (Object)targetCompanyId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(InterCheckNewListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.btnFirst.setEnabled(false);
        this.btnPre.setEnabled(false);
        this.btnNext.setEnabled(true);
        this.btnLast.setEnabled(true);
        this.currencyIndex = 0;
        this.pp.setString("currencyId", (String)this.currencyList.get(this.currencyIndex));
        this.query(this.pp);
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        if (this.currencyIndex == this.currencyList.size() - 1) {
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        }
        --this.currencyIndex;
        if (this.currencyIndex == 0) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
        }
        this.pp.setString("currencyId", (String)this.currencyList.get(this.currencyIndex));
        this.query(this.pp);
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (this.currencyIndex == 0) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
        }
        ++this.currencyIndex;
        if (this.currencyIndex == this.currencyList.size() - 1) {
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        }
        this.pp.setString("currencyId", (String)this.currencyList.get(this.currencyIndex));
        this.query(this.pp);
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.btnFirst.setEnabled(true);
        this.btnPre.setEnabled(true);
        this.btnNext.setEnabled(false);
        this.btnLast.setEnabled(false);
        this.currencyIndex = this.currencyList.size() - 1;
        this.pp.setString("currencyId", (String)this.currencyList.get(this.currencyIndex));
        this.query(this.pp);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.pp.setString("currencyId", (String)this.getUIContext().get("currencyId"));
        super.actionQuery_actionPerformed(e);
    }

    @Override
    protected void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
        String tableName = this.pp.getString("tableName");
        if (tableName != null) {
            try {
                InterCheckSumFactory.getRemoteInstance().releaseTempTable(tableName);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private String getAuthenticUnits() {
        StringBuffer sbSql = new StringBuffer();
        String tableAliasName = "ENTRIES";
        try {
            OrgUnitInfo uif;
            String companyId;
            OrgUnitInfo companyInfo = null;
            if (this.pp.containsKey("company") && this.pp.getObject("company") != null) {
                companyId = (String)this.pp.getObject("company");
                companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            if ((uif = companyInfo != null ? companyInfo : this.ctx.getCurOrgGroup()).isIsGrouping()) {
                ArrayList arr = new ArrayList();
                arr = CslRptUtil.getAuthenticUnits(this.ctx.getCurOrgBound().getId().toString(), uif.getId().toString(), (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "InterCheckNewListUI"), (IMetaDataPK)new MetaDataPK("actionView"), 1);
                OrgUnitInfo ouif = null;
                int arraySize = arr.size();
                if (arraySize > 0) {
                    sbSql.append(" and (");
                }
                for (int i = 0; i < arraySize; ++i) {
                    ouif = (OrgUnitInfo)arr.get(i);
                    if (i > 0) {
                        sbSql.append("  or  ");
                    }
                    String companyId2 = ouif.getId().toString();
                    sbSql.append(tableAliasName).append(".FCompanyID = '").append(companyId2).append("'");
                    sbSql.append(" or ").append(tableAliasName).append(".FTargetCompanyID = '").append(companyId2).append("'");
                }
                if (arraySize > 0) {
                    sbSql.append(" ) ");
                }
            } else {
                companyId = uif.getId().toString();
                sbSql.append(" and (");
                sbSql.append(tableAliasName).append(".FCompanyID = '").append(companyId).append("'");
                sbSql.append(" or ").append(tableAliasName).append(".FTargetCompanyID = '").append(companyId).append("'");
                sbSql.append(" ) ");
            }
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        return sbSql.toString();
    }
}

