/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInvestDataConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Dimension;
import org.apache.log4j.Logger;

public class InvestDataConditionUI
extends AbstractInvestDataConditionUI {
    private static final Logger logger = Logger.getLogger(InvestDataConditionUI.class);
    private boolean hasLoadInitData;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
            this.pp.setObject("day", this.ctx.getCurReportDate());
        }
    }

    private void fillDataToUI() {
        String companyId;
        String toCurrencyId;
        CurrencyInfo currencyInfo;
        int j;
        String fromCurrencyId;
        this.clearUI();
        this.comboFromCurrency.removeAllItems();
        this.comboToCurrency.removeAllItems();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.comboFromCurrency.addItem((Object)this.selectAll);
        this.comboFromCurrency.setSelectedIndex(0);
        this.comboToCurrency.addItem((Object)this.selectAll);
        this.comboToCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.pp.setObject("allCurrency", currencyCollection);
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.comboFromCurrency.addItems(currencyCollection.toArray());
            this.comboToCurrency.addItems(currencyCollection.toArray());
        }
        if (this.pp.containsKey("fromCurrency") && (fromCurrencyId = this.pp.getString("fromCurrency")) != null) {
            for (j = 1; j < this.comboFromCurrency.getItemCount(); ++j) {
                currencyInfo = (CurrencyInfo)this.comboFromCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.comboFromCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("toCurrency") && (toCurrencyId = this.pp.getString("toCurrency")) != null) {
            for (j = 1; j < this.comboFromCurrency.getItemCount(); ++j) {
                currencyInfo = (CurrencyInfo)this.comboToCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(toCurrencyId)) continue;
                this.comboToCurrency.setSelectedIndex(j);
                break;
            }
        }
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.prmtFromCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            this.prmtFromCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            this.prmtFromCompany.setSelector((KDPromptSelector)f7);
            this.prmtFromCompany.setEditable(true);
            this.prmtToCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            this.prmtToCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            this.prmtToCompany.setSelector((KDPromptSelector)f7);
            this.prmtToCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (this.pp.containsKey("fromCompany") && this.pp.getObject("fromCompany") != null) {
            companyId = (String)this.pp.getObject("fromCompany");
            try {
                FullOrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.prmtFromCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("toCompany") && this.pp.getObject("toCompany") != null) {
            companyId = (String)this.pp.getObject("toCompany");
            try {
                FullOrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.prmtToCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public RptProperties getCustomCondition() {
        try {
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
            this.pp.setObject("day", this.ctx.getCurReportDate());
        }
        catch (BOSException e) {
            logger.error((Object)"getCustomCondition_BOSException", (Throwable)e);
        }
        this.pp.setString("fromCompany", this.prmtFromCompany.getValue() == null ? null : ((OrgUnitInfo)this.prmtFromCompany.getValue()).getId().toString());
        this.pp.setString("toCompany", this.prmtToCompany.getValue() == null ? null : ((OrgUnitInfo)this.prmtToCompany.getValue()).getId().toString());
        this.pp.setString("fromCurrency", this.comboFromCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.comboFromCurrency.getSelectedItem()).getId().toString());
        this.pp.setString("toCurrency", this.comboToCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.comboToCurrency.getSelectedItem()).getId().toString());
        this.pp.setBoolean("isSelectMode", (Boolean)this.chkByToCompany.isSelected());
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.fillDataToUI();
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    private void clearUI() {
        this.prmtFromCompany.setValue(null);
        this.prmtToCompany.setValue(null);
        this.comboFromCurrency.setSelectedItem((Object)this.selectAll);
        this.comboToCurrency.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public boolean verify() {
        return true;
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }
}

