/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AbstractInvestDayEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AbstractInvestDayInvestOwnerEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.CombineTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDay;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDayEntry;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDayInvestOwnerEntry;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInvestOwnerEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInvestOwnerEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInvestOwnerEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInvestDayEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InvestDayEntryUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InvestMoneyUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class InvestDayEditUI
extends AbstractInvestDayEditUI {
    public static final String UICTX_KEY_CONTROLATTR = "CONTROLATTR";
    public static final String UICTX_KEY_ISCHANGEBEFORE = "ISCHANGEBEFOR";
    public static final String UICTX_KEY_DATAELEMENT = "DATAELEMENT";
    public static final String UICTX_KEY_STATUS = "STATUS";
    public static final String UICTX_KEY_INVESTDAY = "INVESTDAY";
    public static final String UICTX_KEY_SUMVALUE = "SUMVALUE";
    public static final String UICTX_KEY_SUBITEMS = "SUBITMES";
    public static final int PRECISION = 4;
    public static final int INVEST_PRECISION = 13;
    private BigDecimal lastSumInvestAmount = new BigDecimal("0");
    private BigDecimal lastSumInvestRate = new BigDecimal("0");
    private BigDecimal lastHonorSum = new BigDecimal("0");
    private boolean isFirstInvest = true;
    BigDecimal oldInvestRate;
    private java.util.Date lastChangeDate;
    private InvestDayEntryCollection ownerSumNewItems;
    private InvestDayInvestOwnerEntryCollection ownerSumNewItemsOwnerAfter;
    private InvestDayInvestOwnerEntryCollection ownerSumNewItemsOwnerBefore;
    private BigDecimal sumDiff;
    private InvestDayEntryCollection ownerSumOldItems;
    private InvestDayEntryCollection profitItems;
    private int times = 0;
    private String memory = "";
    private InvestDayCollection col = null;
    private boolean isFirstOpen = true;
    private String highMaintainLowLevel = "true";

    public InvestDayEditUI() throws Exception {
        this.btnOwnerSumNew.setIcon(EASResource.getIcon((String)"imgTbtn_formuladefine"));
        this.btnOwnerSumOld.setIcon(EASResource.getIcon((String)"imgTbtn_formuladefine"));
        this.btnProfit.setIcon(EASResource.getIcon((String)"imgTbtn_formuladefine"));
        this.btnAfterInvest.setIcon(EASResource.getIcon((String)"imgTbtn_formuladefine"));
        this.btnBeforeInvest.setIcon(EASResource.getIcon((String)"imgTbtn_formuladefine"));
    }

    @Override
    public void loadFields() {
        BigDecimal rate;
        super.loadFields();
        if (this.editData.getCurrency() != null) {
            BOSUuid cid = this.editData.getCurrency().getId();
            for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
                CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                if (!cid.equals((Object)currency.getId())) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.oldInvestRate = rate = this.editData.getInvestRate();
        if (rate != null) {
            rate = rate.multiply(new BigDecimal(100.0));
        }
        this.txtInvestRate.setValue((Object)rate);
        rate = this.editData.getSumInvestRate();
        if (rate != null) {
            rate = rate.multiply(new BigDecimal(100.0));
        }
        this.txtSumInvestRate.setValue((Object)rate);
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        java.util.Date changedate = this.editData.getChangeDate();
        this.editData.setChangeDate(RPTDateUtil.getBeginOfDay(changedate));
        this.editData.setInvestRate(this.getInvestRate());
        this.editData.setSumInvestRate(this.getSumInvestRate());
        this.editData.setTrackRecordCreator(SysContext.getSysContext().getCurrentFIUnit());
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(this.editData.getCurrency().getId());
        this.editData.setCurrency(currency);
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo curCompany;
        BOSUuid id;
        super.onLoad();
        this.highMaintainLowLevel = ParamManager.getParamValue(null, null, (String)"GR_CSL_HIGHERUPFINANCEORGMAINTAINLOWERLEVEVL");
        this.isCanMainTainRecord();
        this.menuSubmitOption.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        if (this.highMaintainLowLevel.equals("true")) {
            CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtCompany, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        } else {
            HashSet<String> disablePermSet = new HashSet<String>();
            disablePermSet.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            NewOrgViewF7PromptDialog f7 = CompanyF7Helper.getDisablePermCompanyBizUnitF7(disablePermSet);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            f7.setNeedAddOrgRange(false);
            this.prmtCompany.setSelector((KDPromptSelector)f7);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtCompany.setEntityViewInfo(view);
            this.prmtCompany.setEditable(true);
        }
        CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtTargetCompany, (boolean)false, (boolean)true, null);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem);
        CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view, true);
        BOSUuid bOSUuid = id = this.editData.getCurrency() != null ? this.editData.getCurrency().getId() : null;
        if (id == null && (curCompany = SysContext.getSysContext().getCurrentFIUnit()) != null && curCompany.getBaseCurrency() != null) {
            id = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId();
        }
        int i = 0;
        for (CurrencyInfo currency : currencies) {
            this.comboCurrency.addItem((Object)currency);
            if (currency.getId().equals((Object)id)) {
                this.comboCurrency.setSelectedIndex(i);
            }
            ++i;
        }
        this.txtInvestRate.setPrecision(13);
        this.txtInvestRate.setMaximumValue((Comparable)new BigDecimal(100.0));
        this.txtInvestRate.setMinimumValue((Comparable)new BigDecimal(-100.0));
        this.txtSumInvestRate.setPrecision(13);
        this.txtSumInvestRate.setMaximumValue((Comparable)new BigDecimal(100.0));
        this.txtSumInvestRate.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.txtInvestAmount.setMaximumValue((Comparable)new BigDecimal("1000000000000"));
        this.txtInvestAmount.setMinimumValue((Comparable)new BigDecimal("-1000000000000"));
        this.txtInvestAmount.setHorizontalAlignment(4);
        this.txtInvestRate.setHorizontalAlignment(4);
        this.txtSumInvestAmout.setHorizontalAlignment(4);
        this.txtSumInvestRate.setHorizontalAlignment(4);
        this.txtOwnerSumNew.setHorizontalAlignment(4);
        this.txtOwnerSumOld.setHorizontalAlignment(4);
        this.txtProfit.setHorizontalAlignment(4);
        this.txtHonor.setHorizontalAlignment(4);
        this.txtHonor.setPrecision(4);
        this.txtHonor.setDataType(1);
        this.txtHonor.setMaximumValue((Comparable)new BigDecimal("1000000000000"));
        this.txtHonor.setMinimumValue((Comparable)new BigDecimal("-1000000000000"));
        this.txtHonorSum.setHorizontalAlignment(4);
        this.txtHonorSum.setPrecision(4);
        this.txtHonorSum.setMaximumValue((Comparable)new BigDecimal("1000000000000"));
        this.txtHonor.setMinimumValue((Comparable)new BigDecimal("-1000000000000"));
        this.txtMinorityChange.setHorizontalAlignment(4);
        this.txtAfterInvestMon.setHorizontalAlignment(4);
        this.txtBeforeInvestMon.setHorizontalAlignment(4);
        this.txtInvestAudit.setHorizontalAlignment(4);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
            this.btnCopy.setEnabled(false);
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
            this.loadLastSumDatas();
            this.pkChangeDate.setEnabled(false);
        }
        this.invokeChangeEvent();
    }

    private void isCanMainTainRecord() throws EASBizException, BOSException {
        if (this.getUIContext().get("ID") != null) {
            String id = this.getUIContext().get("ID").toString();
            InvestDayInfo info = InvestDayFactory.getRemoteInstance().getInvestDayInfo("select trackRecordCreator where id='" + id + "'");
            String recordId = info.getTrackRecordCreator() == null ? "" : info.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                if (!this.getOprtState().equals(OprtState.EDIT)) {
                    this.actionEdit.setEnabled(true);
                }
                this.actionRemove.setEnabled(true);
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
        }
    }

    private void invokeChangeEvent() throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.isFirstOpen = false;
            this.pkChangeDate_dataChanged(null);
            this.comboCurrency_actionPerformed(null);
        } else {
            this.isFirstOpen = false;
            this.prmtCompany_dataChanged(null);
            this.prmtTargetCompany_dataChanged(null);
            this.pkChangeDate_dataChanged(null);
            this.txtSumInvestRate_dataChanged(null);
            this.txtHonor_dataChanged(null);
            this.txtOwnerSumNew_dataChanged(null);
            this.txtOwnerSumOld_dataChanged(null);
            this.comboCurrency_actionPerformed(null);
        }
    }

    private void initEditOwnerSum() throws UIException {
        BigDecimal value = null;
        InvestDayEntryUI ui = null;
        value = this.txtOwnerSumNew.getBigDecimalValue();
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        uiCtx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(false));
        uiCtx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        uiCtx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        uiCtx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumNewItems);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestDayEntryUI.class.getName(), (Map)uiCtx, null);
        ui = (InvestDayEntryUI)uiWindow.getUIObject();
        this.ownerSumNewItems = ui.getSubItems();
        this.txtOwnerSumNew.setValue((Object)ui.getSumValue());
        value = this.txtOwnerSumOld.getBigDecimalValue();
        UIContext uiCtxOld = new UIContext((Object)this);
        uiCtxOld.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        uiCtxOld.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(true));
        uiCtxOld.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        uiCtxOld.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtxOld.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtxOld.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        uiCtxOld.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumOldItems);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestDayEntryUI.class.getName(), (Map)uiCtxOld, null);
        ui = (InvestDayEntryUI)uiWindow.getUIObject();
        this.ownerSumOldItems = ui.getSubItems();
        this.txtOwnerSumOld.setValue((Object)ui.getSumValue());
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.pkChangeDate.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_ChangeDateIsNull")));
        }
        if (this.prmtCompany.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_CompanyIsNull")));
        }
        if (this.prmtTargetCompany.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_TargetCompanyIsNull")));
        }
        if (((CompanyOrgUnitInfo)this.prmtCompany.getData()).getName().equalsIgnoreCase(((CompanyOrgUnitInfo)this.prmtTargetCompany.getData()).getName())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_CompanyIsRepeat")));
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Currency_Blank")));
        }
        if (this.txtInvestAmount.getBigDecimalValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_AmountIsNull")));
        }
        if (this.txtInvestRate.getBigDecimalValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_RateIsNull")));
        }
        if (this.txtSumInvestRate.getBigDecimalValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_SumRateIsNull")));
        }
        this.txtInvestAmount_dataChanged(null);
        this.computeMinorityChange();
        if (this.txtOwnerSumOld.getBigDecimalValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_OwnerSumOldIsNull")));
        }
        if (this.txtOwnerSumNew.getBigDecimalValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_OwnerSumNewIsNull")));
        }
        if (this.txtProfit.getBigDecimalValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_ProfitIsNull")));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.loadLastSumDatas();
        if (this.lastChangeDate != null && !DateTimeUtils.dayBefore((java.util.Date)this.lastChangeDate, (java.util.Date)this.editData.getChangeDate())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_ChangeDateError")));
        }
        if (this.txtSumInvestAmout.getBigDecimalValue().doubleValue() < 0.0) {
            this.txtInvestAmount.grabFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_SumInvestAmountIsNegative")));
        }
        CompanyOrgUnitInfo targetCompany = (CompanyOrgUnitInfo)this.prmtTargetCompany.getData();
        Date changeDate = this.pkChangeDate.getSqlDate();
        boolean isAddNew = this.getOprtState().equals(OprtState.ADDNEW);
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        param.put("isAddnew", new Boolean(isAddNew));
        if (!isAddNew) {
            param.put("editData", this.editData);
        } else {
            param.put("editData", null);
        }
        ((IInvestDay)this.getBizInterface()).checkCombineTypeConstant((IObjectValue)targetCompany, changeDate, (CombineTypeEnum)((Object)this.cmbCombine.getSelectedItem()), param);
    }

    @Override
    protected void txtInvestAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtInvestAmount_dataChanged(e);
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        BigDecimal investAmount = this.txtInvestAmount.getBigDecimalValue() != null ? this.txtInvestAmount.getBigDecimalValue() : new BigDecimal(0.0);
        BigDecimal sumInvestAmount = this.lastSumInvestAmount.add(investAmount);
        this.txtSumInvestAmout.setValue((Object)sumInvestAmount);
        this.computeHonor();
    }

    @Override
    protected void txtSumInvestRate_focusLost(FocusEvent e) throws Exception {
        super.txtSumInvestRate_focusLost(e);
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        BigDecimal rate = this.getSumInvestRate();
        if (rate != null && rate.doubleValue() < 0.0) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_SumInvestRateIsNegative")));
        }
        this.computeHonor();
        this.computeMinorityChange();
    }

    @Override
    protected void txtSumInvestRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtSumInvestRate_dataChanged(e);
        if (!this.isFirstOpen) {
            boolean isAddNew = false;
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                isAddNew = true;
            }
            this.afterInvstMon(false, isAddNew);
            this.beforeInvestMon(false, isAddNew);
        }
    }

    @Override
    protected void txtOwnerSumNew_dataChanged(DataChangeEvent e) throws Exception {
        super.txtOwnerSumNew_dataChanged(e);
        if (!this.isFirstOpen) {
            this.computeHonor();
            this.computeMinorityChange();
            boolean isAddNew = false;
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                isAddNew = true;
            }
            this.afterInvstMon(false, isAddNew);
        }
    }

    @Override
    protected void txtOwnerSumOld_dataChanged(DataChangeEvent e) throws Exception {
        super.txtOwnerSumOld_dataChanged(e);
        if (!this.isFirstOpen) {
            this.computeHonor();
            this.computeMinorityChange();
            boolean isAddNew = false;
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                isAddNew = true;
            }
            this.beforeInvestMon(false, isAddNew);
        }
    }

    private void computeHonor() {
        BigDecimal investAmount = new BigDecimal("0");
        if (this.txtInvestAmount.getBigDecimalValue() != null) {
            investAmount = this.txtInvestAmount.getBigDecimalValue();
        }
        BigDecimal afterInvestMon = new BigDecimal("0");
        if (this.txtAfterInvestMon != null && this.txtAfterInvestMon.getBigDecimalValue() != null) {
            afterInvestMon = this.txtAfterInvestMon.getBigDecimalValue();
        }
        BigDecimal beforeInvestMon = new BigDecimal("0");
        if (this.txtBeforeInvestMon != null && this.txtBeforeInvestMon.getBigDecimalValue() != null) {
            beforeInvestMon = this.txtBeforeInvestMon.getBigDecimalValue();
        }
        BigDecimal value = investAmount.subtract(afterInvestMon).add(beforeInvestMon);
        this.txtHonor.setValue((Object)value);
    }

    private void computeMinorityChange() throws EASBizException, BOSException {
        BigDecimal afterInvestMon = new BigDecimal("0");
        if (this.txtAfterInvestMon != null && this.txtAfterInvestMon.getBigDecimalValue() != null) {
            afterInvestMon = this.txtAfterInvestMon.getBigDecimalValue();
        }
        BigDecimal beforeInvestMon = new BigDecimal("0");
        if (this.txtBeforeInvestMon != null && this.txtBeforeInvestMon.getBigDecimalValue() != null) {
            beforeInvestMon = this.txtBeforeInvestMon.getBigDecimalValue();
        }
        BigDecimal value = null;
        value = beforeInvestMon.subtract(afterInvestMon);
        this.txtMinorityChange.setValue((Object)value);
    }

    @Override
    protected void txtHonor_dataChanged(DataChangeEvent e) throws Exception {
        super.txtHonor_dataChanged(e);
        if (!this.isFirstOpen) {
            BigDecimal honor = this.txtHonor.getBigDecimalValue() != null ? this.txtHonor.getBigDecimalValue() : new BigDecimal(0.0);
            this.txtHonorSum.setValue((Object)honor.add(this.lastHonorSum));
        }
    }

    @Override
    public void actionEditOwnerSumNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditOwnerSumNew_actionPerformed(e);
        BigDecimal value = null;
        if (this.txtOwnerSumNew.getValue() != null) {
            value = this.txtOwnerSumNew.getBigDecimalValue();
        }
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        uiCtx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(false));
        uiCtx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        uiCtx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        uiCtx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumNewItems);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestDayEntryUI.class.getName(), (Map)uiCtx, null);
        uiWindow.show();
        InvestDayEntryUI ui = (InvestDayEntryUI)uiWindow.getUIObject();
        this.ownerSumNewItems = ui.getSubItems();
        this.txtOwnerSumNew.setValue((Object)ui.getSumValue());
    }

    @Override
    public void actionEditOwnerSumOld_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditOwnerSumOld_actionPerformed(e);
        BigDecimal value = this.txtOwnerSumOld.getBigDecimalValue();
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        uiCtx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(true));
        uiCtx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        uiCtx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        uiCtx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumOldItems);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestDayEntryUI.class.getName(), (Map)uiCtx, null);
        uiWindow.show();
        InvestDayEntryUI ui = (InvestDayEntryUI)uiWindow.getUIObject();
        this.ownerSumOldItems = ui.getSubItems();
        this.txtOwnerSumOld.setValue((Object)ui.getSumValue());
    }

    @Override
    public void actionEditProfit_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal value = null;
        super.actionEditProfit_actionPerformed(e);
        if (this.txtProfit.getValue() != null) {
            value = this.txtProfit.getBigDecimalValue();
        }
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.NET_PROFIT);
        uiCtx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(3));
        uiCtx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        uiCtx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.profitItems);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestDayEntryUI.class.getName(), (Map)uiCtx, null);
        uiWindow.show();
        InvestDayEntryUI ui = (InvestDayEntryUI)uiWindow.getUIObject();
        this.profitItems = ui.getSubItems();
        this.txtProfit.setValue((Object)ui.getSumValue());
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        if (!this.isFirstOpen) {
            this.loadLastSumDatas();
            this.computeMinorityChange();
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        if (!this.isFirstOpen) {
            this.loadLastSumDatas();
            this.computeMinorityChange();
        }
    }

    @Override
    protected void prmtTargetCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTargetCompany_dataChanged(e);
        if (!this.isFirstOpen) {
            this.loadLastSumDatas();
            this.computeMinorityChange();
        }
    }

    private void loadLastSumDatas() {
        if (this.prmtCompany.getData() != null && this.prmtTargetCompany.getData() != null && this.comboCurrency.getSelectedItem() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            CompanyOrgUnitInfo targetCompany = (CompanyOrgUnitInfo)this.prmtTargetCompany.getData();
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            Date changeDate = this.pkChangeDate.getSqlDate();
            try {
                IInvestDay iinvestDay = InvestDayFactory.getRemoteInstance();
                StringBuffer buffer = new StringBuffer();
                buffer.append("select id,changeDate,honorSum,sumInvestRate,sumInvestAmout");
                buffer.append(" where company.id = '");
                buffer.append(company.getId().toString());
                buffer.append("' and targetCompany.id = '");
                buffer.append(targetCompany.getId().toString());
                buffer.append("' and currency.id = '");
                buffer.append(currency.getId().toString());
                if (!"ADDNEW".equals(this.getOprtState()) && changeDate != null) {
                    buffer.append("' and changeDate < '");
                    buffer.append(changeDate);
                }
                buffer.append("' order by changeDate desc");
                if (this.memory.equals("")) {
                    this.memory = buffer.toString();
                    this.col = iinvestDay.getInvestDayCollection(buffer.toString());
                } else if (!this.memory.equals("") && !this.memory.equals(buffer.toString())) {
                    this.col = iinvestDay.getInvestDayCollection(buffer.toString());
                }
                Iterator iter = this.col.iterator();
                if (iter.hasNext()) {
                    this.isFirstInvest = false;
                    InvestDayInfo info = (InvestDayInfo)iter.next();
                    this.lastHonorSum = info.getHonorSum() != null ? info.getHonorSum() : new BigDecimal(0.0);
                    this.lastSumInvestAmount = info.getSumInvestAmout() != null ? info.getSumInvestAmout() : new BigDecimal(0.0);
                    this.lastSumInvestRate = info.getSumInvestRate() != null ? info.getSumInvestRate() : new BigDecimal(0.0);
                    this.lastChangeDate = info.getChangeDate();
                    return;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.lastHonorSum = new BigDecimal(0.0);
        this.lastSumInvestAmount = new BigDecimal(0.0);
        this.lastSumInvestRate = new BigDecimal(0.0);
        this.lastChangeDate = null;
        this.isFirstInvest = true;
    }

    protected IObjectValue createNewData() {
        InvestDayInfo info = new InvestDayInfo();
        info.setChangeDate(new java.util.Date());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InvestDayFactory.getRemoteInstance();
    }

    public BigDecimal getLastHonorSum() {
        return this.lastHonorSum;
    }

    public BigDecimal getLastSumInvestAmount() {
        return this.lastSumInvestAmount;
    }

    public BigDecimal getLastSumInvestRate() {
        return this.lastSumInvestRate;
    }

    public IObjectPK runSubmit() throws Exception {
        Exception e;
        int i;
        Object[] oParamater;
        String msg;
        StringBuffer errMsg;
        Result result;
        Serializable info;
        Iterator iter;
        float f = this.txtInvestRate.getNumberValue().floatValue() / 100.0f + this.getTotalNumber();
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            f -= this.oldInvestRate.floatValue();
        }
        if (f > 1.0f) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InvestOver100Percent"));
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.editData.setCurrency(currency);
        this.editData.setDiffValue(this.sumDiff);
        IObjectPK pk = super.runSubmit();
        IInvestDayEntry iide = InvestDayEntryFactory.getRemoteInstance();
        IInvestDayInvestOwnerEntry iInvestOwner = InvestDayInvestOwnerEntryFactory.getRemoteInstance();
        CoreBaseCollection entries = new CoreBaseCollection();
        CoreBaseCollection ownerEntries = new CoreBaseCollection();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.ownerSumNewItems != null) {
                iter = this.ownerSumNewItems.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayEntryInfo)iter.next();
                    ((AbstractInvestDayEntryInfo)info).getInvestDay().setId(BOSUuid.read((String)pk.toString()));
                    ((AbstractInvestDayEntryInfo)info).setId(null);
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.ownerSumOldItems != null) {
                iter = this.ownerSumOldItems.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayEntryInfo)iter.next();
                    ((AbstractInvestDayEntryInfo)info).getInvestDay().setId(BOSUuid.read((String)pk.toString()));
                    ((AbstractInvestDayEntryInfo)info).setId(null);
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.profitItems != null) {
                iter = this.profitItems.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayEntryInfo)iter.next();
                    ((AbstractInvestDayEntryInfo)info).getInvestDay().setId(BOSUuid.read((String)pk.toString()));
                    ((AbstractInvestDayEntryInfo)info).setId(null);
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.ownerSumNewItemsOwnerAfter != null) {
                iter = this.ownerSumNewItemsOwnerAfter.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayInvestOwnerEntryInfo)iter.next();
                    ((AbstractInvestDayInvestOwnerEntryInfo)info).getInvestDay().setId(BOSUuid.read((String)pk.toString()));
                    info.setId(null);
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.ownerSumNewItemsOwnerBefore != null) {
                iter = this.ownerSumNewItemsOwnerBefore.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayInvestOwnerEntryInfo)iter.next();
                    ((AbstractInvestDayInvestOwnerEntryInfo)info).getInvestDay().setId(BOSUuid.read((String)pk.toString()));
                    info.setId(null);
                    entries.add((CoreBaseInfo)info);
                }
            }
        } else {
            if (this.ownerSumNewItems != null) {
                iter = this.ownerSumNewItems.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayEntryInfo)iter.next();
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.ownerSumOldItems != null) {
                iter = this.ownerSumOldItems.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayEntryInfo)iter.next();
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.profitItems != null) {
                iter = this.profitItems.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayEntryInfo)iter.next();
                    entries.add((CoreBaseInfo)info);
                }
            }
            if (this.ownerSumNewItemsOwnerAfter != null) {
                iter = this.ownerSumNewItemsOwnerAfter.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayInvestOwnerEntryInfo)iter.next();
                    ownerEntries.add((CoreBaseInfo)info);
                }
            }
            if (this.ownerSumNewItemsOwnerBefore != null) {
                iter = this.ownerSumNewItemsOwnerBefore.iterator();
                while (iter.hasNext()) {
                    info = (InvestDayInvestOwnerEntryInfo)iter.next();
                    ownerEntries.add((CoreBaseInfo)info);
                }
            }
        }
        if (entries.size() > 0 && (result = iide.submit(entries)).getResult() != 1) {
            errMsg = new StringBuffer();
            msg = null;
            oParamater = null;
            for (i = 0; i < result.size(); ++i) {
                if (result.getLineResult(i).isSucess()) continue;
                e = result.getLineResult(i).getException();
                if (e == null) {
                    oParamater = new Object[]{i + 1};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"17_AdjustTempletDispenseUI");
                } else {
                    oParamater = new Object[]{i + 1, e.getMessage()};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"18_AdjustTempletDispenseUI");
                }
                errMsg.append(MessageFormat.format(msg, new Object[]{oParamater})).append("\\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"313_AdjustTempletDispenseUI"), (String)errMsg.toString(), (int)8188);
        }
        if (ownerEntries.size() > 0 && (result = iInvestOwner.submit(ownerEntries)).getResult() != 1) {
            errMsg = new StringBuffer();
            msg = null;
            oParamater = null;
            for (i = 0; i < result.size(); ++i) {
                if (result.getLineResult(i).isSucess()) continue;
                e = result.getLineResult(i).getException();
                if (e == null) {
                    oParamater = new Object[]{i + 1};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"17_AdjustTempletDispenseUI");
                } else {
                    oParamater = new Object[]{i + 1, e.getMessage()};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"18_AdjustTempletDispenseUI");
                }
                errMsg.append(MessageFormat.format(msg, new Object[]{oParamater})).append("\\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"313_AdjustTempletDispenseUI"), (String)errMsg.toString(), (int)8188);
        }
        this.clearEntry();
        return pk;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnOwnerSumNew.setEnabled(true);
        this.btnOwnerSumOld.setEnabled(true);
        this.btnProfit.setEnabled(true);
        this.pkChangeDate.setEnabled(true);
        this.clearEntry();
        this.btnCopy.setEnabled(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnOwnerSumNew.setEnabled(true);
        this.btnOwnerSumOld.setEnabled(true);
        this.btnProfit.setEnabled(true);
        this.pkChangeDate.setEnabled(false);
        this.btnCopy.setEnabled(true);
        this.txtInvestAudit.setText(InvestCheckTypeEnum.COST_METHOD.getAlias());
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.clearEntry();
        this.afterInvstMon(false, false);
        this.beforeInvestMon(false, false);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.clearEntry();
        this.afterInvstMon(false, false);
        this.beforeInvestMon(false, false);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.clearEntry();
        this.afterInvstMon(false, false);
        this.beforeInvestMon(false, false);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.clearEntry();
        this.afterInvstMon(false, false);
        this.beforeInvestMon(false, false);
    }

    private void clearEntry() {
        this.ownerSumNewItems = null;
        this.ownerSumOldItems = null;
        this.profitItems = null;
        this.ownerSumNewItemsOwnerAfter = null;
        this.ownerSumNewItemsOwnerBefore = null;
        this.btnCopy.setEnabled(true);
        if (this.editData != null && this.editData.getId() != null) {
            String recordId = this.editData.getTrackRecordCreator() == null ? "" : this.editData.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
        }
    }

    public boolean isModify() {
        if (this.prmtCompany.getData() == null && this.prmtTargetCompany.getData() == null) {
            return false;
        }
        return super.isModify();
    }

    public BigDecimal getInvestRate() {
        BigDecimal investRate = this.txtInvestRate.getBigDecimalValue();
        if (investRate == null) {
            investRate = new BigDecimal(0.0);
        }
        investRate = investRate.divide(new BigDecimal("100"), 15, 5);
        return investRate;
    }

    public BigDecimal getSumInvestRate() {
        BigDecimal sumInvestRate = this.txtSumInvestRate.getBigDecimalValue();
        if (sumInvestRate == null) {
            sumInvestRate = new BigDecimal(0.0);
        }
        sumInvestRate = sumInvestRate.divide(new BigDecimal(100.0), 15, 5);
        return sumInvestRate;
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        InvestDayEntryInfo info;
        Iterator iter;
        String oql;
        IInvestDayEntry iinvestDayEntry;
        String id = null;
        if (this.editData.getId() != null) {
            id = this.editData.getId().toString();
        }
        super.actionCopy_actionPerformed(e);
        this.pkChangeDate.setEnabled(true);
        if (this.ownerSumNewItems == null && id != null) {
            iinvestDayEntry = InvestDayEntryFactory.getRemoteInstance();
            oql = " where investDay.id = '" + id + "' and controlAttr = " + RPTItemControlEnum.OWNER_EQUITY_SUM.getValue();
            oql = oql + " and assistantFlag = 1";
            this.ownerSumNewItems = iinvestDayEntry.getInvestDayEntryCollection(oql);
            iter = this.ownerSumNewItems.iterator();
            while (iter.hasNext()) {
                info = (InvestDayEntryInfo)iter.next();
                info.setId(null);
            }
        }
        if (this.ownerSumOldItems == null && id != null) {
            iinvestDayEntry = InvestDayEntryFactory.getRemoteInstance();
            oql = " where investDay.id = '" + id + "' and controlAttr = " + RPTItemControlEnum.OWNER_EQUITY_SUM.getValue();
            oql = oql + " and assistantFlag = 0";
            this.ownerSumOldItems = iinvestDayEntry.getInvestDayEntryCollection(oql);
            iter = this.ownerSumOldItems.iterator();
            while (iter.hasNext()) {
                info = (InvestDayEntryInfo)iter.next();
                info.setId(null);
            }
        }
        if (this.profitItems == null && id != null) {
            iinvestDayEntry = InvestDayEntryFactory.getRemoteInstance();
            oql = " where investDay.id = '" + id + "' and controlAttr = " + RPTItemControlEnum.NET_PROFIT.getValue();
            this.profitItems = iinvestDayEntry.getInvestDayEntryCollection(oql);
            iter = this.profitItems.iterator();
            while (iter.hasNext()) {
                info = (InvestDayEntryInfo)iter.next();
                info.setId(null);
            }
        }
        this.txtInvestAmount_dataChanged(null);
        this.actionCopy.setEnabled(false);
    }

    private void afterInvstMon(boolean isOpen, boolean isRateOrOwnerSumNewChange) throws EASBizException, BOSException {
        BigDecimal value = null;
        if (this.txtOwnerSumNew.getBigDecimalValue() != null) {
            value = this.txtOwnerSumNew.getBigDecimalValue();
        }
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        uiCtx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(false));
        uiCtx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        uiCtx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        if (this.txtSumInvestRate.getBigDecimalValue() != null) {
            uiCtx.put((Object)"sumInvestRate", (Object)this.txtSumInvestRate.getBigDecimalValue().divide(new BigDecimal("100"), 6, 4));
        } else {
            uiCtx.put((Object)"sumInvestRate", (Object)this.txtSumInvestRate.getBigDecimalValue());
        }
        this.setFilter(uiCtx, this.getOprtState().equals(OprtState.ADDNEW));
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        ctx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(false));
        ctx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        ctx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        ctx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        ctx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        ctx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumNewItems);
        uiCtx.put((Object)"changeMoney", (Object)this.ownerSumNewItems);
        uiCtx.put((Object)"actualSumValue", (Object)this.txtAfterInvestMon.getBigDecimalValue());
        uiCtx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumNewItemsOwnerAfter);
        uiCtx.put((Object)"isOpen", (Object)new Boolean(isOpen));
        uiCtx.put((Object)"isRateOrOwnerSumNewChange", (Object)new Boolean(isRateOrOwnerSumNewChange));
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestMoneyUI.class.getName(), (Map)uiCtx, null);
        if (isOpen) {
            uiWindow.show();
        }
        InvestMoneyUI investUI = (InvestMoneyUI)uiWindow.getUIObject();
        this.ownerSumNewItemsOwnerAfter = investUI.getSubItems();
        this.sumDiff = investUI.getSumDiffValue();
        this.txtAfterInvestMon.setValue((Object)investUI.getSumValue());
        this.computeMinorityChange();
        this.computeHonor();
    }

    @Override
    public void actionAfterInvestMon_actionPerformed(ActionEvent e) throws Exception {
        super.actionAfterInvestMon_actionPerformed(e);
        boolean isAddNew = false;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            isAddNew = true;
        }
        ++this.times;
        if (this.times <= 1 && isAddNew) {
            this.afterInvstMon(true, true);
        } else if (this.times > 1 && isAddNew) {
            this.afterInvstMon(true, false);
        } else {
            this.afterInvstMon(true, false);
        }
    }

    private void beforeInvestMon(boolean isOpen, boolean isRateOrOwnerSumNewChange) throws EASBizException, BOSException {
        BigDecimal value = null;
        if (this.txtOwnerSumOld.getBigDecimalValue() != null) {
            value = this.txtOwnerSumOld.getBigDecimalValue();
        }
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        uiCtx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(true));
        uiCtx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        uiCtx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        uiCtx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        uiCtx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        uiCtx.put((Object)"sumInvestRate", (Object)this.txtSumInvestRate.getBigDecimalValue());
        this.setFilter(uiCtx, this.getOprtState().equals(OprtState.ADDNEW));
        if (this.txtBeforeInvestMon != null) {
            uiCtx.put((Object)"actualSumValue", (Object)this.txtBeforeInvestMon.getBigDecimalValue());
        } else {
            uiCtx.put((Object)"actualSumValue", null);
        }
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)UICTX_KEY_CONTROLATTR, (Object)RPTItemControlEnum.OWNER_EQUITY_SUM);
        ctx.put((Object)UICTX_KEY_ISCHANGEBEFORE, (Object)new Boolean(true));
        ctx.put((Object)UICTX_KEY_DATAELEMENT, (Object)new Integer(4));
        ctx.put((Object)UICTX_KEY_STATUS, (Object)this.getOprtState());
        ctx.put((Object)UICTX_KEY_INVESTDAY, (Object)this.editData);
        ctx.put((Object)UICTX_KEY_SUMVALUE, (Object)value);
        ctx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumOldItems);
        uiCtx.put((Object)"changeMoney", (Object)this.ownerSumOldItems);
        uiCtx.put((Object)"isOpen", (Object)new Boolean(isOpen));
        uiCtx.put((Object)"isRateOrOwnerSumNewChange", (Object)new Boolean(isRateOrOwnerSumNewChange));
        uiCtx.put((Object)UICTX_KEY_SUBITEMS, (Object)this.ownerSumNewItemsOwnerBefore);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestMoneyUI.class.getName(), (Map)uiCtx, null);
        if (isOpen) {
            uiWindow.show();
        }
        InvestMoneyUI investUI = (InvestMoneyUI)uiWindow.getUIObject();
        this.ownerSumNewItemsOwnerBefore = investUI.getSubItems();
        this.txtBeforeInvestMon.setValue((Object)investUI.getSumValue());
        this.computeMinorityChange();
        this.computeHonor();
    }

    @Override
    public void actionBeforeInvestMon_actionPerformed(ActionEvent e) throws Exception {
        super.actionBeforeInvestMon_actionPerformed(e);
        boolean isAddNew = false;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            isAddNew = true;
        }
        ++this.times;
        if (this.times <= 1 && isAddNew) {
            this.beforeInvestMon(true, true);
        } else if (this.times > 1 && isAddNew) {
            this.beforeInvestMon(true, false);
        } else {
            this.beforeInvestMon(true, false);
        }
    }

    private void setFilter(UIContext uiCtx, boolean isAddNew) {
        java.util.Date date;
        String id;
        if (this.prmtTargetCompany.getData() == null && isAddNew) {
            uiCtx.put((Object)"targetCompany", null);
        } else if (this.prmtTargetCompany.getData() != null && isAddNew) {
            CompanyOrgUnitInfo targetCompany = (CompanyOrgUnitInfo)this.prmtTargetCompany.getData();
            uiCtx.put((Object)"targetCompany", (Object)targetCompany.getId().toString());
        } else {
            id = this.editData.getTargetCompany().getId().toString();
            uiCtx.put((Object)"targetCompany", (Object)id);
        }
        if (this.prmtCompany.getData() == null && isAddNew) {
            uiCtx.put((Object)"company", null);
        } else if (this.prmtCompany.getData() != null && isAddNew) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            uiCtx.put((Object)"company", (Object)company.getId().toString());
        } else {
            id = this.editData.getCompany().getId().toString();
            uiCtx.put((Object)"company", (Object)id);
        }
        if (this.pkChangeDate.getValue() == null && isAddNew) {
            uiCtx.put((Object)"date", null);
        } else if (this.pkChangeDate.getValue() != null && isAddNew) {
            date = this.pkChangeDate.getSqlDate();
            uiCtx.put((Object)"date", (Object)date);
        } else {
            date = this.editData.getChangeDate();
            uiCtx.put((Object)"date", (Object)date);
        }
        if (this.comboCurrency.getSelectedItem() == null && isAddNew) {
            uiCtx.put((Object)"currency", null);
        } else if (this.comboCurrency.getSelectedItem() != null && isAddNew) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            uiCtx.put((Object)"currency", (Object)currency.getId().toString());
        } else {
            uiCtx.put((Object)"currency", (Object)this.editData.getCurrency().getId().toString());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtInvestAudit.setText(InvestCheckTypeEnum.COST_METHOD.getAlias());
        this.txtAfterInvestMon.setEnabled(true);
        this.txtBeforeInvestMon.setEnabled(true);
        this.btnAfterInvest.setEnabled(true);
        this.btnBeforeInvest.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initEditOwnerSum();
        this.beforeInvestMon(false, true);
        this.afterInvstMon(false, true);
    }

    @Override
    protected void pkChangeDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkChangeDate_dataChanged(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = super.getSelectors();
        src.add(new SelectorItemInfo("trackRecordCreator"));
        return src;
    }

    public float getTotalNumber() throws BOSException {
        FilterInfo filterInfo = this.getFilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("investRate"));
        InvestDayCollection investDayCollection = InvestDayFactory.getRemoteInstance().getInvestDayCollection(view);
        int size = investDayCollection.size();
        float f = 0.0f;
        for (int i = 0; i < size; ++i) {
            f += investDayCollection.get(i).getInvestRate().floatValue();
        }
        return f;
    }

    private FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtTargetCompany.getData() != null) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.prmtTargetCompany.getData();
            FilterItemInfo filterItem = new FilterItemInfo("targetCompany.id", (Object)org.getId().toString());
            filterInfo.getFilterItems().add(filterItem);
        }
        return filterInfo;
    }
}

