/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDayEntry;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInvestDayEntryUI;
import com.kingdee.eas.fi.gr.cslrpt.util.SaveTableColumn;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;

public class InvestDayEntryUI
extends AbstractInvestDayEntryUI {
    private InvestDayEntryCollection subItems = new InvestDayEntryCollection();
    private RPTItemControlEnum controlAttr;
    private Boolean isChangeBefore;
    private int dataEle;
    private RPTItemInfo sumitem;
    private InvestDayInfo investDay;
    private BigDecimal sumValue;

    public void onLoad() throws Exception {
        String oql;
        super.onLoad();
        Map uiCtx = super.getUIContext();
        this.controlAttr = (RPTItemControlEnum)((Object)uiCtx.get("CONTROLATTR"));
        this.isChangeBefore = (Boolean)uiCtx.get("ISCHANGEBEFOR");
        if (this.controlAttr != null) {
            this.setUITitle(this.controlAttr.getAlias());
            IRPTItem irptItem = RPTItemFactory.getRemoteInstance();
            oql = " where control = " + this.controlAttr.getValue() + " and isFreezed = 0";
            try {
                this.sumitem = irptItem.getRPTItemInfo(oql);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ControlHasOnlyRPTItem")), new Object[]{this.controlAttr.getAlias()});
            }
        }
        this.sumValue = (BigDecimal)uiCtx.get("SUMVALUE");
        this.dataEle = (Integer)uiCtx.get("DATAELEMENT");
        this.investDay = (InvestDayInfo)uiCtx.get("INVESTDAY");
        this.subItems = (InvestDayEntryCollection)((Object)uiCtx.get("SUBITMES"));
        if (this.subItems == null && this.investDay.getId() != null) {
            IInvestDayEntry iinvestDayEntry = InvestDayEntryFactory.getRemoteInstance();
            oql = " where investDay.id = '" + this.investDay.getId().toString() + "' and controlAttr = " + this.controlAttr.getValue();
            if (this.isChangeBefore != null) {
                oql = oql + " and assistantFlag = ";
                oql = oql + (this.isChangeBefore != false ? "0" : "1");
            }
            this.subItems = iinvestDayEntry.getInvestDayEntryCollection(oql);
        }
        this.createTable();
    }

    private void createTable() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.setRefresh(false);
        this.kDTable1.addColumns(5);
        IColumn column = this.kDTable1.getColumn(0);
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHided(true);
        column = this.kDTable1.getColumn(1);
        column.getStyleAttributes().setLocked(true);
        column.setWidth(180);
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setPrecision(2);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)formatField);
        column = this.kDTable1.getColumn(2);
        column.setEditor((ICellEditor)editor);
        String numberFmt = FMClientHelper.getNumberFtm((int)2);
        column.getStyleAttributes().setNumberFormat(numberFmt);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column = this.kDTable1.getColumn(3);
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHided(true);
        column = this.kDTable1.getColumn(4);
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHided(true);
        IRow headrow = this.kDTable1.addHeadRow();
        ICell cell = headrow.getCell(1);
        cell.setValue((Object)CslRptUtil.getString("OwnerRights"));
        cell = headrow.getCell(2);
        cell.setValue((Object)CslRptUtil.getString("Money"));
        String patternString = "([\\(]*)([^\\+|^\\-|^\\(|^\\))]{1,})([\\+|\\-|\\(|\\)]*)";
        Pattern pt = Pattern.compile("([\\(]*)([^\\+|^\\-|^\\(|^\\))]{1,})([\\+|\\-|\\(|\\)]*)");
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("sumitem", this.sumitem);
        uiCtx.put("sumValue", this.sumValue);
        uiCtx.put("subItems", (Object)this.subItems);
        uiCtx.put("pt", pt);
        List list = InvestDayEntryFactory.getRemoteInstance().initFormulaData(uiCtx);
        if (list.size() == 0) {
            return;
        }
        this.fillTable(list);
        this.kDTable1.setRefresh(true);
        this.kDTable1.repaint();
    }

    private void fillTable(List list) {
        for (int i = 0; i < list.size(); ++i) {
            SaveTableColumn sv = (SaveTableColumn)list.get(i);
            IRow row = this.kDTable1.addRow();
            ICell cell = row.getCell(0);
            cell.setValue(sv.getRptNumber());
            cell = row.getCell(1);
            cell.setValue(sv.getRptName());
            cell = row.getCell(2);
            cell.setValue(sv.getmoney());
            cell = row.getCell(3);
            cell.setValue(sv.getOperation());
            cell = row.getCell(4);
            cell.setValue(sv.getEntryUIlevel());
            Integer isLock = (Integer)sv.getIsLock();
            if (isLock != 1) continue;
            cell.getStyleAttributes().setLocked(true);
        }
    }

    private void displayFormula(RPTItemInfo item, int level, Pattern pt, String op) throws Exception {
        StringBuffer space = new StringBuffer("");
        for (int i = 0; i < level; ++i) {
            space.append("  ");
        }
        IRow row = this.kDTable1.addRow();
        ICell cell = row.getCell(0);
        if (level != 0) {
            cell.setValue((Object)item.getNumber());
        }
        cell = row.getCell(1);
        cell.setValue((Object)(space.toString() + item.getName()));
        cell = row.getCell(3);
        cell.setValue((Object)op);
        cell = row.getCell(4);
        cell.setValue((Object)new Integer(level));
        cell = row.getCell(2);
        if (level == 0) {
            cell.setValue((Object)this.sumValue);
        } else {
            InvestDayEntryInfo entry = this.getEntry(item);
            if (entry != null) {
                cell.setValue((Object)entry.getAmount());
            } else {
                cell.setValue(null);
            }
        }
        cell.getStyleAttributes().setLocked(true);
        String formula = item.getSumItemFormula();
        if (StringUtils.isEmpty((String)formula)) {
            cell.getStyleAttributes().setLocked(false);
            return;
        }
        space.append("  ");
        Matcher matcher = pt.matcher(formula);
        while (matcher.find()) {
            String oql;
            IRPTItem irptItem = RPTItemFactory.getRemoteInstance();
            item = irptItem.getRPTItemInfo(oql = " where number = '" + matcher.group(2) + "'");
            if (StringUtils.isEmpty((String)item.getSumItemFormula())) {
                row = this.kDTable1.addRow();
                cell = row.getCell(0);
                cell.setValue((Object)item.getNumber());
                cell = row.getCell(1);
                cell.setValue((Object)(space.toString() + item.getName()));
                cell = row.getCell(2);
                InvestDayEntryInfo entry = this.getEntry(item);
                if (entry != null) {
                    cell.setValue((Object)entry.getAmount());
                } else {
                    cell.setValue(null);
                }
                cell = row.getCell(3);
                cell.setValue((Object)matcher.group(3));
                cell = row.getCell(4);
                cell.setValue((Object)new Integer(level + 1));
                continue;
            }
            this.displayFormula(item, level + 1, pt, matcher.group(3));
        }
    }

    private InvestDayEntryInfo getEntry(RPTItemInfo info) {
        if (this.subItems == null) {
            return null;
        }
        Iterator iter = this.subItems.iterator();
        while (iter.hasNext()) {
            InvestDayEntryInfo entry = (InvestDayEntryInfo)iter.next();
            if (!entry.getItem().getId().equals((Object)info.getId())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.subItems == null) {
            this.subItems = new InvestDayEntryCollection();
        }
        if (this.kDTable1.getRowCount() > 1) {
            InvestDayEntryInfo entry = new InvestDayEntryInfo();
            this.computeFormulaValue(0, entry);
            this.sumValue = entry.getAmount();
            IRow row = this.kDTable1.getRow(0);
            row.getCell(2).setValue((Object)this.sumValue);
        } else {
            this.sumValue = (BigDecimal)this.kDTable1.getRow(0).getCell(2).getValue();
        }
        this.getUIWindow().close();
    }

    private int computeFormulaValue(int startRow, InvestDayEntryInfo topentry) throws Exception {
        IRow row = this.kDTable1.getRow(startRow);
        int level = (Integer)row.getCell(4).getValue();
        BigDecimal sum = new BigDecimal(0.0);
        String op = "+";
        int count = this.kDTable1.getRowCount();
        ++startRow;
        while (startRow < count) {
            BigDecimal value;
            String oql;
            row = this.kDTable1.getRow(startRow);
            int nextlevel = (Integer)row.getCell(4).getValue();
            if (level >= nextlevel) {
                topentry.setAmount(sum);
                return startRow;
            }
            String number = row.getCell(0).getValue().toString();
            IRPTItem irptItem = RPTItemFactory.getRemoteInstance();
            RPTItemInfo info = irptItem.getRPTItemInfo(oql = " where number = '" + number + "'");
            InvestDayEntryInfo entry = this.getEntry(info);
            if (entry == null) {
                entry = new InvestDayEntryInfo();
                entry.setItem(info);
                entry.setControlAttr(this.controlAttr);
                entry.setDataElement(this.dataEle);
                entry.setInvestDay(this.investDay);
                if (this.isChangeBefore != null) {
                    int flag = this.isChangeBefore != false ? 0 : 1;
                    entry.setAssistantFlag(flag);
                }
                this.subItems.add(entry);
            }
            if ((value = (BigDecimal)row.getCell(2).getValue()) == null) {
                value = new BigDecimal(0.0);
            }
            if (this.hasChild(startRow, nextlevel)) {
                startRow = this.computeFormulaValue(startRow, entry);
                value = entry.getAmount();
                row.getCell(2).setValue((Object)value);
            } else {
                entry.setAmount(value);
                ++startRow;
            }
            if (StringUtils.equals((String)op, (String)"+")) {
                sum = sum.add(value);
            } else if (StringUtils.equals((String)op, (String)"-")) {
                sum = sum.subtract(value);
            }
            op = row.getCell(3).getValue().toString();
        }
        topentry.setAmount(sum);
        return startRow;
    }

    private boolean hasChild(int startRow, int currentlevel) {
        IRow row;
        int level;
        int count = this.kDTable1.getRowCount();
        return startRow < count - 1 && (level = ((Integer)(row = this.kDTable1.getRow(startRow + 1)).getCell(4).getValue()).intValue()) > currentlevel;
    }

    public InvestDayEntryCollection getSubItems() {
        return this.subItems;
    }

    public BigDecimal getSumValue() {
        return this.sumValue;
    }
}

