/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.InvestDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInvestItemDataListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.DynaItem2ElimItemUI;
import com.kingdee.eas.fi.gr.cslrpt.client.DynaItemDataImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InvestDataConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class InvestItemDataListUI
extends AbstractInvestItemDataListUI
implements ICSLContextUI {
    private static final Logger logger = CoreUI.getLogger(InvestItemDataListUI.class);
    private static final String TB_RECORDTYPE = "TB_RECORDTYPE";
    private static final String TB_COMPANY_Name = "TB_COMPANY_Name";
    private static final String TB_TARGETCOMPANY_Name = "TB_TARGETCOMPANY_Name";
    private static final String TB_CURRENCY_Name = "TB_CURRENCY_Name";
    private static final String TB_TARGETCURRENCY_Name = "TB_TARGETCURRENCY_Name";
    private static final String TB_COMPANY = "TB_COMPANY";
    private static final String TB_TARGETCOMPANY = "TB_TARGETCOMPANY";
    private static final String TB_CURRENCY = "TB_CURRENCY";
    private static final String TB_TARGETCURRENCY = "TB_TARGETCURRENCY";
    private static final String TB_SHARE_HOLD_RATE = "TB_SHARE_HOLD_RATE";
    private static final String TB_INVEST_LONG = "TB_INVEST_LONG";
    private static final String TB_INVEST_DIFF = "TB_INVEST_DIFF";
    private static final String TB_TERM_INVEST_PROFIT = "TB_TERM_INVEST_PROFIT";
    private static final String TB_YEAR_INVEST_PROFIT = "TB_YEAR_INVEST_PROFIT";
    private InvestDataConditionUI queryPanel = new InvestDataConditionUI();
    private CSLSysParamanager paramnager = null;
    private String ElimResName = "com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg";
    private int mergeType;

    public InvestItemDataListUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getViewManager().setFreezeView(0, 3);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
    }

    @Override
    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.paramnager = CSLContextHelper.getSysParamanager();
            if (this.paramnager != null) {
                this.paramnager.refreshParams();
                this.mergeType = this.paramnager.getMergeType();
            }
            if (this.mergeType == -1) {
                throw new AdjustException(AdjustException.PLEASE_SET_SYSPARAMS);
            }
        } else {
            SysUtil.abort();
        }
        if (CSLContextHelper.getCSLContext().isQueryBudget()) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("budgetHisQueryNotAllow"));
            SysUtil.abort();
        }
        if (CSLContextHelper.getCSLContext().getCurDataCollect() != null && CSLContextHelper.getCSLContext().getCurDataCollect().getNumber().equals("BUDGETDATA")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InvestSearchNotSupportBGDC"));
            SysUtil.abort();
        }
        super.onLoad();
        this.menuImportDynaItemData.setIcon(EASResource.getIcon((String)"imgTbtn_putin"));
        this.menuDeleteImport.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnImportDynaItemData.setIcon(EASResource.getIcon((String)"imgTbtn_putin"));
        this.btnDeleteImport.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDeleteByReport.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemRelaItem.setIcon(EASResource.getIcon((String)"imgTbtn_openlink"));
        this.btnRelaItem.setIcon(EASResource.getIcon((String)"imgTbtn_openlink"));
        this.actionImportDynaItemData.setEnabled(true);
        this.actionDeleteImport.setEnabled(true);
        this.actionDeleteByReport.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
        this.menuItemRefresh.setEnabled(true);
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        OrgTreeInfo orgBound = cslCtx.getCurOrgBound();
        OrgUnitInfo company = cslCtx.getCurOrgGroup();
        if (orgBound != null && orgBound.getName() != null) {
            this.txtOrgBound.setText(orgBound.getName());
        }
        this.comboBoxCompany.removeAllItems();
        if (company != null) {
            this.comboBoxCompany.addItem((Object)company);
        }
        CslRptClientHelperUI.setCruYearAndPeriod(cslCtx, this.spCurYear, this.spCurPeriod);
        this.rptArchive();
    }

    private void rptArchive() throws BOSException {
        if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
            this.actionImportDynaItemData.setEnabled(false);
            this.actionDeleteImport.setEnabled(false);
            this.actionDeleteByReport.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    @Override
    public IRptBase getInitRemoteInstance() throws BOSException {
        return InvestDataProviderFactory.getRemoteInstance();
    }

    @Override
    public CslBaseConditionUI getQueryDialogUserPanel() {
        return this.queryPanel;
    }

    @Override
    public void query(Object condition) {
        this.pp = (RptProperties)condition;
        super.doLayout();
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            this.pp.setInt("from", from);
            this.pp.setInt("length", length);
            IInvestDataProvider iInvestData = InvestDataProviderFactory.getRemoteInstance();
            RptRowSet tempRst = iInvestData.createInvestCompanyTempTable(this.pp);
            String tableName = (String)tempRst.getProperty("tableName");
            this.pp.setString("tableName", tableName);
            boolean isSelectMode = this.pp.getBoolean("isSelectMode");
            RptRowSet rst = iInvestData.getInvestItemData(this.mergeType, this.pp, this.pp.getString("tableName"));
            String[][] hd1 = new String[][]{{EASResource.getString((String)this.ElimResName, (String)"RecordType"), EASResource.getString((String)this.ElimResName, (String)"InvestCompany"), EASResource.getString((String)this.ElimResName, (String)"BeInvestedCompany"), EASResource.getString((String)this.ElimResName, (String)"ShareHoldRate"), EASResource.getString((String)this.ElimResName, (String)"FromCurrency"), EASResource.getString((String)this.ElimResName, (String)"TargetCurrency"), EASResource.getString((String)this.ElimResName, (String)"InvestLong"), EASResource.getString((String)this.ElimResName, (String)"InvestDiff"), EASResource.getString((String)this.ElimResName, (String)"TermInvestProfit"), EASResource.getString((String)this.ElimResName, (String)"YearInvestProfit"), "companyId", "targetCompanyId", "currencyId", "targetCurrencyId"}};
            String[][] hd2 = new String[][]{{EASResource.getString((String)this.ElimResName, (String)"RecordType"), EASResource.getString((String)this.ElimResName, (String)"BeInvestedCompany"), EASResource.getString((String)this.ElimResName, (String)"InvestCompany"), EASResource.getString((String)this.ElimResName, (String)"ShareHoldRate"), EASResource.getString((String)this.ElimResName, (String)"FromCurrency"), EASResource.getString((String)this.ElimResName, (String)"TargetCurrency"), EASResource.getString((String)this.ElimResName, (String)"InvestLong"), EASResource.getString((String)this.ElimResName, (String)"InvestDiff"), EASResource.getString((String)this.ElimResName, (String)"TermInvestProfit"), EASResource.getString((String)this.ElimResName, (String)"YearInvestProfit"), "companyId", "targetCompanyId", "currencyId", "targetCurrencyId"}};
            String[][] hd = hd1;
            if (isSelectMode) {
                hd = hd2;
            }
            if (from == 0) {
                KDTableHeaderModel mm = new KDTableHeaderModel();
                mm.setHiddenColumnIndexices(new int[]{0, 10, 11, 12, 13});
                mm.setData(hd);
                mm.setColumnWidths(new int[]{0, 180, 180, 120, 100, 100, 130, 130, 130, 130, 0, 0, 0, 0});
                KDTableUtil.setHeader((KDTableHeaderModel)mm, (KDTable)this.tblMain);
                boolean isUpdateSuccess = InvestItemDataListUI.updateColumnKey(this.tblMain, new String[]{TB_RECORDTYPE, TB_COMPANY_Name, TB_TARGETCOMPANY_Name, TB_SHARE_HOLD_RATE, TB_CURRENCY_Name, TB_TARGETCURRENCY_Name, TB_INVEST_LONG, TB_INVEST_DIFF, TB_TERM_INVEST_PROFIT, TB_YEAR_INVEST_PROFIT, TB_COMPANY, TB_TARGETCOMPANY, TB_CURRENCY, TB_TARGETCURRENCY});
                if (!isUpdateSuccess) {
                    logger.error((Object)"Fail to update column key.");
                    return;
                }
            }
            KDTableUtil.insertRows((Object[][])rst.toArray(), null, (int)from, (KDTable)this.tblMain);
            int rowIndex = 0;
            while (rst.next()) {
                String recordType = rst.getString("FDataType");
                IRow row = this.tblMain.getRow(rowIndex);
                row.getCell(TB_SHARE_HOLD_RATE).getStyleAttributes().setNumberFormat("%R-{#,##0.0000}f");
                row.getCell(TB_INVEST_LONG).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
                row.getCell(TB_INVEST_DIFF).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
                row.getCell(TB_TERM_INVEST_PROFIT).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
                row.getCell(TB_YEAR_INVEST_PROFIT).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
                row.getCell(TB_SHARE_HOLD_RATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell(TB_INVEST_LONG).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell(TB_INVEST_DIFF).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell(TB_TERM_INVEST_PROFIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell(TB_YEAR_INVEST_PROFIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (recordType.equals("2")) {
                    if (row.getCell(TB_SHARE_HOLD_RATE).getValue() != null && row.getCell(TB_SHARE_HOLD_RATE).getValue() instanceof BigDecimal && ((BigDecimal)row.getCell(TB_SHARE_HOLD_RATE).getValue()).compareTo(new BigDecimal("0")) == 0) {
                        row.getCell(TB_SHARE_HOLD_RATE).setValue((Object)"");
                    }
                    row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
                    row.getCell(TB_COMPANY_Name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                }
                ++rowIndex;
            }
            this.groupTableRow();
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
            this.close();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private static boolean updateColumnKey(KDTable table, String[] columnKeys) {
        if (table == null || columnKeys == null || columnKeys.length == 0) {
            return false;
        }
        if (table.getColumnCount() != columnKeys.length) {
            return false;
        }
        for (int i = table.getColumnCount() - 1; i >= 0; --i) {
            table.getColumn(i).setKey(columnKeys[i]);
        }
        return true;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query(this.pp);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public KDTable getPrintTable() {
        return this.tblMain;
    }

    @Override
    public Variant getPrintVariant(String varName) {
        return null;
    }

    @Override
    protected int appendHeadRow(HeadFootModel header) {
        return 0;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        CSLContextHelper.update(arg0, this);
    }

    @Override
    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(1).setGroup(true);
        this.tblMain.getColumn(1).setMergeable(true);
    }

    @Override
    public void actionDeleteImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        ArrayList lst = this.getSelectedValues();
        if (this.confirmRemove()) {
            if (lst != null && !lst.isEmpty()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                CSLContext context = CSLContext.getInstance();
                params.put("KeyOrgTree", context.getCurOrgBound());
                params.put("KeyOrgUnit", context.getCurOrgGroup());
                params.put("Year", new Integer(context.getCurRptYear()));
                params.put("Period", new Integer(context.getCurRptPeriod()));
                params.put("PeriodType", new Integer(context.getCurRptPeriodType().getValue()));
                String error = InvestItemDataFactory.getRemoteInstance().removeBatch(lst, params);
                if (!StringUtils.isEmpty((String)error)) {
                    String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)error, (int)8188);
                }
            }
            this.actionRefresh_actionPerformed(null);
        }
    }

    private boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private ArrayList getSelectedValues() {
        ArrayList<Map> list = new ArrayList<Map>();
        KDTSelectBlock selectBlock = null;
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        int size = selectManager.size();
        if (selectManager.getSelectMode() == 8) {
            for (int i = 0; i <= this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                String type = (String)row.getCell(TB_RECORDTYPE).getValue();
                if (StringUtils.equals((String)type, (String)"2")) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"totalData_CantDelete"));
                    SysUtil.abort();
                }
                list.add(this.getRowData(row));
            }
            return list;
        }
        if (size == 0 || selectManager.getActiveRowIndex() < 0) {
            return list;
        }
        if (size == 1 && selectManager.get().getTop() == selectManager.get().getBottom()) {
            IRow row = this.tblMain.getRow(selectManager.get().getTop());
            String type = (String)row.getCell(TB_RECORDTYPE).getValue();
            if (StringUtils.equals((String)type, (String)"2")) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"totalData_CantDelete"));
                SysUtil.abort();
            }
            list.add(this.getRowData(row));
        } else {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                selectBlock = selectManager.get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    if (rows.contains(new Integer(j))) continue;
                    rows.add(new Integer(j));
                    IRow row = this.tblMain.getRow(j);
                    String type = (String)row.getCell(TB_RECORDTYPE).getValue();
                    if (StringUtils.equals((String)type, (String)"2")) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"totalData_CantDelete"));
                        SysUtil.abort();
                    }
                    list.add(this.getRowData(row));
                }
            }
        }
        return list;
    }

    private Map getRowData(IRow row) {
        HashMap<String, String> data = new HashMap<String, String>();
        String companyName = (String)row.getCell(TB_COMPANY_Name).getValue();
        String targetCompanyName = (String)row.getCell(TB_TARGETCOMPANY_Name).getValue();
        String currencyName = (String)row.getCell(TB_CURRENCY_Name).getValue();
        String targetCurrencyName = (String)row.getCell(TB_TARGETCURRENCY_Name).getValue();
        String companyId = (String)row.getCell(TB_COMPANY).getValue();
        String targetCompanyId = (String)row.getCell(TB_TARGETCOMPANY).getValue();
        String currencyId = (String)row.getCell(TB_CURRENCY).getValue();
        String targetCurrencyId = (String)row.getCell(TB_TARGETCURRENCY).getValue();
        data.put("companyName", companyName);
        data.put("targetCompanyName", targetCompanyName);
        data.put("currencyName", currencyName);
        data.put("targetCurrencyName", targetCurrencyName);
        data.put("companyId", companyId);
        data.put("targetCompanyId", targetCompanyId);
        data.put("currencyId", currencyId);
        data.put("targetCurrencyId", targetCurrencyId);
        return data;
    }

    @Override
    public void actionImportDynaItemData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportDynaItemData_actionPerformed(e);
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"KEY_CURRENCY_ID", (Object)this.pp.getString("toCurrency"));
        uiCtx.put((Object)"KEY_DynaItemData_TYPE", (Object)"INVESTITEMDATA");
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DynaItemDataImportUI.class.getName(), (Map)uiCtx, null);
        uiWindow.show();
        DynaItemDataImportUI ui = (DynaItemDataImportUI)uiWindow.getUIObject();
        if (!ui.isCanceled()) {
            this.actionRefresh_actionPerformed(null);
        }
    }

    @Override
    public void actionRelaItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionRelaItem_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(DynaItem2ElimItemUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    @Override
    public void actionDeleteByReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteByReport_actionPerformed(e);
        IUIWindow uiWindow = null;
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"KEY_CURRENCY_ID", (Object)this.pp.getString("toCurrency"));
        uiCtx.put((Object)"isDelete", (Object)Boolean.TRUE);
        uiCtx.put((Object)"KEY_DynaItemData_TYPE", (Object)"INVESTITEMDATA");
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DynaItemDataImportUI.class.getName(), (Map)uiCtx, null);
        uiWindow.show();
        DynaItemDataImportUI ui = (DynaItemDataImportUI)uiWindow.getUIObject();
        if (!ui.isCanceled()) {
            this.actionRefresh_actionPerformed(null);
        }
    }
}

