/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractItemDataYearInitCslRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GenerateNextYearInitDataListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataAddByTemplateUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizardUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ItemDataYearInitCslRptEditUI
extends AbstractItemDataYearInitCslRptEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ItemDataYearInitCslRptEditUI.class);
    private Color yellowColor = new Color(0xF6F6BF);
    private Color whiteColor = new Color(0xFFFFFF);
    private FullOrgUnitCollection idList;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnGenerate.setVisible(false);
        this.menuItemGenerate.setVisible(false);
        this.btnAddBatch.setVisible(false);
        this.menuAddBatch.setVisible(false);
        this.btnAddRow.setVisible(true);
        this.menuAddRow.setVisible(true);
    }

    protected void checkSelected() {
        if (this.kDPmt_OrgUnit.getData() == null) {
            MsgBox.showInfo((String)CslRptUtil.getString("YearInitSelectOrgFirst"));
            SysUtil.abort();
        }
        if (this.kDSp_Year.getValue() == null || this.kDSp_Year.getIntegerVlaue() < 1900) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("YearInitSelectCorrectYear"));
            SysUtil.abort();
        }
    }

    protected ICSLContext getCslContext() {
        return CSLContextHelper.getCSLContext();
    }

    @Override
    public void actionAddByTemp_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        this.checkSelected();
        String orgUnitId = ((OrgUnitInfo)this.kDPmt_OrgUnit.getData()).getId().toString();
        String curOrgBoundId = this.curOrgBound.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"orgUnitId", (Object)orgUnitId);
        uiContext.put((Object)"curOrgBoundId", (Object)curOrgBoundId);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ItemDataAddByTemplateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
        List<String> tempIdList = ItemDataAddByTemplateUI.tempIdList;
        Map<String, CurrencyInfo> currencyMap = ItemDataAddByTemplateUI.currencyMap;
        if (tempIdList == null || tempIdList.size() == 0) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("templateIds", tempIdList);
        param.put("dataElement", this.dataElement.getInterSeq());
        List result = ((IItemDataYearInit)this.getBizInterface()).getYearInitItemByTemplates(param);
        if (result == null) {
            return;
        }
        int rowCount = this.kDTMain.getRowCount();
        ArrayList<String> itemNumbers = new ArrayList<String>();
        RPTItemInfo rptItem = null;
        CurrencyInfo sourceCurrency = null;
        CurrencyInfo currency = null;
        String key = null;
        Object obj = null;
        for (int i = rowCount - 1; i >= 0; --i) {
            row = this.kDTMain.getRow(i);
            obj = row.getCell(this.COL_ITEM_NUMBER).getValue();
            if (obj == null || !(obj instanceof RPTItemInfo)) continue;
            rptItem = (RPTItemInfo)obj;
            currency = (CurrencyInfo)row.getCell(this.COL_CURRENCY_NAME).getValue();
            sourceCurrency = (CurrencyInfo)row.getCell(this.COL_SOURCECURRENCY_NAME).getValue();
            key = rptItem.getNumber() + (currency == null ? "" : currency.getNumber() + (sourceCurrency == null ? "" : sourceCurrency.getNumber()));
            itemNumbers.add(key);
        }
        sourceCurrency = currencyMap.get("sourceCurrency");
        currency = currencyMap.get("targCurrency");
        RPTItemInfo itemInfo = null;
        for (int i = 0; i < result.size(); ++i) {
            itemInfo = (RPTItemInfo)result.get(i);
            if (itemInfo == null) continue;
            key = itemInfo.getNumber() + (currency == null ? "" : currency.getNumber() + (sourceCurrency == null ? "" : sourceCurrency.getNumber()));
            if (itemNumbers.contains(key)) continue;
            row = this.kDTMain.addRow();
            row.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
            row.getCell(this.COL_ITEM_NUMBER).setValue((Object)itemInfo);
            row.getCell(this.COL_ITEM_NAME).setValue((Object)itemInfo.getName());
            this.setColor(row, itemInfo.getDc());
            if (currency != null) {
                row.getCell(this.COL_CURRENCY_NAME).setValue((Object)currency);
                row.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName());
            }
            if (sourceCurrency != null) {
                row.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)sourceCurrency);
                row.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)sourceCurrency.getName());
            }
            row.getCell(this.COL_YEAR).setValue((Object)this.kDSp_Year.getIntegerVlaue());
            if (itemInfo.get("ValueType") != null) {
                row.getCell(this.COL_VALUETYPE).setValue(itemInfo.get("ValueType"));
            } else {
                row.getCell(this.COL_VALUETYPE).setValue((Object)this.valueType);
            }
            row.getCell(this.COL_DATAELEMENT).setValue((Object)this.dataElement);
            if (currency != null && sourceCurrency != null) {
                if (currency.getNumber().equals(sourceCurrency.getNumber())) {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            } else {
                row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
            }
            row.getCell("dataCollect").setValue((Object)this.dataCollectInfo.getNumber());
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
        }
        this.tableSorter.setOrder(0);
        this.tableSorter.sort("number");
    }

    @Override
    public void actionGenerate_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"simpleShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"year", (Object)this.kDSp_Year.getIntegerVlaue());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GenerateNextYearInitDataListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    @Override
    protected void setColor(IRow row, DebitOrCreditEnum dc) {
        if (DebitOrCreditEnum.CREDIT.equals((Object)dc)) {
            row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setBackground(this.yellowColor);
            row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
        } else if (DebitOrCreditEnum.DEBIT.equals((Object)dc)) {
            row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
            row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setBackground(this.yellowColor);
        } else {
            row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
            row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
        }
    }

    @Override
    protected void setOrgUnitF7() throws Exception {
        super.setOrgUnitF7();
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 2);
        f7.setTreeID(CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString());
        f7.setRootUnitID(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        f7.setMultiSelect(false);
        this.kDPmt_OrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
        this.kDPmt_OrgUnit.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
        this.kDPmt_OrgUnit.setSelector((KDPromptSelector)f7);
        this.kDPmt_OrgUnit.setValue((Object)CSLContextHelper.getCSLContext().getCurOrgGroup());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionCopyCurrYearInitData_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyCurrYearInitData_actionPerformed(e);
        String orgTree = CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString();
        String orgUnit = CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString();
        int year = CSLContextHelper.getCSLContext().getCurRptYear();
        String dataCollectNumber = CSLContextHelper.getCSLContext().getCurDataCollect().getNumber();
        IItemDataYearInit IItemData2 = ItemDataYearInitFactory.getRemoteInstance();
        boolean isExistsRecords = IItemData2.checkCurrYearInitExists(orgTree, orgUnit, year, dataCollectNumber);
        if (isExistsRecords) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Exists_InitData")) != 0) return;
            Map param = this.packParams(isExistsRecords, orgTree, orgUnit, year, dataCollectNumber);
            IItemData2.copyCurrYearInitData(param);
            this.actionRefresh_actionPerformed(e);
            return;
        } else {
            Map param = this.packParams(isExistsRecords, orgTree, orgUnit, year, dataCollectNumber);
            IItemData2.copyCurrYearInitData(param);
            this.actionRefresh_actionPerformed(e);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    protected void orgUnitDataChange(DataChangeEvent e) {
        super.orgUnitDataChange(e);
    }

    private Map packParams(boolean isExistsRecords, String orgTree, String orgUnit, int year, String dataCollectNumber) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgTree", orgTree);
        param.put("orgUnit", orgUnit);
        param.put("Year", new Integer(year));
        param.put("isExistsRecords", isExistsRecords);
        param.put("dataCollectNumber", dataCollectNumber);
        return param;
    }

    private boolean isLastPeriod() {
        try {
            return CSLContextHelper.getCSLContext().getCurRptPeriod() == 12;
        }
        catch (BOSException e) {
            return false;
        }
    }

    @Override
    public void actionImportExcelData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        HashMap<String, String> params = new HashMap<String, String>();
        String treeId = CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString();
        if (this.idList == null || this.idList.size() == 0) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            this.idList = (FullOrgUnitCollection)ItemDataYearInitFactory.getRemoteInstance().getUnionUnitOfTree(userId, treeId);
        }
        params.put("excelOrgTreeId", treeId);
        params.put("orgIds", (String)this.idList);
        uiContext.put((Object)"parentUI", (Object)this);
        uiContext.put((Object)"UIParams", params);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ItemDataImportWizardUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }
}

