/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.BoundTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.IItemHisExchgRate;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractItemHisExchgRateEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ItemHisExchgRateEditUI
extends AbstractItemHisExchgRateEditUI {
    private static final Logger logger = Logger.getLogger(ItemHisExchgRateEditUI.class);
    private int COL_CURRENCY = 0;
    private int COL_DIRECTRATE = 1;
    private int COL_AMOUNT = 2;
    private OrgTreeInfo orgTreeInfo = null;
    private HashMap dataCollectMapByNumber = new HashMap();
    protected boolean isEnableSelectCompany = false;

    public ItemHisExchgRateEditUI() throws Exception {
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.isEnableSelectCompany = true;
    }

    protected void initListener() {
        super.initListener();
        this.dateChangeDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getOldValue() != null && !eventObj.getOldValue().equals(eventObj.getNewValue()) || eventObj.getOldValue() != null && !eventObj.getOldValue().equals(eventObj.getNewValue())) {
                    try {
                        ItemHisExchgRateEditUI.this.initOrgBound();
                        ItemHisExchgRateEditUI.this.initOrgBoundGroup();
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"initOrgBound_EASBizException", (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"initOrgBound_BOSException", (Throwable)e);
                    }
                }
            }
        });
    }

    public void onLoad() throws Exception {
        DataCollectInfo dataCollect;
        this.f7OrgBoundGrp.setEnabled(false);
        this.initCompanyF7();
        this.initPromRateEntry();
        this.initData();
        super.onLoad();
        this.setControlsStatus(false);
        this.txtChangeAmount.setPrecision(4);
        this.txtChangeAmount.setHorizontalAlignment(4);
        if (this.txtChangeAmount.getValue() == null) {
            this.txtChangeAmount.setValue((Object)CslConstant.BGZERO);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
        this.menuSubmitOption.setVisible(false);
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        DataCollectCollection datacollect = DataCollectFactory.getRemoteInstance().getDataCollectCollection("select * where number in ('ACTUALDATA','BUDGETDATA')");
        for (int i = 0; i < datacollect.size(); ++i) {
            dataCollect = datacollect.get(i);
            boolean check = CSLPermissionUtil.hasDataCollectPermissionAndParam(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), dataCollect);
            if (!check) continue;
            this.cbDataCollect.addItem((Object)dataCollect);
            this.dataCollectMapByNumber.put(dataCollect.getNumber(), dataCollect);
        }
        BOSUuid dataCollectId = null;
        if (this.editData != null && this.editData.getDataCollect() != null) {
            dataCollectId = this.editData.getDataCollect().getId();
        }
        if (dataCollectId != null) {
            dataCollect = DataCollectFactory.getRemoteInstance().getDataCollectInfo((IObjectPK)new ObjectUuidPK(dataCollectId));
            this.cbDataCollect.setSelectedItem((Object)dataCollect);
        } else {
            Object obj = this.dataCollectMapByNumber.get("ACTUALDATA");
            if (obj != null) {
                this.cbDataCollect.setSelectedItem(obj);
            }
        }
        this.cbDataCollect.setRequired(true);
        if ("true".equals(isSupportOtherDS)) {
            this.kDDataCollect.setVisible(true);
        } else {
            this.kDDataCollect.setVisible(false);
        }
        if (this.editData != null) {
            DataCollectInfo dataCollect2;
            BOSUuid dataCollectId1;
            OrgTreeInfo selectOrg = this.editData.getOrgBound();
            if (selectOrg != null) {
                BOSUuid selectOrgId = selectOrg.getId();
                selectOrg = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(selectOrgId));
                if (selectOrg != null) {
                    int itemCount = this.cmbOrgBound.getItemCount();
                    for (int i = 0; i < itemCount; ++i) {
                        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cmbOrgBound.getItemAt(i);
                        if (!selectOrgId.toString().equals(orgTreeInfo.getId().toString())) continue;
                        this.cmbOrgBound.setSelectedItem((Object)orgTreeInfo);
                        break;
                    }
                }
            }
            if (this.editData.getDataCollect() != null && (dataCollectId1 = this.editData.getDataCollect().getId()) != null && (dataCollect2 = DataCollectFactory.getRemoteInstance().getDataCollectInfo((IObjectPK)new ObjectUuidPK(dataCollectId1))) != null) {
                this.cbDataCollect.setSelectedItem((Object)dataCollect2);
            }
        }
        this.chkPromissoryRate.setSelected(true);
        this.chkPromissoryRate.setEnabled(false);
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.f7Item, null);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        Object sel = this.cbDataCollect.getSelectedItem();
        Object value = this.txtChangeAmount.getValue();
        Object company = this.f7Company.getValue();
        Object orgUnit = this.f7OrgBoundGrp.getValue();
        this.getUIContext().put("isCopy", Boolean.TRUE);
        super.actionCopy_actionPerformed(e);
        this.getUIContext().remove("isCopy");
        this.cbDataCollect.setSelectedItem(sel);
        this.txtChangeAmount.setValue(value);
        try {
            if (company != null && company instanceof FullOrgUnitInfo) {
                String currentOrgID = this.editData.getTrackRecordCreator().getId().toString();
                String currentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                if (!currentOrgID.equals(currentCreateOrgID)) {
                    String orgId = ((FullOrgUnitInfo)company).getId().toString();
                    String oql = "where user.id='" + userId + "' and org.id='" + orgId + "' and type=" + 10;
                    if (!OrgRangeFactory.getRemoteInstance().exists(oql)) {
                        this.f7Company.setData(null);
                    }
                }
            }
            if (orgUnit != null && orgUnit instanceof FullOrgUnitInfo) {
                String orgId = ((FullOrgUnitInfo)orgUnit).getId().toString();
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                String oql = "where user.id='" + userId + "' and org.id='" + orgId + "' and type=" + 10;
                if (!OrgRangeFactory.getRemoteInstance().exists(oql)) {
                    if (this.cmbOrgBound.getItemCount() > 0) {
                        this.cmbOrgBound.setSelectedIndex(0, false);
                    }
                    this.f7OrgBoundGrp.setData(null);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.chkPromissoryRate.setSelected(true);
        try {
            this.actionChkSetPromRate_actionPerformed(null);
            if ("ADDNEW".equals(this.getOprtState()) && this.actionCopy.isEnabled()) {
                this.txtChangeAmount.setValue((Object)CslConstant.BGZERO);
                this.cbDataCollect.setSelectedItem(this.dataCollectMapByNumber.get("ACTUALDATA"));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        super.storeFields();
        BigDecimal bdTmp = (BigDecimal)this.txtChangeAmount.getValue(BigDecimal.class);
        Calendar ca = Calendar.getInstance();
        ca.setTime((java.util.Date)this.dateChangeDate.getValue());
        int year = ca.get(1);
        int month = ca.get(2);
        int day = ca.get(5);
        ca.clear();
        ca.set(year, month, day, 0, 0, 0);
        Timestamp stamp = new Timestamp(ca.getTimeInMillis());
        this.editData.setChangeDate(stamp);
        this.editData.setSyncOldValue(true);
        this.editData.setChangeAmount(bdTmp);
        DataCollectInfo dataCollect = (DataCollectInfo)this.cbDataCollect.getSelectedItem();
        this.editData.setDataCollect(dataCollect);
        if (dataCollect != null) {
            this.editData.setDataCollectNumber(dataCollect.getNumber());
        }
        this.editData.setSyncOldValue(false);
    }

    private void addCreatrOrg() {
        boolean oldIsSyncValue = this.editData.isSyncOldValue();
        this.editData.setSyncOldValue(true);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
        this.editData.setSyncOldValue(oldIsSyncValue);
    }

    protected IObjectValue createNewData() {
        return new ItemHisExchgRateInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemHisExchgRateFactory.getRemoteInstance();
    }

    private void initData() throws BOSException, EASBizException {
        this.dateChangeDate.setValue((Object)CslRptUtil.getCurrencyTime());
    }

    private void initOrgBound() throws BOSException, EASBizException {
        BoundTypeEnum boundType = (BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem());
        if (boundType != null) {
            boolean OrgBound = boundType.equals((Object)BoundTypeEnum.OrgBound);
            if (OrgBound) {
                OrgTreeInfo select;
                Date date = this.dateChangeDate.getSqlDate();
                java.util.Date lastDate = RPTDateUtil.getLastDayByDate(new Date(date.getTime()));
                OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection(lastDate);
                this.cmbOrgBound.removeAllItems();
                this.cmbOrgBound.addItems(otc.toArray());
                if (this.editData != null && this.editData.getOrgBound() != null && this.editData.getOrgBound().getId() != null) {
                    OrgTreeInfo orgTree = this.editData.getOrgBound();
                    String sourceNumber = null;
                    if (orgTree != null) {
                        sourceNumber = orgTree.getNumber();
                    }
                    if (!StringUtil.isEmpty(sourceNumber)) {
                        for (int i = 0; i < this.cmbOrgBound.getItemCount(); ++i) {
                            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cmbOrgBound.getItemAt(i);
                            if (sourceNumber.equals(orgTreeInfo.getNumber())) {
                                this.cmbOrgBound.setSelectedIndex(i);
                                break;
                            }
                            if (i != this.cmbOrgBound.getItemCount() - 1 || !"VIEW".equals(this.getOprtState())) continue;
                            this.cmbOrgBound.removeAllItems();
                            this.cmbOrgBound.addItem((Object)orgTree);
                        }
                    }
                }
                if ((select = (OrgTreeInfo)this.cmbOrgBound.getSelectedItem()) == null) {
                    this.f7OrgBoundGrp.setEnabled(false);
                    this.f7OrgBoundGrp.setValue(null);
                } else {
                    this.f7OrgBoundGrp.setEnabled(true);
                }
            }
        } else {
            this.cmbOrgBound.removeAllItems();
        }
    }

    private void initOrgBoundGroup() throws BOSException {
        BoundTypeEnum boundType;
        if (this.cmbOrgBound.getSelectedItem() != null) {
            if (this.editData != null && this.editData.getOrgBound() != null) {
                OrgTreeInfo selectOrgTreeInfo = (OrgTreeInfo)this.cmbOrgBound.getSelectedItem();
                StringBuffer ksql = new StringBuffer();
                ksql.append("select unit.id,unit.name,unit.number,unit.longNumber,unit.level,level ");
                ksql.append("where tree.id='").append(selectOrgTreeInfo.getId().toString()).append("'");
                ksql.append(" and unit.isunion=1");
                IOrgStructure iStruc = OrgStructureFactory.getRemoteInstance();
                OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(ksql.toString());
                FullOrgUnitInfo curUnitInfo = null;
                FullOrgUnitInfo fullOrgUnitInfo = this.editData.getOrgBoundGrp();
                boolean isExit = false;
                for (int i = 0; i < strucInfos.size(); ++i) {
                    curUnitInfo = strucInfos.get(i).getUnit();
                    if (curUnitInfo == null || fullOrgUnitInfo == null || !curUnitInfo.getNumber().equals(fullOrgUnitInfo.getNumber())) continue;
                    this.f7OrgBoundGrp.setValue((Object)curUnitInfo);
                    isExit = true;
                    break;
                }
                if (!isExit) {
                    this.f7OrgBoundGrp.setValue(null);
                }
            } else {
                this.f7OrgBoundGrp.setValue(null);
            }
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 2);
            f7.setTreeID(((OrgTreeInfo)this.cmbOrgBound.getSelectedItem()).getId().toString());
            f7.setMultiSelect(false);
            this.f7OrgBoundGrp.setSelector((KDPromptSelector)f7);
        }
        if ((boundType = (BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem())) != null) {
            boolean isCompany = boundType.equals((Object)BoundTypeEnum.Company);
            this.cmbOrgBound.setEnabled(!isCompany);
            this.f7OrgBoundGrp.setEnabled(!isCompany);
            this.f7Company.setEnabled(isCompany && this.isEnableSelectCompany);
            this.f7PrmtTargetCompany.setEnabled(isCompany);
        }
    }

    @Override
    public void actionBoundTypeChanged_actionPerformed(ActionEvent e) throws Exception {
        super.actionBoundTypeChanged_actionPerformed(e);
        this.setControlsStatus(false);
    }

    private void setControlsStatus(boolean isModifyValue) throws BOSException, EASBizException {
        BoundTypeEnum boundType = (BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem());
        if (boundType != null) {
            boolean isCompany = boundType.equals((Object)BoundTypeEnum.Company);
            if (isModifyValue) {
                this.cmbOrgBound.setSelectedItem(null);
                this.f7OrgBoundGrp.setValue(null);
                this.f7Company.setValue(null);
                this.f7PrmtTargetCompany.setValue(null);
            }
            this.cmbOrgBound.setEnabled(!isCompany);
            this.f7OrgBoundGrp.setEnabled(!isCompany);
            this.cmbOrgBound.setRequired(!isCompany);
            this.f7OrgBoundGrp.setRequired(!isCompany);
            this.f7Company.setEnabled(isCompany && this.isEnableSelectCompany);
            this.f7PrmtTargetCompany.setEnabled(isCompany && this.isEnableSelectCompany);
            if (isCompany) {
                this.f7Company.setFocusable(true);
                this.f7PrmtTargetCompany.setFocusable(true);
                this.cmbOrgBound.setSelectedItem(null);
                this.f7OrgBoundGrp.setValue(null);
            } else {
                this.initOrgBound();
                this.initOrgBoundGroup();
                this.cmbOrgBound.setFocusable(true);
                this.f7Company.setValue(null);
                this.f7PrmtTargetCompany.setValue(null);
                if (this.cmbOrgBound.getSelectedItem() != null) {
                    this.f7OrgBoundGrp.setEnabled(true);
                }
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String dataCollectNumber;
        BigDecimal bgValue;
        super.beforeStoreFields(e);
        if (this.cbDataCollect.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("checkSelectDC"));
            SysUtil.abort();
        }
        if (this.f7Item.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectItem"));
            SysUtil.abort();
        }
        if (this.cmbBoundType.getSelectedIndex() < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("945_HisExchgSelectOrgType"));
            SysUtil.abort();
        }
        if (((BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem())).getValue() == 1) {
            if (this.cmbOrgBound.getSelectedItem() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectBound"));
                SysUtil.abort();
            }
            if (this.f7OrgBoundGrp.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectGroup"));
                SysUtil.abort();
            }
        } else {
            if (this.f7Company.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectCompany"));
                SysUtil.abort();
            }
            if (!(this.f7Company.getValue() instanceof FullOrgUnitInfo) && this.f7Company.getValue() instanceof OrgUnitInfo) {
                this.f7Company.setValue((Object)((OrgUnitInfo)this.f7Company.getValue()).castToFullOrgUnitInfo());
            }
            if (this.f7PrmtTargetCompany.getValue() != null && !(this.f7PrmtTargetCompany.getValue() instanceof FullOrgUnitInfo) && this.f7Company.getValue() instanceof OrgUnitInfo) {
                this.f7PrmtTargetCompany.setValue((Object)((OrgUnitInfo)this.f7PrmtTargetCompany.getValue()).castToFullOrgUnitInfo());
            }
        }
        if (this.f7Currency.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectCurrency"));
            SysUtil.abort();
        }
        if (this.txtChangeAmount.getValue(BigDecimal.class) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectChangeAmount"));
            SysUtil.abort();
        }
        if (this.dateChangeDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgSelectChangeDate"));
            SysUtil.abort();
        }
        if ((bgValue = (BigDecimal)this.txtChangeAmount.getValue(BigDecimal.class)).compareTo(new BigDecimal("9999999999999")) > 0 || bgValue.compareTo(new BigDecimal("-9999999999999")) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("HisExchgValueOutOfRange"));
            SysUtil.abort();
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        StringBuffer param = new StringBuffer();
        String desc = null;
        DataBaseInfo rptItem = (DataBaseInfo)this.f7Item.getData();
        filterItems.add(new FilterItemInfo("item", (Object)rptItem.getId().toString()));
        param.append(rptItem.getName());
        BoundTypeEnum boundType = (BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem());
        filterItems.add(new FilterItemInfo("boundType", (Object)new Integer(boundType.getValue())));
        if (boundType.getValue() == 1) {
            DataBaseInfo orgBound = (DataBaseInfo)this.cmbOrgBound.getSelectedItem();
            filterItems.add(new FilterItemInfo("orgBound", (Object)orgBound.getId().toString()));
            DataBaseInfo orgGroup = (DataBaseInfo)this.f7OrgBoundGrp.getData();
            filterItems.add(new FilterItemInfo("orgBoundGrp", (Object)orgGroup.getId().toString()));
            param.append(",").append(orgBound.getName());
            param.append(",").append(orgGroup.getName());
            desc = CslRptUtil.getString("ItemHisRateKey2");
        } else {
            DataBaseInfo company = (DataBaseInfo)this.f7Company.getData();
            filterItems.add(new FilterItemInfo("company", (Object)company.getId().toString()));
            param.append(",").append(company.getName());
            desc = CslRptUtil.getString("ItemHisRateKey1");
            DataBaseInfo prmtTargetCompany = (DataBaseInfo)this.f7PrmtTargetCompany.getData();
            String prmtTargetCompanyId = null;
            if (prmtTargetCompany != null) {
                prmtTargetCompanyId = prmtTargetCompany.getId().toString();
                param.append(",").append(prmtTargetCompany.getName());
                desc = CslRptUtil.getString("ItemHisRateKey3");
            }
            filterItems.add(new FilterItemInfo("prmtTargetCompany", (Object)prmtTargetCompanyId));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.dateChangeDate.getSqlDate());
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date(0L));
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, 0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        param.append(format.format(calendar2.getTime()));
        DataBaseInfo currency = (DataBaseInfo)this.f7Currency.getData();
        filterItems.add(new FilterItemInfo("currency", (Object)currency.getId().toString()));
        param.append(",").append(currency.getName());
        DataCollectInfo dataCollect = (DataCollectInfo)this.cbDataCollect.getSelectedItem();
        if (dataCollect != null && (dataCollectNumber = dataCollect.getNumber()) != null && dataCollectNumber.length() != 0) {
            filterItems.add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
        }
        if (this.editData != null && this.editData.getId() != null) {
            filterItems.add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        IItemHisExchgRate itemHisExchgRate = ItemHisExchgRateFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filterInfo);
        CoreBaseCollection c = itemHisExchgRate.getCollection(ev);
        for (ItemHisExchgRateInfo entry : c) {
            java.util.Date dt = entry.getChangeDate();
            Calendar cx = Calendar.getInstance();
            cx.setTime(dt);
            if (cx.get(1) != calendar2.get(1) || cx.get(2) != calendar2.get(2) || cx.get(5) != calendar2.get(5)) continue;
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(desc, param));
            SysUtil.abort();
        }
        if (this.chkPromissoryRate.isSelected()) {
            if (this.kdtPromRate.getRowCount() <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("donotSetPromRate"));
                SysUtil.abort();
            } else {
                ArrayList<String> lstCurrency = new ArrayList<String>();
                for (int i = 0; i < this.kdtPromRate.getRowCount(); ++i) {
                    CurrencyInfo info = (CurrencyInfo)this.kdtPromRate.getCell(i, this.COL_CURRENCY).getValue();
                    if (info != null) {
                        if (info.getId().toString().equals(((CurrencyInfo)this.f7Currency.getData()).getId().toString())) {
                            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(CslRptUtil.getString("targetAndSourceCurrencyRepeat"), info.getName()));
                            SysUtil.abort();
                        }
                        if (lstCurrency.contains(info.getId().toString())) {
                            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(CslRptUtil.getString("targetCurrencyRepeat"), info.getName()));
                            SysUtil.abort();
                        }
                        lstCurrency.add(info.getId().toString());
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("targetCurrencyCannotIsNull"));
                        SysUtil.abort();
                    }
                    if (this.kdtPromRate.getCell(i, this.COL_DIRECTRATE).getValue() == null) {
                        MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("promRateCannotIsNull"));
                        SysUtil.abort();
                    }
                    if (this.kdtPromRate.getCell(i, this.COL_AMOUNT).getValue() != null) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("convertedValueCannotIsNull"));
                    SysUtil.abort();
                }
            }
        }
        if (!this.chkPromissoryRate.isSelected() && this.kdtPromRate.getRowCount() > 0) {
            this.kdtPromRate.removeRows(true);
        }
        this.editData.getPromRate().clear();
    }

    private void initCompanyF7() {
        this.f7PrmtTargetCompany.setCommitFormat("$number$");
        this.f7PrmtTargetCompany.setEditFormat("$number$");
        this.f7PrmtTargetCompany.setDisplayFormat("$name$");
        NewCompanyF7 f7 = CompanyF7Helper.getMultiOrgViewTypeUnitF7WithoutFilter((IUIObject)this, (OrgViewType[])new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.PROFITCENTER});
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.f7Company.setSelector((KDPromptSelector)f7);
        this.f7PrmtTargetCompany.setSelector((KDPromptSelector)f7);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initOrgBound();
        this.f7OrgBoundGrp.setValue((Object)this.editData.getOrgBoundGrp());
        BoundTypeEnum boundType = (BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem());
        if (boundType != null) {
            boolean isCompany = boundType.equals((Object)BoundTypeEnum.Company);
            if (isCompany) {
                this.f7Company.setEnabled(this.isEnableSelectCompany);
                this.f7PrmtTargetCompany.setEnabled(this.isEnableSelectCompany);
                this.cmbOrgBound.setEnabled(false);
                this.cmbOrgBound.setSelectedItem(null);
                this.f7OrgBoundGrp.setEnabled(false);
                this.f7OrgBoundGrp.setValue(null);
            } else {
                this.cmbOrgBound.setEnabled(true);
                this.f7OrgBoundGrp.setEnabled(true);
                this.f7Company.setEnabled(false);
                this.f7Company.setValue(null);
                this.f7PrmtTargetCompany.setEnabled(false);
                this.f7PrmtTargetCompany.setValue(null);
            }
        }
    }

    @Override
    public void actionChkSetPromRate_actionPerformed(ActionEvent e) throws Exception {
        super.actionChkSetPromRate_actionPerformed(e);
        if (this.uiWindow == null) {
            return;
        }
        this.kdtPromRate.getStyleAttributes().setLocked(!this.chkPromissoryRate.isSelected());
        Window window = SwingUtilities.getWindowAncestor((JComponent)this.uiWindow.getUIObject());
        if (this.chkPromissoryRate.isSelected()) {
            for (int i = 0; i < this.kdtPromRate.getRowCount(); ++i) {
                IRow row = this.kdtPromRate.getRow(i);
                CurrencyInfo currency = (CurrencyInfo)row.getCell(this.COL_CURRENCY).getValue();
                ICell cell = row.getCell(this.COL_AMOUNT);
                if (currency == null) continue;
                this.setCellPrecision(currency, cell);
            }
        }
        this.btnAddLine.setVisible(this.chkPromissoryRate.isSelected());
        this.btnRemoveLine.setVisible(this.chkPromissoryRate.isSelected());
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        if (this.kdtPromRate.isEnabled()) {
            this.kdtPromRate.addRow();
        }
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveLine_actionPerformed(e);
        if (this.kdtPromRate.isEnabled() && this.kdtPromRate.getSelectManager().getActiveRowIndex() >= 0) {
            this.kdtPromRate.removeRow(this.kdtPromRate.getSelectManager().getActiveRowIndex());
        }
    }

    private void initPromRateEntry() {
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kdtPromRate.checkParsed();
        this.kdtPromRate.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)CslRptUIUtil.getCurrencyF7()));
        this.kdtPromRate.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                ItemHisExchgRateEditUI.this.tableValueChanged(e);
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setMaximumValue((Comparable)new BigDecimal("100000"));
        formatField.setMinimumValue((Comparable)new BigDecimal("-100000"));
        formatField.setSupportedEmpty(false);
        formatField.setPrecision(6);
        KDTDefaultCellEditor rateEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kdtPromRate.getColumn(this.COL_DIRECTRATE).setEditor((ICellEditor)rateEditor);
        this.kdtPromRate.getColumn(this.COL_DIRECTRATE).getStyleAttributes().setNumberFormat("%R-{#,##0.######}f");
        KDFormattedTextField amountFormatField = new KDFormattedTextField();
        amountFormatField.setDataType(1);
        KDTDefaultCellEditor amountEditor = new KDTDefaultCellEditor((JTextField)amountFormatField);
        this.kdtPromRate.getColumn(this.COL_AMOUNT).setEditor((ICellEditor)amountEditor);
        this.kdtPromRate.getColumn(this.COL_AMOUNT).getStyleAttributes().setLocked(false);
        this.txtChangeAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ItemHisExchgRateEditUI.this.amountValueChanged();
            }
        });
    }

    private void tableValueChanged(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        CurrencyInfo currency = (CurrencyInfo)this.kdtPromRate.getRow(selectRow).getCell(this.COL_CURRENCY).getValue();
        if (e.getColIndex() == this.COL_DIRECTRATE) {
            if (e.getValue() != null && e.getOldValue() != e.getValue()) {
                BigDecimal bgAmount = new BigDecimal("0");
                if (!StringUtils.isEmpty((String)this.txtChangeAmount.getText()) && kdtEntry.getRow(selectRow).getCell(this.COL_DIRECTRATE).getValue() != null) {
                    bgAmount = this.txtChangeAmount.getBigDecimalValue();
                    try {
                        bgAmount = bgAmount.multiply(new BigDecimal(kdtEntry.getRow(selectRow).getCell(this.COL_DIRECTRATE).getValue().toString()));
                    }
                    catch (NumberFormatException exc) {
                        kdtEntry.getRow(selectRow).getCell(this.COL_DIRECTRATE).setValue(null);
                        return;
                    }
                    kdtEntry.getRow(selectRow).getCell(this.COL_AMOUNT).setValue((Object)this.getPrecisionValue(bgAmount, currency));
                }
            }
        } else if (e.getColIndex() == this.COL_AMOUNT) {
            if (e.getValue() != null && e.getOldValue() != e.getValue()) {
                BigDecimal bgAmount = new BigDecimal("0");
                if (!StringUtils.isEmpty((String)this.txtChangeAmount.getText()) && kdtEntry.getRow(selectRow).getCell(this.COL_AMOUNT).getValue() != null) {
                    kdtEntry.getRow(selectRow).getCell(this.COL_AMOUNT).setValue((Object)this.getPrecisionValue(new BigDecimal(kdtEntry.getRow(selectRow).getCell(this.COL_AMOUNT).getValue().toString()), currency));
                    bgAmount = this.txtChangeAmount.getBigDecimalValue();
                    try {
                        bgAmount = new BigDecimal(kdtEntry.getRow(selectRow).getCell(this.COL_AMOUNT).getValue().toString()).divide(bgAmount, 6, 4);
                    }
                    catch (NumberFormatException exc) {
                        kdtEntry.getRow(selectRow).getCell(this.COL_AMOUNT).setValue(null);
                        return;
                    }
                    catch (Exception exc2) {
                        return;
                    }
                    kdtEntry.getRow(selectRow).getCell(this.COL_DIRECTRATE).setValue((Object)bgAmount);
                }
            }
        } else if (e.getColIndex() == this.COL_CURRENCY) {
            ICell cell = this.kdtPromRate.getCell(selectRow, this.COL_AMOUNT);
            if (currency != null) {
                this.setCellPrecision(currency, cell);
            }
        }
    }

    private BigDecimal getPrecisionValue(BigDecimal curValue, CurrencyInfo currency) {
        if (currency != null && curValue != null) {
            int precision = CslRptUIUtil.getPrecisionByCry(currency);
            return curValue.setScale(precision, 4);
        }
        return curValue;
    }

    private void setCellPrecision(CurrencyInfo currency, ICell cell) {
        int precision = 4;
        if (currency != null) {
            precision = CslRptUIUtil.getPrecisionByCry(currency);
        }
        StringBuffer formatStr = new StringBuffer();
        formatStr.append("%R-{#,##0.");
        for (int j = precision; j > 0; --j) {
            formatStr.append("0");
        }
        formatStr.append("}f");
        cell.getStyleAttributes().setNumberFormat(formatStr.toString());
    }

    private void amountValueChanged() {
        if (this.chkPromissoryRate.isSelected()) {
            for (int i = 0; i < this.kdtPromRate.getRowCount(); ++i) {
                BigDecimal bgAmount = this.txtChangeAmount.getBigDecimalValue();
                if (bgAmount == null) {
                    bgAmount = new BigDecimal("0");
                }
                if (this.kdtPromRate.getRow(i).getCell(this.COL_DIRECTRATE).getValue() == null) continue;
                bgAmount = bgAmount.multiply(new BigDecimal(this.kdtPromRate.getRow(i).getCell(this.COL_DIRECTRATE).getValue().toString()));
                this.kdtPromRate.getRow(i).getCell(this.COL_AMOUNT).setValue((Object)bgAmount);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)this.getUIWindow();
            uiFrame.setResizable(false);
        }
        this.actionChkSetPromRate_actionPerformed(null);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.txtChangeAmount.getValue() == null) {
            this.txtChangeAmount.setValue((Object)CslConstant.BGZERO);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("boundType"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("item.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("changeAmount"));
        sic.add(new SelectorItemInfo("changeDate"));
        sic.add(new SelectorItemInfo("orgBoundGrp.*"));
        sic.add(new SelectorItemInfo("isSetPromRate"));
        sic.add(new SelectorItemInfo("promRate.*"));
        sic.add(new SelectorItemInfo("promRate.targetCurrency.*"));
        sic.add(new SelectorItemInfo("promRate.directRate"));
        sic.add(new SelectorItemInfo("promRate.amount"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("summary"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        sic.add(new SelectorItemInfo("prmtTargetCompany.*"));
        return sic;
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.isCompanyGrayControl(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.isCompanyGrayControl(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.isCompanyGrayControl(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.isCompanyGrayControl(e);
    }

    private void isCompanyGrayControl(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.actionSubmit.setEnabled(false);
        this.setOprtState(OprtState.VIEW);
        this.initOrgBound();
        this.showEditBtnByCreateOrg();
        BoundTypeEnum boundType = (BoundTypeEnum)((Object)this.cmbBoundType.getSelectedItem());
        boolean enabled = boundType.getValue() == 2;
        this.cmbOrgBound.setEnabled(!enabled);
        this.actionOrgBoundChanged.setEnabled(!enabled);
        this.f7OrgBoundGrp.setEnabled(!enabled);
        this.f7Company.setEnabled(enabled && this.isEnableSelectCompany);
        this.f7PrmtTargetCompany.setEnabled(enabled && this.isEnableSelectCompany);
    }

    @Override
    public void actionOrgBoundChanged_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgBoundChanged_actionPerformed(e);
        this.initOrgBoundGroup();
    }
}

