/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IMnsRptSeqSchemeFacade;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.MnsRptSeqSchemeFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractMnsRptCompanyFillSeqUI;
import com.kingdee.eas.fi.gr.fast.CSLContextData;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MnsRptCompanyFillSeqUI
extends AbstractMnsRptCompanyFillSeqUI {
    private static final Logger logger = CoreUIObject.getLogger(MnsRptCompanyFillSeqUI.class);
    private boolean isModified = false;
    private List orgUnitCollection = null;
    private String schemeID = "";
    private static final int UP = 1;
    private static final int DOWN = 0;
    private int seqDirection = 0;
    private KDTSortManager sortManager = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        IMnsRptSeqSchemeFacade controller = MnsRptSeqSchemeFacadeFactory.getRemoteInstance();
        HashMap orgUnitMap = controller.getOrgUnitList(this.getSchemeInfo());
        this.schemeID = (String)orgUnitMap.get("SchemeID");
        this.orgUnitCollection = (List)orgUnitMap.get("OrgUnitList");
        if (this.orgUnitCollection != null) {
            this.initTable();
        }
        this.sortManager = new KDTSortManager(this.tblMain);
        this.sortManager.setSortAuto(false);
    }

    private HashMap getSchemeInfo() throws BOSException, EASBizException {
        ICSLContext ctx = null;
        if (this.getUIContext().get("orgBound") != null) {
            int year = (Integer)this.getUIContext().get("year");
            int period = (Integer)this.getUIContext().get("period");
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
            OrgTreeInfo orgBound = (OrgTreeInfo)this.getUIContext().get("orgBound");
            OrgUnitInfo orgUnit = (OrgUnitInfo)this.getUIContext().get("orgUnit");
            Date date = (Date)this.getUIContext().get("date");
            CurrencyInfo currency = (CurrencyInfo)this.getUIContext().get("currency");
            ctx = new CSLContextData(DataCollectConstant.getActualDC(), orgBound, orgUnit, date, period, periodType, year, false, currency);
        } else {
            ctx = CSLContext.getInstance();
        }
        String orgTreeID = ctx.getCurOrgBound().getId().toString();
        OrgUnitInfo orgUnitGroup = ctx.getCurOrgGroup();
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(ctx.getCurOrgBound());
        HashMap<String, Object> scheme = new HashMap<String, Object>();
        scheme.put("OrgTree", orgTreeID);
        scheme.put("OrgUnitGroup", orgUnitGroup);
        scheme.put("MergeMode", (Object)mergeMode);
        scheme.put("queryIndustryName", Boolean.TRUE);
        scheme.put("queryAllName", Boolean.TRUE);
        return scheme;
    }

    public List getOrgUnitCollection() {
        return this.orgUnitCollection;
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        List orgUnitList = this.getOrgUnitCollection();
        this.tblMain.removeRows();
        HashMap values = null;
        String orgUnitNumber = "";
        String orgUnitName = "";
        String orgUnitSimpleName = "";
        String industry = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"548_MnsRptCompanyFillSeqUI");
        for (int i = 0; i < orgUnitList.size(); ++i) {
            values = (HashMap)orgUnitList.get(i);
            orgUnitNumber = (String)values.get("OrgUnitNumber");
            orgUnitName = (String)values.get("OrgUnitName");
            orgUnitSimpleName = (String)values.get("OrgUnitSimpleName");
            industry = (String)values.get("IndustryName");
            IRow row = this.tblMain.addRow();
            row.getCell("number", true).setValue((Object)orgUnitNumber);
            row.getCell("name", true).setValue((Object)orgUnitName);
            row.getCell("simpleName", true).setValue((Object)orgUnitSimpleName);
            row.getCell("industry", true).setValue((Object)industry);
            row.setUserObject(orgUnitList.get(i));
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        this.checkSelected();
        this.isModified = true;
        int[] selectedRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        Set set = this.toMove_RowIndex_Set(0);
        this.rowMove(set, 0);
        this.setSelectedRowAfterMove(selectedRowIndexs, 0);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.updateScheme();
        this.destroyWindow();
    }

    public void updateScheme() throws BOSException, EASBizException {
        if (this.isModified) {
            this.orgUnitCollection = new LinkedList();
            for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
                Object obj = this.tblMain.getRow(i).getUserObject();
                this.orgUnitCollection.add(obj);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("SchemeID", this.schemeID);
            map.put("OrgUnitList", this.orgUnitCollection);
            IMnsRptSeqSchemeFacade controller = MnsRptSeqSchemeFacadeFactory.getRemoteInstance();
            controller.update(map);
        }
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        this.checkSelected();
        this.isModified = true;
        int[] selectedRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        Set set = this.toMove_RowIndex_Set(1);
        this.rowMove(set, 1);
        this.setSelectedRowAfterMove(selectedRowIndexs, 1);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    private void rowMove(Set set, int mode) {
        int i;
        if (set == null || set.size() == 0) {
            return;
        }
        LinkedList<IRow> sourceList = new LinkedList<IRow>();
        int rowCount = this.tblMain.getRowCount3();
        HashMap map = new HashMap();
        int[][] resultListIndexs = new int[rowCount][2];
        for (i = 0; i < rowCount; ++i) {
            sourceList.add(this.tblMain.getRow(i));
            resultListIndexs[i][0] = i;
        }
        this.tblMain.removeRows();
        for (i = 0; i < sourceList.size(); ++i) {
            if (set.contains(new Integer(i))) {
                int direction = mode == 1 ? -1 : 1;
                resultListIndexs[i][1] = i + direction;
                map.put(new Integer(i + direction), sourceList.get(i));
                continue;
            }
            int temp = i;
            while (true) {
                int direction;
                int n = direction = mode == 1 ? 1 : -1;
                if (!set.contains(new Integer(temp + direction))) break;
                temp += direction;
            }
            resultListIndexs[i][1] = temp;
            map.put(new Integer(temp), sourceList.get(i));
        }
        for (i = 0; i < rowCount; ++i) {
            this.tblMain.addRow(i, (IRow)map.get(new Integer(i)));
        }
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private Set toMove_RowIndex_Set(int mode) {
        Integer index_forDelete;
        int index;
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            set.add(new Integer(rows[i]));
        }
        int n = index = mode == 1 ? 0 : this.tblMain.getRowCount3() - 1;
        while (set.contains(index_forDelete = new Integer(index))) {
            index = mode == 1 ? index + 1 : index - 1;
            set.remove(index_forDelete);
        }
        return set;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.isModified = true;
            this.orderByForTable(e);
            return;
        }
        super.tblMain_tableClicked(e);
    }

    private void orderByForTable(KDTMouseEvent e) throws Exception {
        this.seqDirection = this.seqDirection == 0 ? 1 : 0;
        String key_in_table = this.tblMain.getColumn(e.getColIndex()).getKey();
        String key_in_orgUnit = "";
        key_in_orgUnit = key_in_table.equals("number") ? "OrgUnitNumber" : (key_in_table.equals("name") ? "OrgUnitName" : (key_in_table.equals("simpleName") ? "OrgUnitSimpleName" : "IndustryName"));
        OrgUnitListcomparator orgUnitListcomparator = new OrgUnitListcomparator(key_in_orgUnit, this.seqDirection);
        Collections.sort(this.getOrgUnitCollection(), orgUnitListcomparator);
        this.initTable();
        orgUnitListcomparator = null;
        this.sortManager.sort(e.getColIndex(), this.seqDirection);
    }

    private void setSelectedRowAfterMove(int[] rowIndexs, int direction) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int i = 0; i < rowIndexs.length; ++i) {
            indexSet.add(new Integer(rowIndexs[i]));
        }
        int m = 0;
        while (m < rowIndexs.length) {
            boolean find = false;
            int top = rowIndexs[m];
            int bottom = rowIndexs[m];
            while (indexSet.contains(new Integer(bottom))) {
                ++bottom;
                ++m;
                find = true;
            }
            if (find) {
                if (direction == 1) {
                    this.tblMain.getSelectManager().add(top - 1, 0, bottom - 2, 0);
                } else {
                    this.tblMain.getSelectManager().add(top + 1, 0, bottom, 0);
                }
                find = false;
                continue;
            }
            ++m;
        }
        this.tblMain.scrollToVisible(rowIndexs[0] + (direction == 1 ? -1 : 1) + 5, 0);
    }

    class OrgUnitListcomparator
    implements Comparator {
        private String compareKey = "";
        private int direction = 0;
        RuleBasedCollator collator = null;

        OrgUnitListcomparator(String compareKey, int direction) {
            this.compareKey = compareKey;
            this.direction = direction;
            RuleBasedCollator rule = (RuleBasedCollator)Collator.getInstance(Locale.CHINA);
            try {
                this.collator = new RuleBasedCollator(rule.getRules());
            }
            catch (ParseException e) {
                logger.error((Object)"RuleBasedCollator_ParseException", (Throwable)e);
            }
        }

        public int compare(Object o1, Object o2) {
            String s2;
            String s1 = StringUtils.isEmpty((String)((String)((HashMap)o1).get(this.compareKey))) ? "" : (String)((HashMap)o1).get(this.compareKey);
            String string = s2 = StringUtils.isEmpty((String)((String)((HashMap)o2).get(this.compareKey))) ? "" : (String)((HashMap)o2).get(this.compareKey);
            if (this.direction == 0) {
                return this.collator.compare(s1, s2);
            }
            return this.collator.compare(s2, s1);
        }
    }
}

