/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractMnsRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptParaMgrStartergy;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptMenuStrategy;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.TextMsgBox;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptGuideHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReportProcess;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptMessage;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptParaMgrStartergy;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;

public class MnsRptEditUI
extends AbstractMnsRptEditUI
implements IReportProcess {
    private static final long serialVersionUID = 3395381072746194456L;
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    IUIWindow reportUI;
    CslReportInfo curMnsReport = null;
    ICSLContext cslCtx = null;
    OrgTreeInfo unitTree;
    OrgUnitInfo company;
    Map mapLinkOpenParam = null;
    public static final int BATCHSAVE_REPEAT = 1;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;
    private boolean isSupportOtherDS;
    private boolean isMergeByFiscalPeriod = false;
    private PeriodCollection periods = null;
    private boolean isCtrlPress = false;
    boolean isSelect = true;

    public MnsRptEditUI() throws Exception {
        boolean[] value = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_SupportOtherDS", "GR_CSL_MergeByFiscalPeriod"});
        this.isSupportOtherDS = value[0];
        this.isMergeByFiscalPeriod = value[1];
    }

    public void setCurMnsReport(CslReportInfo info) {
        this.editData = info;
    }

    public CslReportInfo getCurMnsReport() {
        return this.editData;
    }

    public void setData(byte[] data) {
        this.getCurMnsReport().setZipData(data);
    }

    public byte[] getData() {
        return this.getCurMnsReport().getZipData();
    }

    public IObjectValue getEditDataObject() {
        return this.getCurMnsReport();
    }

    public boolean getIsAudited() {
        if (this.getCurMnsReport() != null) {
            return this.getCurMnsReport().getAuditedStatus().getValue() != 1;
        }
        return false;
    }

    public boolean getIsCacl() {
        return false;
    }

    public String getReportUIName() {
        return MnsRptProcessUI.class.getName();
    }

    public RptStrategyManager getRptStrategyManager() {
        RptStrategyManager rptStrategyManager = new RptStrategyManager();
        MnsRptMenuStrategy mnsMenu = new MnsRptMenuStrategy();
        mnsMenu.setReportBaseInfo(this.getCurMnsReport());
        rptStrategyManager.setCslParamStartegy(true);
        rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)mnsMenu);
        CslRptParaMgrStartergy para = new CslRptParaMgrStartergy();
        rptStrategyManager.setRptParaMgrStartergy((RptParaMgrStartergy)para);
        return rptStrategyManager;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    public SelectorItemCollection getSelectorsForTemplate() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    public Object getSheetparam() {
        return this.getCurMnsReport().getSheetParam();
    }

    public Object getSheetparam(String sheetId) {
        RptSheetParamCollection params = this.getCurMnsReport().getSheetParam();
        if (params != null && params.size() > 0) {
            int paramsSize = params.size();
            for (int i = 0; i < paramsSize; ++i) {
                if (!params.get(i).getSheetID().trim().equals(sheetId)) continue;
                return params.get(i);
            }
        }
        return null;
    }

    public SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.id"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.name"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.number"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("orgSavePoint.relaType"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass.id"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass.number"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass.reportGroup"));
        return sic;
    }

    public Object getView(String arg0) throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue("id", (Object)this.getCurMnsReport().getId().toString());
        TemplateInfo templateInfoView = ((ITemplate)this.getBizInterface()).getTemplateInfo((IObjectPK)pk);
        ReportProcessUI reportProcessUI = new ReportProcessUI();
        RptTablePane viewPane = reportProcessUI.loadReportContent(templateInfoView.getKDF(), true);
        return viewPane;
    }

    public RptMessage checkCreatSheet(List rptSheets, RptSheet currentSheet) {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mapLinkOpenParam = (Map)this.getUIContext().get("KEY_LINKOPENRPT_PARAM");
        this.cslCtx = this.mapLinkOpenParam != null ? CSLContextHelper.getCSLContext(this.mapLinkOpenParam) : CSLContextHelper.getCSLContext();
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(null, this.cslCtx.getCurOrgBound());
        }
        if (this.getUIContext().get("OpenReport") != null) {
            this.openReportUI();
        } else {
            this.tblTemplate.checkParsed();
            this.unitTree = this.cslCtx.getCurOrgBound();
            this.company = this.cslCtx.getCurOrgGroup();
            this.tblTemplate.getSelectManager().setSelectMode(10);
            this.initData();
        }
        this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString("AddNew"));
        KDTSortManager sm = new KDTSortManager(this.tblTemplate);
        sm.setEnableSortable(true);
        sm.setSortAuto(true);
        sm.setClickCount(1);
        this.tblTemplate.setSortMange(sm);
        this.tblTemplate.getColumn("Template.number").setSortable(true);
        this.tblTemplate.getColumn("Template.name").setSortable(true);
        this.tblTemplate.getColumn("Template.templateType").setSortable(true);
        this.tblTemplate.getColumn("Template.lastUpdateTime").setSortable(true);
        this.tblTemplate.getColumn("Template.periodType").setSortable(true);
        this.tblTemplate.getColumn("Template.description").setSortable(true);
        String dateTime = CslRptUIUtil.getNationalTimeFormatString();
        if (dateTime != null) {
            this.tblTemplate.getColumn("Template.lastUpdateTime").getStyleAttributes().setNumberFormat(dateTime);
        }
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
        CslRptUIUtil.addTableSelectedListener(this.tblTemplate, "select");
        this.initTableEvent();
        this.menuBiz.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.menuItemAddNew.setVisible(false);
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initTableEvent() {
        this.tblTemplate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    MnsRptEditUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (MnsRptEditUI.this.isCtrlPress) {
                    MnsRptEditUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblTemplate.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int count = MnsRptEditUI.this.tblTemplate.getRowCount();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        MnsRptEditUI.this.tblTemplate.getRow(i).getCell("select").setValue((Object)false);
                    }
                }
            }
        });
        this.tblTemplate.getColumn("select").getStyleAttributes().setLocked(false);
    }

    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setCurrency(this.getCurMnsReport().getCurrency());
        newSheetParam.setRelaType(ReportTypeEnum.TEMPLATE);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setStatus(1);
        newSheetParam.setReportClass(CSLReportGroupEnum.COMMON);
        return newSheetParam;
    }

    public VirtualSheetParamInfo save() throws Exception {
        IObjectPK pk = ((ICslReport)this.getBizInterface()).submit((CoreBaseInfo)this.getCurMnsReport());
        this.setOprtState(OprtState.EDIT);
        this.setCurMnsReport((CslReportInfo)this.getBizInterface().getValue(pk, this.getRptSelectors()));
        return this.getCurMnsReport();
    }

    private SelectorItemCollection getRptSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        return sic;
    }

    public void switchReport(String reportId) {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getRptSelectors());
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblTemplate.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblTemplate.getRow(rowIndex = selectBlock.getTop())).getCell(this.tblTemplate.getColumnIndex("Template.id"))) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    private List getSelectedTemplateIdList() {
        ArrayList<String> list = new ArrayList<String>();
        int count = this.tblTemplate.getRowCount();
        if (count > 0) {
            boolean isSelect = false;
            for (int i = 0; i < count; ++i) {
                isSelect = (Boolean)this.tblTemplate.getRow(i).getCell("select").getValue();
                if (!isSelect) continue;
                String id = (String)this.tblTemplate.getRow(i).getCell("Template.id").getValue();
                list.add(id);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        if (list.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return list;
    }

    private void batchAddReport(List list) throws Exception {
        ArrayList<Object> successLst = new ArrayList<Object>();
        ArrayList<Object> repeatLst = new ArrayList<Object>();
        ArrayList<Object> failedLst = new ArrayList<Object>();
        ArrayList<CslReportInfo> successReportLst = new ArrayList<CslReportInfo>();
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        info.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        info.setSelector(this.getSelectorsForTemplate());
        Date date = (Date)this.datePickerDate.getValue();
        int year = this.cslCtx.getCurRptYear();
        short period = (short)this.cslCtx.getCurRptPeriod();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        TemplateCollection tempColl = TemplateFactory.getRemoteInstance().getTemplateCollection(info);
        for (TemplateInfo template : tempColl) {
            int n = this.addNewEditData(template, date, year, period, currency, this.unitTree, this.company, this.cslCtx.getCurDataCollect(), false, list.size());
            if (n == 1) {
                repeatLst.add(template);
                continue;
            }
            if (n == 2) {
                failedLst.add(template);
                continue;
            }
            successLst.add(template);
            successReportLst.add(this.editData);
        }
        HashMap<String, TemplateInfo> templateCache = new HashMap<String, TemplateInfo>();
        if (successReportLst.size() > 0) {
            for (TemplateInfo templateInfo : successLst) {
                templateCache.put(templateInfo.getId().toString(), templateInfo);
            }
            Map result = CslReportFactory.getRemoteInstance().batchAddDataToMnsReport(successReportLst);
            List list2 = (List)result.get("repeatLst");
            for (String templateID : list2) {
                repeatLst.add(templateCache.get(templateID));
            }
            List failedIDLst = (List)result.get("failedLst");
            for (String templateID : failedIDLst) {
                failedLst.add(templateCache.get(templateID));
            }
            List successIDLst = (List)result.get("successLst");
            for (String templateID : successIDLst) {
                successLst.add(templateCache.get(templateID));
            }
        }
        CslRptUIUtil.displayResult((Object)this, successLst, repeatLst, null, failedLst, ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getName());
    }

    public void displayResult(List successLst, List repeatLst, List failedLst) {
        StringBuffer sResult = new StringBuffer();
        if (!successLst.isEmpty()) {
            sResult.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"549_MnsRptEditUI"));
            sResult.append("\r\n");
            Iterator it1 = successLst.iterator();
            while (it1.hasNext()) {
                sResult.append("    ").append(((TemplateInfo)it1.next()).getName()).append("\r\n");
            }
            sResult.append("\r\n");
        }
        if (!repeatLst.isEmpty()) {
            sResult.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"373_CslRptUIUtil"));
            Iterator it2 = repeatLst.iterator();
            while (it2.hasNext()) {
                sResult.append("    ").append(((TemplateInfo)it2.next()).getName()).append("\r\n");
            }
            sResult.append("\r\n");
        }
        if (!failedLst.isEmpty()) {
            sResult.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"550_MnsRptEditUI"));
            sResult.append("\r\n");
            Iterator it3 = failedLst.iterator();
            while (it3.hasNext()) {
                sResult.append("    ").append(((TemplateInfo)it3.next()).getName()).append("\r\n");
            }
            sResult.append("\r\n");
        }
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"375_CslRptUIUtil"));
        ctx.put((Object)"TextLabel", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"551_MnsRptEditUI"));
        ctx.put((Object)"TextMsg", (Object)sResult.toString());
        if (!TextMsgBox.showMessageByModel(ctx)) {
            SysUtil.abort();
        }
    }

    public int addNewEditData(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company, DataCollectInfo dataCollect, boolean isCslWorkTable, int size) throws Exception {
        RptTmpTypeEnum tmpType = template.getTemplateType();
        RptSrcTypeEnum rptType = null;
        if (RptTmpTypeEnum.MANUSCRIPT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.MANUSCRIPT;
        } else if (RptTmpTypeEnum.MULTIDYNAMICMNSPORT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.MULTIDYNAMICMNSREPORT;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int periodType = template.getPeriodType().getValue();
        if (rptType != null && !this.verifyMnsReport(unitTree.getId().toString(), company.getId().toString(), periodType, year, period, currency.getId().toString(), template.getId().toString(), rptType.getValue())) {
            return 1;
        }
        try {
            Date startDate = FiscalPeriodHelper.getPeriodFirstDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.periods, this.isMergeByFiscalPeriod);
            Date endDate = FiscalPeriodHelper.getPeriodLastDate(this.periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.isMergeByFiscalPeriod);
            this.editData = MnsRptGuideHelper.createMnsRpt(date, year, period, unitTree, company, template, this.isSupportOtherDS, currency, startDate, endDate, null, SysContext.getSysContext().getCurrentFIUnit(), dataCollect);
        }
        catch (Exception exc) {
            if (!isCslWorkTable && size == 1) {
                MsgBox.showError((String)exc.getMessage());
                SysUtil.abort();
            }
            return 2;
        }
        return 3;
    }

    public CslReportInfo addSingleEditData(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company) throws IOException, Exception {
        RptTmpTypeEnum tmpType = template.getTemplateType();
        RptSrcTypeEnum rptType = null;
        if (RptTmpTypeEnum.MANUSCRIPT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.MANUSCRIPT;
        } else if (RptTmpTypeEnum.MULTIDYNAMICMNSPORT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.MULTIDYNAMICMNSREPORT;
        }
        int periodType = template.getPeriodType().getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date startDate = FiscalPeriodHelper.getPeriodFirstDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.periods, this.isMergeByFiscalPeriod);
        Date endDate = FiscalPeriodHelper.getPeriodLastDate(this.periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.isMergeByFiscalPeriod);
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(year);
        editData.setPeriod(period);
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setTemplate(template);
        editData.setOrgTree(unitTree);
        editData.setOrgUnit(company);
        Book tmplbook = template.getBook();
        boolean isAutoCalculate = tmplbook.isAutoCalculate();
        tmplbook.setAutoCalculate(false);
        editData.setBook(tmplbook);
        tmplbook.setAutoCalculate(isAutoCalculate);
        editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        editData.setSourceType(rptType);
        editData.setOrgTree(unitTree);
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setReportDate(new Timestamp(date.getTime()));
        editData.setDataCollect(DataCollectConstant.getActualDC());
        editData.setDataCollectNumber("ACTUALDATA");
        ArrayList<CslReportInfo> models = new ArrayList<CslReportInfo>();
        models.add(editData);
        Map result = CslReportFactory.getRemoteInstance().batchAddDataToMnsReport(models);
        List reports = (List)result.get("reportsLst");
        CslReportInfo report = (CslReportInfo)reports.get(0);
        return report;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.cslCtx.getCurOrgBound().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.unit.id", (Object)this.cslCtx.getCurOrgGroup().getId()));
        boolean exists = OrgStructureFactory.getRemoteInstance().exists(filterInfo);
        if (!exists) {
            throw new SumRptException(SumRptException.ORGUNIT_NOCHILD, new Object[]{this.cslCtx.getCurOrgBound().getName(), this.cslCtx.getCurOrgGroup()});
        }
        this.batchAddReport(this.getSelectedTemplateIdList());
    }

    protected IObjectValue createNewData() {
        return new CslReportInfo();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = null;
        try {
            exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            exec.option().isAutoTranslateEnum = true;
            int index = 1;
            exec.setParameter(index++, (Object)this.cslCtx.getCurOrgBound().getId().toString());
            exec.setParameter(index++, (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()));
            exec.setParameter(index++, (Object)this.cslCtx.getCurOrgGroup().getId().toString());
            FilterInfo filter = this.querySumTemplateQuery.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            index = filter.getFilterItems().size();
            StringBuffer maskString = new StringBuffer();
            if (filter.getMaskString() == null || filter.getMaskString().length() == 0) {
                maskString.append(" (#").append(index++).append(" or #").append(index++).append(")");
                maskString.append(" and #").append(index++);
            } else {
                maskString.append(filter.getMaskString());
                maskString.append(" and (#").append(index++).append(" or #").append(index++).append(")");
                maskString.append(" and #").append(index++);
            }
            filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(4)));
            filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(19)));
            filter.getFilterItems().add(new FilterItemInfo("Template.isFreezed", (Object)new Integer(0)));
            filter.setMaskString(maskString.toString());
            FilterInfo dataPermissionFilter = CslRptUtil.getDataPermissionFilter(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "csl_cslrpttmp_view");
            if (dataPermissionFilter != null) {
                for (int i = 0; i < dataPermissionFilter.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = dataPermissionFilter.getFilterItems().get(i);
                    filterItemInfo.setPropertyName("Template." + filterItemInfo.getPropertyName());
                }
                filter.mergeFilter(dataPermissionFilter, "AND");
            }
            this.querySumTemplateQuery.setFilter(filter);
            exec.setObjectView(this.querySumTemplateQuery);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return exec;
    }

    protected void initData() throws Exception {
        super.setDataObject("querySumTemplateQuery", (IObjectValue)new EntityViewInfo());
        CslClientHelper.initCurrencyCombox((JComboBox)this.comboCurrency);
        this.datePickerDate.setValue((Object)this.cslCtx.getCurReportDate());
        this.datePickerDate.setEnabled(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.tblTemplate.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_EmptyTemplate"));
            SysUtil.abort();
        }
        if (this.tblTemplate.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
    }

    private void openReportUI() throws Exception {
        IUIWindow window;
        String reportID = (String)this.getUIContext().get("ID");
        this.setCurMnsReport(this.getReportInfo(reportID));
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        this.reportUI = window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getReportUIName(), (Map)uiContext, null, this.getOprtState());
        window.getUIObject().setUITitle(CslRptUIUtil.getUITitle((VirtualSheetParamInfo)this.editData, this.getOprtState()));
        window.show();
    }

    private boolean verifyMnsReport(String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateID, int reportType) throws Exception {
        String rptId;
        String reportId = null;
        if (currencyID == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"54_ItemAnalysisFilterUI"));
            return false;
        }
        if (super.getOprtState() == OprtState.EDIT) {
            reportId = this.editData.getId().toString();
        }
        String dataColelctNumber = "ACTUALDATA";
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        if (this.isSupportOtherDS) {
            dataColelctNumber = ctx.getCurDataCollect().getNumber();
        }
        return (rptId = CslRptUIUtil.getRptByOldVersionTmpAndDataCollect(treeID, companyID, periodType, year, period, currencyID, templateID, reportType, reportId, dataColelctNumber)) == null;
    }

    public boolean destroyWindow() {
        Object owner;
        if (this.getOprtState().equals("EDIT")) {
            super.releaseObjectLock(this.editData.getId().toString());
        }
        if ((owner = this.getUIContext().get("Owner")) instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    public void submitWorkFlow() throws Exception {
    }

    public PostilCollection getRptPostilColl() {
        for (int i = 0; i < this.editData.getPostils().size(); ++i) {
            if (this.editData.getPostils().get(i).getPostilType().getValue() == 1) continue;
            this.editData.getPostils().removeObject(i);
            --i;
        }
        return this.editData.getPostils();
    }

    public RptMessage checkCreatSheet(List rptSheets) {
        return null;
    }

    @Override
    protected void tblTemplate_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.isSelect = true;
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getSelectedTemplateID());
            this.batchAddReport(list);
            if (this.isSelect) {
                this.destroyWindow();
            }
        } else if (e.getButton() == 1 && e.getClickCount() == 1 && this.isCtrlPress) {
            IRow row = this.tblTemplate.getRow(e.getRowIndex());
            boolean isSelect = (Boolean)row.getCell("select").getValue();
            row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
            this.tblTemplate.checkParsed();
        }
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblTemplate.getColumnIndex("Template.number");
            int colIndex2 = this.tblTemplate.getColumnIndex("Template.name");
            CslRptUIUtil.tableMainLocate(this.tblTemplate, search, new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionDisplay_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay(this.tblTemplate, "select", this.btnDisplay);
    }
}

