/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.BaseRptCalcGuideUI;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.List;

public class MnsRptGuideUI
extends BaseRptCalcGuideUI {
    private List companyList;
    private MnsRptParamInfo mnsRptParamInfo;

    public MnsRptGuideUI(IUIObject owner, CslReportInfo cslReportInfo) throws Exception {
        super(owner, cslReportInfo);
        this.setHideDyRptCalcPanel(true);
        this.initUI(owner);
        this.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"74MnsRptGuideTitle"));
    }

    @Override
    public void init() throws UIException {
        super.init();
    }

    @Override
    public boolean show() {
        boolean isConfirm = super.show();
        if (isConfirm && !this.isSetting) {
            this.mnsRptParamInfo = this.guideOrgUnitTabUI.getMnsRptParamInfo();
            this.companyList = this.guideOrgUnitTabUI.getCompanyList();
        }
        return isConfirm;
    }

    public boolean hasDefaultSolution() throws BOSException, EASBizException {
        MessagePostManManager msgMng = new MessagePostManManager("hasDefaultMnsGuideSolution");
        msgMng.addMessage(new MessagePostMan("treeId", this.cslReportInfo.getOrgTree().getId().toString()));
        msgMng.addMessage(new MessagePostMan("orgUnitId", this.cslReportInfo.getOrgUnit().getId().toString()));
        msgMng.addMessage(new MessagePostMan("queryObjectName", this.getQueryName()));
        msgMng.addMessage(new MessagePostMan("parentUIName", this.getParentUIClassName()));
        msgMng.addMessage(new MessagePostMan("rptDate", this.cslReportInfo.getReportDate()));
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        msgMng.addMessage(new MessagePostMan("userId", currUserID));
        msgMng = RpcHandleFacadeFactory.getRemoteInstance().getRpcZipData(msgMng);
        if (msgMng.getItem("hasDefaultSolution").getParams().equals(Boolean.FALSE)) {
            return false;
        }
        if (msgMng.getItem("isSystemSolution").getParams().equals(Boolean.FALSE)) {
            this.mnsRptParamInfo = new MnsRptParamInfo();
            int calcType = (Integer)msgMng.getItem("guideCalcType").getParams();
            this.mnsRptParamInfo.setGuideCalcType(calcType);
            MnsFillOrgUnitCollection coll = (MnsFillOrgUnitCollection)msgMng.getItem("MnsFillOrgUnitCollection").getParams();
            if (coll == null) {
                return false;
            }
            if (msgMng.getItem("isSupportHandSingleData") != null) {
                Object params = msgMng.getItem("isSupportHandSingleData").getParams();
                this.mnsRptParamInfo.setSupportHandSingleData("1".equals(params));
            }
            int arrCount = coll.size();
            this.companyList = new ArrayList(arrCount);
            for (int i = 0; i < arrCount; ++i) {
                FullOrgUnitInfo fullOrgUnitInfo = coll.get(i).getFullOrgUnitInfo();
                this.mnsRptParamInfo.addCompany(coll.get(i).getOrgTreeInfo(), fullOrgUnitInfo.getId().toString());
                if (fullOrgUnitInfo.isIsUnion() || fullOrgUnitInfo.isIsGrouping()) {
                    this.mnsRptParamInfo.addUnion(coll.get(i).getOrgTreeInfo(), fullOrgUnitInfo.getId().toString());
                }
                this.companyList.add(fullOrgUnitInfo);
            }
        } else {
            FullOrgUnitCollection orgUnitCollection = (FullOrgUnitCollection)msgMng.getItem("orgUnitCollection").getParams();
            if (orgUnitCollection == null) {
                return false;
            }
            this.loadSysDefaultSolution(orgUnitCollection);
        }
        return true;
    }

    public void setSysDefaultSolutionInfo() throws EASBizException, BOSException {
        MessagePostManManager msgMng = new MessagePostManManager("getUnionDebtChildren");
        msgMng.addMessage(new MessagePostMan("treeId", this.cslReportInfo.getOrgTree().getId().toString()));
        msgMng.addMessage(new MessagePostMan("orgUnitId", this.cslReportInfo.getOrgUnit().getId().toString()));
        msgMng = RpcHandleFacadeFactory.getRemoteInstance().getRpcZipData(msgMng);
        FullOrgUnitCollection col = (FullOrgUnitCollection)msgMng.getItem("returnValue").getValue();
        if (col != null) {
            this.loadSysDefaultSolution(col);
        }
    }

    private void loadSysDefaultSolution(FullOrgUnitCollection fullOrgUnitCollection) throws BOSException, EASBizException {
        int arrCount = fullOrgUnitCollection.size();
        this.mnsRptParamInfo = new MnsRptParamInfo();
        this.companyList = new ArrayList(arrCount);
        this.mnsRptParamInfo.setGuideCalcType(0);
        OrgTreeInfo orgTree = this.cslReportInfo.getOrgTree();
        for (int i = 0; i < arrCount; ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(i);
            if (fullOrgUnitInfo.isIsUnion() || fullOrgUnitInfo.isIsGrouping()) {
                this.mnsRptParamInfo.addUnion(orgTree, fullOrgUnitInfo.getId().toString());
            }
            this.mnsRptParamInfo.addCompany(orgTree, fullOrgUnitInfo.getId().toString());
            this.companyList.add(fullOrgUnitInfo);
        }
    }

    public MnsRptParamInfo getMnsRptParamInfo() {
        return this.mnsRptParamInfo;
    }

    public List getCompanyList() {
        return this.companyList;
    }
}

