/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractMnsRptTmpGuide_ShowResult_Items;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuideUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuide_ChooseDetailUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuide_ChooseItemsUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuide_ChooseTableHead;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MnsRptTmpGuide_ShowResult_Items
extends AbstractMnsRptTmpGuide_ShowResult_Items {
    private RPTItemInfo[] items;
    private Sheet curSheet;
    private boolean hasSingle = false;
    private boolean hasAdjust = false;
    private boolean hasAdjustBefore = false;
    private boolean hasSumAdjust = false;
    private boolean hasSumAdjustAfter = false;
    private boolean hasComAdjust = false;
    private boolean hasComAdjustAfter = false;
    private boolean hasSum = false;
    private boolean hasDebit = false;
    private boolean hasCredit = false;
    private boolean hasElim = false;
    private boolean hasCsl = false;
    private boolean hasExcludeSingle = false;
    private boolean hasExcludeSum = false;
    private boolean hasIncludeClearSingle = false;
    private boolean hasDisposalSingle = false;
    private Vector dataElements = new Vector(0);
    private int valueType = 1;
    private int year = 0;
    private int period = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        MnsRptTmpGuideUIUtil.initGuideImage(this.pnlImage);
        this.initParam();
        this.initTable();
        this.btnCancel.setEnabled(true);
        this.btnPreStep.setEnabled(true);
        this.btnNextStep.setEnabled(false);
        this.btnFinished.setEnabled(true);
        this.btnHelp.setVisible(false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        if (MnsRptTmpGuideUIUtil.isCloseWindow((Component)((Object)this))) {
            MnsRptTmpGuideUIUtil.closeAllUI();
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnFinished_actionPerformed(ActionEvent e) throws Exception {
        super.btnFinished_actionPerformed(e);
        this.fillData(this.curSheet);
        MnsRptTmpGuideUIUtil.closeAllUI();
        this.getUIWindow().close();
    }

    private void fillData(Sheet table) {
        boolean isIncludeAdjust;
        int top = this.curSheet.getActiveRow();
        int left = this.curSheet.getActiveCol();
        this.curSheet.getSheetRange().clear(true, true, true, true, new String[0]);
        Vector vecColumns = null;
        if (this.radioBtnData.isSelected()) {
            vecColumns = this.getColumnParamsByData();
            this.curSheet.setUserObject("RADIO_SELECTED", (Object)"DATA");
        } else if (this.radioBtnOrg.isSelected()) {
            vecColumns = this.getColumnParamsByOrg();
            this.curSheet.setUserObject("RADIO_SELECTED", (Object)"ORG");
        }
        this.curSheet.removeUserObject("TEMPLATE_NUMBER");
        this.curSheet.removeUserObject("ORDER_DATA_TYPE");
        this.curSheet.removeUserObject("DATA_MAP");
        if (vecColumns == null || vecColumns.size() == 0) {
            return;
        }
        int rowCount = this.items.length + top;
        int columnCount = vecColumns.size() + left;
        boolean bl = isIncludeAdjust = this.hasAdjust || this.hasAdjustBefore || this.hasSumAdjust || this.hasSumAdjustAfter || this.hasComAdjust || this.hasComAdjustAfter;
        if (isIncludeAdjust) {
            ++rowCount;
        }
        for (int i = top; i <= rowCount; ++i) {
            if (isIncludeAdjust && i == top + 1) continue;
            int index = 0;
            for (int j = left; j <= columnCount; ++j) {
                int itemIndex;
                ItemFormula itemFormula;
                Cell curCell = table.getCell(i, j, true);
                if (i == top) {
                    if (j == left) {
                        String value = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem");
                        curCell.setValue(new Variant((Object)value));
                        ItemFormula itemFormula2 = new ItemFormula();
                        if (this.radioBtnData.isSelected()) {
                            itemFormula2.putExt("Arrangement", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"555_MnsRptTmpGuide_ShowResult_Items"));
                        } else if (this.radioBtnOrg.isSelected()) {
                            itemFormula2.putExt("Arrangement", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"554_MnsRptProcessUI"));
                        }
                        curCell.setUserObject("ITEM", (Object)itemFormula2);
                        if (!isIncludeAdjust) continue;
                        itemFormula2.putExt("isIncludeAdjust", "1");
                        table.getRange(i, j, i + 1, j).merge();
                        continue;
                    }
                    SrcAndElement curParam = (SrcAndElement)vecColumns.get(index);
                    String param = curParam.dataSrc.getAlias() + "(" + curParam.dataElement.getName() + ")";
                    curCell.setValue(new Variant((Object)param));
                    itemFormula = new ItemFormula();
                    itemFormula.putExt("3", curParam.dataElement.getNumber());
                    itemFormula.putExt("1", Integer.toString(this.year));
                    itemFormula.putExt("2", Integer.toString(this.period));
                    itemFormula.putExt("4", Integer.toString(this.valueType));
                    itemFormula.putExt("DataSrc", Integer.toString(curParam.dataSrc.getValue()));
                    curCell.setUserObject("ITEM", (Object)itemFormula);
                    if (isIncludeAdjust) {
                        curCell.setUserObject("dataSrcIndex", (Object)index);
                        if ((curParam.dataSrc.equals((Object)CslDataSrcTypeEnum.SINGLE) || curParam.dataSrc.equals((Object)CslDataSrcTypeEnum.COMBINE) || curParam.dataSrc.equals((Object)CslDataSrcTypeEnum.SUMMARY)) && curParam.adjustDataSrcs != null) {
                            String adjustDataSrcStr = curParam.toStringForAdjustDataSrc();
                            if (!StringUtils.isEmpty((String)adjustDataSrcStr)) {
                                itemFormula.putExt("DATASRCFORADJUST", adjustDataSrcStr);
                                table.getRange(i, j, i, j + curParam.adjustDataSrcs.size() - 1).merge();
                                Cell adjustCell = null;
                                for (int k = 0; k < curParam.adjustDataSrcs.size(); ++k) {
                                    adjustCell = table.getCell(i + 1, j + k, true);
                                    adjustCell.setValue(new Variant((Object)curParam.adjustDataSrcs.get(k).getAlias()));
                                    adjustCell.setUserObject("DATASRCFORADJUST", (Object)curParam.adjustDataSrcs.get(k).getValue());
                                }
                                j = j + curParam.adjustDataSrcs.size() - 1;
                                columnCount = columnCount + curParam.adjustDataSrcs.size() - 1;
                            } else {
                                table.getRange(i, j, i + 1, j).merge();
                            }
                        } else {
                            table.getRange(i, j, i + 1, j).merge();
                        }
                    }
                    ++index;
                    continue;
                }
                int n = itemIndex = isIncludeAdjust ? i - top - 2 : i - top - 1;
                if (j == left) {
                    RPTItemInfo item = this.items[itemIndex];
                    curCell.setValue(new Variant((Object)item.getName()));
                    itemFormula = new ItemFormula();
                    itemFormula.setItemNumber(item.getNumber());
                    curCell.setUserObject("ITEM", (Object)itemFormula);
                    continue;
                }
                SrcAndElement type = null;
                if (isIncludeAdjust) {
                    Object obj = table.getCell(top, j, true).getUserObjectValue("dataSrcIndex");
                    if (obj == null) continue;
                    type = (SrcAndElement)vecColumns.get((Integer)obj);
                } else {
                    type = (SrcAndElement)vecColumns.get(j - left - 1);
                }
                if (!type.dataSrc.equals((Object)CslDataSrcTypeEnum.COMBINE)) continue;
                RPTItemInfo item = this.items[itemIndex];
                String formula = this.constructFormula(item, type);
                ItemFormula itemFormula3 = new ItemFormula(formula);
                curCell.setUserObject("ITEM", (Object)itemFormula3);
            }
        }
        ItemAnalysisHepler.getInstance().setBorder(table.getRange(top, left, rowCount, columnCount));
        CslRptUtil.saveBasePosition(table, left, top);
    }

    @Override
    protected void btnPreStep_actionPerformed(ActionEvent e) throws Exception {
        super.btnPreStep_actionPerformed(e);
        this.getUIWindow().hide();
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MnsRptTmpGuide_ChooseDetailUI.class.getName());
        if (obj != null && obj instanceof CoreUI) {
            CoreUI preUI = (CoreUI)obj;
            preUI.getUIWindow().show();
            this.getUIWindow().close();
        }
    }

    private Vector getColumnParamsByData() {
        Map dataSrcs = this.getDataSrc();
        if (this.dataElements.size() == 0 || dataSrcs.size() == 0) {
            return null;
        }
        Vector<SrcAndElement> vecResult = new Vector<SrcAndElement>(0);
        ValueTypeEnum value = ValueTypeEnum.getEnum(this.valueType);
        for (int j = 0; j < this.dataElements.size(); ++j) {
            DataElementInfo dataElement = (DataElementInfo)this.dataElements.get(j);
            for (Object dataSrc : dataSrcs.keySet()) {
                SrcAndElement srcAndElement = new SrcAndElement((CslDataSrcTypeEnum)((Object)dataSrc), dataElement, value, (List)dataSrcs.get(dataSrc));
                vecResult.add(srcAndElement);
            }
        }
        return vecResult;
    }

    private Vector getColumnParamsByOrg() {
        Map dataSrcs = this.getDataSrc();
        if (this.dataElements.size() == 0 || dataSrcs.size() == 0) {
            return null;
        }
        Vector<SrcAndElement> vecResult = new Vector<SrcAndElement>(0);
        ValueTypeEnum value = ValueTypeEnum.getEnum(this.valueType);
        List adjustSrcList = null;
        for (Object dataSrc : dataSrcs.keySet()) {
            adjustSrcList = (List)dataSrcs.get((Object)((CslDataSrcTypeEnum)((Object)dataSrc)));
            for (int j = 0; j < this.dataElements.size(); ++j) {
                DataElementInfo dataElement = (DataElementInfo)this.dataElements.get(j);
                SrcAndElement srcAndElement = new SrcAndElement((CslDataSrcTypeEnum)((Object)dataSrc), dataElement, value, adjustSrcList);
                vecResult.add(srcAndElement);
            }
        }
        return vecResult;
    }

    private Map getDataSrc() {
        LinkedHashMap dataSrcs = new LinkedHashMap(0);
        ArrayList<CslDataSrcTypeEnum> adjustList = null;
        if (this.hasSingle) {
            if (this.hasAdjust || this.hasAdjustBefore) {
                adjustList = new ArrayList<CslDataSrcTypeEnum>();
            }
            if (this.hasAdjustBefore && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUSTBEFORE);
            }
            if (this.hasAdjust && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUST);
            }
            if ((this.hasAdjustBefore || this.hasAdjust) && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUSTAFTER);
            }
        }
        if (this.hasSingle) {
            dataSrcs.put(CslDataSrcTypeEnum.SINGLE, adjustList);
        }
        if (this.hasIncludeClearSingle) {
            dataSrcs.put(CslDataSrcTypeEnum.INCLUDECLEARSINGLE, null);
        }
        if (this.hasDisposalSingle) {
            dataSrcs.put(CslDataSrcTypeEnum.DISPOSALSINGLE, null);
        }
        if (this.hasSum) {
            adjustList = null;
            if (this.hasSumAdjust || this.hasSumAdjustAfter) {
                adjustList = new ArrayList();
                adjustList.add(CslDataSrcTypeEnum.ADJUSTBEFORE);
            }
            if (this.hasSumAdjust && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUST);
            }
            if (this.hasSumAdjustAfter && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUSTAFTER);
            }
            dataSrcs.put(CslDataSrcTypeEnum.SUMMARY, adjustList);
        }
        if (this.hasElim) {
            dataSrcs.put(CslDataSrcTypeEnum.ELIMCOMBINE, null);
        } else {
            if (this.hasDebit) {
                dataSrcs.put(CslDataSrcTypeEnum.ELIMDEBIT, null);
            }
            if (this.hasCredit) {
                dataSrcs.put(CslDataSrcTypeEnum.ELIMCREDIT, null);
            }
        }
        if (this.hasCsl) {
            adjustList = null;
            if (this.hasComAdjust || this.hasComAdjustAfter) {
                adjustList = new ArrayList();
                adjustList.add(CslDataSrcTypeEnum.ADJUSTBEFORE);
            }
            if (this.hasComAdjust && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUST);
            }
            if (this.hasComAdjustAfter && adjustList != null) {
                adjustList.add(CslDataSrcTypeEnum.ADJUSTAFTER);
            }
            dataSrcs.put(CslDataSrcTypeEnum.COMBINE, adjustList);
        }
        if (this.dataElements.size() == 0 || dataSrcs.size() == 0) {
            return null;
        }
        return dataSrcs;
    }

    private RPTItemInfo[] getItemInfos() {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MnsRptTmpGuide_ChooseItemsUI.class.getName());
        if (obj != null && obj instanceof MnsRptTmpGuide_ChooseItemsUI) {
            MnsRptTmpGuide_ChooseItemsUI itemUI = (MnsRptTmpGuide_ChooseItemsUI)((Object)obj);
            KDTable table = itemUI.tblItems;
            RPTItemInfo[] itemsLocal = new RPTItemInfo[table.getRowCount()];
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow row = table.getRow(i);
                ICell cell = row.getCell(3);
                Object cellObj = cell.getValue();
                itemsLocal[i] = cellObj != null && cellObj instanceof RPTItemInfo ? (RPTItemInfo)cellObj : null;
            }
            return itemsLocal;
        }
        return null;
    }

    private String constructFormula(RPTItemInfo rptItem, SrcAndElement type) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=Item(\"");
        strBuffer.append(rptItem.getNumber() + "\",");
        strBuffer.append(this.year + ",");
        strBuffer.append(this.period + ",\"");
        strBuffer.append(type.dataElement.getNumber() + "\",\"");
        strBuffer.append(type.vType.getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private void initDetail() {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MnsRptTmpGuide_ChooseDetailUI.class.getName());
        if (obj != null && obj instanceof MnsRptTmpGuide_ChooseDetailUI) {
            MnsRptTmpGuide_ChooseDetailUI detailUI = (MnsRptTmpGuide_ChooseDetailUI)((Object)obj);
            KDTable table = detailUI.tblDataElement;
            int size = table.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = table.getRow(i);
                ICell cell = row.getCell(3);
                Object cellObj = cell.getValue();
                if (cellObj == null || !(cellObj instanceof DataElementInfo)) continue;
                this.dataElements.add(cellObj);
            }
            Integer tmpYear = (Integer)detailUI.spnYear.getValue();
            this.year = tmpYear;
            Integer tmpPeriod = (Integer)detailUI.spnPeriod.getValue();
            this.period = tmpPeriod;
            if (detailUI.btnMoney.isSelected()) {
                this.valueType = 1;
            }
            if (detailUI.btnQuantity.isSelected()) {
                this.valueType = 2;
            }
        }
    }

    private void initParam() {
        this.items = this.getItemInfos();
        this.initTableHead();
        this.initDetail();
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MnsRptTmpGuide_ChooseItemsUI.class.getName());
        if (obj != null && obj instanceof MnsRptTmpGuide_ChooseItemsUI) {
            MnsRptTmpGuide_ChooseItemsUI itemUI = (MnsRptTmpGuide_ChooseItemsUI)((Object)obj);
            this.curSheet = itemUI.curSheet;
        }
    }

    private void initTable() {
        this.tblResult.checkParsed();
        this.tblResult.getStyleAttributes().setLocked(true);
        this.tblResult.getSelectManager().setSelectMode(4);
        this.loadTable(this.tblResult);
        this.tblResult.setFocusable(false);
        this.tblResult1.checkParsed();
        this.tblResult1.getStyleAttributes().setLocked(true);
        this.tblResult1.getSelectManager().setSelectMode(4);
        this.loadTable(this.tblResult1);
        this.tblResult1.setFocusable(false);
    }

    private void initTableHead() {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(MnsRptTmpGuide_ChooseTableHead.class.getName());
        if (obj != null && obj instanceof MnsRptTmpGuide_ChooseTableHead) {
            MnsRptTmpGuide_ChooseTableHead headUI = (MnsRptTmpGuide_ChooseTableHead)((Object)obj);
            if (headUI.chkSingle.isSelected()) {
                this.hasSingle = true;
                if (headUI.chkAdjustBefore.isSelected()) {
                    this.hasAdjustBefore = true;
                }
                if (headUI.chkAdjust.isSelected()) {
                    this.hasAdjust = true;
                }
            }
            if (headUI.chkSum.isSelected()) {
                this.hasSum = true;
                if (headUI.chkSumAdjust.isSelected()) {
                    this.hasSumAdjust = true;
                }
                if (headUI.chkSumAdjustAfter.isSelected()) {
                    this.hasSumAdjustAfter = true;
                }
            }
            if (headUI.chkDebit.isSelected()) {
                this.hasDebit = true;
            }
            if (headUI.chkCredit.isSelected()) {
                this.hasCredit = true;
            }
            if (headUI.chkElim.isSelected()) {
                this.hasElim = true;
            }
            if (headUI.chkCsl.isSelected()) {
                this.hasCsl = true;
                if (headUI.chkComAdjust.isSelected()) {
                    this.hasComAdjust = true;
                }
                if (headUI.chkComAdjustAfter.isSelected()) {
                    this.hasComAdjustAfter = true;
                }
            }
            if (headUI.chkIncludeClearingCmp.isSelected()) {
                this.hasIncludeClearSingle = true;
            }
            if (headUI.chkDisposalCompany.isSelected()) {
                this.hasDisposalSingle = true;
            }
        }
    }

    private void loadTable(KDTable table) {
        int left = CslRptUtil.getBasePosition_Left(this.curSheet);
        int top = CslRptUtil.getBasePosition_Top(this.curSheet);
        if (left < 0 || top < 0) {
            top = this.curSheet.getActiveRow();
            left = this.curSheet.getActiveCol();
        }
        table.removeColumns();
        table.setRowCount(-1);
        table.setHeadDisplayMode(1);
        table.setCellDisplayMode(1);
        Vector vecColumns = null;
        if (table == this.tblResult) {
            vecColumns = this.getColumnParamsByData();
        } else if (table == this.tblResult1) {
            vecColumns = this.getColumnParamsByOrg();
        }
        if (vecColumns == null || vecColumns.size() == 0) {
            return;
        }
        int rowCount = this.items.length + top;
        int columnCount = vecColumns.size() + left;
        boolean isIncludeAdjust = this.hasAdjust || this.hasAdjustBefore || this.hasSumAdjust || this.hasSumAdjustAfter || this.hasComAdjust || this.hasComAdjustAfter;
        KDTMergeManager mm = null;
        if (isIncludeAdjust) {
            ++rowCount;
            mm = table.getMergeManager();
        }
        table.addColumns(columnCount + 1);
        table.addRows(rowCount + 1);
        for (int i = top; i <= rowCount; ++i) {
            if (isIncludeAdjust && i == top + 1) continue;
            int index = 0;
            for (int j = left; j <= columnCount; ++j) {
                int itemIndex;
                ItemFormula itemFormula;
                RptCell curRptCell;
                Object curCellObj;
                ICell curCell = table.getRow(i).getCell(j);
                if (i == top) {
                    if (j == left) {
                        RptCell curRptCell2;
                        curCell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem"));
                        Object curCellObj2 = curCell.getUserObject();
                        if (curCellObj2 != null && curCellObj2 instanceof RptCell) {
                            curRptCell2 = (RptCell)curCellObj2;
                        } else {
                            curRptCell2 = new RptCell(curCell);
                            curCell.setUserObject((Object)curRptCell2);
                        }
                        if (!isIncludeAdjust || mm == null) continue;
                        mm.mergeBlock(i, j, i + 1, j, 4);
                        continue;
                    }
                    SrcAndElement curParam = (SrcAndElement)vecColumns.get(index);
                    String param = curParam.dataSrc.getAlias() + "(" + curParam.dataElement.getName() + ")";
                    curCell.setValue((Object)param);
                    curCellObj = curCell.getUserObject();
                    if (curCellObj != null && curCellObj instanceof RptCell) {
                        curRptCell = (RptCell)curCellObj;
                    } else {
                        curRptCell = new RptCell(curCell);
                        curCell.setUserObject((Object)curRptCell);
                    }
                    itemFormula = new ItemFormula();
                    itemFormula.putExt("3", curParam.dataElement.getNumber());
                    itemFormula.putExt("1", Integer.toString(this.year));
                    itemFormula.putExt("2", Integer.toString(this.period));
                    itemFormula.putExt("4", Integer.toString(this.valueType));
                    itemFormula.putExt("DataSrc", Integer.toString(curParam.dataSrc.getValue()));
                    curRptCell.setItemFormula(itemFormula);
                    if (isIncludeAdjust) {
                        curRptCell.putExtObj((Object)"dataSrcIndex", (Object)index);
                        if (curParam.dataSrc.equals((Object)CslDataSrcTypeEnum.SINGLE) || curParam.dataSrc.equals((Object)CslDataSrcTypeEnum.SUMMARY) || curParam.dataSrc.equals((Object)CslDataSrcTypeEnum.COMBINE)) {
                            String adjustDataSrcStr = curParam.toStringForAdjustDataSrc();
                            if (!StringUtils.isEmpty((String)adjustDataSrcStr)) {
                                itemFormula.putExt("DATASRCFORADJUST", adjustDataSrcStr);
                                if (mm != null) {
                                    mm.mergeBlock(i, j, i, j + curParam.adjustDataSrcs.size() - 1, 4);
                                }
                                ICell adjustCell = null;
                                for (int k = 0; k < curParam.adjustDataSrcs.size(); ++k) {
                                    adjustCell = table.getRow(i + 1).getCell(j + k);
                                    adjustCell.setValue((Object)new Variant((Object)curParam.adjustDataSrcs.get(k).getAlias()));
                                    table.addColumn();
                                }
                                j = j + curParam.adjustDataSrcs.size() - 1;
                                columnCount = columnCount + curParam.adjustDataSrcs.size() - 1;
                            } else if (mm != null) {
                                mm.mergeBlock(i, j, i + 1, j, 4);
                            }
                        } else if (mm != null) {
                            mm.mergeBlock(i, j, i + 1, j, 4);
                        }
                    }
                    ++index;
                    continue;
                }
                int n = itemIndex = isIncludeAdjust ? i - top - 2 : i - top - 1;
                if (j == left) {
                    RPTItemInfo item = this.items[itemIndex];
                    curCell.setValue((Object)item.getName());
                    curCellObj = curCell.getUserObject();
                    if (curCellObj != null && curCellObj instanceof RptCell) {
                        curRptCell = (RptCell)curCellObj;
                    } else {
                        curRptCell = new RptCell(curCell);
                        curCell.setUserObject((Object)curRptCell);
                    }
                    itemFormula = new ItemFormula();
                    itemFormula.setItemNumber(item.getNumber());
                    curRptCell.setItemFormula(itemFormula);
                    continue;
                }
                SrcAndElement type = null;
                if (isIncludeAdjust) {
                    Object cellObj = table.getRow(top).getCell(j).getUserObject();
                    Object obj = null;
                    if (cellObj != null && cellObj instanceof RptCell) {
                        obj = ((RptCell)cellObj).getExtObj((Object)"dataSrcIndex");
                    }
                    if (obj == null) continue;
                    type = (SrcAndElement)vecColumns.get((Integer)obj);
                } else {
                    type = (SrcAndElement)vecColumns.get(j - left - 1);
                }
                if (!type.dataSrc.equals((Object)CslDataSrcTypeEnum.COMBINE)) continue;
                curCellObj = curCell.getUserObject();
                RPTItemInfo item = this.items[itemIndex];
                if (curCellObj != null && curCellObj instanceof RptCell) {
                    curRptCell = (RptCell)curCellObj;
                } else {
                    curRptCell = new RptCell(curCell);
                    curCell.setUserObject((Object)curRptCell);
                }
                String formula = this.constructFormula(item, type);
                curRptCell.setItemFormula(formula);
            }
        }
        CslRptUtil.saveBasePosition(table, left, top);
    }

    public boolean destroyWindow() {
        MnsRptTmpGuideUIUtil.closeAllUI();
        return super.destroyWindow();
    }

    class SrcAndElement {
        CslDataSrcTypeEnum dataSrc;
        DataElementInfo dataElement;
        ValueTypeEnum vType;
        List<CslDataSrcTypeEnum> adjustDataSrcs = null;

        SrcAndElement(CslDataSrcTypeEnum src, DataElementInfo element, ValueTypeEnum value) {
            this.dataSrc = src;
            this.dataElement = element;
            this.vType = value;
        }

        SrcAndElement(CslDataSrcTypeEnum src, DataElementInfo element, ValueTypeEnum value, List adjustDataSrcs) {
            this(src, element, value);
            if (src.equals((Object)CslDataSrcTypeEnum.SINGLE) || src.equals((Object)CslDataSrcTypeEnum.SUMMARY) || src.equals((Object)CslDataSrcTypeEnum.COMBINE)) {
                this.adjustDataSrcs = adjustDataSrcs;
            }
        }

        public String toStringForAdjustDataSrc() {
            if (this.adjustDataSrcs != null && !this.adjustDataSrcs.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (CslDataSrcTypeEnum obj : this.adjustDataSrcs) {
                    sb.append(obj.getValue()).append(",");
                }
                sb.deleteCharAt(sb.lastIndexOf(","));
                return sb.toString();
            }
            return null;
        }
    }
}

