/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AfterSelectablePasteAction;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsClearItemAction;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsTemplateItemFormulaChangeListener;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.event.ItemFormulaChangeListener;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class MnsTemplateItemReviseHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reLoadBook(Book book) {
        if (book == null) {
            return;
        }
        boolean autoCalculate = book.isAutoCalculate();
        book.setCalculate(false);
        try {
            book.getUndoManager().enable(false);
            book.getUndoManager().startGroup();
            HashMap basePosition = null;
            for (int x = 0; x < book.getSheetCount(); ++x) {
                Sheet sheet = book.getSheet(x);
                if (sheet == null || (basePosition = CslRptUtil.getBasePosition(sheet)) == null) continue;
                int left = 0;
                int top = 0;
                if (basePosition.containsKey("left")) {
                    left = (Integer)basePosition.get("left");
                }
                if (basePosition.containsKey("top")) {
                    top = (Integer)basePosition.get("top");
                }
                left = left >= 0 ? left : 0;
                top = top >= 0 ? top : 0;
                int maxCol = sheet.getMaxColIndex();
                int maxRow = sheet.getMaxRowIndex();
                List ls = MnsTemplateItemReviseHelper.getCombineList(sheet, left, maxCol, top);
                if (ls.isEmpty()) continue;
                MnsTemplateItemReviseHelper.loopItemRow(sheet, top, left, maxRow, ls);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            book.getUndoManager().enable(true);
            book.getUndoManager().endGroup();
            book.setCalculate(autoCalculate);
        }
    }

    private static void loopItemRow(Sheet sheet, int top, int left, int maxRow, List ls) throws BOSException {
        int col = 0;
        ItemFormula tmpFormula = null;
        ItemFormula colFormula = null;
        String tmpNumber = null;
        String colNumber = null;
        int nullCol = 0;
        ArrayList<Integer> reSetList = new ArrayList<Integer>();
        ArrayList<String> itemNumberList = new ArrayList<String>();
        for (int rowIndex = top + 1; rowIndex <= maxRow; ++rowIndex) {
            tmpFormula = (ItemFormula)sheet.getRange(rowIndex, left).getUserObject("ITEM");
            tmpNumber = tmpFormula == null ? null : tmpFormula.getItemNumber();
            nullCol = 0;
            for (int m = 0; m < ls.size(); ++m) {
                col = (Integer)ls.get(m);
                colFormula = (ItemFormula)sheet.getRange(rowIndex, col).getUserObject("ITEM");
                if (colFormula == null) {
                    ++nullCol;
                    continue;
                }
                colNumber = colFormula.getItemNumber();
                if (colNumber == null || colNumber.equals(tmpNumber)) continue;
                reSetList.add(new Integer(rowIndex));
                itemNumberList.add(colNumber);
                break;
            }
            if (nullCol == ls.size()) break;
        }
        if (itemNumberList.isEmpty()) {
            return;
        }
        MnsTemplateItemReviseHelper.reSetItemFormula(sheet, top, left, ls, itemNumberList, reSetList);
    }

    public static void registerAfterSelectablePasteAction(SpreadManager spreadManager) {
        spreadManager.getSpreadContainer().getActionManager().getAction("Show_SelectablePaste_Wizzard").setAfterAction((NotifyListener)new AfterSelectablePasteAction());
        spreadManager.getSpreadContainer().getActionManager().getAction("CLEAR_CELL_ALL").setAfterAction((NotifyListener)new MnsClearItemAction());
    }

    public static void registerDefaultItemFormulaChangeListener(SpreadManager spreadManager) {
        spreadManager.registerDefaultItemFormulaChangeListener((ItemFormulaChangeListener)new MnsTemplateItemFormulaChangeListener(spreadManager.getSpreadContainer()));
    }

    private static void changeMnsTempalteItem(Sheet sheet, boolean isClearItem, boolean clearAll) {
        if (sheet == null) {
            return;
        }
        HashMap basePosition = CslRptUtil.getBasePosition(sheet);
        if (basePosition == null) {
            return;
        }
        int left = 0;
        int top = 0;
        if (basePosition.containsKey("left")) {
            left = (Integer)basePosition.get("left");
        }
        if (basePosition.containsKey("top")) {
            top = (Integer)basePosition.get("top");
        }
        left = left >= 0 ? left : 0;
        int n = top = top >= 0 ? top : 0;
        if (sheet.getActiveRow() <= top) {
            return;
        }
        int activeCol = sheet.getActiveCol();
        Cell curCell = sheet.getCell(top, activeCol, false);
        if (curCell == null) {
            return;
        }
        ItemFormula tmpFormula = (ItemFormula)curCell.getUserObjectValue("ITEM");
        if (tmpFormula == null || tmpFormula.getExt("DataSrc") == null) {
            return;
        }
        Integer dataSrc = Integer.valueOf(tmpFormula.getExt("DataSrc"));
        if (dataSrc != 3) {
            return;
        }
        int maxCol = sheet.getMaxColIndex();
        List ls = MnsTemplateItemReviseHelper.getCombineList(sheet, left, maxCol, top);
        if (ls.isEmpty()) {
            return;
        }
        Range range = sheet.getSelectionRange();
        if (isClearItem) {
            MnsTemplateItemReviseHelper.clearRange(sheet, clearAll, left, activeCol, ls, range);
        } else {
            MnsTemplateItemReviseHelper.fillRange(sheet, left, top, activeCol, ls, range);
        }
    }

    private static void fillRange(Sheet sheet, int left, int top, int activeCol, List ls, Range range) {
        ArrayList<String> itemNumberList = new ArrayList<String>();
        ArrayList<Integer> reSetList = new ArrayList<Integer>();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock cb = range.getBlock(i);
            if (cb == null) continue;
            for (int j = cb.getRow(); j <= cb.getRow2(); ++j) {
                ItemFormula tmpFormula = (ItemFormula)sheet.getRange(j, activeCol).getUserObject("ITEM");
                if (tmpFormula == null || tmpFormula.getItemNumber() == null) continue;
                itemNumberList.add(tmpFormula.getItemNumber());
                reSetList.add(new Integer(j));
            }
        }
        try {
            MnsTemplateItemReviseHelper.reSetItemFormula(sheet, top, left, ls, itemNumberList, reSetList);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private static void clearRange(Sheet sheet, boolean clearAll, int left, int activeCol, List ls, Range range) {
        String[] userKeys = new String[]{};
        if (!clearAll) {
            userKeys = new String[]{"ITEM"};
        }
        int col = 0;
        for (int i = 0; i < range.size(); ++i) {
            CellBlock cb = range.getBlock(i);
            if (cb == null) continue;
            sheet.getRange(cb.getRow(), left, cb.getRow2(), left).clear(true, true, clearAll, clearAll, userKeys);
            for (int x = 0; x < ls.size(); ++x) {
                col = (Integer)ls.get(x);
                if (activeCol == col) continue;
                sheet.getRange(cb.getRow(), col, cb.getRow2(), col).clear(clearAll, clearAll, clearAll, clearAll, userKeys);
            }
        }
    }

    protected static void reSetSheet(Sheet sheet) {
        MnsTemplateItemReviseHelper.changeMnsTempalteItem(sheet, false, false);
    }

    public static void clearItemSheet(Sheet sheet, boolean clearAll) {
        MnsTemplateItemReviseHelper.changeMnsTempalteItem(sheet, true, clearAll);
    }

    private static void reSetItemFormula(Sheet sheet, int top, int left, List ls, List itemNumberList, List reSetList) throws BOSException {
        if (itemNumberList == null || itemNumberList.isEmpty()) {
            return;
        }
        RPTItemCollection coll = RPTItemFactory.getRemoteInstance().getRPTItemCollection("select number,name where number in(" + CslRptUtil.changeIdList2String(itemNumberList) + ")");
        HashMap<String, String> map = new HashMap<String, String>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            map.put(coll.get(i).getNumber(), coll.get(i).getName());
        }
        int row = 0;
        Cell curCell = null;
        String itemName = null;
        ItemFormula tmpFormula = null;
        ItemFormula colFormula = null;
        String colNumber = null;
        int col = 0;
        for (int i = 0; i < reSetList.size(); ++i) {
            row = (Integer)reSetList.get(i);
            curCell = sheet.getCell(row, left, true);
            colNumber = itemNumberList.get(i).toString();
            itemName = map.get(colNumber) == null ? colNumber : map.get(colNumber).toString();
            curCell.setValue(new Variant((Object)itemName));
            tmpFormula = new ItemFormula();
            tmpFormula.setItemNumber(colNumber);
            curCell.setUserObject("ITEM", (Object)tmpFormula);
            for (int m = 0; m < ls.size(); ++m) {
                col = (Integer)ls.get(m);
                curCell = sheet.getCell(row, col, true);
                colFormula = (ItemFormula)sheet.getRange(top, col).getUserObject("ITEM");
                curCell.setUserObject("ITEM", (Object)new ItemFormula(MnsTemplateItemReviseHelper.constructFormula(colFormula, colNumber)));
            }
        }
    }

    private static List getCombineList(Sheet sheet, int left, int maxCol, int top) {
        ArrayList<Integer> ls = new ArrayList<Integer>(4);
        ItemFormula tmpFormula = null;
        int n = maxCol;
        for (int i = left; i <= n; ++i) {
            Integer dataSrc;
            Cell curCell = sheet.getCell(top, i, false);
            if (curCell == null || (tmpFormula = (ItemFormula)curCell.getUserObjectValue("ITEM")) == null || tmpFormula.getExt("DataSrc") == null || (dataSrc = Integer.valueOf(tmpFormula.getExt("DataSrc"))) != 3) continue;
            ls.add(new Integer(i));
        }
        return ls;
    }

    private static String constructFormula(ItemFormula colFormula, String colNumber) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=Item(\"");
        strBuffer.append(colNumber + "\",");
        strBuffer.append(colFormula.getYearOffSet() + ",");
        strBuffer.append(colFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(colFormula.getDataElementNumber() + "\",\"");
        strBuffer.append(ValueTypeEnum.getEnum(colFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }
}

