/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractMnsTmpColEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;

public class MnsTmpColEditUI
extends AbstractMnsTmpColEditUI {
    Sheet curSheet;

    public MnsTmpColEditUI() throws Exception {
        CslClientHelper.initDataElementCombox(this.comboDataElement, false, true, false);
        this.btnGroupValueType.add((AbstractButton)this.btnMoney);
        this.btnGroupValueType.add((AbstractButton)this.btnQuantity);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        int leftstart;
        HashMap point;
        int rowstart;
        super.btnComfirm_actionPerformed(e);
        CslDataSrcTypeEnum srcType = (CslDataSrcTypeEnum)((Object)this.comboColType.getSelectedItem());
        DataElementInfo dataElement = null;
        dataElement = (DataElementInfo)this.comboDataElement.getSelectedItem();
        ValueTypeEnum valueType = null;
        if (this.btnMoney.isSelected()) {
            valueType = ValueTypeEnum.MONEY;
        } else if (this.btnQuantity.isSelected()) {
            valueType = ValueTypeEnum.QUANTITY;
        }
        int period = Integer.parseInt(this.spnPeriod.getValue().toString());
        int year = Integer.parseInt(this.spnYear.getValue().toString());
        Selection sel = this.curSheet.getSheetOption().getSelection();
        SortedCellBlockArray blocks = sel.toSortedBlocks();
        int columnIndex = 1;
        if (blocks != null && blocks.getBlock(0).getCol() >= 0) {
            int n = columnIndex = blocks.getBlock(0).getCol() == 0 ? columnIndex : blocks.getBlock(0).getCol();
        }
        if ((rowstart = ((Integer)(point = CslRptUtil.getBasePosition(this.curSheet)).get("top")).intValue()) < 0) {
            rowstart = 0;
            CslRptUtil.saveBasePosition(this.curSheet, 0, 0);
        }
        if ((leftstart = ((Integer)point.get("left")).intValue()) < 0) {
            leftstart = 0;
        }
        for (int i = rowstart; i <= this.curSheet.getMaxRowIndex() && columnIndex > leftstart; ++i) {
            Range curCell = this.curSheet.getRange(i, columnIndex);
            if (i == rowstart) {
                String param = srcType.getAlias() + "(" + dataElement.getName() + ")";
                curCell.setValue(new Variant((Object)param));
                ItemFormula itemFormula = new ItemFormula();
                itemFormula.putExt("3", dataElement.getNumber());
                itemFormula.putExt("1", Integer.toString(year));
                itemFormula.putExt("2", Integer.toString(period));
                if (valueType != null) {
                    itemFormula.putExt("4", Integer.toString(valueType.getValue()));
                }
                itemFormula.putExt("DataSrc", Integer.toString(srcType.getValue()));
                curCell.setUserObject("ITEM", (Object)itemFormula);
                continue;
            }
            if (srcType.equals((Object)CslDataSrcTypeEnum.COMBINE)) {
                ItemFormula item = (ItemFormula)this.curSheet.getCell(i, leftstart, true).getUserObjectValue("ITEM");
                if (item == null || item.getItemNumber() == null || item.getItemNumber().length() == 0) continue;
                String itemNumber = item.getItemNumber();
                String formula = this.constructFormula(itemNumber, dataElement.getNumber(), valueType, year, period);
                curCell.setUserObject("ITEM", (Object)new ItemFormula(formula));
                continue;
            }
            curCell.setUserObject("ITEM", null);
        }
        this.destroyWindow();
    }

    private String constructFormula(String rptItemNumber, String dataElementNumber, ValueTypeEnum valueType, int year, int period) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=Item(\"");
        strBuffer.append(rptItemNumber + "\",");
        strBuffer.append(year + ",");
        strBuffer.append(period + ",\"");
        strBuffer.append(dataElementNumber + "\",\"");
        strBuffer.append(valueType.getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private void initData() {
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        CslDataSrcTypeEnum srcType = null;
        for (int i = this.comboColType.getItemCount() - 1; i >= 0; --i) {
            srcType = (CslDataSrcTypeEnum)((Object)this.comboColType.getItemAt(i));
            if (srcType == null || !srcType.equals((Object)CslDataSrcTypeEnum.ADJUST) && !srcType.equals((Object)CslDataSrcTypeEnum.ADJUSTAFTER) && !srcType.equals((Object)CslDataSrcTypeEnum.ADJUSTBEFORE)) continue;
            this.comboColType.removeItemAt(i);
        }
    }
}

