/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MAGroupCollection;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.client.MAGroupReF7;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaFactory;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaInfo;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaRemindFactory;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaRemindInfo;
import com.kingdee.eas.fi.gr.cslrpt.NoticeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.SchemaCurrencyCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemaCurrencyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemaCurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.SchemaReceivorCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemaReceivorFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemaReceivorInfo;
import com.kingdee.eas.fi.gr.cslrpt.SchemaTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemaTemplateFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemaTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractNoticeSchemaRemindEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.NoticeSchemaRemindMailTemplateUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NoticeSchemaRemindEditUI
extends AbstractNoticeSchemaRemindEditUI {
    private static final long serialVersionUID = -6848418487254434315L;
    Map template = new HashMap();
    private static final Logger logger = CoreUIObject.getLogger(NoticeSchemaRemindEditUI.class);
    NoticeSchemaRemindInfo info = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboPeriodType.setEnabled(true);
        this.comboPeriodType.setEditable(false);
        this.btnEmailEdit.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.initTemplateButton();
        this.tblTemplateList.getSelectManager().setSelectMode(10);
        this.tblTemplateList.setEditable(false);
        this.tblCurrency.getSelectManager().setSelectMode(2);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setRequiredFields();
        this.setIsEnabledFields();
        this.initPrmtReceiver();
        try {
            this.loadCurrency();
            this.loadRPTTemplate();
            this.loadNoticeSchemaRemind();
            this.loadReceivors();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeNoticeSchemaRemind();
        this.storeCurrency();
        this.storeTemplate();
        this.storeReceivors();
        this.editData.setNoticeType(NoticeTypeEnum.NOTICE_REMIND);
        this.initOldData((IObjectValue)this.editData);
    }

    private void setRequiredFields() {
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.prmtReceiver.setRequired(true);
        if (this.getOprtState().equals("ADDNEW")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"568_NoticeSchemaRemindEditUI"));
            Calendar now = Calendar.getInstance();
            Calendar oneYearLater = Calendar.getInstance();
            this.pkEfficientDate.setValue((Object)now.getTime());
            if (oneYearLater.get(2) == 2 && oneYearLater.get(5) == 29) {
                oneYearLater.add(5, -1);
            }
            oneYearLater.add(1, 1);
            this.pkDisabledDate.setValue((Object)oneYearLater.getTime());
        }
        if (this.getOprtState().equals("EDIT")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"569_NoticeSchemaRemindEditUI"));
        }
        if (this.getOprtState().equals("VIEW")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"570_NoticeSchemaRemindEditUI"));
        }
    }

    private void setIsEnabledFields() {
        this.btnChooseTemplate.setEnabled(true);
        this.btnDeleteTemplate.setEnabled(true);
        this.btnEmailEdit.setEnabled(true);
    }

    private void initPrmtReceiver() {
        MAGroupReF7 mAGroupReF7 = new MAGroupReF7((IUIObject)this);
        this.prmtReceiver.setEditFormat("$id$");
        this.prmtReceiver.setCommitFormat("$id$");
        this.prmtReceiver.setDisplayFormat("$id$");
        this.prmtReceiver.setSelector((KDPromptSelector)mAGroupReF7);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equals("")) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"571_NoticeSchemaRemindEditUI")));
        }
        if (this.editData.getName() == null || this.editData.getName().trim().equals("")) {
            this.txtName.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"572_NoticeSchemaRemindEditUI")));
        }
        if (this.prmtReceiver.getData() == null || this.prmtReceiver.getData().toString().trim().equals("")) {
            this.prmtReceiver.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"573_NoticeSchemaRemindEditUI")));
        }
        if (!(this.chkIsCheckAudit.isSelected() || this.chkIsCheckReceive.isSelected() || this.chkIsReportCommit.isSelected() || this.chkIsReportReceive.isSelected())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"574_NoticeSchemaRemindEditUI")));
        }
        if (this.tblTemplateList.getRowCount() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"575_NoticeSchemaRemindEditUI")));
        }
        boolean hasCheck = false;
        int n = this.tblCurrency.getRowCount();
        for (int i = 0; i < n && !(hasCheck = ((Boolean)this.tblCurrency.getRow(i).getCell("choose").getValue()).booleanValue()); ++i) {
        }
        if (!hasCheck) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"576_NoticeSchemaRemindEditUI")));
        }
    }

    private void loadCurrency() throws Exception {
        this.tblCurrency.checkParsed();
        this.tblCurrency.removeRows();
        ArrayList<String> currencyIdList = null;
        if (!this.getOprtState().equals("ADDNEW")) {
            currencyIdList = new ArrayList<String>();
            SchemaCurrencyCollection schemaCurrencyCollection = SchemaCurrencyFactory.getRemoteInstance().getSchemaCurrencyCollection("select * where schemaID = '" + this.editData.getId() + "'");
            if (schemaCurrencyCollection != null && schemaCurrencyCollection.size() > 0) {
                int n = schemaCurrencyCollection.size();
                for (int i = 0; i < n; ++i) {
                    SchemaCurrencyInfo info = schemaCurrencyCollection.get(i);
                    currencyIdList.add(info.getCurrencyID().toString());
                }
            }
        }
        CurrencyCollection currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        String currencyID = null;
        int n = currencys.size();
        for (int i = 0; i < n; ++i) {
            CurrencyInfo info = currencys.get(i);
            if (info.getIsoCode() != null && (info.getIsoCode().equalsIgnoreCase("GLC") || info.getIsoCode().equalsIgnoreCase("GRC"))) continue;
            IRow row = this.tblCurrency.addRow();
            currencyID = info.getId().toString();
            row.getCell("id").setValue((Object)currencyID);
            Boolean choose = Boolean.FALSE;
            if (currencyIdList != null && currencyIdList.contains(currencyID)) {
                choose = Boolean.TRUE;
            }
            row.getCell("choose").setValue((Object)choose);
            row.getCell("currency.number").setValue((Object)info.getNumber());
            row.getCell("currency.name").setValue((Object)info.getName());
        }
    }

    private void loadRPTTemplate() throws Exception {
        this.tblTemplateList.checkParsed();
        this.tblTemplateList.removeRows();
        HashSet<String> templateIdSet = null;
        if (!this.getOprtState().equals("ADDNEW")) {
            templateIdSet = new HashSet<String>();
            SchemaTemplateCollection schemaTemplateCollection = SchemaTemplateFactory.getRemoteInstance().getSchemaTemplateCollection("select * where schemaID = '" + this.editData.getId() + "'");
            if (schemaTemplateCollection != null && schemaTemplateCollection.size() > 0) {
                int n = schemaTemplateCollection.size();
                for (int i = 0; i < n; ++i) {
                    SchemaTemplateInfo info = schemaTemplateCollection.get(i);
                    templateIdSet.add(info.getTemplateID().toString());
                }
            }
        }
        if (templateIdSet != null && templateIdSet.size() > 0) {
            EntityViewInfo templateView = new EntityViewInfo();
            FilterInfo templateFilter = new FilterInfo();
            templateFilter.getFilterItems().add(new FilterItemInfo("id", templateIdSet, CompareType.INCLUDE));
            templateView.setFilter(templateFilter);
            TemplateCollection templateCollection = TemplateFactory.getRemoteInstance().getTemplateCollection(templateView);
            String templateID = null;
            TemplateInfo info = null;
            IRow row = null;
            int n = templateCollection.size();
            for (int i = 0; i < n; ++i) {
                info = templateCollection.get(i);
                row = this.tblTemplateList.addRow();
                templateID = info.getId().toString();
                row.getCell("id").setValue((Object)templateID);
                row.getCell("TemplateForNoticeSchema.number").setValue((Object)info.getNumber());
                row.getCell("TemplateForNoticeSchema.name").setValue((Object)info.getName());
                row.getCell("TemplateForNoticeSchema.versionNumber").setValue((Object)info.getVersionNumber());
                row.getCell("TemplateForNoticeSchema.periodType").setValue((Object)info.getPeriodType());
                row.getCell("TemplateForNoticeSchema.templateType").setValue((Object)info.getTemplateType());
            }
        }
    }

    private void loadNoticeSchemaRemind() throws Exception {
        if (!this.getOprtState().equals("ADDNEW")) {
            this.info = NoticeSchemaRemindFactory.getRemoteInstance().getNoticeSchemaRemindInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (this.info != null) {
                String checkTemplate;
                if (this.info.isIsCheckAudit()) {
                    this.chkIsCheckAudit.setSelected(true);
                } else {
                    this.chkIsCheckAudit.setSelected(false);
                }
                if (this.info.isIsCheckReceive()) {
                    this.chkIsCheckReceive.setSelected(true);
                } else {
                    this.chkIsCheckReceive.setSelected(false);
                }
                if (this.info.isIsReportCommit()) {
                    this.chkIsReportCommit.setSelected(true);
                } else {
                    this.chkIsReportCommit.setSelected(false);
                }
                if (this.info.isIsReportReceive()) {
                    this.chkIsReportReceive.setSelected(true);
                } else {
                    this.chkIsReportReceive.setSelected(false);
                }
                String reportTemplate = this.info.getReportTemplate();
                if (reportTemplate != null && reportTemplate.trim().length() > 0) {
                    this.template.put("reportTemplate", reportTemplate);
                }
                if ((checkTemplate = this.info.getCheckTemplate()) != null && checkTemplate.trim().length() > 0) {
                    this.template.put("checkTemplate", checkTemplate);
                }
            }
        }
    }

    private void loadReceivors() {
        String schemaID = (String)this.getUIContext().get("ID");
        try {
            if (schemaID == null || schemaID.length() == 0) {
                return;
            }
            SchemaReceivorCollection schemaReceivorCollection = SchemaReceivorFactory.getRemoteInstance().getSchemaReceivorCollection("select * where schemaId = '" + schemaID + "'");
            if (schemaReceivorCollection.size() == 0) {
                return;
            }
            SchemaReceivorInfo info = null;
            HashSet<String> receivorSet = new HashSet<String>();
            int count = schemaReceivorCollection.size();
            for (int i = 0; i < count; ++i) {
                info = schemaReceivorCollection.get(i);
                receivorSet.add(info.getReceivorID().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", receivorSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MAGroupCollection groupCollection = MAGroupFactory.getRemoteInstance().getMAGroupCollection(view);
            ArrayList<MAGroupInfo> groupList = new ArrayList<MAGroupInfo>();
            int n = groupCollection.size();
            for (int i = 0; i < n; ++i) {
                groupList.add(groupCollection.get(i));
            }
            this.prmtReceiver.setData(groupList);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void storeNoticeSchemaRemind() {
        this.info = new NoticeSchemaRemindInfo();
        if (this.chkIsCheckAudit.isSelected()) {
            this.info.setIsCheckAudit(true);
        } else {
            this.info.setIsCheckAudit(false);
        }
        if (this.chkIsCheckReceive.isSelected()) {
            this.info.setIsCheckReceive(true);
        } else {
            this.info.setIsCheckReceive(false);
        }
        if (this.chkIsReportCommit.isSelected()) {
            this.info.setIsReportCommit(true);
        } else {
            this.info.setIsReportCommit(false);
        }
        if (this.chkIsReportReceive.isSelected()) {
            this.info.setIsReportReceive(true);
        } else {
            this.info.setIsReportReceive(false);
        }
        this.editData.put("remind", this.info);
    }

    private void storeCurrency() {
        int rowCount = this.tblCurrency.getRowCount();
        SchemaCurrencyCollection col = new SchemaCurrencyCollection();
        SchemaCurrencyInfo scInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblCurrency.getRow(i);
            Boolean choosed = (Boolean)row.getCell("choose").getValue();
            if (!choosed.booleanValue()) continue;
            scInfo = new SchemaCurrencyInfo();
            String id = (String)row.getCell("id").getValue();
            scInfo.setCurrencyID(BOSUuid.read((String)id));
            col.add(scInfo);
        }
        this.editData.put("currency", (Object)col);
    }

    private void storeTemplate() {
        int rowCount = this.tblTemplateList.getRowCount();
        SchemaTemplateCollection col = new SchemaTemplateCollection();
        SchemaTemplateInfo stInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblTemplateList.getRow(i);
            stInfo = new SchemaTemplateInfo();
            String templateID = (String)row.getCell("id").getValue();
            stInfo.setTemplateID(BOSUuid.read((String)templateID));
            col.add(stInfo);
        }
        this.editData.put("template", (Object)col);
    }

    private void storeReceivors() {
        SchemaReceivorCollection receivors = new SchemaReceivorCollection();
        SchemaReceivorInfo receivor = null;
        List objs = (List)this.prmtReceiver.getData();
        MAGroupInfo maGroup = null;
        if (objs != null) {
            int count = objs.size();
            for (int i = 0; i < count; ++i) {
                maGroup = (MAGroupInfo)objs.get(i);
                if (maGroup == null) continue;
                receivor = new SchemaReceivorInfo();
                receivor.setReceivorID(maGroup.getId());
                receivors.add(receivor);
            }
            this.editData.put("receivors", (Object)receivors);
        }
    }

    @Override
    public void chooseTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.chooseTemplate_actionPerformed(e);
        Window owner = ComponentUtil.getOwnerWindow((Component)((Object)this));
        Object[] arrObj = this.getTemplate(owner, true);
        this.addArrayValueToTable(this.tblTemplateList, arrObj);
    }

    public Object[] getTemplate(Window owner, boolean isMultiSelect) {
        KDCommonPromptDialog dlg = owner instanceof Frame ? new KDCommonPromptDialog((Frame)owner) : new KDCommonPromptDialog((Dialog)owner);
        QueryAgent queryAgent = new QueryAgent();
        queryAgent.setQueryInfoPK(new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaTemplate56Query"));
        queryAgent.setEnabledMultiSelection(isMultiSelect);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        queryAgent.setSelectorCollection(sic);
        QueryInfo queryInfo = queryAgent.getQueryInfo();
        dlg.setQueryInfo(queryInfo);
        FilterInfo filter = new FilterInfo();
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)String.valueOf(periodTypeEnum.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)Integer.valueOf("1"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)Integer.valueOf("2")));
        filter.getFilterItems().add(new FilterItemInfo("isK3Tpl", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("easTplIdForK3", null));
        String mask = "#0 and #1 and #2 and #3 and #4";
        filter.setMaskString(mask);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        dlg.setEntityViewInfo(view);
        dlg.setSelectorCollection(queryAgent.getSelectorCollection());
        dlg.setQueryExecutor(queryAgent.getQueryExecutor());
        dlg.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
        dlg.setReturnValueType(queryAgent.getReturnValueType());
        dlg.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"577_NoticeSchemaRemindEditUI"));
        dlg.show();
        if (!dlg.isCanceled()) {
            return (Object[])dlg.getData();
        }
        return null;
    }

    private void addArrayValueToTable(KDTable kdt, Object[] arrObj) {
        if (arrObj == null) {
            return;
        }
        int arrCount = arrObj.length;
        for (int i = 0; i < arrCount; ++i) {
            this.adObjValueToTable(kdt, arrObj[i]);
        }
    }

    private void adObjValueToTable(KDTable kdt, Object obj) {
        IRow row = null;
        if (kdt.getName().equalsIgnoreCase("tblTemplateList")) {
            TemplateInfo template = (TemplateInfo)obj;
            if (this.isExistsDouble(kdt, template)) {
                return;
            }
            row = kdt.addRow();
            row.getCell("id").setValue((Object)template.getId().toString());
            row.getCell("TemplateForNoticeSchema.number").setValue((Object)template.getNumber());
            row.getCell("TemplateForNoticeSchema.name").setValue((Object)template.getName());
            row.getCell("TemplateForNoticeSchema.versionNumber").setValue((Object)template.getVersionNumber());
            row.getCell("TemplateForNoticeSchema.periodType").setValue((Object)template.getPeriodType());
            row.getCell("TemplateForNoticeSchema.templateType").setValue((Object)template.getTemplateType());
        }
    }

    private boolean isExistsDouble(KDTable kdt, TemplateInfo template) {
        kdt.checkParsed();
        for (int i = kdt.getRowCount() - 1; i >= 0; --i) {
            if (((RptTmpTypeEnum)kdt.getRow(i).getCell("TemplateForNoticeSchema.templateType").getValue()).getValue() != template.getTemplateType().getValue() || !kdt.getRow(i).getCell("TemplateForNoticeSchema.number").getValue().toString().equals(template.getNumber())) continue;
            if (kdt.getRow(i).getCell(3).getValue().equals(template.getVersionNumber())) {
                return true;
            }
            kdt.removeRow(i);
            return false;
        }
        return false;
    }

    @Override
    public void deleteTemplate_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows;
        super.deleteTemplate_actionPerformed(e);
        if (this.tblTemplateList.getRowCount() > 0 && (selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblTemplateList)).length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                this.tblTemplateList.removeRow(selectRows[i]);
            }
        }
    }

    @Override
    public void actionChangePeriodType_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblTemplateList == null) {
            return;
        }
        int rowCount = this.tblTemplateList.getRowCount();
        if (rowCount <= 0) {
            return;
        }
        RptPeriodTypeEnum cellValue = null;
        for (int i = rowCount - 1; i >= 0; --i) {
            cellValue = (RptPeriodTypeEnum)this.tblTemplateList.getRow(i).getCell("TemplateForNoticeSchema.periodType").getValue();
            if (this.comboPeriodType.getSelectedItem().equals(cellValue)) continue;
            this.tblTemplateList.removeRow(i);
        }
    }

    @Override
    public void actionEmailEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEmailEdit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        String schemaID = (String)this.getUIContext().get("ID");
        uiContext.put((Object)"schemaID", (Object)schemaID);
        uiContext.put((Object)"template", (Object)this.template);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NoticeSchemaRemindMailTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        Map template = (Map)uiContext.get((Object)"template");
        this.info.setReportTemplate((String)template.get("reportTemplate"));
        this.info.setCheckTemplate((String)template.get("checkTemplate"));
    }

    private void initTemplateButton() {
        this.btnEmailEdit.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        if (this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW")) {
            this.btnEmailEdit.setEnabled(true);
        }
        if (this.getOprtState().equals("ADDNEW")) {
            this.btnEmailEdit.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnEmailEdit.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnEmailEdit.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        NoticeSchemaInfo noticeSchemaInfo = new NoticeSchemaInfo();
        noticeSchemaInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        noticeSchemaInfo.setNoticeType(NoticeTypeEnum.NOTICE_REMIND);
        return noticeSchemaInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return NoticeSchemaFactory.getRemoteInstance();
    }
}

