/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptAddedPerporty;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyCollection;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.util.GetProcessUINameByRptType;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class OpenReport {
    private DBHandler dao;

    public OpenReport() {
        this.dao = new DBHandler(null);
    }

    public OpenReport(DBHandler dao) {
        this.dao = dao;
    }

    public void exec(String reportId, Object uiOwner, boolean isView) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)reportId);
        uiContext.put((Object)"superParent", uiOwner);
        uiContext.put((Object)"isView", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptReportProcessUI.class.getName(), (Map)uiContext, null, isView ? OprtState.VIEW : OprtState.EDIT);
        window2.show();
    }

    public void exec(CslReportInfo report, Object uiOwner, String oprtState) throws BOSException {
        AuditedStatusEnum isAudit;
        String orgTreeId;
        String reportId;
        RptSrcTypeEnum rptType;
        try {
            rptType = report.getSourceType();
            reportId = report.getId().toString();
            orgTreeId = report.getOrgTree().getId().toString();
            isAudit = report.getAuditedStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (AuditedStatusEnum.AUDITED.equals((Object)isAudit)) {
            oprtState = OprtState.VIEW;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)reportId);
        uiContext.put((Object)"superParent", uiOwner);
        uiContext.put((Object)"isView", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)0);
        if (rptType == null) {
            return;
        }
        int rptTypeValue = rptType.getValue();
        String rptProcessUIName = new GetProcessUINameByRptType().exec(rptTypeValue);
        if (StringUtils.isEmpty((String)rptProcessUIName)) {
            return;
        }
        try {
            if (4 == rptTypeValue || 33 == rptTypeValue || 16 == rptTypeValue) {
                boolean isSupportCrossMerger;
                uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
                Object[] paramValues = CSLParamUtil.batchGetCslParam(this.dao.getContext(), new String[]{"KEY_CSLPARAM_SUPPORTREMEBERINNERCOMPANYID", "ENABLE_MENU_FILL_COMPANY_ITEM"});
                uiContext.put((Object)"KEY_CSLPARAM_SUPPORTREMEBERINNERCOMPANYID", (Object)RptUtil.isTrue((Object)paramValues[0]));
                uiContext.put((Object)"ENABLE_MENU_FILL_COMPANY_ITEM", paramValues[1]);
                boolean bl = isSupportCrossMerger = orgTreeId != null && CSLParamUtil.isSupportCrossMerger(this.dao.getContext(), orgTreeId);
                if (isSupportCrossMerger) {
                    boolean support = false;
                    SumRptAddedPerportyCollection addedProps = this.dao.get(ISumRptAddedPerporty.class).getSumRptAddedPerportyCollection(" where report = '" + reportId + "'");
                    if (!addedProps.isEmpty()) {
                        support = IsSupportGroupReportEnum.SUPPORT.equals((Object)addedProps.get(0).getIsSupportGroup());
                        uiContext.put((Object)"isSupportGroup", (Object)support);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(rptProcessUIName, (Map)uiContext, null, oprtState);
        window2.show();
    }
}

