/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractOrgBoundSelectUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupNormalProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportDesignerUI;
import com.kingdee.eas.fi.newrpt.client.designer.BaseTemplateDesignerUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ProfReportProcessUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ProfTemplateProcessUI;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class OrgBoundSelectUI
extends AbstractOrgBoundSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgBoundSelectUI.class);
    private OrgTreeInfo orgTreeInfo = null;
    private boolean isOk = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadOrgBound();
        this.prmptOrgBound.setEditable(false);
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        try {
            this.orgTreeInfo = (OrgTreeInfo)this.prmptOrgBound.getData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isOk = true;
        this.getUIWindow().close();
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.isOk = false;
        this.getUIWindow().close();
    }

    private void loadOrgBound() throws EASBizException, BOSException {
        FilterInfo treeFilter;
        this.prmptOrgBound.setValue(null);
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        f7.disablePerm();
        Object owner = this.getUIContext().get("Owner");
        boolean isProfitcenter = false;
        if (owner != null) {
            OrgType orgType;
            if (owner instanceof ProfTemplateProcessUI || owner instanceof ProfReportProcessUI) {
                isProfitcenter = true;
            } else if (owner instanceof GroupNormalProcessUI && (orgType = ((TemplateInfo)((GroupNormalProcessUI)((Object)owner)).getEditData()).getOrgType()) != null && orgType.getValue() == 6) {
                isProfitcenter = true;
            }
        }
        if (isProfitcenter) {
            treeFilter = new FilterInfo();
            treeFilter.appendFilterItem("layerType", (Object)6);
            f7.setTreeFilter(treeFilter);
        } else {
            treeFilter = new FilterInfo();
            treeFilter.appendFilterItem("layerType", (Object)1);
            f7.setTreeFilter(treeFilter);
        }
        this.prmptOrgBound.setSelector((KDPromptSelector)f7);
        try {
            if (this.getUIContext().containsKey("curSheet")) {
                Sheet curSheet = (Sheet)this.getUIContext().get("curSheet");
                OrgTreeInfo orgTree = null;
                if (owner instanceof BaseTemplateDesignerUI) {
                    orgTree = CslRptUtil.getOrgTreeInfo(null, null, curSheet);
                } else if (owner instanceof BaseReportDesignerUI) {
                    orgTree = CslRptUtil.getOrgTreeInfo(null, (VirtualSheetParamInfo)((ReportBaseInfo)((BaseReportDesignerUI)owner).getBookProvider().getEditValue()), curSheet);
                }
                if (orgTree != null) {
                    this.prmptOrgBound.setData((Object)orgTree);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getOrgTreeInfo error.", (Throwable)e);
            super.handUIException((Throwable)e);
        }
    }

    public OrgTreeInfo getOrgTreeInfo() {
        return this.orgTreeInfo;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

