/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gr.cslrpt.IOrgInteMapping;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingCollection;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingFactory;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractOrgInteMappingListUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class OrgInteMappingListUI
extends AbstractOrgInteMappingListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgInteMappingListUI.class);
    private KDBizPromptBox orgF7 = null;
    private OrgInteMappingInfo oimInfo;
    private List modifyDataIndex;
    public final String RESOURCE_PATH = "com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingResource.";
    public OrgUnitInfo[] orgUnitInfos;

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgInteMappingFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingResource.title"));
        super.onLoad();
        this.tblMain.checkParsed();
        this.fillTable();
        this.setUiStyle();
        this.addListener();
    }

    private void fillTable() throws BOSException, Exception {
        OrgInteMappingCollection oiMappings = ((IOrgInteMapping)this.getBizInterface()).getMappingList();
        this.fillTable(oiMappings);
    }

    private void fillTable(OrgInteMappingCollection oiMappings) {
        int i;
        OrgInteMappingInfo oimInfo = null;
        int orgInteCount = oiMappings.size();
        if (orgInteCount > this.tblMain.getRowCount3()) {
            this.tblMain.addRows(orgInteCount - this.tblMain.getRowCount3());
        } else {
            i = 0;
            while (i < this.tblMain.getRowCount3() - orgInteCount) {
                this.tblMain.removeRow(this.tblMain.getRowCount3() - 1);
            }
        }
        for (i = 0; i < this.tblMain.getRowCount3(); ++i) {
            oimInfo = oiMappings.get(i);
            this.tblMain.getRow(i).getCell("integrationCase.name").setValue((Object)oimInfo.getBillMapping().getBillMappingName());
            OrgInteMappingEntryCollection entries = oimInfo.getEntry();
            String orgNameCellVal = this.entryOrgNameToString(entries);
            if (orgNameCellVal != null) {
                this.tblMain.getRow(i).getCell("org.name").setValue((Object)orgNameCellVal);
            }
            if (oimInfo.getOrgType().getValue() != 0) {
                this.tblMain.getRow(i).getCell("orgType").setValue((Object)oimInfo.getOrgType().getAlias());
            }
            this.tblMain.getRow(i).getCell("description").setValue((Object)oimInfo.getDescription());
            this.tblMain.getRow(i).getCell("id").setValue((Object)oimInfo);
            OrgInteMappingEntryCollection enties = oimInfo.getEntry();
            int size = oimInfo.getEntry().size();
            OrgUnitInfo[] orgs = new OrgUnitInfo[size];
            for (int j = 0; j < size; ++j) {
                orgs[j] = enties.get(j).getOrg();
            }
            this.tblMain.getRow(i).getCell("integrationCase.id").setValue((Object)enties);
            this.tblMain.getRow(i).getCell("entries").setValue((Object)orgs);
            this.tblMain.getRow(i).getCell("entries").setUserObject((Object)orgs);
        }
    }

    private void setUiStyle() {
        this.tblMain.getColumn("integrationCase.name").setWidth(150);
        this.tblMain.getColumn("org.name").setWidth(310);
        this.tblMain.getColumn("org.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("description").setWidth(360);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(false);
        this.btnSave.setEnabled(true);
        this.btnRemove.setVisible(false);
    }

    private void addListener() {
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                if (OrgInteMappingListUI.this.tblMain.getColumn(e.getColumnIndex()) != null && "org.name".equals(OrgInteMappingListUI.this.tblMain.getColumn(e.getColumnIndex()).getKey())) {
                    OrgInteMappingListUI.this.addKDF7ToTable(e);
                }
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    if (e.getColIndex() == OrgInteMappingListUI.this.tblMain.getColumnIndex("org.name")) {
                        OrgInteMappingListUI.this.proF7DataChanged();
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)"tableValueChanged_EASBizException", (Throwable)e1);
                }
            }
        });
    }

    protected String entryOrgNameToString(OrgInteMappingEntryCollection entries) {
        StringBuffer buffer = new StringBuffer();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo orgInfo = entries.get(i).getOrg();
            buffer.append(orgInfo.getName());
            if (i == size - 1) continue;
            buffer.append(";");
        }
        return buffer.toString();
    }

    private void addKDF7ToTable(KDTActiveCellEvent e) {
        this.orgF7 = new KDBizPromptBox();
        NewCompanyF7 promptOrgCompany = CompanyF7Helper.getMultiOrgViewTypeUnitF7WithoutFilter((IUIObject)this, (OrgViewType[])new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.PROFITCENTER});
        promptOrgCompany.setMultiSelect(true);
        promptOrgCompany.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        promptOrgCompany.setShowAssistantOrg(true);
        promptOrgCompany.setCheckedAssistantOrgChkBox(true);
        this.orgF7.setSelector((KDPromptSelector)promptOrgCompany);
        this.orgF7.setUserObject((Object)this.oimInfo);
        this.orgF7.setRequired(true);
        this.orgF7.setEditable(false);
        this.orgF7.setHistoryRecordEnabled(false);
        this.orgF7.setEditFormat("$name$");
        this.orgF7.setDisplayFormat("$name$");
        this.orgF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (OrgInteMappingListUI.this.orgF7.getSelector() != null) {
                    IRow row = OrgInteMappingListUI.this.getSelectedRow(OrgInteMappingListUI.this.tblMain);
                    OrgUnitInfo[] unitInfos = (OrgUnitInfo[])row.getCell("entries").getValue();
                    OrgInteMappingListUI.this.orgUnitInfos = unitInfos;
                    OrgInteMappingListUI.this.orgF7.setData((Object)unitInfos);
                }
            }
        });
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)this.orgF7);
        ICell cell = this.tblMain.getCell(e.getRowIndex(), e.getColumnIndex());
        cell.setEditor((ICellEditor)editor);
    }

    private StringBuffer checkOrgType(OrgViewType orgType, OrgUnitInfo[] unitInfos) {
        try {
            String ids = "";
            for (int i = 0; i < unitInfos.length; ++i) {
                ids = ids + "'" + unitInfos[i].getId().toString() + "'";
                if (i == unitInfos.length - 1) continue;
                ids = ids + ",";
            }
            String oql = "select id ,ISCOMPANYORGUNIT,ISPROFITORGUNIT,name where id in(" + ids + ")";
            if (unitInfos.length > 0) {
                StringBuffer names = new StringBuffer();
                FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(oql);
                for (int i = 0; i < coll.size(); ++i) {
                    if (OrgViewType.COMPANY.equals((Object)orgType) && !coll.get(i).isIsCompanyOrgUnit()) {
                        names.append(coll.get(i).getName());
                        if (i == coll.size() - 1) continue;
                        names.append(",");
                        continue;
                    }
                    if (!OrgViewType.PROFITCENTER.equals((Object)orgType) || coll.get(i).isIsProfitOrgUnit()) continue;
                    names.append(coll.get(i).getName());
                    if (i == coll.size() - 1) continue;
                    names.append(",");
                }
                if (names.length() > 0) {
                    String tipStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingResource.label3_orgTypeError"), names.toString(), orgType.getAlias(), orgType.getAlias());
                    return new StringBuffer(tipStr);
                }
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return new StringBuffer();
    }

    private void proF7DataChanged() {
        OrgViewType selectedOrgType = ((NewOrgF7PromptDialog)this.orgF7.getSelector()).getComboTypeSelectedItem();
        IRow row = this.getSelectedRow(this.tblMain);
        if (row.getCell("org.name").getValue() == null && row.getCell("entries") != null) {
            row.getCell("description").setValue(null);
            row.getCell("orgType").setValue(null);
            return;
        }
        Object selectorData = ((NewOrgF7PromptDialog)this.orgF7.getSelector()).getData();
        if (selectorData instanceof String) {
            row.getCell("org.name").setValue((Object)((String)selectorData));
        } else {
            OrgUnitInfo[] unitInfos = (OrgUnitInfo[])((NewOrgF7PromptDialog)this.orgF7.getSelector()).getData();
            StringBuffer orgTypeError = this.checkOrgType(selectedOrgType, unitInfos);
            if (unitInfos == null || orgTypeError.length() > 0) {
                unitInfos = (OrgUnitInfo[])row.getCell("entries").getValue();
            } else {
                row.getCell("entries").setValue((Object)unitInfos);
            }
            if (unitInfos == null) {
                row.getCell("org.name").setValue(null);
            } else {
                StringBuffer infos = new StringBuffer();
                for (int i = 0; i < unitInfos.length; ++i) {
                    infos.append(unitInfos[i].getName());
                    if (i == unitInfos.length - 1) continue;
                    infos.append(";");
                }
                row.getCell("org.name").setValue((Object)infos.toString());
                String orgsString = (String)row.getCell("org.name").getValue();
                if (selectedOrgType != null && orgsString != null && orgsString.trim().length() > 0 && orgTypeError.length() == 0) {
                    row.getCell("orgType").setValue((Object)selectedOrgType.getAlias());
                }
            }
            if (orgTypeError.length() > 0) {
                MsgBox.showInfo((String)orgTypeError.toString());
            }
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnAddNew);
        this.toolBar.remove((Component)this.btnView);
        this.toolBar.remove((Component)this.btnEdit);
        this.toolBar.remove((Component)this.btnQuery);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuFile.remove((JMenuItem)this.menuItemAddNew);
        this.menuEdit.remove((JMenuItem)this.menuItemEdit);
        this.menuView.remove((JMenuItem)this.menuItemView);
        this.menuView.remove((JMenuItem)this.menuItemQuery);
    }

    @Override
    public void actionSaveOIMapping_actionPerformed(ActionEvent e) throws Exception {
        this.saveOrgInteMapping();
    }

    private void saveOrgInteMapping() throws Exception {
        CoreBaseCollection oimInfos = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> deleteCol = new ArrayList<ObjectUuidPK>();
        int number = this.tblMain.getRowCount();
        HashMap<String, String> exitInteOrg = new HashMap<String, String>();
        HashMap<String, String> orgs = new HashMap<String, String>();
        for (int i = 0; i < number; ++i) {
            IRow row = this.tblMain.getRow(i);
            String orgNameStr = (String)row.getCell("org.name").getValue();
            OrgInteMappingInfo oimInfo = (OrgInteMappingInfo)row.getCell("id").getValue();
            OrgUnitInfo[] unitInfos = (OrgUnitInfo[])row.getCell("entries").getValue();
            if (orgNameStr != null && orgNameStr.trim().length() > 0) {
                String newId;
                String oldId;
                int j;
                String orgTypeStr = (String)row.getCell("orgType").getValue();
                oimInfo.setOrgType(this.getOrgTypeEnum(orgTypeStr));
                OrgInteMappingEntryCollection entries = oimInfo.getEntry();
                for (j = entries.size() - 1; j >= 0; --j) {
                    boolean isDelete = true;
                    oldId = entries.get(j).getOrg().getId().toString();
                    for (int j2 = 0; j2 < unitInfos.length; ++j2) {
                        newId = unitInfos[j2].getId().toString();
                        if (!newId.equals(oldId)) continue;
                        isDelete = false;
                        break;
                    }
                    if (!isDelete) continue;
                    entries.removeObject(j);
                }
                for (j = 0; j < unitInfos.length; ++j) {
                    boolean isAdd = true;
                    oldId = unitInfos[j].getId().toString();
                    for (int j2 = 0; j2 < entries.size(); ++j2) {
                        newId = entries.get(j2).getOrg().getId().toString();
                        if (!newId.equals(oldId)) continue;
                        isAdd = false;
                        break;
                    }
                    if (isAdd) {
                        OrgInteMappingEntryInfo entry = new OrgInteMappingEntryInfo();
                        entry.setOrg((FullOrgUnitInfo)unitInfos[j]);
                        entries.add(entry);
                    }
                    if (!exitInteOrg.containsKey(unitInfos[j].getId().toString() + oimInfo.getOrgType().getValue())) {
                        exitInteOrg.put(unitInfos[j].getId().toString() + oimInfo.getOrgType().getValue(), i + 1 + "");
                        continue;
                    }
                    orgs.put(unitInfos[j].getId().toString() + oimInfo.getOrgType().getValue(), unitInfos[j].getName());
                    exitInteOrg.put(unitInfos[j].getId().toString() + oimInfo.getOrgType().getValue(), (String)exitInteOrg.get(unitInfos[j].getId().toString() + oimInfo.getOrgType().getValue()) + "," + (i + 1));
                }
                String description = (String)row.getCell("description").getValue();
                if (description != null && description.length() > 255) {
                    int rowIndex = i + 1;
                    String meg = MessageFormat.format(EASResource.getString((String)(this.RESOURCE_PATH + "orgInteMapping_lenToLong")), rowIndex);
                    MsgBox.showConfirm2((String)meg);
                    return;
                }
                oimInfo.setDescription(description);
                oimInfos.add((CoreBaseInfo)oimInfo);
                continue;
            }
            if (unitInfos == null || unitInfos.length <= 0) continue;
            deleteCol.add(new ObjectUuidPK(oimInfo.getId()));
        }
        if (orgs.size() > 0) {
            StringBuffer tip = new StringBuffer();
            for (String key : orgs.keySet()) {
                tip.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingResource.label4_orgSetMoreInte"), exitInteOrg.get(key), orgs.get(key)));
            }
            MsgBox.showConfirm4a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingResource.label5_canSave"), (String)tip.toString());
            SysUtil.abort();
        }
        if (deleteCol.size() > 0) {
            IObjectPK[] pks = new IObjectPK[deleteCol.size()];
            deleteCol.toArray(pks);
            OrgInteMappingFactory.getRemoteInstance().deleteBatchData(pks);
        }
        this.getBizInterface().saveBatchData(oimInfos);
        this.SaveSuccessMeg();
        this.fillTable();
    }

    private void SaveSuccessMeg() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.showMessage();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rowIndexArr = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int rowIndexArrLen = rowIndexArr.length;
        IObjectPK[] oimDeletePKs = new IObjectPK[rowIndexArrLen];
        if (this.confirmRemove()) {
            for (int i = 0; i < rowIndexArrLen; ++i) {
                IRow row = this.tblMain.getRow(rowIndexArr[i]);
                OrgInteMappingInfo oimInfo = (OrgInteMappingInfo)row.getCell("id").getValue();
                oimDeletePKs[i] = new ObjectUuidPK(oimInfo.getId());
            }
        }
        this.getBizInterface().deleteBatchData(oimDeletePKs);
        this.fillTable();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillTable();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private OrgType getOrgTypeEnum(String orgType) {
        OrgType type = null;
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType value = (OrgType)orgTypeList.get(i);
            if (value == null || !orgType.equals(value.getAlias())) continue;
            type = value;
        }
        return type;
    }

    private IRow getSelectedRow(KDTable tblMain) {
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.ExistModifyData()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)this.getMeg());
            if (result == 0) {
                try {
                    this.saveOrgInteMapping();
                }
                catch (Exception e) {
                    logger.info((Object)(this.getName() + " saveOrgInteMapping error " + e));
                }
                return true;
            }
            return result == 1;
        }
        return true;
    }

    private String getMeg() {
        StringBuffer meg = new StringBuffer();
        for (int i = 0; i < this.modifyDataIndex.size(); ++i) {
            meg.append(this.modifyDataIndex.get(i));
            if (i == this.modifyDataIndex.size() - 1) continue;
            meg.append("\u3001");
        }
        String megs = MessageFormat.format(EASResource.getString((String)(this.RESOURCE_PATH + "orgInteMapping_existNOSave")), meg.toString());
        return megs;
    }

    private boolean ExistModifyData() {
        this.modifyDataIndex = new ArrayList();
        boolean modify = false;
        int number = this.tblMain.getRowCount();
        IRow row = null;
        OrgInteMappingInfo oimInfo = null;
        String des = null;
        OrgUnitInfo[] unitInfos = null;
        for (int i = 0; i < number; ++i) {
            row = this.tblMain.getRow(i);
            String orgNameStr = (String)row.getCell("org.name").getValue();
            if (orgNameStr != null && orgNameStr.trim().length() > 0) {
                des = (String)row.getCell("description").getValue();
                unitInfos = (OrgUnitInfo[])row.getCell("entries").getValue();
                oimInfo = (OrgInteMappingInfo)row.getCell("id").getValue();
                if (!(des != null && !des.equals(oimInfo.getDescription()) || des == null && oimInfo.getDescription() != null) && (unitInfos == null || unitInfos.equals(row.getCell("entries").getUserObject()))) continue;
                modify = true;
                this.modifyDataIndex.add(i + 1);
                continue;
            }
            if (orgNameStr != null || row.getCell("entries").getValue() == null) continue;
            modify = true;
            this.modifyDataIndex.add(i + 1);
        }
        return modify;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"integrationCase.name", "org.name", "orgType", "description"};
        return locateNames;
    }
}

