/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class OrgTreeF7SelectorForCslRpt
extends KDDialog
implements KDPromptSelector {
    protected boolean isOK = false;
    KDButton btnOk = null;
    KDButton btnCancel = null;
    FormulaWizardUI formulaWizardUI = null;
    private KDTable kdtable = this.initKDtable();
    String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private final String NUMBER = "orgTreeNumber";
    private final String NAME = "orgTreeName";

    public OrgTreeF7SelectorForCslRpt() throws HeadlessException {
        this.kdtable.setBounds(10, 20, 380, 200);
        this.kdtable.setVisible(true);
        KDPanel jp = new KDPanel();
        jp.setLayout(null);
        jp.add((Component)this.kdtable);
        this.setTitle(CslRptUtil.getString("DataService_OrgTree"));
        this.setModal(true);
        String strConfirm = EASResource.getString((String)this.resClassName, (String)"confirm");
        this.btnOk = new KDButton("OK");
        this.btnOk.setText(strConfirm);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrgTreeF7SelectorForCslRpt.this.close(true);
            }
        });
        this.btnOk.setEnabled(true);
        this.btnOk.setBounds(100, 230, 80, 26);
        jp.add((Component)this.btnOk);
        String strCancel = EASResource.getString((String)this.resClassName, (String)"cancel");
        this.btnCancel = new KDButton("CANCEL");
        this.btnCancel.setText(strCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrgTreeF7SelectorForCslRpt.this.close(false);
            }
        });
        this.btnCancel.setBounds(200, 230, 80, 26);
        this.btnCancel.setEnabled(true);
        jp.add((Component)this.btnCancel);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)jp, "Center");
        this.setSize(400, 300);
    }

    public boolean isCanceled() {
        return !this.isOK;
    }

    public Object getData() {
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            return iRow.getUserObject();
        }
        return null;
    }

    public static void main(String[] args) {
        OrgTreeF7SelectorForCslRpt orgTreeF7Selector = new OrgTreeF7SelectorForCslRpt();
        orgTreeF7Selector.show();
    }

    public void show() {
        this.setModal(true);
        this.putDataToKDTable();
        super.show();
    }

    private void close(boolean isOk) {
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)iRow.getUserObject();
            this.getFormulaWizardUI().setDataObject("orgTreeCslRpt", (IObjectValue)orgTreeInfo);
        }
        this.isOK = isOk;
        this.setVisible(false);
    }

    public KDTable initKDtable() {
        if (this.kdtable == null) {
            this.kdtable = new KDTable();
        }
        this.kdtable.checkParsed();
        this.kdtable.getSelectManager().setSelectMode(2);
        this.kdtable.getStyleAttributes().setLocked(true);
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("orgTreeNumber");
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("orgTreeName");
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)this.resClassName, (String)"orgTreeNumber");
        String strName = EASResource.getString((String)this.resClassName, (String)"orgTreeName");
        iRow.getCell("orgTreeNumber").setValue((Object)strNumber);
        iRow.getCell("orgTreeName").setValue((Object)strName);
        return this.kdtable;
    }

    public void putDataToKDTable() {
        try {
            IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("type", (Object)new Integer(8), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            view.setFilter(filter);
            OrgTreeCollection orgTrees = iOrgTree.getOrgTreeCollection(view);
            if (orgTrees != null && orgTrees.size() > 0) {
                this.kdtable.removeRows();
                for (int i = 0; i < orgTrees.size(); ++i) {
                    OrgTreeInfo info = orgTrees.get(i);
                    IRow iRow = this.kdtable.addRow();
                    iRow.setUserObject((Object)info);
                    ICell iCell1 = iRow.getCell("orgTreeNumber");
                    iCell1.setValue((Object)info.getNumber());
                    ICell iCell2 = iRow.getCell("orgTreeName");
                    iCell2.setValue((Object)info.getName());
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }
}

