/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IRptFormulaInductorHint;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.log4j.Logger;

public class OrgUnitF7ConfigHint
implements IRptFormulaInductorHint {
    private static final Logger logger = Logger.getLogger(OrgUnitF7ConfigHint.class);
    private FormulaWizardUI formulaWizardUI = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private int iSelectMode;
    private String SEPARATOR_SYMBOL = "|";
    private String orgUnitNumbers = "";

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void setCustomConfig(KDBizPromptBox box) {
        if (box == null) {
            return;
        }
        try {
            OrgTreeInfo orgTreeInfo;
            if (this.getFormulaWizardUI() != null) {
                String strNumber = this.getFormulaWizardUI().getParam("orgTreeCslRpt");
                if (strNumber == null || strNumber.length() == 0) {
                    String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                    MsgBox.showInfo((String)strErr);
                    return;
                }
                IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem1 = new FilterItemInfo("number", (Object)strNumber, CompareType.EQUALS);
                FilterItemInfo filterItem2 = new FilterItemInfo("type", (Object)new Integer(8), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem1);
                filter.getFilterItems().add(filterItem2);
                filter.setMaskString("#0 and #1");
                view.setFilter(filter);
                OrgTreeCollection orgTreeCollection = iOrgTree.getOrgTreeCollection(view);
                orgTreeInfo = null;
                if (orgTreeCollection == null || orgTreeCollection.size() <= 0) {
                    String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                    MsgBox.showInfo((String)strErr);
                    return;
                }
                orgTreeInfo = orgTreeCollection.get(0);
            } else {
                String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                MsgBox.showInfo((String)strErr);
                return;
            }
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this.getFormulaWizardUI(), 3);
            f7.setMultiSelect(true);
            f7.setTreeID(orgTreeInfo.getId().toString());
            f7.setCtrlUnitPK(orgTreeInfo.getCU());
            box.setSelector((KDPromptSelector)f7);
        }
        catch (Exception e) {
            logger.error((Object)"setCustomConfig_Exception", (Throwable)e);
        }
    }
}

