/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgUnitF7SelectorForEsp
extends KDDialog
implements KDPromptSelector {
    private static final Logger logger = Logger.getLogger(OrgUnitF7SelectorForEsp.class);
    private FormulaWizardUI formulaWizardUI = null;
    private int iSelectMode;
    private OrgUnitInfo orgUnit = null;

    public OrgUnitF7SelectorForEsp() {
        this.iSelectMode = 3;
    }

    public OrgUnitF7SelectorForEsp(int iMode) {
        this.iSelectMode = iMode;
    }

    public void show() {
        this.createOrgTree();
    }

    public boolean isCanceled() {
        return false;
    }

    public Object getData() {
        return this.orgUnit;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void createOrgTree() {
        Object obj = null;
        boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
        if (this.getFormulaWizardUI() != null) {
            obj = ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).getData();
        }
        String orgTreeID = null;
        if (obj instanceof String) {
            Object info;
            String orgTreeNumber = (String)obj;
            String rptPeriodType = this.getFormulaWizardUI().getParam("rptPeriodType");
            String year = this.getFormulaWizardUI().getParam("year");
            String period = this.getFormulaWizardUI().getParam("period");
            RptContextManager RptContext = (RptContextManager)this.getFormulaWizardUI().getRptContext();
            Object object = info = RptContext == null ? null : RptContext.getReportInfo();
            if (info != null && info instanceof CslReportInfo) {
                CslReportInfo cslInfo = (CslReportInfo)info;
                List list = RPTDate13Util.getRptYearAndPeriodAndDate(cslInfo.getYear(), cslInfo.getPeriod(), FormulaAdapter.getRptPeriodType(rptPeriodType.trim()), Integer.parseInt(year), Integer.parseInt(period), isSupport13Period);
                Timestamp date = new Timestamp(((Date)list.get(2)).getTime());
                try {
                    orgTreeID = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(orgTreeNumber, date);
                }
                catch (EASBizException e) {
                    logger.error((Object)"getID_EASBizException", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getID_BOSException", (Throwable)e);
                }
            } else {
                try {
                    OrgTreeCollection orgTreeCollection = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("where number = '" + orgTreeNumber + "' and status=" + 1 + " order by startDate desc ");
                    if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
                        orgTreeID = orgTreeCollection.get(0).getId().toString();
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"getOrgTreeCollection_BOSException", (Throwable)e);
                }
            }
        } else if (obj instanceof OrgTreeInfo) {
            orgTreeID = ((OrgTreeInfo)obj).getId().toString();
        }
        if (StringUtils.isEmpty(orgTreeID)) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"pleaseSelectOrgTree");
            MsgBox.showInfo((String)strErr);
            return;
        }
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this.getFormulaWizardUI(), this.iSelectMode);
        f7.setMultiSelect(false);
        f7.setTreeID(orgTreeID);
        f7.setNeedAddOrgRange(false);
        f7.show();
        this.orgUnit = (OrgUnitInfo)f7.getData();
    }
}

