/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.IEliminationStrategy;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OrgUnitTreeComponent
implements IEliminationStrategy {
    private static final Logger logger = CoreUIObject.getLogger(OrgUnitTreeComponent.class);
    private ListUI ui;
    KDTreeView treeView;
    private KDTree treeMain;
    private String treeId = null;
    Map permTreeAndUnit = null;
    KDCheckBox cbxContainSubordinate = null;
    Map allSubordinate = null;
    private static final String ROOT_ID = "TreeId";
    private Map unitMap = new HashMap();
    private Map idMap = new HashMap();
    Map resultMap = null;
    private UnionF7Helper.UnionF7 f7 = null;
    private OrgTreeInfo treeInfo = null;

    public OrgUnitTreeComponent(ListUI ui, KDTreeView treeView, String treeId, Map permTreeAndUnit, KDCheckBox cbxContainSubordinate, Map resultMap) {
        this.ui = ui;
        this.treeView = treeView;
        this.treeMain = new KDTree();
        treeView.setTree(this.treeMain);
        this.treeId = treeId;
        this.permTreeAndUnit = permTreeAndUnit;
        this.cbxContainSubordinate = cbxContainSubordinate;
        this.resultMap = resultMap;
    }

    public void setResultMap(Map map) {
        this.resultMap = map;
    }

    protected void initOrgTree() throws Exception {
        OrgStructureCollection allSubUnit = (OrgStructureCollection)this.resultMap.get("rs");
        this.unitMap = (Map)this.resultMap.get("unitMap");
        this.idMap = (Map)this.resultMap.get("idMap");
        this.allSubordinate = this.indexByParent(allSubUnit, this.treeId);
        this.refreshPermTreeAndUnit(this.permTreeAndUnit, this.treeId);
        this.treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectStringPK(this.treeId));
        this.f7 = new UnionF7Helper.UnionF7((IUIObject)this.ui, 2);
        this.f7.setTreeID(this.treeId);
        this.f7.setMultiSelect(false);
        String uiName = this.ui.getMetaDataPK().getFullName();
        if ("com.kingdee.eas.fi.gr.cslrpt.client.EliminationViewListUI".equals(uiName)) {
            this.f7.setPermissionItem("csl_elivoucher_list");
        }
        TreeModel mode = this.f7.buildTreeModel(OrgViewType.UNIONDEBT, this.treeInfo, null);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectStringPK userPk = new ObjectStringPK(userInfo.getId().toString());
        HashMap<String, ObjectStringPK> map = new HashMap<String, ObjectStringPK>();
        map.put("userPk", userPk);
        this.treeMain.setModel(mode);
        this.treeMain.setSelectionRow(0);
        this.onload_stepAddTreeData();
    }

    private void refreshPermTreeAndUnit(Map permTreeAndUnitCache, String treeId) throws Exception {
        if (treeId != null && permTreeAndUnitCache != null && !permTreeAndUnitCache.containsKey(treeId)) {
            HashMap<String, String> treeIdMap = new HashMap<String, String>(2);
            treeIdMap.put("treeId", treeId);
            Map valueMap = EliminationFactory.getRemoteInstance().getPermissionUnion(treeIdMap);
            permTreeAndUnitCache.putAll(valueMap);
        }
    }

    public void initialize() throws Exception {
        this.iniTree();
    }

    private void iniTree() throws Exception {
        this.treeView.setShowButton(false);
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                OrgUnitTreeComponent.this.tree_valueChanged(e);
            }
        });
        this.refreshTree();
    }

    private void onload_stepAddTreeData() throws Exception {
        UnionF7Helper.addTreeWillExpandListener((KDTree)this.treeMain, (OrgTreeInfo)this.treeInfo, (UnionF7Helper.UnionF7)this.f7);
    }

    protected void tree_valueChanged(TreeSelectionEvent e) {
        FullOrgUnitInfo orgUnit;
        this.setFilterByOrgUnit();
        try {
            this.ui.refreshList();
        }
        catch (Exception e1) {
            logger.error((Object)"tree_valueChanged()", (Throwable)e1);
            this.ui.handUIException((Throwable)e1);
        }
        boolean flag = true;
        if ("com.kingdee.eas.fi.gr.fast.client.EliminationForPCListUI".equals(this.ui.getMetaDataPK().getFullName()) && (orgUnit = this.getSelectOrgUnit()) != null) {
            flag = this.isHasOrgUnitPerm(orgUnit.getId().toString());
        }
        this.refreshButton(flag);
    }

    protected void refreshButton(boolean flag) {
    }

    protected void setFilterByOrgUnit() {
        String compareValue = null;
        CompareType compareType = null;
        FullOrgUnitInfo orgUnit = this.getSelectOrgUnit();
        if (orgUnit != null) {
            compareValue = orgUnit.getId().toString();
            compareType = CompareType.INCLUDE;
            boolean isHasPerm = false;
            if (!this.cbxContainSubordinate.isSelected()) {
                isHasPerm = this.isHasOrgUnitPerm(compareValue);
            }
            if (!isHasPerm && !this.cbxContainSubordinate.isSelected()) {
                compareValue = "error";
            }
        }
        boolean hasItem = false;
        FilterItemInfo itemInfo = null;
        if (this.ui.getMainQuery() != null) {
            FilterInfo filter = this.ui.getMainQuery().getFilter();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!"ORGUNIT.ID".equals(item.getPropertyName())) continue;
                if (this.cbxContainSubordinate.isSelected()) {
                    HashSet set = new HashSet();
                    if (compareValue != null) {
                        this.search(set, compareValue);
                        String uiName = this.ui.getMetaDataPK().getFullName();
                        if ("com.kingdee.eas.fi.gr.cslrpt.client.EliminationViewListUI".equals(uiName) && set != null && set.size() > 0) {
                            set = this.getFunctionPermissionUnit(set);
                        }
                        if (set == null || set.isEmpty()) {
                            item.setCompareValue((Object)"''");
                            item.setCompareType(CompareType.EQUALS);
                        } else {
                            item.setCompareValue(set);
                            item.setCompareType(CompareType.INCLUDE);
                        }
                    }
                    hasItem = true;
                    break;
                }
                if (compareType == null) break;
                item.setCompareValue((Object)(compareValue != null ? compareValue : "''"));
                item.setCompareType(CompareType.EQUALS);
                hasItem = true;
                break;
            }
            if (!hasItem && compareType != null) {
                HashSet set = null;
                if (this.cbxContainSubordinate.isSelected()) {
                    set = new HashSet();
                    this.search(set, compareValue);
                    String uiName = this.ui.getMetaDataPK().getFullName();
                    if ("com.kingdee.eas.fi.gr.cslrpt.client.EliminationViewListUI".equals(uiName) && set != null && set.size() > 0) {
                        set = this.getFunctionPermissionUnit(set);
                    }
                } else {
                    set = new HashSet();
                    set.add(compareValue);
                }
                if (set != null && set.size() == 0) {
                    set.add("''");
                }
                itemInfo = new FilterItemInfo("ORGUNIT.ID", set, compareType);
                filter.getFilterItems().add(itemInfo);
                String maskString = filter.getMaskString();
                if (filter.getFilterItems().size() == 0 || maskString == null) {
                    if (maskString == null) {
                        maskString = new String();
                    }
                    maskString = maskString + " #" + (filter.getFilterItems().size() - 1);
                } else {
                    maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
                }
                filter.setMaskString(maskString);
            }
        }
    }

    private HashSet getFunctionPermissionUnit(HashSet unitSet) {
        HashSet<String> unit = new HashSet<String>();
        try {
            String userPK = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            EliminationFactory.getRemoteInstance().removeCache();
            FullOrgUnitCollection fullOrgs = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userPK)), OrgType.UnionDebt, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.treeId)), "csl_elivoucher_list");
            Iterator it = unitSet.iterator();
            if (fullOrgs != null && fullOrgs.size() > 0) {
                while (it.hasNext()) {
                    String unitid = (String)it.next();
                    for (int i = 0; i < fullOrgs.size(); ++i) {
                        FullOrgUnitInfo info = fullOrgs.get(i);
                        String id = info.getId().toString();
                        if (!unitid.equals(id)) continue;
                        unit.add(unitid);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getFunctionPermissionUnit", (Throwable)e);
        }
        return unit;
    }

    private Map indexByParent(OrgStructureCollection allSubUnit, String treeId) throws SQLException {
        if (allSubUnit == null) {
            return null;
        }
        HashMap result = new HashMap();
        ArrayList<String> firstLevelList = new ArrayList<String>();
        String firstLevel = ROOT_ID;
        result.put(firstLevel, firstLevelList);
        for (int i = 0; i < allSubUnit.size(); ++i) {
            OrgStructureInfo info = allSubUnit.get(i);
            String id = info.getId().toString();
            String parentId = null;
            if (info.getParent().getId() != null) {
                parentId = info.getParent().getId().toString();
            }
            if (parentId == null) {
                firstLevelList.add(id);
                continue;
            }
            ArrayList<String> childrenList = (ArrayList<String>)result.get(parentId);
            if (childrenList == null) {
                childrenList = new ArrayList<String>();
                childrenList.add(id);
                result.put(parentId, childrenList);
                continue;
            }
            childrenList.add(id);
        }
        return result;
    }

    private void search(HashSet set, String curUnitId) {
        this.findLowLevelNode(this.allSubordinate, curUnitId, set);
    }

    private void findLowLevelNode(Map result, String curUnitId, HashSet set) {
        String id;
        ArrayList lowLevelList;
        boolean hasPermmission = this.isHasOrgUnitPerm(curUnitId);
        if (hasPermmission) {
            set.add(curUnitId);
        }
        ArrayList arrayList = lowLevelList = result.get(id = (String)this.unitMap.get(curUnitId)) == null ? null : (ArrayList)result.get(id);
        if (lowLevelList != null && lowLevelList.size() > 0) {
            for (int i = 0; i < lowLevelList.size(); ++i) {
                String idkey = (String)lowLevelList.get(i);
                String unitId = (String)this.idMap.get(idkey);
                boolean hasPerm = this.isHasOrgUnitPerm(unitId);
                if (hasPerm && unitId != null) {
                    set.add(unitId);
                }
                this.findLowLevelNode(result, unitId, set);
            }
        }
    }

    private boolean isHasOrgUnitPerm(String orgUnitId) {
        boolean isHasPerm = false;
        if (this.permTreeAndUnit != null && this.permTreeAndUnit.size() > 0) {
            Set keySet = this.permTreeAndUnit.keySet();
            if (this.treeId != null && keySet.contains(this.treeId)) {
                Set union = (Set)this.permTreeAndUnit.get(this.treeId);
                isHasPerm = union.contains(orgUnitId);
            }
        }
        return isHasPerm;
    }

    protected FullOrgUnitInfo getSelectOrgUnit() {
        DefaultKingdeeTreeNode node;
        FullOrgUnitInfo orgUnit = null;
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null && (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject() instanceof OrgStructureInfo) {
            orgUnit = ((OrgStructureInfo)node.getUserObject()).getUnit();
        }
        return orgUnit;
    }

    private void isOrgBoundNull() {
        if (this.ui.getMainQuery() != null) {
            FilterInfo filter = this.ui.getMainQuery().getFilter();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!"orgBound.id".equals(item.getPropertyName())) continue;
                if (item.getCompareValue() == null) {
                    MsgBox.showInfo((Component)this.ui, (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"584_OrgUnitTreeComponent"));
                    SysUtil.abort();
                    break;
                }
                this.treeId = (String)item.getCompareValue();
                break;
            }
        }
    }

    public ItemAction getActionBatchMove() {
        return null;
    }

    public ItemAction getActionMoveToSubOrg() {
        return null;
    }

    public void refreshTree() throws Exception {
        this.isOrgBoundNull();
        this.initOrgTree();
    }

    public String getRealSelectedNodeKeyValue() {
        return null;
    }
}

