/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractProcessSchedulePlan;
import com.kingdee.eas.fi.gr.cslrpt.client.EveryDay;
import com.kingdee.eas.fi.gr.cslrpt.client.EveryMonth;
import com.kingdee.eas.fi.gr.cslrpt.client.EveryWeek;
import com.kingdee.eas.fi.gr.cslrpt.client.OneTime;
import com.kingdee.eas.fi.gr.cslrpt.client.SelectScheduleType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

public class ProcessSchedulePlan
extends AbstractProcessSchedulePlan {
    private SelectScheduleType commonScheduleType;
    private EveryDay commonEveryDay;
    private EveryWeek commonEveryWeek;
    private EveryMonth commonEveryMonth;
    private OneTime commonOneTime;
    private String currentCard;
    private HashMap contex;
    private ScheduleDef schedule;
    private boolean readOnly;
    public static final String SCHEDULEDESC = "scheduleDescription";

    private void previousStep() {
        if (!this.currentCard.equalsIgnoreCase("type")) {
            String tempType = "type";
            this.getLayOut().show((Container)this.containerkDPanel, tempType);
            this.currentCard = tempType;
            this.previousKDButton.setEnabled(false);
            this.nextKDButton.setEnabled(true);
        }
    }

    private void nextStep() {
        if (this.currentCard.equalsIgnoreCase("type")) {
            ScheduleType st = this.commonScheduleType.getScheduleType();
            this.getLayOut().show((Container)this.containerkDPanel, st.toString());
            this.currentCard = st.toString();
            this.nextKDButton.setEnabled(false);
            this.previousKDButton.setEnabled(true);
        }
    }

    private String getSchedule() {
        try {
            ScheduleType st = this.commonScheduleType.getScheduleType();
            if (ScheduleType.EVERYDAY.equals((Object)st)) {
                return this.commonEveryDay.getSchedule();
            }
            if (ScheduleType.EVERYMONTH.equals((Object)st)) {
                return this.commonEveryMonth.getSchedule();
            }
            if (ScheduleType.EVERYWEEK.equals((Object)st)) {
                return this.commonEveryWeek.getSchedule();
            }
            if (ScheduleType.ONETIME.equals((Object)st)) {
                return this.commonOneTime.getSchedule();
            }
            return "";
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
            SysUtil.abort();
            return "";
        }
    }

    private String getScheduleDescription() {
        try {
            ScheduleType st = this.commonScheduleType.getScheduleType();
            if (ScheduleType.EVERYDAY.equals((Object)st)) {
                return this.commonEveryDay.getScheduleDescription();
            }
            if (ScheduleType.EVERYMONTH.equals((Object)st)) {
                return this.commonEveryMonth.getScheduleDescription();
            }
            if (ScheduleType.EVERYWEEK.equals((Object)st)) {
                return this.commonEveryWeek.getScheduleDescription();
            }
            if (ScheduleType.ONETIME.equals((Object)st)) {
                return this.commonOneTime.getScheduleDescription();
            }
            return "";
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
            return "";
        }
    }

    private void setSchedule() {
        if (this.schedule != null) {
            String shdl = this.schedule.getDefine();
            ScheduleType st = this.schedule.getType();
            this.commonScheduleType.setScheduleType(st, this.readOnly);
            if (ScheduleType.EVERYDAY.equals((Object)st)) {
                this.commonEveryDay.setSchedule(shdl, this.readOnly);
            } else if (ScheduleType.EVERYMONTH.equals((Object)st)) {
                this.commonEveryMonth.setSchedule(shdl, this.readOnly);
            } else if (ScheduleType.EVERYWEEK.equals((Object)st)) {
                this.commonEveryWeek.setSchedule(shdl, this.readOnly);
            } else if (ScheduleType.ONETIME.equals((Object)st)) {
                this.commonOneTime.setSchedule(shdl, this.readOnly);
            }
        }
    }

    private void finish() {
        ScheduleType type = this.commonScheduleType.getScheduleType();
        if (this.schedule == null) {
            this.schedule = new ScheduleDef(null);
        }
        String define = this.getSchedule();
        this.schedule.setType(type);
        this.schedule.setDefine(define);
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)this.schedule);
        this.contex.put("schedule", scheduleXML);
        this.contex.put(SCHEDULEDESC, this.getScheduleDescription());
        this.getUIWindow().close();
    }

    private void cancle() {
        this.getUIContext().put("schedule", "");
        this.getUIWindow().close();
    }

    private void getParameter() {
        try {
            Object obj = this.getUIContext().get("contex");
            if (obj instanceof HashMap) {
                Object objReadOnly;
                String scheduleXML;
                this.contex = (HashMap)obj;
                Object objSchedule = this.contex.get("oldschedule");
                if (objSchedule instanceof String && (scheduleXML = (String)objSchedule) != null && scheduleXML.length() > 0) {
                    this.schedule = KpdlParser.parseSchedule((String)scheduleXML);
                }
                if ((objReadOnly = this.contex.get("readonly")) instanceof Boolean) {
                    this.readOnly = (Boolean)objReadOnly;
                }
            }
        }
        catch (Exception e) {
            this.schedule = null;
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private CardLayout getLayOut() {
        LayoutManager lm = this.containerkDPanel.getLayout();
        if (lm != null && lm instanceof CardLayout) {
            return (CardLayout)lm;
        }
        return null;
    }

    private void initializeUI() {
        try {
            this.windowTitle = JobResourceUtil.getJobResource((String)"setSchedulePlan");
            this.imgKDLabel.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
            this.previousKDButton.addActionListener((ActionListener)new CommonActionListener());
            this.nextKDButton.addActionListener((ActionListener)new CommonActionListener());
            this.finishKDButton.addActionListener((ActionListener)new CommonActionListener());
            this.cancelKDButton.addActionListener((ActionListener)new CommonActionListener());
            CardLayout tempCL = new CardLayout();
            this.containerkDPanel.setLayout((LayoutManager)tempCL);
            this.commonScheduleType = new SelectScheduleType();
            this.commonScheduleType.initLayout();
            this.commonEveryDay = new EveryDay();
            this.commonEveryDay.initLayout();
            this.commonEveryWeek = new EveryWeek();
            this.commonEveryWeek.initLayout();
            this.commonEveryMonth = new EveryMonth();
            this.commonEveryMonth.initLayout();
            this.commonOneTime = new OneTime();
            this.commonOneTime.initLayout();
            this.containerkDPanel.add((Component)((Object)this.commonScheduleType), (Object)"type");
            this.containerkDPanel.add((Component)((Object)this.commonEveryDay), (Object)ScheduleType.EVERYDAY.toString());
            this.containerkDPanel.add((Component)((Object)this.commonEveryWeek), (Object)ScheduleType.EVERYWEEK.toString());
            this.containerkDPanel.add((Component)((Object)this.commonEveryMonth), (Object)ScheduleType.EVERYMONTH.toString());
            this.containerkDPanel.add((Component)((Object)this.commonOneTime), (Object)ScheduleType.ONETIME.toString());
            this.currentCard = "type";
            this.previousKDButton.setEnabled(false);
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.getParameter();
        this.setSchedule();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.initializeUI();
    }

    public static String[] open(Object owner, String scheduleXML, boolean readOnly) {
        try {
            HashMap<String, Object> contex = new HashMap<String, Object>();
            contex.put("oldschedule", scheduleXML);
            contex.put("readonly", new Boolean(readOnly));
            UIContext uiContext = new UIContext(owner);
            uiContext.put((Object)"contex", contex);
            String className = ProcessSchedulePlan.class.getName();
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            window.show();
            String[] result = new String[]{(String)contex.get("schedule"), (String)contex.get(SCHEDULEDESC)};
            return result;
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return null;
        }
    }

    public static String[] open(Object owner, String scheduleXML) {
        try {
            HashMap<String, Object> contex = new HashMap<String, Object>();
            contex.put("oldschedule", scheduleXML);
            contex.put("readonly", new Boolean(false));
            UIContext uiContext = new UIContext(owner);
            uiContext.put((Object)"contex", contex);
            String className = ProcessSchedulePlan.class.getName();
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            window.show();
            String[] result = new String[]{(String)contex.get("schedule"), (String)contex.get(SCHEDULEDESC)};
            return result;
        }
        catch (Exception error) {
            ExceptionHandler.handle((Throwable)error);
            return null;
        }
    }

    private class CommonActionListener
    implements ActionListener {
        private CommonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if ("next".equalsIgnoreCase(e.getActionCommand())) {
                    ProcessSchedulePlan.this.nextStep();
                } else if ("previous".equalsIgnoreCase(e.getActionCommand())) {
                    ProcessSchedulePlan.this.previousStep();
                } else if ("finish".equalsIgnoreCase(e.getActionCommand())) {
                    ProcessSchedulePlan.this.finish();
                } else if ("cancel".equalsIgnoreCase(e.getActionCommand())) {
                    ProcessSchedulePlan.this.cancle();
                }
            }
            catch (Exception error) {
                ExceptionHandler.handle((Throwable)error);
            }
        }
    }
}

