/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ProfitDistributeListFactory;
import com.kingdee.eas.fi.gr.cslrpt.ProfitDistributeListInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractProfitDistributeEditUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ProfitDistributeEditUI
extends AbstractProfitDistributeEditUI {
    private static final Logger logger = Logger.getLogger(ProfitDistributeEditUI.class);
    private String highMaintainLowLevel = "true";

    public ProfitDistributeEditUI() throws Exception {
        this.comboCurrency.addItemListener((ItemListener)new comCurrencyItemChanged());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        ProfitDistributeListInfo info = new ProfitDistributeListInfo();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.clear(14);
        info.setDistDate(calendar.getTime());
        info.setAmount(null);
        info.setCompany(null);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProfitDistributeListFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo curCompany;
        BOSUuid id;
        super.onLoad();
        this.highMaintainLowLevel = ParamManager.getParamValue(null, null, (String)"GR_CSL_HIGHERUPFINANCEORGMAINTAINLOWERLEVEVL");
        this.menuSubmitOption.setVisible(false);
        if (this.highMaintainLowLevel.equals("true")) {
            CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtCompany, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        } else {
            HashSet<String> disablePermSet = new HashSet<String>();
            disablePermSet.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            NewOrgViewF7PromptDialog f7 = CompanyF7Helper.getDisablePermCompanyBizUnitF7(disablePermSet);
            f7.setNeedAddOrgRange(false);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
            this.prmtCompany.setSelector((KDPromptSelector)f7);
            this.prmtCompany.setEditable(true);
        }
        this.txtAmount.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.txtAmount.setMaximumValue((Comparable)new BigDecimal("1000000000000"));
        EntityViewInfo view = new EntityViewInfo();
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem);
        CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view, true);
        BOSUuid bOSUuid = id = this.editData.getCurrency() != null ? this.editData.getCurrency().getId() : null;
        if (id == null && (curCompany = SysContext.getSysContext().getCurrentFIUnit()) != null && curCompany.getBaseCurrency() != null) {
            id = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId();
        }
        int i = 0;
        int precision = 2;
        for (CurrencyInfo currency : currencies) {
            this.comboCurrency.addItem((Object)currency);
            if (currency.getId().equals((Object)id)) {
                this.comboCurrency.setSelectedIndex(i);
                precision = currency.getPrecision() == 0 ? precision : currency.getPrecision();
                this.txtAmount.setPrecision(precision);
            }
            ++i;
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
        this.menuItemCopy.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.setControlStatus();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.pkDistDate.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_DateIsNull")));
        }
        if (this.prmtCompany.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_CompanyIsNull")));
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_CurrencyIsNull")));
        }
        if (StringUtils.isEmpty((String)this.txtAmount.getText())) {
            this.txtAmount.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_AmountMustGreaterZero")));
        }
        String text = this.txtAmount.getText().replaceAll(",", "");
        text = text.replaceAll("\\.\\.", "\\.");
        BigDecimal amount = null;
        try {
            amount = new BigDecimal(text);
        }
        catch (NumberFormatException nfe) {
            this.txtAmount.setText("");
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"wrong_money_format")));
        }
        BigDecimal zero = new BigDecimal("0");
        if (amount.compareTo(zero) != 1) {
            this.txtAmount.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_AmountMustGreaterZero")));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = super.getSelectors();
        src.add(new SelectorItemInfo("trackRecordCreator"));
        src.add(new SelectorItemInfo("currency.*"));
        return src;
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setControlStatus();
    }

    private void setControlStatus() {
        if (this.editData != null && this.editData.getId() != null) {
            String recordId = this.editData.getTrackRecordCreator() == null ? "" : this.editData.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
                    this.actionEdit.setEnabled(false);
                }
                this.actionRemove.setEnabled(true);
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(true);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
            if (this.editData.getCurrency() != null && this.editData.getCurrency().getId() != null) {
                for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
                    if (!this.editData.getCurrency().getId().toString().equals(((CurrencyInfo)this.comboCurrency.getItemAt(i)).getId().toString())) continue;
                    this.comboCurrency.setSelectedIndex(i);
                }
            }
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setTrackRecordCreator(SysContext.getSysContext().getCurrentFIUnit());
        super.actionSubmit_actionPerformed(e);
    }

    private void bom_changed(ItemEvent e) {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null) {
            int precision = currency.getPrecision() == 0 ? 2 : currency.getPrecision();
            this.txtAmount.setPrecision(precision);
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    class comCurrencyItemChanged
    implements ItemListener {
        comCurrencyItemChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ProfitDistributeEditUI.this.bom_changed(e);
            }
        }
    }
}

