/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RptReciveQueryStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractReceiveFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ReceiveFilterUI
extends AbstractReceiveFilterUI {
    private static final String SELECT_ALL = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    private CSLContext context = CSLContext.getInstance();
    private Map selectedUnit = new HashMap();
    private List selectedTemplate = new ArrayList();
    private HashSet idSet = new HashSet();
    private StringBuffer orgUnitIds = null;
    private StringBuffer tmpIds = null;
    private StringBuffer orgTreeIds = null;
    private static final String TB_ID = "id";
    private static final String TB_NUMBER = "number";
    private static final String TB_NAME = "name";
    private static final String TB_TYPE = "type";
    private static final String TB_OBJ = "obj";
    private static final String TB_ORGTREE = "orgTree";
    boolean isMergeByFiscalPeriod = false;
    boolean isSupportOtherDS = true;
    boolean isSupport13Period = false;

    public ReceiveFilterUI() throws Exception {
        boolean[] cslParams = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = cslParams[0];
        this.isSupportOtherDS = cslParams[1];
        this.isSupport13Period = cslParams[2];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.spinCurrentYear.setValue((Object)new Integer(calendar.get(1)));
        this.spinCurrentYear.setEnabled(false);
        this.spinCurrentPeriod.setEnabled(false);
        this.pkReortDate.setSupportedEmpty(false);
        this.initPeriodType();
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReceiveFilterUI.this.refreshContainer();
                ReceiveFilterUI.this.refreshDate();
            }
        });
        this.cbxQueryStatus.removeAllItems();
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.ALL);
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.UNWEAVE);
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.WEAVED);
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.UNCOMMITTED);
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.COMMITTED);
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.UNCONFIRMED);
        this.cbxQueryStatus.addItem((Object)RptReciveQueryStatusEnum.CONFIRMED);
        this.pkReortDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ReceiveFilterUI.this.refreshDate();
            }
        });
        this.chkQueryBudget.setSelected(false);
        if (this.isSupportOtherDS) {
            this.chkQueryBudget.setVisible(true);
        } else {
            this.chkQueryBudget.setVisible(false);
        }
        this.chkIsFreezed.setSelected(false);
        this.chkStartWorkTable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReceiveFilterUI.this.buttonStatusChange();
            }
        });
    }

    private void buttonStatusChange() {
        if (this.btnAddOrg.isEnabled()) {
            this.btnAddOrg.setEnabled(false);
            this.btnDelOrg.setEnabled(false);
            this.tblOrg.removeRows();
            this.selectedUnit.clear();
        } else {
            this.btnAddOrg.setEnabled(true);
            this.btnDelOrg.setEnabled(true);
        }
        if (this.btnAddTmp.isEnabled()) {
            this.btnAddTmp.setEnabled(false);
            this.btnDelTmp.setEnabled(false);
            this.tblTmp.removeRows();
            this.selectedTemplate.clear();
        } else {
            this.btnAddTmp.setEnabled(true);
            this.btnDelTmp.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkQueryBudget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiveFilterUI.this.refresh13Period();
            }
        });
        this.refreshContainer();
        this.clearClassParams();
        this.initOrgTable();
        this.initTmpTable();
    }

    private void clearClassParams() {
        this.selectedUnit.clear();
        this.selectedTemplate.clear();
        this.idSet.clear();
        this.orgUnitIds = null;
        this.tmpIds = null;
        this.orgTreeIds = null;
    }

    private void initOrgTable() {
        this.tblOrg.checkParsed();
        this.tblOrg.getSelectManager().setSelectMode(10);
        this.tblOrg.getStyleAttributes().setLocked(true);
    }

    private void initTmpTable() {
        this.tblTmp.checkParsed();
        this.tblTmp.getSelectManager().setSelectMode(10);
        this.tblTmp.getStyleAttributes().setLocked(true);
    }

    private void refreshContainer() {
        if (!this.isMergeByFiscalPeriod) {
            return;
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (periodType.equals((Object)RptPeriodTypeEnum.DAILY) || periodType.equals((Object)RptPeriodTypeEnum.WEEKLY)) {
            this.pkReortDate.setEnabled(true);
            this.spinCurrentYear.setEnabled(false);
            this.spinCurrentPeriod.setEnabled(false);
            CslRptUIUtil.setSpineRange(this.spinCurrentYear, 1900, 9999);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.spinCurrentPeriod, periodType);
        } else {
            this.pkReortDate.setEnabled(false);
            this.spinCurrentYear.setEnabled(true);
            this.spinCurrentPeriod.setEnabled(true);
            CslRptUIUtil.setSpineRange(this.spinCurrentYear, FiscalPeriodHelper.YearSpineRange[0], FiscalPeriodHelper.YearSpineRange[1]);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.spinCurrentPeriod, periodType);
        }
    }

    private void refreshDate() {
        Object type = this.comboPeriodType.getSelectedItem();
        if (type == null || type.equals(SELECT_ALL)) {
            return;
        }
        List times = null;
        if (this.pkReortDate.getSqlDate() != null) {
            times = RPTDateUtil.getRptPeriod(this.pkReortDate.getSqlDate(), (RptPeriodTypeEnum)type);
            this.spinCurrentYear.setValue((Object)new Integer(times.get(0).toString()));
            this.spinCurrentPeriod.setValue((Object)new Integer(times.get(1).toString()));
            this.pkReortDate.setValue(times.get(2));
        }
        this.refresh13Period();
    }

    private void initPeriodType() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        List types = RptPeriodTypeEnum.getEnumList();
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            RptPeriodTypeEnum type = (RptPeriodTypeEnum)types.get(i);
            model.addElement(types.get(i));
        }
        this.comboPeriodType.setModel(model);
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        if (this.comboPeriodType.getSelectedItem() != null && !this.comboPeriodType.getSelectedItem().equals(SELECT_ALL)) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterItemPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemPeriodType);
            Integer year = (Integer)this.spinCurrentYear.getValue();
            FilterItemInfo filterYear = new FilterItemInfo("year", (Object)year, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterYear);
            Integer period = (Integer)this.spinCurrentPeriod.getValue();
            FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)period, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriod);
        }
        RptReciveQueryStatusEnum queryStatus = (RptReciveQueryStatusEnum)((Object)this.cbxQueryStatus.getSelectedItem());
        FilterItemInfo item = new FilterItemInfo("queryStatus", (Object)new Integer(queryStatus.getValue()));
        this.filterInfo.getFilterItems().add(item);
        boolean isQueryBudget = this.chkQueryBudget.isSelected();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isQueryBudget", (Object)(isQueryBudget ? new Integer(1) : new Integer(0))));
        int isFreezed = 1;
        if (!this.chkIsFreezed.isSelected()) {
            isFreezed = 0;
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("template.isFreezed", (Object)new Integer(isFreezed), CompareType.EQUALS));
        boolean isFilter = this.chkStartWorkTable.isSelected();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isFilter", (Object)(isFilter ? new Integer(1) : new Integer(0))));
        if (isFilter) {
            this.getOrgIds();
            this.getTmplids();
            if (this.orgUnitIds != null && this.orgUnitIds.length() > 0) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitIds", (Object)this.orgUnitIds.toString()));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("orgTreeIds", (Object)this.orgTreeIds.toString()));
            }
            if (this.tmpIds != null && this.tmpIds.length() > 0) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("tmpIds", (Object)this.tmpIds.toString()));
            }
        }
        StringBuffer maskString = new StringBuffer();
        int size = this.filterInfo.getFilterItems().size();
        for (int index = 0; index < size; ++index) {
            maskString.append(" #").append(index);
            if (index + 1 == size) continue;
            maskString.append(" and ");
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    private void getOrgIds() {
        int count = this.tblOrg.getRowCount();
        ArrayList<String> treeList = new ArrayList<String>();
        this.orgUnitIds = new StringBuffer();
        this.orgTreeIds = new StringBuffer();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                OrgTreeInfo treeInfo;
                String treeid;
                IRow row = this.tblOrg.getRow(i);
                String orgUnitid = (String)row.getCell(TB_ID).getValue();
                this.orgUnitIds.append(orgUnitid);
                if (i != count - 1) {
                    this.orgUnitIds.append(",");
                }
                if (treeList.contains(treeid = (treeInfo = (OrgTreeInfo)row.getCell(TB_ORGTREE).getValue()).getId().toString())) continue;
                treeList.add(treeid);
                this.orgTreeIds.append(treeid);
            }
        }
    }

    private void getTmplids() {
        this.tmpIds = new StringBuffer();
        int count = this.tblTmp.getRowCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblTmp.getRow(i);
                String id = (String)row.getCell(TB_ID).getValue();
                this.tmpIds.append(id);
                if (i == count - 1) continue;
                this.tmpIds.append(",");
            }
        }
    }

    public void loadData(EntityViewInfo v) {
        try {
            this.onLoad();
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        super.loadData(v);
        FilterItemCollection currentFilterItemCollection = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        Integer year = null;
        Integer period = null;
        RptPeriodTypeEnum periodType = null;
        RptReciveQueryStatusEnum queryStatus = null;
        String orgUnitIdStr = null;
        String orgTreeIdStr = null;
        String tmpIdStr = null;
        this.chkStartWorkTable.setSelected(false);
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodTypeInt = (Integer)filterItemInfo.getCompareValue();
                periodType = RptPeriodTypeEnum.getEnum((int)periodTypeInt);
                this.comboPeriodType.setSelectedItem((Object)periodType);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                year = (Integer)filterItemInfo.getCompareValue();
                this.spinCurrentYear.setValue((Object)year);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                period = (Integer)filterItemInfo.getCompareValue();
                this.spinCurrentPeriod.setValue((Object)period);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("queryStatus")) {
                Integer queryStatusValue = (Integer)filterItemInfo.getCompareValue();
                queryStatus = RptReciveQueryStatusEnum.getEnum(queryStatusValue);
                this.cbxQueryStatus.setSelectedItem((Object)queryStatus);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isQueryBudget")) {
                Integer isQueryBudget = (Integer)filterItemInfo.getCompareValue();
                if (isQueryBudget == 1) {
                    this.chkQueryBudget.setSelected(true);
                } else {
                    this.chkQueryBudget.setSelected(false);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("template.isFreezed")) {
                Integer isFreezed = (Integer)filterItemInfo.getCompareValue();
                if (isFreezed == 0) {
                    this.chkIsFreezed.setSelected(false);
                } else {
                    this.chkIsFreezed.setSelected(true);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isFilter")) {
                Integer isFilter = (Integer)filterItemInfo.getCompareValue();
                if (isFilter == 0) {
                    this.chkStartWorkTable.setSelected(false);
                } else {
                    this.chkStartWorkTable.setSelected(true);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnitIds")) {
                orgUnitIdStr = filterItemInfo.getCompareValue().toString();
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgTreeIds")) {
                orgTreeIdStr = filterItemInfo.getCompareValue().toString();
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("tmpIds")) continue;
            tmpIdStr = filterItemInfo.getCompareValue().toString();
        }
        if (periodType != null && year != null && period != null) {
            this.pkReortDate.setValue((Object)RPTDate13Util.getPeriodLastDate(year, period, periodType));
            if (RPTDate13Util.isPeriod13(period, periodType)) {
                this.spinCurrentPeriod.setValue((Object)period);
            }
        }
        if (!StringUtils.isEmpty(orgUnitIdStr) && !StringUtils.isEmpty(orgTreeIdStr)) {
            this.fillOrgUnitTbl(orgUnitIdStr, orgTreeIdStr);
        }
        if (!StringUtils.isEmpty(tmpIdStr)) {
            this.fillTmpTbl(tmpIdStr);
        }
    }

    private void fillOrgUnitTbl(String orgUnitIdStr, String orgTreeIdStr) {
        this.selectedUnit = new HashMap();
        OrgTreeInfo treeInfo = null;
        FullOrgUnitCollection orgUnitCol = null;
        ArrayList<FullOrgUnitInfo> data = new ArrayList<FullOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)orgUnitIdStr, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeIdStr));
            orgUnitCol = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (orgUnitCol != null && orgUnitCol.size() > 0) {
            for (int i = 0; i < orgUnitCol.size(); ++i) {
                FullOrgUnitInfo orgUnitInfo = orgUnitCol.get(i);
                data.add(orgUnitInfo);
            }
            this.selectedUnit.put(treeInfo, data);
            this.fillOrgTable();
        }
    }

    private void fillTmpTbl(String temIdStr) {
        this.selectedTemplate = new ArrayList();
        this.idSet = new HashSet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)temIdStr, CompareType.INCLUDE));
        view.setFilter(filter);
        TemplateCollection temCol = null;
        try {
            temCol = TemplateFactory.getRemoteInstance().getTemplateCollection(view);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (temCol != null && temCol.size() > 0) {
            for (int i = 0; i < temCol.size(); ++i) {
                TemplateInfo temInfo = temCol.get(i);
                this.idSet.add(temInfo.getId().toString());
                this.selectedTemplate.add(temInfo);
            }
            this.fillTmpTable();
        }
    }

    public void clear() {
        super.clear();
        this.clearClassParams();
        if (RptPeriodTypeEnum.MONTHLY.equals(this.comboPeriodType.getSelectedItem())) {
            this.pkReortDate.setValue((Object)CslRptUIUtil.getLastPeriodDate(new Date()));
        } else {
            this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
        this.cbxQueryStatus.setSelectedItem((Object)RptReciveQueryStatusEnum.ALL);
        int[] value = RPTDateUtil.getLastPeriod(RptPeriodTypeEnum.MONTHLY, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) - 1);
        this.spinCurrentYear.setValue((Object)new Integer(value[0]));
        this.spinCurrentPeriod.setValue((Object)new Integer(value[1]));
        this.spinCurrentYear.setEnabled(false);
        this.spinCurrentPeriod.setEnabled(false);
        if (this.isMergeByFiscalPeriod && !RptPeriodTypeEnum.DAILY.equals(this.comboPeriodType.getSelectedItem()) && !RptPeriodTypeEnum.WEEKLY.equals(this.comboPeriodType.getSelectedItem())) {
            this.spinCurrentYear.setEnabled(true);
            this.spinCurrentPeriod.setEnabled(true);
        }
        this.pkReortDate.setValue((Object)calendar.getTime());
        this.chkQueryBudget.setSelected(false);
        this.chkIsFreezed.setSelected(false);
        this.chkStartWorkTable.setSelected(false);
    }

    private void refresh13Period() {
        int periodType;
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodTypeEnum)) {
            return;
        }
        int n = periodType = periodTypeEnum == null ? 0 : periodTypeEnum.getValue();
        if (3 == periodType && this.isSupport13Period && RPTDateUtil.isYearLastPeriod((Date)this.pkReortDate.getValue(), RptPeriodTypeEnum.MONTHLY)) {
            if (!this.chkQueryBudget.isSelected()) {
                this.spinCurrentPeriod.setEnabled(true);
                CslRptUIUtil.setSpineRange(this.spinCurrentPeriod, 12, 13);
            } else {
                SpinnerModel sm = this.spinCurrentPeriod.getModel();
                if (!(sm instanceof SpinnerNumberModel)) {
                    return;
                }
                SpinnerNumberModel nm = (SpinnerNumberModel)sm;
                if (nm.getValue() != null && (Integer)nm.getValue() == 13) {
                    nm.setValue(new Integer(12));
                }
                this.spinCurrentPeriod.setEnabled(false);
                CslRptUIUtil.setSpineRange(this.spinCurrentPeriod, 0, 365);
            }
        } else {
            this.spinCurrentPeriod.setEnabled(false);
            CslRptUIUtil.setSpineRange(this.spinCurrentPeriod, 0, 365);
        }
    }

    @Override
    public void addOrg_actionPerformed(ActionEvent e) throws Exception {
        int year = Integer.valueOf(this.spinCurrentYear.getValue().toString());
        int period = Integer.valueOf(this.spinCurrentPeriod.getValue().toString());
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        List time = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType);
        OrgTreeCollection collection = null;
        try {
            collection = CslRptUIUtil.getOrgTreeCollection((Date)time.get(2));
        }
        catch (EASBizException e1) {
            super.handUIException((Throwable)e1);
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        if (collection == null || collection.size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("912_ReceiveFilterUI"));
            return;
        }
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setOrgTrees(collection);
        f7.setMultiSelect(true);
        f7.setCumulate(false);
        f7.show();
        if (!f7.isCanceled()) {
            OrgTreeInfo tree = f7.getComboTreeSelectedItem();
            ArrayList<OrgUnitInfo> data = null;
            OrgTreeInfo tree12 = null;
            for (OrgTreeInfo tree12 : this.selectedUnit.keySet()) {
                if (tree12 == null || !tree12.getId().equals((Object)tree.getId())) continue;
                tree = tree12;
            }
            if (this.selectedUnit.containsKey(tree)) {
                data = (ArrayList<OrgUnitInfo>)this.selectedUnit.get(tree);
            } else if (this.selectedUnit.isEmpty()) {
                data = new ArrayList<OrgUnitInfo>();
                this.selectedUnit.put(tree, data);
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("notSameTree"));
                SysUtil.abort();
            }
            if (data != null) {
                OrgUnitInfo[] objs = (OrgUnitInfo[])f7.getData();
                for (int i = 0; i < objs.length; ++i) {
                    String obj = objs[i].toString().trim();
                    boolean bool = false;
                    for (int j = 0; j < data.size(); ++j) {
                        String objData = data.get(j).toString().trim();
                        if (!obj.equals(objData)) continue;
                        bool = true;
                    }
                    if (bool) continue;
                    data.add(objs[i]);
                }
            }
        }
        this.fillOrgTable();
    }

    @Override
    public void delOrg_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblOrg.getSelectManager().getBlocks();
        if (blocks.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int j = smallLine; j <= bigLine; ++j) {
                Object obj = this.tblOrg.getCell(j, this.tblOrg.getColumnIndex(TB_OBJ)).getValue();
                OrgTreeInfo tree = (OrgTreeInfo)this.tblOrg.getCell(j, this.tblOrg.getColumnIndex(TB_ORGTREE)).getValue();
                List data = (List)this.selectedUnit.get(tree);
                data.remove(obj);
                if (!data.isEmpty()) continue;
                this.selectedUnit.remove(tree);
            }
        }
        this.fillOrgTable();
    }

    private void fillOrgTable() {
        this.tblOrg.removeRows();
        for (OrgTreeInfo tree : this.selectedUnit.keySet()) {
            List data = (List)this.selectedUnit.get(tree);
            for (int i = 0; i < data.size(); ++i) {
                OrgUnitInfo info = (OrgUnitInfo)data.get(i);
                String id = info.getId().toString();
                IRow row = this.tblOrg.addRow();
                row.getCell(TB_ID).setValue((Object)id);
                row.getCell(TB_NUMBER).setValue((Object)info.getNumber());
                row.getCell(TB_NAME).setValue((Object)info.getName());
                if (info.isIsUnion()) {
                    row.getCell(TB_TYPE).setValue((Object)CslRptUtil.getString("ReceiveProgressTextGroup"));
                } else if (info.isIsCompanyOrgUnit()) {
                    row.getCell(TB_TYPE).setValue((Object)CslRptUtil.getString("ReceiveProgressTextCompany"));
                }
                row.getCell(TB_OBJ).setValue((Object)info);
                row.getCell(TB_ORGTREE).setValue((Object)tree);
            }
        }
    }

    @Override
    public void addTmp_actionPerformed(ActionEvent e) throws Exception {
        Set ids = this.getTableExistValues(this.tblTmp);
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        QueryAgent queryAgent = new QueryAgent();
        queryAgent.setQueryInfoPK(MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt.ReceiveFilterTemplateQuery"));
        queryAgent.setEnabledMultiSelection(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        queryAgent.setSelectorCollection(sic);
        dlg.setQueryInfo(queryAgent.getQueryInfo());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int isFreezed = 0;
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (periodType.getValue() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue())));
        }
        if (!ids.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)ids, CompareType.NOTINCLUDE));
        }
        if (!this.chkIsFreezed.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(isFreezed), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isK3Tpl", (Object)new Integer("0"), CompareType.EQUALS));
        view.setFilter(filter);
        dlg.setEntityViewInfo(view);
        dlg.setSelectorCollection(queryAgent.getSelectorCollection());
        dlg.setQueryExecutor(queryAgent.getQueryExecutor());
        dlg.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
        dlg.setReturnValueType(queryAgent.getReturnValueType());
        dlg.show();
        if (!dlg.isCanceled()) {
            Object[] objs = (Object[])dlg.getData();
            for (int i = 0; i < objs.length; ++i) {
                TemplateInfo info = (TemplateInfo)objs[i];
                if (this.idSet.contains(info.getId().toString())) continue;
                this.selectedTemplate.add(objs[i]);
                this.idSet.add(info.getId().toString());
            }
        }
        this.fillTmpTable();
    }

    private Set getTableExistValues(KDTable tbl) {
        HashSet<Object> ids = new HashSet<Object>();
        if (tbl == null) {
            return ids;
        }
        int count = tbl.getRowCount();
        for (int i = 0; i < count; ++i) {
            ids.add(tbl.getCell(i, 0).getValue());
        }
        return ids;
    }

    @Override
    public void delTmp_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblTmp.getSelectManager().getBlocks();
        if (blocks.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int j = smallLine; j <= bigLine; ++j) {
                Object obj = this.tblTmp.getCell(j, this.tblTmp.getColumnIndex(TB_OBJ)).getValue();
                TemplateInfo info = (TemplateInfo)obj;
                this.idSet.remove(info.getId().toString());
                this.selectedTemplate.remove(obj);
            }
        }
        this.fillTmpTable();
    }

    private void fillTmpTable() {
        this.tblTmp.removeRows();
        for (int i = 0; i < this.selectedTemplate.size(); ++i) {
            TemplateInfo info = (TemplateInfo)this.selectedTemplate.get(i);
            String id = info.getId().toString();
            IRow row = this.tblTmp.addRow();
            row.getCell(TB_ID).setValue((Object)id);
            row.getCell(TB_NUMBER).setValue((Object)info.getNumber());
            row.getCell(TB_NAME).setValue((Object)info.getName());
            row.getCell(TB_TYPE).setValue((Object)info.getTemplateType());
            row.getCell(TB_OBJ).setValue((Object)info);
        }
    }
}

