/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractReceiveProgressFilterUI;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ReceiveProgressFilterUI
extends AbstractReceiveProgressFilterUI {
    private static final long serialVersionUID = -3054261605809898098L;
    private boolean isByOrg = true;
    private final String SELECT_ALL = CslRptUtil.getString("ReceiveProgressTextAll");
    private final String IS_GROUP = CslRptUtil.getString("ReceiveProgressTextGroup");
    private final String IS_COMPANY = CslRptUtil.getString("ReceiveProgressTextCompany");

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Boolean showCompanyOnly() {
        if (!this.isByOrg) {
            throw new RuntimeException("can only called in org state ");
        }
        if (this.comboType.getSelectedIndex() > 0) {
            if (this.IS_GROUP.equals(this.comboType.getSelectedItem())) {
                return Boolean.FALSE;
            }
            if (this.IS_COMPANY.equals(this.comboType.getSelectedItem())) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public RptTmpTypeEnum getTemplateType() {
        if (this.isByOrg) {
            throw new RuntimeException("can only called in template state ");
        }
        if (this.comboType.getSelectedIndex() > 0) {
            return (RptTmpTypeEnum)this.comboType.getSelectedItem();
        }
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.contName.setVisible(false);
        this.comboType.removeAllItems();
        this.comboType.addItem((Object)this.SELECT_ALL);
        if (this.isByOrg) {
            this.comboType.addItem((Object)this.IS_COMPANY);
            this.comboType.addItem((Object)this.IS_GROUP);
            this.contName.setBoundLabelText(CslRptUtil.getString("ReceiveProgressByCompany"));
        } else {
            this.comboType.addItem((Object)RptTmpTypeEnum.GROUPCOMMREPORT);
            String value = CslParamFactory.getRemoteInstance().getParam("KEY_CSLPARAM_DIFFTABLE");
            if ("true".equalsIgnoreCase(value)) {
                this.comboType.addItem((Object)RptTmpTypeEnum.DIFFTABLE);
            }
            this.comboType.addItem((Object)RptTmpTypeEnum.CSLREPORT);
            this.comboType.addItem((Object)RptTmpTypeEnum.SUMREPORT);
            this.contName.setBoundLabelText(CslRptUtil.getString("ReceiveProgressByReport"));
        }
        this.initComponet();
        this.setF7EntityViewInfo();
    }

    private void initComponet() {
        this.bizCompany.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.ReceiveOgrUnitQuery");
        this.bizCompany.setEditFormat("$name$");
        this.bizCompany.setDisplayFormat("$name$");
        this.bizCompany.setCommitFormat("$name$");
        this.bizCompany.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
                Point location = pb.getLocationOnScreen();
                location.x += pb.getWidth();
                location.y += pb.getHeight();
                Dimension dialogSize = new Dimension(480, 540);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (location.x > screenSize.width - 480) {
                    location.x = location.x - dialogSize.width - 20;
                }
                if (location.y > screenSize.height - dialogSize.height) {
                    location.y = screenSize.height - dialogSize.height;
                }
                KDCommonPromptDialog dialog = (KDCommonPromptDialog)pb.getSelector();
                dialog.setLocation(location);
                dialog.setSize(dialogSize);
            }
        });
        this.comboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiveProgressFilterUI.this.comboTypeChange();
            }
        });
    }

    protected void comboTypeChange() {
        this.bizCompany.setData(null);
        this.setF7EntityViewInfo();
    }

    public void setF7EntityViewInfo() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("OrgTree.id", this.getUIContext().get("orgBound")));
        if (this.IS_COMPANY.equals(this.comboType.getSelectedItem())) {
            filter.getFilterItems().add(new FilterItemInfo("IsGrouping", (Object)new Integer(0)));
        } else if (this.IS_GROUP.equals(this.comboType.getSelectedItem())) {
            filter.getFilterItems().add(new FilterItemInfo("IsGrouping", (Object)new Integer(1)));
        }
        entityViewInfo.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorter);
        this.bizCompany.setEntityViewInfo(entityViewInfo);
    }

    public void setByOrg(boolean isByOrg) {
        this.isByOrg = isByOrg;
    }

    public OrgUnitInfo getUnit() {
        if (this.bizCompany.getData() != null) {
            return (OrgUnitInfo)this.bizCompany.getData();
        }
        return null;
    }

    public FilterInfo getFilterInfo() {
        String txt;
        this.filterInfo = new FilterInfo();
        int index = 0;
        if (this.comboType.getSelectedIndex() > 0) {
            FilterItemInfo filterType = null;
            if (this.isByOrg) {
                if (this.showCompanyOnly() != null) {
                    Integer it = null;
                    it = this.showCompanyOnly().equals(Boolean.TRUE) ? new Integer(1) : new Integer(0);
                    filterType = new FilterItemInfo("type", (Object)it);
                }
            } else if (this.getTemplateType() != null) {
                filterType = new FilterItemInfo("type", (Object)new Integer(this.getTemplateType().getValue()));
            }
            this.filterInfo.getFilterItems().add(filterType);
            ++index;
        }
        String string = txt = this.getUnit() == null ? null : this.getUnit().getId().toString();
        if (txt != null) {
            FilterItemInfo filterName = new FilterItemInfo("id", (Object)txt);
            this.filterInfo.getFilterItems().add(filterName);
            ++index;
        }
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < index; ++i) {
            if (i != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + i + " ");
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.comboType.setSelectedItem((Object)this.SELECT_ALL);
        this.bizCompany.setData(null);
    }

    public void loadData(EntityViewInfo v) {
        this.clearUI();
        try {
            this.onLoad();
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        super.loadData(v);
        FilterItemCollection currentFilterItemCollection = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            Object o;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("id")) {
                String id = (String)filterItemInfo.getCompareValue();
                OrgUnitInfo orgUnit = this.getCompanyById(id);
                this.bizCompany.setData((Object)orgUnit);
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("type") || (o = filterItemInfo.getCompareValue()) == null || !(o instanceof Integer)) continue;
            int value = (Integer)o;
            if (this.isByOrg) {
                if (value == 1) {
                    this.comboType.setSelectedItem((Object)this.IS_COMPANY);
                    continue;
                }
                if (value != 0) continue;
                this.comboType.setSelectedItem((Object)this.IS_GROUP);
                continue;
            }
            RptTmpTypeEnum type = RptTmpTypeEnum.getEnum((int)value);
            if (type == null) continue;
            this.comboType.setSelectedItem((Object)type);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    private OrgUnitInfo getCompanyById(String id) {
        if (id == null || "".equals(id.trim())) {
            return null;
        }
        try {
            OrgUnitCollection orgUnitCol = FullOrgUnitFactory.getRemoteInstance().getOrgUnitCollection("select * where id='" + id + "'");
            if (orgUnitCol.size() > 0) {
                return orgUnitCol.get(0);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

