/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IRptReceiveFacade;
import com.kingdee.eas.fi.gr.cslrpt.RptReceiveFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractReceiveProgressUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ReceiveProgressFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLIOUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.ReceiveFilterCondition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ReceiveProgressUI
extends AbstractReceiveProgressUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.client.ReceiveProgressUI");
    private static final long serialVersionUID = 1260254479762859074L;
    private boolean isByOrg = true;
    ReceiveFilterCondition condition = null;
    CommonQueryDialog conditionDialog = null;
    ReceiveProgressFilterUI conditionPanel = null;
    String currentDirectoryPath = null;
    boolean permission = false;

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object o = this.getUIContext().get("byOrg");
        if (o != null && o instanceof Boolean) {
            this.isByOrg = (Boolean)o;
        }
        this.initInterface();
        this.initData(this.getCondition());
    }

    public void onShow() throws Exception {
        super.onShow();
        PopupMenuManager tm = this.getPopupMenuManager((JComponent)this.tblMain);
        if (tm == null) {
            return;
        }
        tm.removeMenuSection("export");
    }

    private void initInterface() {
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        if (this.isByOrg) {
            this.tblMain.getHeadRow(0).getCell(1).setValue((Object)CslRptUtil.getString("ReceiveProgressByCompany"));
            this.tblMain.getHeadRow(1).getCell(1).setValue((Object)CslRptUtil.getString("ReceiveProgressByCompany"));
        }
    }

    private List filter(List list, ReceiveFilterCondition cd) {
        List<Map> result = new ArrayList();
        if (this.isByOrg) {
            Boolean showCompany = cd.getShowCompanyOnly();
            OrgUnitInfo unit = cd.getFilterUnit();
            if (showCompany != null || unit != null) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    Boolean isCompany;
                    Map row = (Map)list.get(i);
                    if (showCompany != null && !showCompany.equals(isCompany = (Boolean)row.get("KEY_RCV_TYPE"))) continue;
                    if (unit != null) {
                        String id = (String)row.get("KEY_RCV_ID");
                        if (!unit.getId().toString().equals(id)) continue;
                    }
                    result.add(row);
                }
            } else {
                result = list;
            }
        } else {
            RptTmpTypeEnum type = cd.getTemplateType();
            if (type != null) {
                int size = list.size();
                for (int i = size - 1; i >= 0; --i) {
                    Map row = (Map)list.get(i);
                    RptTmpTypeEnum tmpType = (RptTmpTypeEnum)row.get("KEY_RCV_TYPE");
                    int value = tmpType.getValue();
                    if (value == 10 || value == 15) {
                        value = 6;
                    } else if (value == 11 || value == 17) {
                        value = 3;
                    } else if (value == 13) {
                        value = 5;
                    }
                    if (value != type.getValue()) continue;
                    result.add(row);
                }
            } else {
                result = list;
            }
        }
        return result;
    }

    private void initData(ReceiveFilterCondition cd) throws EASBizException, BOSException {
        IRptReceiveFacade ir = RptReceiveFacadeFactory.getRemoteInstance();
        List treeNodes = (List)this.getUIContext().get("treeNodes");
        treeNodes = this.filter(treeNodes, cd);
        List list = null;
        list = !this.isByOrg ? ir.getReportsStatByTmp(treeNodes, cd) : ir.getReportsStatByOrg(treeNodes, cd);
        if (list == null) {
            return;
        }
        int n = list.size();
        this.tblMain.removeRows();
        this.tblMain.addRows(n);
        IRow row = null;
        List record = null;
        for (int i = 0; i < n; ++i) {
            float total = 0.0f;
            float uncreated = 0.0f;
            float editing = 0.0f;
            float committed = 0.0f;
            float received = 0.0f;
            record = (List)list.get(i);
            row = this.tblMain.getRow(i);
            Object oType = record.get(0);
            Object oName = record.get(1);
            Object oTotal = record.get(2);
            Object oUncreated = record.get(3);
            Object oEditing = record.get(4);
            Object oCommitted = record.get(5);
            Object oReceived = record.get(6);
            String sType = null;
            if (!this.isByOrg && oType instanceof RptTmpTypeEnum) {
                switch (((RptTmpTypeEnum)oType).getValue()) {
                    case 6: {
                        sType = RptSrcTypeEnum.NORMAL.getAlias();
                        break;
                    }
                    case 5: {
                        sType = RptSrcTypeEnum.CONSOLIDATION.getAlias();
                        break;
                    }
                    case 3: {
                        sType = RptSrcTypeEnum.SUM.getAlias();
                        break;
                    }
                    case 10: {
                        sType = RptSrcTypeEnum.DYNAMICNORMALREPORT.getAlias();
                        break;
                    }
                    case 11: {
                        sType = RptSrcTypeEnum.DYNAMICSUMREPORT.getAlias();
                        break;
                    }
                    case 13: {
                        sType = RptSrcTypeEnum.DYNAMICCSLREPORT.getAlias();
                        break;
                    }
                    case 8: {
                        sType = RptSrcTypeEnum.DIFFTABLE.getAlias();
                        break;
                    }
                    case 15: {
                        sType = RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.getAlias();
                        break;
                    }
                    case 17: {
                        sType = RptSrcTypeEnum.MULTIDYNAMICSUMREPORT.getAlias();
                    }
                }
                row.getCell(0).setValue((Object)sType);
            } else if (this.isByOrg && oType instanceof Boolean) {
                sType = Boolean.TRUE.equals(oType) ? CslRptUtil.getString("ReceiveProgressTextCompany") : CslRptUtil.getString("ReceiveProgressTextGroup");
                row.getCell(0).setValue((Object)sType);
            }
            row.getCell(1).setValue(oName);
            row.getCell(2).setValue(oTotal);
            row.getCell(9).setValue(oUncreated);
            row.getCell(7).setValue(oEditing);
            row.getCell(5).setValue(oCommitted);
            row.getCell(3).setValue(oReceived);
            total = this.parseInt(oTotal);
            uncreated = this.parseInt(oUncreated);
            editing = this.parseInt(oEditing);
            committed = this.parseInt(oCommitted);
            received = this.parseInt(oReceived);
            if (!(total > 0.0f)) continue;
            row.getCell(4).setValue((Object)(Math.round(received * 100.0f / total) + "%"));
            row.getCell(6).setValue((Object)(Math.round(committed * 100.0f / total) + "%"));
            row.getCell(8).setValue((Object)(Math.round(editing * 100.0f / total) + "%"));
            row.getCell(10).setValue((Object)(Math.round(uncreated * 100.0f / total) + "%"));
        }
    }

    private ReceiveFilterCondition getCondition() {
        if (this.condition == null) {
            Object isFreezed;
            Object permission;
            Object dataCollect;
            Object period;
            Object year;
            Object periodType;
            Object currencyId;
            this.condition = new ReceiveFilterCondition();
            String orgBound = (String)this.getUIContext().get("orgBound");
            if (orgBound != null) {
                this.condition.setOrgBoundId(orgBound);
            }
            if ((currencyId = this.getUIContext().get("currency")) != null) {
                this.condition.setCurrentyId((String)currencyId);
            }
            if ((periodType = this.getUIContext().get("periodType")) != null) {
                this.condition.setPeriodType((RptPeriodTypeEnum)periodType);
            }
            if ((year = this.getUIContext().get("year")) != null) {
                this.condition.setYear((Integer)year);
            }
            if ((period = this.getUIContext().get("period")) != null) {
                this.condition.setPeriod((Integer)period);
            }
            if ((dataCollect = this.getUIContext().get("dataCollect")) != null) {
                this.condition.setDataCollectType((String)dataCollect);
            }
            if ((permission = this.getUIContext().get("permission")) != null) {
                this.condition.setHavePermission((Boolean)permission);
            }
            if ((isFreezed = this.getUIContext().get("template.isFreezed")) != null) {
                if ((Integer)isFreezed == 0) {
                    this.condition.setIsFreezed(false);
                } else {
                    this.condition.setIsFreezed(true);
                }
            }
        }
        return this.condition;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fc = new KDFileChooser(this.currentDirectoryPath);
        fc.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.ReportProcessUI_Export"));
        fc.addChoosableFileFilter(CSLIOUtils.getExcelFileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            boolean res;
            String path = file.getAbsolutePath();
            FileFilter ext = fc.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                path = path + ".xls";
                file = new File(path);
            }
            this.currentDirectoryPath = file.getParent();
            if (file.isFile()) {
                if (MsgBox.showConfirm2((Component)((Object)this), (String)RptResourceHelper.getString((String)"file-overwrite-confirm")) != 0) {
                    return;
                }
                file.delete();
            }
            if (!(res = this.exportToExcelWorkbook(file.getAbsolutePath()))) {
                MsgBox.showInfo((String)RptResourceHelper.getString((String)"reportprocessui-fileexport-error"));
            } else {
                MsgBox.showInfo((String)RptResourceHelper.getString((String)"lable8"));
            }
        }
    }

    private boolean exportToExcelWorkbook(String fileName) throws AdjustException {
        if (fileName == null) {
            return false;
        }
        try {
            KDSBook bk = new KDSBook(fileName);
            KDSSheet ks = this.tblMain.getIOManager().saveToKDSSheet(bk, true, true, this.tblMain.getName());
            if (ks != null) {
                bk.addSheet(null, ks);
            }
            new ExportManager().exportToExcel(bk, fileName);
            return true;
        }
        catch (Exception e) {
            throw new AdjustException(AdjustException.FILE_NOTFOUND);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getConditionDialog().show()) {
            ReceiveFilterCondition cd = this.getCondition();
            if (this.isByOrg) {
                cd.setShowCompanyOnly(this.conditionPanel.showCompanyOnly());
            } else {
                cd.setTemplateType(this.conditionPanel.getTemplateType());
            }
            cd.setFilterUnit(this.correctOrgUnitInfoByVersion(this.conditionPanel.getUnit()));
            this.initData(cd);
        }
    }

    private OrgUnitInfo correctOrgUnitInfoByVersion(OrgUnitInfo originUnitInfo) throws BOSException {
        String number;
        String string = number = originUnitInfo == null ? null : originUnitInfo.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            return originUnitInfo;
        }
        String orgBoundId = (String)this.getUIContext().get("orgBound");
        if (StringUtils.isEmpty((String)orgBoundId)) {
            return originUnitInfo;
        }
        String ksql = "select *,unit.* where unit.number ='" + number + "' and tree.id='" + orgBoundId + "'";
        OrgStructureCollection col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(ksql);
        if (col == null || col.size() == 0) {
            return originUnitInfo;
        }
        return col.get(0).getUnit();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initData(this.getCondition());
    }

    private int parseInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.app", "ReceiveQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        return this.conditionDialog;
    }

    private ReceiveProgressFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ReceiveProgressFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            this.conditionPanel.setByOrg(this.isByOrg);
            this.conditionPanel.getUIContext().put("orgBound", this.getUIContext().get("orgBound"));
        }
        return this.conditionPanel;
    }
}

