/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.client.IElimImportBasicTree;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;

public class RelatedCompanyImport
implements IElimImportBasicTree {
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private Object sourceCurrencyinfo = null;
    private Object currencyinfo = null;
    private Object elimType = null;
    private Object elimMode = null;

    @Override
    public void addRecordToTable(EntityViewInfo eliminationImportQuery, List companyIds) throws BOSException {
        CurrencyInfo currency;
        IOrgStructure structure = OrgStructureFactory.getRemoteInstance();
        EntityViewInfo structureView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.orgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.orgTreeInfo.getId().toString(), CompareType.EQUALS));
        structureView.setFilter(filterInfo);
        CoreBaseCollection collection = structure.getCollection(structureView);
        OrgStructureInfo base = null;
        StringBuffer companys = new StringBuffer("");
        for (int i = 0; i < collection.size(); ++i) {
            base = (OrgStructureInfo)collection.get(i);
            companys.append("" + base.getUnit().getId().toString() + ",");
            companyIds.add(base.getUnit().getId().toString());
        }
        if (companys.lastIndexOf(",") != -1) {
            companys.deleteCharAt(companys.lastIndexOf(","));
        }
        IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
        OrgTreeCollection orgBoundList = iOrgTree.getOrgTreeCollection("SELECT id WHERE basic = 1 and type = 8 and startdate <= '" + new Timestamp(RPTDate13Util.getPeriodLastDate(this.year, this.period, this.periodType).getTime()) + "' and (enddate is null or enddate >= '" + new Timestamp(RPTDate13Util.getPeriodLastDate(this.year, this.period, this.periodType).getTime()) + "')");
        OrgTreeInfo tree = null;
        StringBuffer basicOrgTrees = new StringBuffer("");
        for (int i = 0; i < orgBoundList.size(); ++i) {
            tree = orgBoundList.get(i);
            basicOrgTrees.append("" + tree.getId().toString() + ",");
        }
        if (0 < orgBoundList.size()) {
            basicOrgTrees.deleteCharAt(basicOrgTrees.lastIndexOf(","));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(this.year), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.period), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.periodType.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)basicOrgTrees.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("entries.company.id", (Object)companys.toString(), CompareType.INCLUDE));
        if (this.currencyinfo != null) {
            currency = (CurrencyInfo)this.currencyinfo;
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
        }
        if (this.sourceCurrencyinfo != null) {
            currency = (CurrencyInfo)this.sourceCurrencyinfo;
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)currency.getId().toString()));
        }
        if (this.elimType != null) {
            ElimTypeEnum type = (ElimTypeEnum)((Object)this.elimType);
            filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)new Integer(type.getValue())));
        }
        if (this.elimMode != null) {
            if ("".equals(this.elimMode)) {
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", null));
            } else {
                EliminationModeInfo eliminationModeInfo = (EliminationModeInfo)this.elimMode;
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", (Object)eliminationModeInfo.getId().toString()));
            }
        }
        eliminationImportQuery.setFilter(filter);
    }

    @Override
    public void setBasicParam(HashMap param) {
        this.orgUnitInfo = (OrgUnitInfo)param.get("orgUnitInfo");
        this.year = new Integer(param.get("year").toString());
        this.period = new Integer(param.get("period").toString());
        this.periodType = (RptPeriodTypeEnum)param.get("periodType");
        this.orgTreeInfo = (OrgTreeInfo)param.get("orgTreeInfo");
    }

    @Override
    public void setCurrency(HashMap map) {
        this.sourceCurrencyinfo = map.get("sourceCurrency");
        this.currencyinfo = map.get("currency");
    }

    @Override
    public void setElimType(Object elimType) {
        this.elimType = elimType;
    }

    @Override
    public void setElimMode(Object elimMode) {
        this.elimMode = elimMode;
    }
}

