/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRelatedPartySumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Dimension;

public class RelatedPartySumFilterUI
extends AbstractRelatedPartySumFilterUI {
    private boolean hasLoadInitData;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
            this.pp.setString("orgGroup", this.ctx.getCurOrgGroup().getId().toString());
        }
    }

    private void fillDataToUI() throws EASBizException, BOSException {
        this.cmbCurrency.removeAllItems();
        CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        this.cmbCurrency.addItems(currencies.toArray());
        if (this.pp.containsKey("currencyId")) {
            String currencyId = this.pp.getString("currencyId");
            for (int j = 1; j < this.cmbCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                this.cmbCurrency.setSelectedIndex(j);
                break;
            }
        }
    }

    @Override
    public RptProperties getCustomCondition() {
        CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        this.pp.setString("currencyId", currency.getId().toString());
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        try {
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public Object getParam() {
        RptProperties condition = this.getCustomCondition();
        if (condition != null && condition.containsKey("tableName")) {
            condition.remove("tableName");
        }
        return condition;
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }

    @Override
    public CustomerParams getCustomerParams() {
        RptProperties condition = this.getCustomCondition();
        if (condition != null && condition.containsKey("tableName")) {
            condition.remove("tableName");
        }
        CustomerParams cp = new CustomerParams();
        if (condition.getString("currencyId") != null && !condition.getString("currencyId").equalsIgnoreCase("")) {
            cp.addCustomerParam("currencyId", condition.getString("currencyId"));
        }
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        RptProperties condition = this.pp;
        if (condition == null) {
            condition = new RptProperties();
        }
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("currencyId") != null) {
            condition.setString("currencyId", cp.getCustomerParam("currencyId"));
            this.setCustomCondition(condition);
        }
    }
}

