/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.RptItemConvDifferenceFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptItemConvDiffListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.RptItemConvDiffEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.RptItemListUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class RptItemConvDiffListUI
extends AbstractRptItemConvDiffListUI {
    private static final Logger logger = CoreUIObject.getLogger(RptItemConvDiffListUI.class);
    private OrgUnitInfo company = null;
    private boolean selfGradeOnly = false;

    public RptItemConvDiffListUI() throws Exception {
        this.addTblDataFillListener();
        this.company = SysContext.getSysContext().getCurrentOrgUnit();
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"formula"};
    }

    private void addTblDataFillListener() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                RptItemConvDiffListUI.this.fillTable(e);
            }
        });
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    RptItemConvDiffListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    RptItemConvDiffListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreatorid").getValue().toString().equals(this.company.getId().toString())) {
            this.actionRemove.setEnabled(false);
            this.actionEdit.setEnabled(false);
        } else {
            this.actionRemove.setEnabled(true);
            this.actionEdit.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonsAndMenu();
    }

    private void setButtonsAndMenu() {
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.menuItemPrint.setEnabled(true);
        this.menuItemPrintPreview.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.actionPrint.setVisible(true);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setVisible(true);
        this.actionPrintPreview.setEnabled(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptItemConvDifferenceFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return RptItemConvDiffEditUI.class.getName();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)RptItemListUI.class.getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)RptItemListUI.class.getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_RptItemConvDifference", (String)"FTrackRecordCreatorID", (ArrayList)this.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtilClient.judgeAndPromptSelectedRow((KDTable)this.tblMain, (int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (String)"trackRecordCreatorid", (String)this.company.getId().toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), (String)"noeqCreateOrgRemove");
        super.actionRemove_actionPerformed(e);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"rptItem.number", "rptItem.name"};
        return locateNames;
    }
}

