/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AbstractRPTItemDiffIndexInfo;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DiffIndexTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FormulaDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemDiffIndex;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptItemDiffIdxEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CheckFormulaIfClauseUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.CslMaterialInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RptItemDiffIdxEditUI
extends AbstractRptItemDiffIdxEditUI
implements IFormulaPickerListener {
    private static final Logger logger = Logger.getLogger(RptItemDiffIdxEditUI.class);
    private Calendar cal = Calendar.getInstance();

    public RptItemDiffIdxEditUI() throws Exception {
        this.btnCreateFormula.setIcon(EASResource.getIcon((String)"imgTbtn_showformula"));
        this.btnEditFormula.setIcon(EASResource.getIcon((String)"imgTbtn_editformula"));
        this.btnClearFormula.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnImportCompany.setIcon(EASResource.getIcon((String)"imgTbtn_citecompany"));
        this.btnDeleteRecord.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnFormulaWizard.setIcon(EASResource.getIcon((String)"imgTbtn_importformulaguide"));
        this.btnValidityCheck.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData == null) {
            return;
        }
        if (this.editData.getCurrency() != null) {
            for (int i = 0; i < this.cbxCurrency.getItemCount(); ++i) {
                CurrencyInfo currency = (CurrencyInfo)this.cbxCurrency.getItemAt(i);
                if (!this.editData.getCurrency().getId().equals((Object)currency.getId())) continue;
                this.cbxCurrency.setSelectedIndex(i);
                break;
            }
        }
        RPTItemDiffIndexEntryCollection collection = this.editData.getEntries();
        int count = collection.size();
        this.entries.checkParsed();
        this.rbnStandardValue.setSelected(true);
        if (this.editData.getDiffIndexType() != null && this.editData.getDiffIndexType().equals((Object)DiffIndexTypeEnum.STANDARDPERENT)) {
            this.rbnStandardPercent.setSelected(true);
            try {
                this.rbnStandardPercent_actionPerformed(null);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.entries.getSelectManager().setSelectMode(10);
        this.entries.getColumn(0).getStyleAttributes().setLocked(true);
        this.entries.getColumn(1).getStyleAttributes().setLocked(true);
        this.entries.getColumn(3).getStyleAttributes().setLocked(true);
        this.entries.removeRows();
        IRow row = this.entries.addRow();
        String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DefaultStandValue");
        row.getCell(0).setValue((Object)str);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            row.getCell(2).setValue((Object)"0.0000");
            if (this.cbxCurrency.getItemCount() > 0) {
                this.cbxCurrency.setSelectedIndex(0);
            }
        } else {
            row.getCell(2).setValue((Object)this.editData.getDefaultStandValue());
        }
        for (int i = 0; i < count; ++i) {
            row = this.entries.addRow();
            if (collection.get(i).getOrgTree() != null) {
                row.getCell(0).setValue((Object)collection.get(i).getOrgTree().getName());
                row.getCell(0).setUserObject((Object)collection.get(i).getOrgTree());
                row.getCell(1).setValue((Object)collection.get(i).getOrgUnit().getName());
                row.getCell(1).setUserObject((Object)collection.get(i).getOrgUnit());
            } else {
                row.getCell(1).setValue((Object)collection.get(i).getCompany().getName());
                row.getCell(1).setUserObject((Object)collection.get(i).getCompany());
            }
            if (collection.get(i).getStandardValue() != null) {
                row.getCell(2).setValue((Object)collection.get(i).getStandardValue());
            }
            if (collection.get(i).getId() == null) continue;
            row.getCell(3).setValue((Object)collection.get(i).getId().toString());
        }
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            KDFormattedTextField formatField = new KDFormattedTextField();
            formatField.setDataType(1);
            formatField.setPrecision(4);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)formatField);
            this.entries.getColumn(2).setEditor((ICellEditor)editor);
        } else {
            this.entries.getColumn(2).getStyleAttributes().setLocked(true);
        }
        this.loadDataFromFormula();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnCreateFormula.setEnabled(true);
            this.btnEditFormula.setEnabled(true);
            this.btnClearFormula.setEnabled(true);
            this.btnImportCompany.setEnabled(true);
            this.btnDeleteRecord.setEnabled(true);
            this.btnFormulaWizard.setEnabled(true);
            this.btnValidityCheck.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnCreateFormula.setEnabled(false);
            this.btnEditFormula.setEnabled(false);
            this.btnClearFormula.setEnabled(false);
            this.btnImportCompany.setEnabled(false);
            this.btnDeleteRecord.setEnabled(false);
            this.btnFormulaWizard.setEnabled(false);
            this.btnValidityCheck.setEnabled(false);
        }
        if (this.f7MaintainCU.getData() == null) {
            this.f7MaintainCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    private void loadDataFromFormula() {
        ItemFormula itemFormula;
        String formulaString = this.editData.getFormula();
        if (StringUtils.isEmpty((String)formulaString)) {
            return;
        }
        String pattern = "Item\\([^\\s^\\)]{1,}\\)|DItem\\([^\\s^\\)]{1,}\\)|ITEM\\([^\\s^\\)]{1,}\\)|DITEM\\([^\\s^\\)]{1,}\\)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(formulaString);
        String item = null;
        boolean result = m.find();
        while (result) {
            item = m.group();
            result = m.find();
        }
        String itemNumber = null;
        String dataElementNumbe = null;
        int valueTypeNumber = -1;
        Pattern pattItem = Pattern.compile("Item\\([^\\s^\\)]{1,}\\)");
        Pattern pattItemUpper = Pattern.compile("ITEM\\([^\\s^\\)]{1,}\\)");
        Pattern pattDItem = Pattern.compile("DItem\\([^\\s^\\)]{1,}\\)");
        Pattern pattDItemUpper = Pattern.compile("DITEM\\([^\\s^\\)]{1,}\\)");
        if (pattItem.matcher(item).matches() || pattItemUpper.matcher(item).matches()) {
            itemFormula = new ItemFormula(item);
            itemNumber = itemFormula.getItemNumber();
            dataElementNumbe = itemFormula.getDataElementNumber();
            valueTypeNumber = itemFormula.getValueType();
        } else if (pattDItem.matcher(item).matches() || pattDItemUpper.matcher(item).matches()) {
            itemFormula = new ItemFormula(item);
            itemNumber = itemFormula.getDItemNumber();
            dataElementNumbe = itemFormula.getDataElementNumber();
            valueTypeNumber = itemFormula.getValueType();
        }
        if (!StringUtils.isEmpty((String)itemNumber)) {
            RPTItemInfo rptItem = null;
            try {
                rptItem = RPTItemFactory.getRemoteInstance().getRPTItemInfo("where number = '" + itemNumber + "'");
            }
            catch (Exception e) {
                logger.error((Object)"getRPTItemInfo_Exception", (Throwable)e);
            }
            this.bizPromptItem.setData(rptItem);
        }
        if (!StringUtils.isEmpty((String)dataElementNumbe)) {
            DataElementInfo dataElement = DataElementProvider.getDataElementInfo(dataElementNumbe);
            this.bizDataElement.setData((Object)dataElement);
        }
        ValueTypeEnum valueType = ValueTypeEnum.getEnum(valueTypeNumber);
        this.cbDataType.setSelectedItem((Object)valueType);
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        AbstractRPTItemDiffIndexInfo oldData = null;
        try {
            if (this.editData.getId() != null) {
                ObjectStringPK pk = new ObjectStringPK(this.editData.getId().toString());
                IRPTItemDiffIndex ie = RPTItemDiffIndexFactory.getRemoteInstance();
                if (ie.exists((IObjectPK)pk)) {
                    oldData = (RPTItemDiffIndexInfo)RPTItemDiffIndexFactory.getRemoteInstance().getValue((IObjectPK)new ObjectStringPK(this.editData.getId().toString()), this.getSelectors());
                }
            }
        }
        catch (EASBizException e) {
            super.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        if (oldData == null) {
            return !StringUtils.isEmpty((String)this.txtName.getText()) || !StringUtils.isEmpty((String)this.txtNumber.getText()) || this.cbxCurrency.getSelectedIndex() > 0 || !StringUtils.isEmpty((String)this.txtPrompt.getText()) || !StringUtils.isEmpty((String)this.formula.getText()) || this.comboOperateSymbol.getSelectedIndex() > 0;
        }
        oldData.getEntries().clear();
        RPTItemDiffIndexEntryCollection entries = (RPTItemDiffIndexEntryCollection)((Object)this.editData.getEntries().clone());
        this.editData.getEntries().clear();
        boolean result = !ObjectValueUtil.objectValueEquals((AbstractObjectValue)oldData, (AbstractObjectValue)this.editData);
        this.editData.getEntries().addCollection(entries);
        return result;
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        super.storeFields();
        if (this.rbnStandardValue.isSelected()) {
            this.editData.setDiffIndexType(DiffIndexTypeEnum.STANDARDVALUE);
        }
        if (this.rbnStandardPercent.isSelected()) {
            this.editData.setDiffIndexType(DiffIndexTypeEnum.STANDARDPERENT);
        }
        this.editData.getEntries().clear();
        IRow row = this.entries.getRow(0);
        if (row.getCell(2).getValue() == null) {
            String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DefaultValueBlank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            SysUtil.abort();
        } else {
            this.editData.setDefaultStandValue(new BigDecimal(row.getCell(2).getValue().toString()));
        }
        for (int i = 1; i < this.entries.getRowCount(); ++i) {
            row = this.entries.getRow(i);
            RPTItemDiffIndexEntryInfo info = new RPTItemDiffIndexEntryInfo();
            if (row.getCell(2).getValue() != null) {
                info.setStandardValue(new BigDecimal(row.getCell(2).getValue().toString()));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"StandValue_Cannot_IsNull"));
                SysUtil.abort();
            }
            if (row.getCell(0).getUserObject() != null) {
                OrgTreeInfo orgInfo = (OrgTreeInfo)row.getCell(0).getUserObject();
                info.setOrgTree(orgInfo);
                FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)row.getCell(1).getUserObject();
                info.setOrgUnit(unitInfo);
            } else if (row.getCell(1).getUserObject() != null) {
                CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)row.getCell(1).getUserObject();
                info.setCompany(unitInfo);
            }
            this.editData.getEntries().add(info);
        }
    }

    private void addCreatrOrg() {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    protected IObjectValue createNewData() {
        RPTItemDiffIndexInfo info = new RPTItemDiffIndexInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        int year = this.cal.get(1);
        int period = this.cal.get(2);
        info.setStartYear(year);
        info.setStartPeriod(period + 1);
        info.setEndYear(year);
        info.setEndPeriod(12);
        info.setDiffIndexType(DiffIndexTypeEnum.STANDARDVALUE);
        info.setRange(new BigDecimal("0.0000"));
        return info;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuSubmitOption.setVisible(false);
        this.menuBiz.setVisible(false);
        this.loadCurrency();
        this.initBizPromptBox();
        this.initSpinner();
        this.initCheckFormulaRela();
        this.txtRange.setDataType(5);
        this.txtRange.setPrecision(10);
        this.txtRange.setHorizontalAlignment(4);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
            this.btnFormulaWizard.setEnabled(true);
            this.btnValidityCheck.setEnabled(true);
            this.chkIsCheckByDefault.setSelected(true);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
            this.btnCreateFormula.setEnabled(false);
            this.btnEditFormula.setEnabled(false);
            this.btnClearFormula.setEnabled(false);
            this.btnImportCompany.setEnabled(false);
            this.btnDeleteRecord.setEnabled(false);
            this.btnFormulaWizard.setEnabled(false);
            this.btnValidityCheck.setEnabled(false);
        } else if ("EDIT".equals(this.oprtState)) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
            this.btnFormulaWizard.setEnabled(true);
            this.btnValidityCheck.setEnabled(true);
        }
        this.entries.getSelectManager().setSelectMode(10);
        if (this.getUIContext().get("COPY_NEW") != null) {
            this.editData.setId(null);
            this.txtName.setText(null);
            this.txtNumber.setText(null);
            this.actionRemove.setEnabled(false);
            this.editData.setName(null);
            this.editData.setNumber(null);
        }
        for (int i = 0; i < this.cbDataType.getItemCount(); ++i) {
            ValueTypeEnum value = (ValueTypeEnum)((Object)this.cbDataType.getItemAt(i));
            if (value.getValue() != 3) continue;
            this.cbDataType.removeItem(this.cbDataType.getItemAt(i));
        }
        this.initControl();
    }

    private void initControl() {
        this.kDLabel1.setLocation(this.kDLabel1.getX(), this.kDLabel1.getY() - 20);
        this.btnFormulaWizard.setLocation(this.btnFormulaWizard.getX(), this.btnFormulaWizard.getY() - 20);
        this.btnValidityCheck.setLocation(this.btnValidityCheck.getX(), this.btnValidityCheck.getY() - 20);
        this.kDScrollPane1.setBounds(this.kDScrollPane1.getX(), this.kDScrollPane1.getY() - 20, this.kDScrollPane1.getWidth(), this.kDScrollPane1.getHeight() + 20);
        if (this.f7MaintainCU.getData() == null) {
            this.f7MaintainCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        if (this.getUIContext().get("maintainCU") != null) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.cbxCurrency.setEnabled(false);
            this.btnFormulaWizard.setEnabled(false);
            this.btnValidityCheck.setEnabled(false);
            this.txtAdvance.setEnabled(false);
            this.bizPromptItem.setEnabled(false);
            this.bizDataElement.setEnabled(false);
            this.cbDataType.setEnabled(false);
            this.rbnStandardPercent.setEnabled(false);
            this.rbnStandardValue.setEnabled(false);
            this.txtPrompt.setEnabled(false);
            this.btnCreateFormula.setEnabled(false);
            this.btnClearFormula.setEnabled(false);
            this.btnEditFormula.setEnabled(false);
            this.formula.setEnabled(false);
            this.comboOperateSymbol.setEnabled(false);
            this.txtRange.setEnabled(false);
            this.btnImportCompany.setEnabled(false);
            this.btnDeleteRecord.setEnabled(false);
            this.entries.setEnabled(false);
            this.spnStartYear.setEnabled(false);
            this.spnStartPeriod.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndPeriod.setEnabled(false);
            this.chkIsCheckByDefault.setEnabled(false);
            this.chkIsRequestLabel.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.actionAddNew.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            this.f7MaintainCU.setEnabled(true);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.editData.getDiffIndexType().equals((Object)DiffIndexTypeEnum.STANDARDVALUE)) {
            this.kDLabelContainer8.setBoundLabelText(CslRptUtil.getString("ItemDiffIdxErrorAllowed"));
            if (this.entries.getHeadRow(0) != null) {
                this.entries.getHeadRow(0).getCell(2).setValue((Object)CslRptUtil.getString("ItemDiffIdxNormalValue"));
            }
        } else {
            this.kDLabelContainer8.setBoundLabelText(CslRptUtil.getString("ItemDiffIdxErrorAllowed") + "(%)");
            if (this.entries.getHeadRow(0) != null) {
                this.entries.getHeadRow(0).getCell(2).setValue((Object)(CslRptUtil.getString("ItemDiffIdxNormalValue") + "(%)"));
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RPTItemDiffIndexFactory.getRemoteInstance();
    }

    @Override
    protected void rbnStandardValue_actionPerformed(ActionEvent e) throws Exception {
        super.rbnStandardValue_actionPerformed(e);
        this.kDLabelContainer8.setBoundLabelText(CslRptUtil.getString("ItemDiffIdxErrorAllowed"));
        this.entries.getHeadRow(0).getCell(2).setValue((Object)CslRptUtil.getString("ItemDiffIdxNormalValue"));
    }

    @Override
    protected void rbnStandardPercent_actionPerformed(ActionEvent e) throws Exception {
        super.rbnStandardPercent_actionPerformed(e);
        this.kDLabelContainer8.setBoundLabelText(CslRptUtil.getString("ItemDiffIdxErrorAllowed") + "(%)");
        this.entries.getHeadRow(0).getCell(2).setValue((Object)(CslRptUtil.getString("ItemDiffIdxNormalValue") + "(%)"));
    }

    @Override
    public void actionCreateFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFormula_actionPerformed(e);
        if (this.bizPromptItem.getData() == null) {
            String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Item_Blank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.bizPromptItem.requestFocus();
            SysUtil.abort();
        }
        RPTItemInfo rptItem = (RPTItemInfo)this.bizPromptItem.getData();
        if (this.bizDataElement.getData() == null) {
            String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElement_Blank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.bizPromptItem.requestFocus();
            SysUtil.abort();
        }
        DataElementInfo dataElement = (DataElementInfo)this.bizDataElement.getData();
        String name = dataElement.getNumber();
        String tempStr = this.getFormula(rptItem, name);
        this.formula.setText(tempStr);
    }

    @Override
    public void actionClearFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearFormula_actionPerformed(e);
        this.formula.setText("");
    }

    @Override
    public void actionEditFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditFormula_actionPerformed(e);
        this.formula.setEnabled(true);
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        picker.addFormulaPickerListener((IFormulaPickerListener)this);
        picker.setFilter("include:categorys{CslRptFormula},groups{5},formulas{Item,DItem}");
        picker.open();
    }

    @Override
    public void actionImportCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportCompany_actionPerformed(e);
        OrgTreeCollection otc = this.getOrgTreeColl();
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setMultiSelect(true);
        f7.setTreeID(null);
        CtrlUnitInfo info = new CtrlUnitInfo();
        info.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        f7.setCtrlUnitPK(info);
        f7.setUserPK((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setOrgTrees(otc);
        f7.show();
        OrgUnitInfo[] orgArray = (OrgUnitInfo[])f7.getData();
        OrgTreeInfo orgTreeInfo = f7.getComboTreeSelectedItem();
        if (orgArray == null) {
            return;
        }
        for (OrgUnitInfo company : orgArray) {
            String tempStr = company.getId().toString();
            int rowCount = this.entries.getRowCount();
            if (rowCount > 1) {
                Object obj = null;
                boolean flag = false;
                for (int j = 1; j < rowCount; ++j) {
                    obj = this.entries.getRow(j).getCell(1).getUserObject();
                    if (obj == null || !((OrgUnitInfo)obj).getId().toString().equals(tempStr)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                IRow row = this.entries.addRow();
                if (company.isIsGrouping()) {
                    row.getCell(0).setValue((Object)orgTreeInfo.getName());
                    row.getCell(0).setUserObject((Object)orgTreeInfo);
                }
                row.getCell(1).setValue((Object)company.getName());
                row.getCell(1).setUserObject((Object)company);
                row.getCell(2).setValue((Object)"0.0000");
                continue;
            }
            IRow row = this.entries.addRow();
            if (company.isIsGrouping()) {
                row.getCell(0).setValue((Object)orgTreeInfo.getName());
                row.getCell(0).setUserObject((Object)orgTreeInfo);
            }
            row.getCell(1).setValue((Object)company.getName());
            row.getCell(1).setUserObject((Object)company);
            row.getCell(2).setValue((Object)"0.0000");
        }
        this.entries.getSelectManager().setSelectMode(10);
    }

    public OrgTreeCollection getOrgTreeColl() throws Exception {
        OrgTreeCollection otc = CslRptUtil.getHistoryAndCurrentOrgTreeCollection(null, this.getUserId());
        this.removeHidenStructure(otc);
        otc = this.filterProfitOrg(otc);
        return otc;
    }

    private OrgTreeCollection filterProfitOrg(OrgTreeCollection otc) throws EASBizException, BOSException {
        if (otc != null && !otc.isEmpty()) {
            otc = CslRptUtil.getOrgTreeCollectionFilterProfitOrgWithDate(null, otc);
        }
        return otc;
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private void removeHidenStructure(OrgTreeCollection otc) {
        OrgTreeInfo info = null;
        for (int i = 0; i < otc.size(); ++i) {
            info = otc.get(i);
            if (!info.isIsHide()) continue;
            otc.remove(info);
            --i;
        }
    }

    @Override
    public void actionDeleteRecord_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionDeleteRecord_actionPerformed(e);
        KDTSelectBlock selectBlock = null;
        int size = this.entries.getSelectManager().size();
        if (size == 1 && this.entries.getSelectManager().get().getTop() == this.entries.getSelectManager().get().getBottom()) {
            int rowNum = this.entries.getSelectManager().get().getTop();
            ICell cell = this.entries.getRow(rowNum).getCell("entries.id");
            if (cell.getRowIndex() != 0) {
                this.entries.removeRow(cell.getRowIndex());
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                selectBlock = this.entries.getSelectManager().get(i);
                for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                    ICell cell = this.entries.getRow(j).getCell("entries.id");
                    if (cell.getRowIndex() == 0) continue;
                    this.entries.removeRow(cell.getRowIndex());
                }
            }
        }
        this.entries.getSelectManager().remove();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.clearData();
        this.btnCreateFormula.setEnabled(true);
        this.btnEditFormula.setEnabled(true);
        this.btnClearFormula.setEnabled(true);
        this.btnImportCompany.setEnabled(true);
        this.btnDeleteRecord.setEnabled(true);
        if (this.f7MaintainCU.getData() == null) {
            this.f7MaintainCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        this.entries.getColumn(2).getStyleAttributes().setLocked(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnCreateFormula.setEnabled(true);
        this.btnEditFormula.setEnabled(true);
        this.btnClearFormula.setEnabled(true);
        this.btnImportCompany.setEnabled(true);
        this.btnDeleteRecord.setEnabled(true);
        this.entries.getColumn(2).getStyleAttributes().setLocked(false);
    }

    private void initSpinner() {
        int year = this.cal.get(1);
        int period = this.cal.get(2);
        int startYear = this.spnStartYear.getIntegerVlaue() != null ? this.spnStartYear.getIntegerVlaue() : year;
        int endYear = this.spnEndYear.getIntegerVlaue() != null ? this.spnEndYear.getIntegerVlaue() : year;
        SpinnerNumberModel yearStartModel = new SpinnerNumberModel(startYear, 1, 4000, 1);
        SpinnerNumberModel yearEndModel = new SpinnerNumberModel(endYear, 1, 4000, 1);
        this.spnStartYear.setModel((SpinnerModel)yearStartModel);
        this.spnEndYear.setModel((SpinnerModel)yearEndModel);
        int startPeriod = this.spnStartPeriod.getIntegerVlaue() != null ? this.spnStartPeriod.getIntegerVlaue() : period;
        int endPeriod = this.spnEndPeriod.getIntegerVlaue() != null ? this.spnEndPeriod.getIntegerVlaue() : 12;
        SpinnerNumberModel periodStartModel = new SpinnerNumberModel(startPeriod, 1, 366, 1);
        SpinnerNumberModel periodEndModel = new SpinnerNumberModel(endPeriod, 1, 366, 1);
        this.spnStartPeriod.setModel((SpinnerModel)periodStartModel);
        this.spnEndPeriod.setModel((SpinnerModel)periodEndModel);
    }

    private void initBizPromptBox() throws Exception {
        this.bizPromptItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPromptItem.setDisplayFormat("$number$ - $name$");
        this.bizPromptItem.setEditFormat("$number$");
        this.bizPromptItem.setCommitFormat("$number$");
        this.bizPromptItem.setEditable(true);
        EntityViewInfo viewInfo = this.bizPromptItem.getEntityViewInfo();
        if (null == viewInfo) {
            viewInfo = new EntityViewInfo();
        }
        FilterInfo fltrInfo = new FilterInfo();
        FilterItemInfo fltrItemInfo = new FilterItemInfo("isFreezed", (Object)new Integer(0));
        fltrInfo.getFilterItems().add(fltrItemInfo);
        fltrInfo.setMaskString("#0");
        viewInfo.setFilter(fltrInfo);
        this.bizPromptItem.setEntityViewInfo(viewInfo);
        this.bizDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.bizDataElement.setDisplayFormat("$number$ - $name$");
        this.bizDataElement.setEditFormat("$number$");
        this.bizDataElement.setCommitFormat("$number$");
        this.bizDataElement.setEditable(true);
        EntityViewInfo curView = this.bizDataElement.getEntityViewInfo();
        if (curView == null) {
            curView = new EntityViewInfo();
        }
        if (curView.getFilter() == null) {
            curView.setFilter(new FilterInfo());
        }
        CslMaterialInfo info = new CslMaterialInfo();
        info.setIsAllVisible(false);
        info.setIsSubVisible(false);
        info.setIsUpVisible(false);
        CslGradeManageUtil.filterDataElementGradeManage((EntityViewInfo)curView, null);
        this.bizDataElement.setEntityViewInfo(curView);
    }

    private void loadCurrency() {
        CurrencyCollection currencyCollection = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            currencyCollection = iCurrency.getCurrencyCollection(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.cbxCurrency.setEditable(false);
        this.cbxCurrency.removeAllItems();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                if (this.editData.getCurrency() == null || !this.editData.getCurrency().getId().toString().equals(currencyCollection.get(i).getId().toString())) continue;
                this.cbxCurrency.setSelectedIndex(i);
            }
        }
    }

    private String getFormula(RPTItemInfo rptItem, String name) {
        String itemNumber = rptItem.getNumber();
        String valueType = null;
        valueType = (ValueTypeEnum)((Object)this.cbDataType.getSelectedItem()) == ValueTypeEnum.MONEY ? "MONEY" : "QUANTITY";
        StringBuffer formulas = new StringBuffer("");
        if (this.rbnStandardValue.isSelected()) {
            formulas.append("Item(").append('\"').append(itemNumber);
            formulas.append('\"').append(",").append(0).append(",").append(0);
            formulas.append(",").append('\"').append(name).append('\"');
            formulas.append(",").append('\"').append(valueType).append('\"').append(")");
            formulas.append("-");
            formulas.append("Item(").append('\"').append(itemNumber);
            formulas.append('\"').append(",").append(0).append(",").append(-1);
            formulas.append(",").append('\"').append(name).append('\"');
            formulas.append(",").append('\"').append(valueType).append('\"').append(")");
            return formulas.toString();
        }
        if (this.rbnStandardPercent.isSelected()) {
            formulas.append("(Item(").append('\"').append(itemNumber);
            formulas.append('\"').append(",").append(0).append(",").append(0);
            formulas.append(",").append('\"').append(name).append('\"');
            formulas.append(",").append('\"').append(valueType).append('\"').append(")");
            formulas.append("-");
            formulas.append("Item(").append('\"').append(itemNumber);
            formulas.append('\"').append(",").append(0).append(",").append(-1);
            formulas.append(",").append('\"').append(name).append('\"');
            formulas.append(",").append('\"').append(valueType).append('\"').append("))");
            formulas.append("/");
            formulas.append("Item(").append('\"').append(itemNumber);
            formulas.append('\"').append(",").append(0).append(",").append(-1);
            formulas.append(",").append('\"').append(name).append('\"');
            formulas.append(",").append('\"').append(valueType).append('\"').append(")");
            return formulas.toString();
        }
        return formulas.toString();
    }

    private void checkSelected() {
        if (this.entries.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entries.orgTree.name"));
        sic.add(new SelectorItemInfo("entries.orgUnit.name"));
        sic.add(new SelectorItemInfo("entries.standardValue"));
        sic.add(new SelectorItemInfo("entries.company.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("diffIndexType"));
        sic.add(new SelectorItemInfo("defaultStandValue"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        return sic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List checkFormulaFormat(Expression stmt) throws CheckFormulaException {
        ArrayList<String> result = new ArrayList<String>();
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            String item = null;
            FunctionExpr expr = (FunctionExpr)stmt;
            List param = expr.parameters;
            if (funName.equalsIgnoreCase("AcctItem")) {
                item = ((StringExpr)param.get((int)4)).value;
                if (StringUtils.isEmpty((String)item)) {
                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                }
                if (!result.contains(item)) {
                    result.add(item);
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)5)).value))) {
                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                }
                if (result.contains(item)) return result;
                result.add(item);
                return result;
            } else if (funName.equalsIgnoreCase("DyItem")) {
                item = ((StringExpr)param.get((int)4)).value;
                if (StringUtils.isEmpty((String)item)) {
                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                }
                if (result.contains(item)) return result;
                result.add(item);
                return result;
            } else {
                if (!funName.equalsIgnoreCase("Item") && !funName.equalsIgnoreCase("DItem")) throw new CheckFormulaException(CheckFormulaException.CONTAINVALIDFORMULA);
                item = ((StringExpr)param.get((int)0)).value;
                if (StringUtils.isEmpty((String)item)) {
                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                }
                if (!result.contains(item)) {
                    result.add(item);
                }
                for (int i = 0; i < param.size(); ++i) {
                    Object obj = param.get(i);
                    if (!(obj instanceof FunctionExpr)) continue;
                    throw new CheckFormulaException(CheckFormulaException.ITEMNOTCONTAINFORMULA);
                }
            }
            return result;
        } else if (stmt instanceof BinaryOperationExpr) {
            String item;
            int i;
            Expression expr = ((BinaryOperationExpr)stmt).left;
            List list = this.checkFormulaFormat(expr);
            for (i = 0; i < list.size(); ++i) {
                item = (String)list.get(i);
                if (result.contains(item)) continue;
                result.add(item);
            }
            expr = ((BinaryOperationExpr)stmt).right;
            list = this.checkFormulaFormat(expr);
            for (i = 0; i < list.size(); ++i) {
                item = (String)list.get(i);
                if (result.contains(item)) continue;
                result.add(item);
            }
            return result;
        } else {
            if (!(stmt instanceof UnaryOperationExpr)) return result;
            Expression expr = ((UnaryOperationExpr)stmt).operand;
            List list = this.checkFormulaFormat(expr);
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (result.contains(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    private void checkFormulaFormat(String formulaString) throws CheckFormulaException, BOSException {
        Expression stmt;
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.FORMULA_FORMAT_ERROR, e);
        }
        List items = this.checkFormulaFormat(stmt);
        this.checkFormulaItemExists(items);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFormulaItemExists(List list) throws BOSException, CheckFormulaException {
        StringBuffer oql = new StringBuffer();
        int length = list.size();
        int count = 0;
        oql.append("select id where number in (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            oql.append("'");
            oql.append(iter.next().toString());
            oql.append("'");
            if (++count != length) {
                oql.append(",");
            }
            if (count != length) continue;
            oql.append(")");
        }
        if (list == null) throw new CheckFormulaException(CheckFormulaException.RPTITEMNOTEXISTS);
        if (list.isEmpty()) throw new CheckFormulaException(CheckFormulaException.RPTITEMNOTEXISTS);
        RPTItemCollection col = RPTItemFactory.getRemoteInstance().getRPTItemCollection(oql.toString());
        int size = col.size();
        if (size == list.size()) return;
        throw new CheckFormulaException(CheckFormulaException.RPTITEMNOTEXISTS);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int end;
        int start;
        String str;
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Number_Blank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Name_Blank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if ("EDIT".equals(this.oprtState)) {
            boolean isExist;
            String id = this.editData.getId().toString();
            RPTItemDiffIndexInfo oldInfo = RPTItemDiffIndexFactory.getRemoteInstance().getRPTItemDiffIndexInfo((IObjectPK)new ObjectUuidPK(id));
            String oldNumber = oldInfo.getNumber();
            String oldName = oldInfo.getName();
            String newNumber = this.editData.getNumber();
            String newName = this.editData.getName();
            if (!(oldNumber.equals(newNumber) && oldName.equals(newName) || !(isExist = FormulaDispenseFactory.getRemoteInstance().exists("select id where diffIndex = '" + id + "'")))) {
                throw new CheckFormulaException(CheckFormulaException.ITEMCHECKFORMULA_DISPENSED);
            }
        }
        if (this.editData.getMaintainCU() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"629_RPTItemCheckFormulaEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getCurrency() == null) {
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Currency_Blank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.cbxCurrency.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getRange() == null) {
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RangeValueBlank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.txtRange.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getFormula() == null || this.editData.getFormula().trim().equals("")) {
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Formula_Blank");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.formula.requestFocus();
            SysUtil.abort();
        }
        if ((start = this.editData.getStartYear() * 100 + this.editData.getStartPeriod()) > (end = this.editData.getEndYear() * 100 + this.editData.getEndPeriod())) {
            String str2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"StartPeriod_BigThan_EndPeriod");
            MsgBox.showWarning((Component)((Object)this), (String)str2);
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)this.editData.getFormula())) {
            this.checkFormulaFormat(this.editData.getFormula());
        }
    }

    private void initCheckFormulaRela() {
        this.comboOperateSymbol.removeAllItems();
        this.comboOperateSymbol.addItem((Object)OperateSymbolEnum.EQUAL);
        this.comboOperateSymbol.addItem((Object)OperateSymbolEnum.MORE);
        this.comboOperateSymbol.addItem((Object)OperateSymbolEnum.LESS);
        this.comboOperateSymbol.addItem((Object)OperateSymbolEnum.MOREANDEQUAL);
        this.comboOperateSymbol.addItem((Object)OperateSymbolEnum.LESSANDEQUAL);
        this.comboOperateSymbol.addItem((Object)OperateSymbolEnum.UNEQUAL);
        OperateSymbolEnum op = this.editData.getOperateSymbol();
        for (int i = 0; i < this.comboOperateSymbol.getItemCount() && op != null; ++i) {
            if (!op.equals(this.comboOperateSymbol.getItemAt(i))) continue;
            this.comboOperateSymbol.setSelectedIndex(i);
        }
    }

    public void pickerSetout(FormulaPickerUI picker) {
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk) {
            this.formula.setText(this.formula.getText() + formulaLine);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setId(null);
        this.editData.setNumber(null);
        this.txtNumber.setText(null);
    }

    @Override
    public void actionFormulaWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionFormulaWizard_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"textArea2", (Object)this.txtAdvance);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaWizardUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionValidityCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionValidityCheck_actionPerformed(e);
        CheckFormulaIfClauseUtil.checkIfClause(this.txtAdvance.getText());
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CheckFormula", (String)"CheckSuccesfull"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnFormulaWizard.setEnabled(true);
        this.btnValidityCheck.setEnabled(true);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("maintainCU") != null) {
            this.verify(e);
            RPTItemDiffIndexFactory.getRemoteInstance().updateMaintainCU(this.editData.getId().toString(), this.editData.getMaintainCU().getId().toString());
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            IObjectValue subMitValue = this.getValue((IObjectPK)pk);
            this.getUIContext().put("ID", pk.toString());
            this.getUIContext().put("InitDataObject", subMitValue);
            this.setSave(true);
            this.setSaved(true);
            this.afterSubmitEdit((IObjectPK)new ObjectStringPK(this.editData.getId().toString()));
            return;
        }
        CheckFormulaIfClauseUtil.checkIfClause(this.txtAdvance.getText());
        super.actionSubmit_actionPerformed(e);
        this.clearData();
    }

    private void clearData() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.bizPromptItem.setData(null);
            this.bizDataElement.setData(null);
            this.comboOperateSymbol.setSelectedIndex(0);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)this.getUIWindow();
            uiFrame.setResizable(false);
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }
}

