/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptItemRptTypeEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.DataElementListUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RptItemRptTypeEditUI
extends AbstractRptItemRptTypeEditUI {
    private static final Logger logger = Logger.getLogger(RptItemRptTypeEditUI.class);
    private DataElementInfo defaultElementInfo = null;

    public RptItemRptTypeEditUI() throws Exception {
        this.txtNumber.setRequired(true);
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        super.storeFields();
    }

    private void addCreatrOrg() {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("dataElement.*"));
        } else {
            sic.add(new SelectorItemInfo("dataElement.id"));
            sic.add(new SelectorItemInfo("dataElement.number"));
            sic.add(new SelectorItemInfo("dataElement.name"));
        }
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        String str = this.getUITitle();
        if (str.indexOf("-") >= 0) {
            this.setUITitle(str.substring(0, str.indexOf(" ")));
        }
        this.onLoad();
        this.btnEdit.setEnabled(false);
        this.btnSubmit.setEnabled(true);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (!"ADDNEW".equals(this.getOprtState())) {
            this.btnSubmit.setEnabled(false);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    protected IObjectValue createNewData() {
        ReportClassInfo info = new ReportClassInfo();
        try {
            if (this.defaultElementInfo == null) {
                this.defaultElementInfo = DataElementFactory.getRemoteInstance().getDataElementInfo("select * where number='ENDBALANCE'");
            }
            info.setDataElement(this.defaultElementInfo);
        }
        catch (Exception e) {
            logger.error((Object)"getDataElementInfo_Exception", (Throwable)e);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReportClassFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equals("")) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NumberNull")));
        }
        if (this.editData.getName() == null || this.editData.getName().trim().equals("")) {
            this.mltName.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NameNull")));
        }
        if (this.promDataelement.getData() == null || this.promDataelement.getData().toString().equals("")) {
            throw new AdjustException(AdjustException.DATAELEMENT_ISNOT_NULL);
        }
        if (this.editData.getNumber().trim().startsWith("=")) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.contNumber.getBoundLabelText() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart")));
            this.abort();
        }
        if (this.editData.getName().trim().startsWith("=")) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.contName.getBoundLabelText() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart")));
            this.abort();
        }
        if (this.editData.getDescription() != null && this.editData.getDescription().trim().startsWith("=")) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.lblDescription.getText() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart")));
            this.abort();
        }
        this.checkNumberDup(this.editData);
    }

    protected boolean checkNumberDup(ReportClassInfo info) throws BOSException, SundryException {
        EntityViewInfo view = this.buildIsNumExistView(info);
        ReportClassCollection reportClassCollection = ReportClassFactory.getRemoteInstance().getReportClassCollection(view);
        if (reportClassCollection.size() > 0) {
            ReportClassInfo infoInDB = reportClassCollection.get(0);
            SundryException sundryException = new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
            MsgBox.showInfo((String)sundryException.getMessage());
            this.abort();
        }
        return true;
    }

    private EntityViewInfo buildIsNumExistView(ReportClassInfo dataBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    public void onLoad() throws Exception {
        this.txtNumber.requestFocus();
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.menuBiz.setVisible(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            this.actionFirst.setVisible(false);
            this.actionPre.setVisible(false);
            this.actionNext.setVisible(false);
            this.actionLast.setVisible(false);
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
            DataElementInfo info = DataElementProvider.getDataElementInfo("ENDBALANCE");
            this.promDataelement.setValue((Object)info);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionAddNew.setEnabled(true);
            this.actionAddNew.setVisible(true);
            this.actionSubmit.setEnabled(false);
            this.actionSubmit.setVisible(true);
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.btnEdit.setEnabled(false);
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
        if (this.promDataelement.getEntityViewInfo() != null) {
            EntityViewInfo view = this.promDataelement.getEntityViewInfo();
            FilterInfo filter = view.getFilter();
            filter.getFilterItems().add(new FilterItemInfo("isUsedElim", (Object)new Integer("1")));
            String mask = filter.getMaskString();
            mask = mask + " and #1";
            filter.setMaskString(mask);
        } else {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("isUsedElim", (Object)new Integer("1"));
            fi.getFilterItems().add(filterItem);
            fi.setMaskString(" (#0) ");
            ev.setFilter(fi);
            this.promDataelement.setEntityViewInfo(ev);
        }
        EntityViewInfo filterView = this.promDataelement.getEntityViewInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterView.getFilter(), (String)"trackRecordCreator.id", (String)DataElementListUI.class.getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.onLoad();
        if ("EDIT".equals(this.getOprtState())) {
            this.btnEdit.setEnabled(false);
        }
    }

    public boolean isModify() {
        if (this.oprtState.equals(OprtState.ADDNEW) && this.txtNumber.getText().equals("") && this.mltName.getUserObject() == null) {
            return false;
        }
        return super.isModify();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    private void refreshTheTitle() throws Exception {
        String str = this.getUITitle();
        if (str.indexOf("-") >= 0) {
            this.setUITitle(str.substring(0, str.indexOf(" ")));
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }
}

