/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptReceiveLostRepairUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class RptReceiveLostRepairUI
extends AbstractRptReceiveLostRepairUI {
    private static final long serialVersionUID = -1905909006427438503L;
    private static final Logger logger = CoreUIObject.getLogger(RptReceiveLostRepairUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCbxOrgTree();
    }

    private void initCbxOrgTree() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UnionVersionStatusEnum.START));
        filter.getFilterItems().add(new FilterItemInfo("Type", (Object)8));
        filter.getFilterItems().add(new FilterItemInfo("IsForBudget", (Object)0));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterItemInfo);
        view.setFilter(filter);
        IOrgTree itree = OrgTreeFactory.getRemoteInstance();
        OrgTreeCollection colls = itree.getOrgTreeCollection(view);
        DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
        int n = colls.size();
        for (int i = 0; i < n; ++i) {
            OrgTreeInfo orgTreeInfo = colls.get(i);
            model.addElement(orgTreeInfo);
        }
        if (!colls.isEmpty()) {
            this.cbxOrgTree.setModel(model);
            this.cbxOrgTree.setSelectedIndex(0);
        }
    }

    @Override
    protected void kdOK_actionPerformed(ActionEvent e) throws Exception {
        super.kdOK_actionPerformed(e);
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cbxOrgTree.getSelectedItem();
        if (orgTreeInfo == null) {
            return;
        }
        ICslReport iCslReport = CslReportFactory.getRemoteInstance();
        long successNum = iCslReport.rptReceiveLostRepair(orgTreeInfo.getNumber());
        Locale locale = SysContext.getSysContext().getLocale();
        if (successNum > 0L) {
            CoreUI parentUI = (CoreUI)this.getUIContext().get("Owner");
            parentUI.setMessageText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"836_SUCCESS_TO_REPAIR"), orgTreeInfo.getName(locale), new Integer(successNum + "")));
            parentUI.showMessage();
            this.disposeUIWindow();
            return;
        }
        MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"835_NO_LOST_RECORD_TO_REPAIR"), orgTreeInfo.getName(locale)));
    }

    @Override
    protected void kdCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kdCancel_actionPerformed(e);
        this.disposeUIWindow();
    }
}

