/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ISJSTableFacade;
import com.kingdee.eas.fi.gr.cslrpt.SJSParamterHelper;
import com.kingdee.eas.fi.gr.cslrpt.SJSPeriodEnum;
import com.kingdee.eas.fi.gr.cslrpt.SJSReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.SJSTableFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSJSMessageOutUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SJSPublishSettingUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class SJSMessageOutUI
extends AbstractSJSMessageOutUI {
    private static final long serialVersionUID = -8621025950338943869L;
    private Map unionUnitsCache = new HashMap();
    private Map allUnionTreesCache = new HashMap();
    Point point = new Point(3, 0);

    public void onLoad() throws Exception {
        this.initTable();
        super.onLoad();
        this.initComponent();
        this.prmtOrgUnit.setEditable(false);
    }

    private void initComponent() throws EASBizException, BOSException {
        this.combCycle.setSelectedIndex(2);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectNone.setEnabled(true);
        this.combYear.setValue((Object)new Integer(Calendar.getInstance().get(1)));
        this.combPeriod.setSelectedItem((Object)SJSPeriodEnum.getEnum(this.getSeason()));
        this.combPeriod.setRenderer((ListCellRenderer)new MyCellRenderer());
    }

    private void initOrgUnit() {
        OrgTreeInfo orgTreeInfo = null;
        if (this.combOrgBound.getSelectedItem() != null) {
            UnionF7Helper.UnionF7 f7;
            this.prmtOrgUnit.setValue(null);
            boolean notOld = true;
            orgTreeInfo = (OrgTreeInfo)this.combOrgBound.getSelectedItem();
            UnionF7Helper.UnionF7 oldf7 = (UnionF7Helper.UnionF7)this.prmtOrgUnit.getSelector();
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7 = UnionF7Helper.getUnionF7((IUIObject)this, (int)2);
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
                notOld = false;
            }
            if (notOld) {
                String unitsSql = "";
                try {
                    unitsSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)CslRptUtil.getPK((IObjectValue)orgTreeInfo));
                    f7.filterUnitSql(unitsSql);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
            this.prmtOrgUnit.setEnabled(true);
        } else {
            this.prmtOrgUnit.setValue(null);
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    private void initOrgBound() throws EASBizException, BOSException {
        int month;
        Calendar calendar = Calendar.getInstance();
        int year = Integer.parseInt(this.combYear.getValue().toString());
        SJSPeriodEnum period = (SJSPeriodEnum)((Object)this.combPeriod.getSelectedItem());
        if (period != null) {
            month = Integer.parseInt(period.getValue());
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            month = (cal.get(2) / 3 + 1) * 3;
        }
        calendar.set(year, month, 1);
        calendar.add(5, -1);
        Date dpDate = new Date(calendar.getTimeInMillis());
        OrgTreeCollection otc = this.getAllUnionTrees(dpDate);
        if (otc == null) {
            return;
        }
        ActionListener[] actionListeners = this.combOrgBound.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            this.combOrgBound.removeActionListener(actionListeners[i]);
        }
        OrgTreeInfo select = (OrgTreeInfo)this.combOrgBound.getModel().getSelectedItem();
        this.combOrgBound.removeAllItems();
        this.combOrgBound.addItems(otc.toArray());
        for (int i = 0; i < actionListeners.length; ++i) {
            this.combOrgBound.addActionListener(actionListeners[i]);
        }
        if (select != null) {
            for (OrgTreeInfo element : otc) {
                if (!select.getNumber().equals(element.getNumber())) continue;
                this.combOrgBound.getModel().setSelectedItem(element);
                break;
            }
        }
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        KDCheckBox box = new KDCheckBox();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)box);
        this.tblMain.getColumn("selector").setEditor((ICellEditor)editor);
        this.tblMain.getColumn("selector").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tblMain.getColumn("selector").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    @Override
    protected void tblMain_tableDataRequest(KDTDataRequestEvent e) throws Exception {
        Map params = this.getSJSContent();
        if (params != null) {
            ISJSTableFacade sjsFacade = SJSTableFacadeFactory.getRemoteInstance();
            List list = sjsFacade.findTable(params);
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                IRow row = this.tblMain.addRow();
                if (row.getCell("id") == null) continue;
                row.getCell("id").setValue(map.get("fid"));
                row.getCell("selector").setValue((Object)Boolean.FALSE);
                row.getCell("reportName").setValue(map.get("repName"));
                row.getCell("currency").setValue(map.get("currName"));
                row.getCell("reportType").setValue(map.get("type"));
            }
        }
    }

    private void query() {
        this.tblMain.removeRows();
    }

    private Map getSJSContent() {
        if (this.combOrgBound.getSelectedItem() == null || this.prmtOrgUnit.getValue() == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("combOrgBound", ((OrgTreeInfo)this.combOrgBound.getSelectedItem()).getId().toString());
        params.put("prmtOrgUnit", OrgClientUtils.getPromptValue((KDBizPromptBox)this.prmtOrgUnit).getId().toString());
        params.put("combYear", this.combYear.getValue().toString());
        SJSPeriodEnum period = (SJSPeriodEnum)((Object)this.combPeriod.getSelectedItem());
        params.put("combPeriod", period.getValue());
        return params;
    }

    @Override
    protected void combOrgBound_actionPerformed(ActionEvent e) throws Exception {
        this.initOrgUnit();
    }

    @Override
    protected void combYear_stateChanged(ChangeEvent e) throws Exception {
        super.combYear_stateChanged(e);
        this.initOrgBound();
        this.initOrgUnit();
    }

    @Override
    protected void combPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.combPeriod_actionPerformed(e);
        this.initOrgBound();
        this.initOrgUnit();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != e.getOldValue()) {
            this.query();
        }
    }

    @Override
    protected void prmtOrgUnit_willCommit(CommitEvent e) throws Exception {
        super.prmtOrgUnit_willCommit(e);
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        this.initOrgUnit();
    }

    private HashMap getUnionUnits(OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        String key = SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "||" + orgTreeInfo.getId().toString();
        HashMap map = (HashMap)this.unionUnitsCache.get(key);
        if (map == null) {
            map = (HashMap)PermissionFactory.getRemoteInstance().getUnionUnits(CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), CslRptUtil.getPK((IObjectValue)orgTreeInfo));
            this.unionUnitsCache.put(key, map);
        }
        return map;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("selector").getValue().equals(Boolean.FALSE)) continue;
            row.getCell("selector").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNone_actionPerformed(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("selector").getValue().equals(Boolean.TRUE)) continue;
            row.getCell("selector").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.tblMain.getRowCount() > 0) {
            boolean flag = false;
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (!this.tblMain.getRow(i).getCell("selector").getValue().equals(Boolean.TRUE)) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.getTableCount();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"658_SJSMessageOutUI"));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"659_SJSMessageOutUI"));
        }
    }

    private void getTableCount() throws Exception {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        boolean typeFlag = true;
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        Element rootElement = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean flag = (Boolean)row.getCell("selector").getValue();
            if (!flag.booleanValue()) continue;
            CslReportInfo info = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()));
            Book book = info.getBook();
            Sheet sheet = book.getActiveSheet();
            Range rptRange = sheet.getRange(this.point.x, this.point.y);
            Map map = SJSParamterHelper.getMapFromString(rptRange.getUserObject("rpt").toString());
            if (doc == null) {
                StringReader read = new StringReader(map.get("xml").toString());
                InputSource source = new InputSource(read);
                doc = builder.build(source);
            }
            rootElement = doc.getRootElement();
            String type = this.getTableType(sheet);
            List eleList = null;
            if (type == null) continue;
            if (typeMap.get(type) != null) {
                typeFlag = false;
                break;
            }
            typeMap.put(type, type);
            String[] typeArray = type.split(":");
            Element e = rootElement.getChild(typeArray[0]);
            eleList = e.getChildren();
            if (typeArray.length == 2 && typeArray[1] != null) {
                this.makeXML(sheet, map, eleList, typeArray[1]);
                continue;
            }
            this.makeXML(sheet, map, eleList);
        }
        if (typeFlag) {
            Map map = this.getPathLoad();
            this.updateXML(rootElement, map);
            XMLOutputter outp = new XMLOutputter();
            File file = new File(map.get("path").toString());
            FileOutputStream fileOutputStream = null;
            if (file.exists()) {
                int exist = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"660_SJSMessageOutUI"));
                if (exist == 0) {
                    fileOutputStream = new FileOutputStream(map.get("path").toString());
                    outp.output(doc, (OutputStream)fileOutputStream);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"661_SJSMessageOutUI"));
                }
            } else {
                fileOutputStream = new FileOutputStream(map.get("path").toString());
                outp.output(doc, (OutputStream)fileOutputStream);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"661_SJSMessageOutUI"));
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"662_SJSMessageOutUI"));
        }
    }

    private void makeXML(Sheet sheet, Map map, List eleList, String type) {
        List rowList = (List)map.get("rowList");
        List colList = (List)map.get("colList");
        int num = Integer.parseInt(map.get("num").toString());
        block0: for (int i = 0; i < rowList.size(); ++i) {
            SJSReportInfo report = (SJSReportInfo)rowList.get(i);
            for (int j = 0; j < eleList.size(); ++j) {
                Element ele = (Element)eleList.get(j);
                if (!ele.getAttribute("kmdm").getValue().equals(report.getKmdm()) || !ele.getAttributeValue("lb").equals(type)) continue;
                for (int k = 0; k < colList.size(); ++k) {
                    Range range = sheet.getRange(this.point.x + i + num, this.point.y + 1 + k);
                    if (range.getText() == null || range.getText().equals("")) continue;
                    ele.setAttribute(new Attribute(colList.get(k).toString(), range.getText()));
                }
                continue block0;
            }
        }
    }

    private void makeXML(Sheet sheet, Map map, List eleList) {
        List rowList = (List)map.get("rowList");
        List colList = (List)map.get("colList");
        int num = Integer.parseInt(map.get("num").toString());
        block0: for (int i = 0; i < rowList.size(); ++i) {
            SJSReportInfo report = (SJSReportInfo)rowList.get(i);
            for (int j = 0; j < eleList.size(); ++j) {
                Element ele = (Element)eleList.get(j);
                if (!ele.getAttribute("kmdm").getValue().equals(report.getKmdm())) continue;
                for (int k = 0; k < colList.size(); ++k) {
                    Range range = sheet.getRange(this.point.x + i + num, this.point.y + 1 + k);
                    if (range.getText() == null || range.getText().equals("")) continue;
                    ele.setAttribute(new Attribute(colList.get(k).toString(), range.getText()));
                }
                continue block0;
            }
        }
    }

    private void updateXML(Element e, Map map) {
        List oneList = e.getChildren();
        for (int i = 0; i < oneList.size(); ++i) {
            Element oneElement = (Element)oneList.get(i);
            List twoList = oneElement.getChildren();
            for (int j = 0; j < twoList.size(); ++j) {
                Element twoElement = (Element)twoList.get(j);
                twoElement.getAttribute("gsdm").setValue(map.get("kDTextFieldNum").toString());
            }
        }
    }

    private Map getPathLoad() throws BOSException, EASBizException {
        Map map = UserOptionFactory.getRemoteInstance().getUserOptionMap(SJSPublishSettingUI.class.getName());
        map.put("kDTextFieldNum", "s" + map.get("kDTextFieldNum").toString());
        SJSPeriodEnum period = (SJSPeriodEnum)((Object)this.combPeriod.getSelectedItem());
        String reportPeriod = null;
        if (period.getValue().equals("3")) {
            reportPeriod = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"663_SJSMessageOutUI");
        } else if (period.getValue().equals("6")) {
            reportPeriod = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"664_SJSMessageOutUI");
        } else if (period.getValue().equals("9")) {
            reportPeriod = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"665_SJSMessageOutUI");
        } else if (period.getValue().equals("12")) {
            reportPeriod = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"666_SJSMessageOutUI");
        }
        File file = new File(map.get("hidtxt").toString());
        if (!file.exists()) {
            int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"667_SJSMessageOutUI"));
            if (i == 0) {
                file.mkdirs();
            } else {
                SysUtil.abort();
            }
        }
        String path = map.get("hidtxt").toString() + File.separator + map.get("kDTextFieldNum").toString() + this.combYear.getValue().toString() + reportPeriod + ".xml";
        map.put("path", path);
        map.put("reportPeriod", reportPeriod);
        return map;
    }

    private String getTableType(Sheet sheet) throws Exception {
        Range range = sheet.getRange(this.point.x - 3, this.point.y, this.point.x - 3, this.point.y + 3);
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"668_SJSMessageOutUI").equals(range.getFormula()) || EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"669_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_zcfz:0";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"670_SJSMessageOutUI").equals(range.getFormula()) || EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"671_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_lr:0";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"672_SJSMessageOutUI").equals(range.getFormula()) || EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"673_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_xjll:0";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"674_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_syzqybd:";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"675_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_xjll:1";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"676_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_syzqybd:0";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"677_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_syzqybd:1";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"678_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_lr:1";
        }
        if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"679_SJSMessageOutUI").equals(range.getFormula())) {
            return "s_zcfz:1";
        }
        return null;
    }

    private String getSeason() {
        GregorianCalendar cal = new GregorianCalendar();
        Date date = new Date(System.currentTimeMillis());
        cal.setTime(date);
        int iMonth = cal.get(2);
        int month = iMonth / 3 * 3;
        if (month == 0) {
            month = 12;
        }
        return month + "";
    }

    public static void showDialogWindows(IUIObject ui) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SJSMessageOutUI.class.getName(), (Map)uiContext, null, "EDIT");
        uiWindow.show();
    }

    private OrgTreeCollection getAllUnionTrees(Date date) throws EASBizException, BOSException {
        OrgTreeCollection otc = (OrgTreeCollection)this.allUnionTreesCache.get(date);
        if (otc == null) {
            otc = CslRptUIUtil.getOrgTreeCollection(date);
            this.allUnionTreesCache.put(date, otc);
        }
        return otc;
    }

    class MyCellRenderer
    extends KDLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? new Color(37, 94, 162) : Color.white);
            this.setHorizontalAlignment(4);
            this.setText(value.toString());
            return this;
        }
    }
}

