/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.ORGF7TreeNodeCheckBoxChangeListener;
import com.kingdee.eas.basedata.org.client.OrgF7SelectException;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSelectedTreeOrgF7UI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class SelectedTreeOrgF7UI
extends AbstractSelectedTreeOrgF7UI {
    public static final int ONLY_UNIT = 1;
    public static final int ONLY_GROUP = 2;
    public static final int UNIT_AND_GROUP = 3;
    protected int selectMode = 1;
    private boolean isCancel = true;
    private ArrayList returnValue = null;
    private boolean isMultiSelected;
    private OrgTreeCollection orgTrees;
    private OrgTreeInfo selectedTree;
    protected boolean isSynCheck = false;
    private boolean cascadingSelectioin = false;
    private ORGF7TreeNodeCheckBoxChangeListener nodeChkChgListener = null;

    public SelectedTreeOrgF7UI() throws Exception {
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(2);
        this.tOrgTree.setSelectionModel((TreeSelectionModel)sm);
        this.tOrgTree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(SelectedTreeOrgF7UI.this.tOrgTree.getModel().getRoot())) {
                    SelectedTreeOrgF7UI.this.tOrgTree.expandPath(new TreePath(SelectedTreeOrgF7UI.this.tOrgTree.getModel().getRoot()));
                }
            }
        });
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAllSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllClr.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    public boolean isMultiSelected() {
        return this.isMultiSelected;
    }

    public void setMultiSelected(boolean isMultiSelected) {
        this.isMultiSelected = isMultiSelected;
    }

    public void setOrgTrees(OrgTreeCollection orgTrees) {
        this.orgTrees = orgTrees;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tOrgTree.setModel((TreeModel)new DefaultTreeModel(null));
        this.tOrgTree.setShowCheckBox(false);
    }

    private void doTreeNodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean selected = node.isChecked();
        this.selectAllChildrenOfTheSelectedNode(node, selected);
        this.tOrgTree.repaint();
    }

    private void selectAllChildrenOfTheSelectedNode(DefaultKingdeeTreeNode node, boolean selected) {
        DefaultKingdeeTreeNode subNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (this.canTheNodeBeSelected(subNode)) {
                subNode.setChecked(selected);
            }
            this.selectAllChildrenOfTheSelectedNode(subNode, selected);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public void onShow() throws Exception {
        if (this.isMultiSelected()) {
            this.tOrgTree.setShowCheckBox(true);
            this.btnAllSel.setVisible(true);
            this.btnAllClr.setVisible(true);
            if (this.isCascadingSelection()) {
                this.tOrgTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                    public void nodeStateChange(TreeNodeStateChangeEvent event) {
                        SelectedTreeOrgF7UI.this.doTreeNodeStateChange(event);
                    }
                });
            } else if (this.getORGF7TreeNodeCheckBoxChangeListener() != null) {
                this.tOrgTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                    public void nodeStateChange(TreeNodeStateChangeEvent event) {
                        SelectedTreeOrgF7UI.this.getORGF7TreeNodeCheckBoxChangeListener().onTreeNodeCheckBoxChange(SelectedTreeOrgF7UI.this.tOrgTree, (DefaultKingdeeTreeNode)event.getNode());
                    }
                });
            } else {
                this.tOrgTree.setSyncChecked(this.isSynCheck());
            }
        }
        this.fillOrgTreeComboBox();
        this.cbOrgTree.setSelectedItem(null);
        if (this.cbOrgTree.getItemCount() > 0) {
            this.cbOrgTree.setSelectedIndex(0);
        }
        super.onShow();
    }

    public void doLayout() {
        super.doLayout();
        this.tOrgTree.requestFocusInWindow();
        if (this.tOrgTree.getModel() != null && this.tOrgTree.getModel().getRoot() != null) {
            this.tOrgTree.setSelectionNode((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot());
        }
    }

    @Override
    protected void cbOrgTree_itemStateChanged(ItemEvent e) throws Exception {
        super.cbOrgTree_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        if (this.cbOrgTree.getSelectedItem() == null || this.cbOrgTree.getSelectedItem().equals("")) {
            return;
        }
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cbOrgTree.getSelectedItem();
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setTreeID(orgTreeInfo.getId().toString());
        f7.setMultiSelect(false);
        TreeModel model = f7.buildTreeModel(OrgViewType.UNIONDEBT, orgTreeInfo, null);
        this.tOrgTree.setModel(model);
        UnionF7Helper.addTreeWillExpandListener((KDTree)this.tOrgTree, (OrgTreeInfo)orgTreeInfo, (UnionF7Helper.UnionF7)f7);
        if (model.getRoot() == null || ((DefaultKingdeeTreeNode)model.getRoot()).getUserObject() == null) {
            this.tOrgTree.setRootVisible(false);
        } else {
            this.tOrgTree.setRootVisible(true);
        }
        this.tOrgTree.setShowsRootHandles(true);
    }

    private void fillOrgTreeComboBox() throws Exception {
        this.cbOrgTree.removeAllItems();
        for (int i = 0; i < this.orgTrees.size(); ++i) {
            this.cbOrgTree.addItem((Object)this.orgTrees.get(i));
        }
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.getUserObject() instanceof OrgStructureInfo && root.isChecked()) {
            this.checkSelect(root);
            list.add(((OrgStructureInfo)root.getUserObject()).getUnit());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public OrgTreeInfo getSelectedTree() {
        return this.selectedTree;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        this.selectedTree = (OrgTreeInfo)this.cbOrgTree.getSelectedItem();
        try {
            if (this.isMultiSelected()) {
                DefaultKingdeeTreeNode root;
                if (this.tOrgTree.getModel() != null && (root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot()) != null) {
                    this.traceNode(root, this.returnValue);
                }
            } else {
                TreePath path = this.tOrgTree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                        throw OrgF7SelectException.SelectValidOrg;
                    }
                    if (node.getUserObject() != null && node.getUserObject() instanceof OrgStructureInfo) {
                        this.checkSelect(node);
                        this.returnValue.add(((OrgStructureInfo)node.getUserObject()).getUnit());
                    }
                }
            }
            if (this.returnValue.size() == 0) {
                throw OrgF7SelectException.SelectOne;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (OrgF7SelectException f7e) {
            MsgBox.showInfo((Component)((Object)this), (String)f7e.getMsg());
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.cbOrgTree.setSelectedItem(null);
        if (this.cbOrgTree.getItemCount() > 0) {
            this.cbOrgTree.setSelectedIndex(0);
        }
        this.tOrgTree.requestFocusInWindow();
    }

    @Override
    protected void btnAllSel_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(true);
    }

    @Override
    protected void btnAllClr_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(false);
    }

    private void doAllSelAndAllClr(boolean selected) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot();
        if (this.tOrgTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.tOrgTree.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (!this.canTheNodeBeSelected(node)) continue;
            node.setChecked(selected);
        }
        this.tOrgTree.repaint();
    }

    @Override
    protected void tOrgTree_focusGained(FocusEvent e) throws Exception {
    }

    @Override
    protected void tOrgTree_mouseClicked(MouseEvent e) throws Exception {
        super.tOrgTree_mouseClicked(e);
        TreePath path = this.tOrgTree.getClosestPath(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (this.isMultiSelected()) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.btnOk_actionPerformed(null);
        }
    }

    public void setSynCheck(boolean isSynCheck) {
        this.cascadingSelectioin = false;
        this.nodeChkChgListener = null;
        this.isSynCheck = isSynCheck;
    }

    public boolean isSynCheck() {
        return this.isSynCheck;
    }

    public void setCascadingSelection(boolean cascadingSelection) {
        this.isSynCheck = false;
        this.nodeChkChgListener = null;
        this.cascadingSelectioin = cascadingSelection;
    }

    public boolean isCascadingSelection() {
        return this.cascadingSelectioin;
    }

    public void addORGF7TreeNodeCheckBoxChangeListener(ORGF7TreeNodeCheckBoxChangeListener listener) {
        this.isSynCheck = false;
        this.cascadingSelectioin = false;
        this.nodeChkChgListener = listener;
    }

    public ORGF7TreeNodeCheckBoxChangeListener getORGF7TreeNodeCheckBoxChangeListener() {
        return this.nodeChkChgListener;
    }

    public void removeORGF7TreeNodeCheckBoxChangeListener() {
        this.nodeChkChgListener = null;
    }

    protected void checkSelect(DefaultKingdeeTreeNode node) throws Exception {
        OrgStructureInfo unitNode = (OrgStructureInfo)node.getUserObject();
        switch (this.selectMode) {
            case 1: {
                if (unitNode.getUnit().isIsCompanyOrgUnit() || this.isSynCheck) break;
                throw OrgF7SelectException.OnlyUnit;
            }
            case 2: {
                if (unitNode.getUnit().isIsUnion()) break;
                throw OrgF7SelectException.OnlyGroup;
            }
        }
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(int i) {
        if (i != 1 && i != 2 && i != 3) {
            throw new IllegalArgumentException("Illegal selectMode:" + i);
        }
        this.selectMode = i;
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!SelectedTreeOrgF7UI.this.isSynCheck) {
                return;
            }
            if (e.getNewLeadSelectionPath() != null) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                OrgStructureInfo structInfo = (OrgStructureInfo)node.getUserObject();
                if (structInfo == null) {
                    return;
                }
                if (structInfo.getUnit().isIsUnion()) {
                    this.checkChildren(node);
                }
            }
        }

        private void checkChildren(DefaultKingdeeTreeNode node) {
            node.setChecked(true);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.checkChildren((DefaultKingdeeTreeNode)node.getChildAt(i));
            }
        }
    }
}

