/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryAsstData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.LazyShowName;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEntityInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ShowDynItemName {
    private DBHandler dao;
    private Map<String, AsstObjQueryUnit> queryUnits = new HashMap<String, AsstObjQueryUnit>(10);

    public ShowDynItemName(DBHandler dao) {
        this.dao = dao;
    }

    public LazyShowName register(ItemValue itemValue) {
        LazyShowName lazyShowName = new LazyShowName("");
        lazyShowName.getExtendedProps().put(ItemValue.class, itemValue);
        String assistNum = itemValue.getDynaItemType();
        String assistObjLongNumberOrId = itemValue.getDynaItem();
        if (StringUtil.isEmpty((String)assistNum)) {
            if (assistObjLongNumberOrId.matches("[0-9](\\.[0-9])*(\\.D){0,1}\\_[\\d\\D]+")) {
                String realDynaItem = assistObjLongNumberOrId.replaceAll("[0-9](\\.[0-9])*(\\.D){0,1}\\_", "");
                itemValue = (ItemValue)itemValue.clone();
                itemValue.setDynaItemName(realDynaItem);
            }
            ShowEntityInfo showEntityInfo = new ShowEntityInfo(this.dao);
            String name = showEntityInfo.exec(itemValue);
            return new LazyShowName(name);
        }
        CompanyOrgUnitInfo company = null;
        try {
            company = RptNewUIUtil.getDelegateCompanyNoOrgType((Context)this.dao.getContext(), (OrgUnitInfo)itemValue.getContext().getCompany());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        DynaParameters dynaParam = new DynaParameters();
        dynaParam.setDynaItemSource(1);
        dynaParam.setGrade(false);
        String key = AsstObjQueryUnit.key(assistNum, company);
        AsstObjQueryUnit queryUnit = null;
        if (!this.queryUnits.containsKey(key)) {
            queryUnit = new AsstObjQueryUnit(assistNum, company);
            this.queryUnits.put(key, queryUnit);
        } else {
            queryUnit = this.queryUnits.get(key);
        }
        queryUnit.put(assistObjLongNumberOrId, lazyShowName);
        if (assistObjLongNumberOrId.matches("[0-9](\\.[0-9])*(\\.D){0,1}\\_[\\d\\D]+")) {
            String realDynaItem = assistObjLongNumberOrId.replaceAll("[0-9](\\.[0-9])*(\\.D){0,1}\\_", "");
            queryUnit.put(realDynaItem, lazyShowName);
        }
        return lazyShowName;
    }

    public void exec() throws EASBizException, BOSException {
        if (this.queryUnits.isEmpty()) {
            return;
        }
        DynaParameters dynaParam = new DynaParameters();
        dynaParam.setDynaItemSource(1);
        dynaParam.setGrade(false);
        List<AsstActObject> asstObjs = null;
        boolean useId = false;
        boolean useLongNumber = false;
        Collection<LazyShowName> names = null;
        String asstObjKey = null;
        ShowEntityInfo showEntityInfo = new ShowEntityInfo(this.dao);
        for (AsstObjQueryUnit queryUnit : this.queryUnits.values()) {
            Object itemValue;
            asstObjs = new QueryAsstData(this.dao, (OrgUnitInfo)queryUnit.getCompany().castToFullOrgUnitInfo(), dynaParam).exec(queryUnit.getAssistNum(), new HashSet<String>(queryUnit.getAsstObjs()));
            boolean bl = useId = "INNER_COMPANY".equals(queryUnit.getAssistNum()) || "R_COMPANY".equals(queryUnit.getAssistNum());
            if (asstObjs.isEmpty()) {
                for (String string : queryUnit.getAsstObjs()) {
                    names = queryUnit.getLazyShowName(string);
                    if (names == null) continue;
                    for (LazyShowName name : names) {
                        itemValue = name.getExtendedProps().get(ItemValue.class);
                        if (!(itemValue instanceof ItemValue)) continue;
                        name.setName(showEntityInfo.exec(itemValue));
                    }
                }
                continue;
            }
            for (AsstActObject asstActObject : asstObjs) {
                useLongNumber = asstActObject.isMultiLevel();
                asstObjKey = useId ? asstActObject.getId() : (useLongNumber ? asstActObject.getLongNumber() : asstActObject.getNumber());
                names = queryUnit.getLazyShowName(asstObjKey);
                if (names == null) continue;
                for (LazyShowName name : names) {
                    itemValue = name.getExtendedProps().get(ItemValue.class);
                    if (!(itemValue instanceof ItemValue)) continue;
                    ((ItemValue)itemValue).setDynaItemName(asstActObject.getName());
                    name.setName(showEntityInfo.exec(itemValue));
                }
            }
            for (Collection collection : queryUnit.getLazyShowNames()) {
                for (LazyShowName showName : collection) {
                    if (!StringUtil.isEmpty((String)showName.getName()) || !((itemValue = showName.getExtendedProps().get(ItemValue.class)) instanceof ItemValue)) continue;
                    if (((ItemValue)itemValue).getDynaItemName() != null && ((ItemValue)itemValue).getDynaItemName().matches("[0-9](\\.[0-9])*(\\.D){0,1}\\_[\\d\\D]+")) {
                        ((ItemValue)itemValue).setDynaItemName(((ItemValue)itemValue).getDynaItemName().replaceAll("[0-9](\\.[0-9])*(\\.D){0,1}\\_", ""));
                    }
                    showName.setName(showEntityInfo.exec(itemValue));
                }
            }
        }
    }

    private static class AsstObjQueryUnit {
        String assistNum;
        CompanyOrgUnitInfo company;
        Map<String, Collection<LazyShowName>> asstObj2Name = new HashMap<String, Collection<LazyShowName>>(5);

        public AsstObjQueryUnit(String assistNum, CompanyOrgUnitInfo company) {
            this.assistNum = assistNum;
            this.company = company;
        }

        public String getAssistNum() {
            return this.assistNum;
        }

        public CompanyOrgUnitInfo getCompany() {
            return this.company;
        }

        public Collection<String> getAsstObjs() {
            return this.asstObj2Name.keySet();
        }

        public Collection<Collection<LazyShowName>> getLazyShowNames() {
            return this.asstObj2Name.values();
        }

        public Collection<LazyShowName> getLazyShowName(String asstObj) {
            return this.asstObj2Name.get(asstObj);
        }

        public void put(String asstObj, LazyShowName name) {
            if (!this.asstObj2Name.containsKey(asstObj)) {
                this.asstObj2Name.put(asstObj, new HashSet(1));
            }
            this.asstObj2Name.get(asstObj).add(name);
        }

        public static String key(String assistNum, CompanyOrgUnitInfo company) {
            return MessageFormat.format("{0}-{1}", assistNum, company.getId().toString());
        }
    }
}

