/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class ShowElimInvestRateCalcShape
extends JPanel {
    private static final long serialVersionUID = 249338804775028392L;
    private static final String PLUS = "+";
    private static final String MULTIPLY = "*";
    private static final String PERCENT = "%";
    private static final String EQUALSPLIT = "\\=";
    private static final String PLUSSPLIT = "\\+";
    private static final String MULTIPLYSPLIT = "\\*";
    private static final int ROOTSPACE = 5;
    private static final int SPACE = 15;
    private static final int YAXISLENGTH = 40;
    private static final int PERCENTXSPACE = 5;
    private static final int PERCENTYSPACE = 25;
    private static final int MARGIN = 75;
    private static final int INCREASEWIDTH = 136;
    private static final float SINGLECHINESESIZE = 12.25f;
    private static final float SINGLEENGLISHSIZE = 6.25f;
    private static final float SINGLENUMBERSIZE = 6.0f;
    private float CHARACTERSIZE = 0.0f;
    private String resultRate;
    public int width;
    public int height;
    Map<String, List<String>> branchs = null;
    List<Map<String, List<String>>> orderedBranchs = null;

    public ShowElimInvestRateCalcShape(String calcLog, int width, int height, boolean isNumber) {
        String calcLogString = calcLog.trim().replaceAll("\\s*|\n", "");
        this.splitCalcLog(calcLogString);
        this.width = width;
        if (this.branchs != null && this.branchs.size() > 4) {
            this.width = width + (this.branchs.size() - 4) * 136;
        }
        this.height = height;
        this.CHARACTERSIZE = isNumber ? 6.25f : 12.25f;
    }

    @Override
    public void paint(Graphics gp) {
        super.paint(gp);
        Graphics2D gp2d = (Graphics2D)gp;
        gp2d.setColor(Color.GRAY);
        this.paintElimInvestRateCalcShape(gp2d);
    }

    private void paintElimInvestRateCalcShape(Graphics2D gp2d) {
        if (this.branchs != null && !this.branchs.isEmpty()) {
            int[] rootXY = this.paintRootNode(gp2d);
            int branchSize = this.branchs.size();
            if (branchSize > 1) {
                this.paintMultiBranch(gp2d, rootXY, branchSize);
            } else {
                List<String> nodes = this.branchs.get("branch0");
                this.paintSingleBranch(gp2d, nodes, rootXY);
            }
        }
    }

    private void paintMultiBranch(Graphics2D gp2d, int[] rootXY, int branchSize) {
        int index = 0;
        List<int[]> branchCoordinates = this.paintRootBranchLine(gp2d, branchSize, rootXY);
        for (int i = 0; i < this.orderedBranchs.size(); ++i) {
            Map<String, List<String>> branch = this.orderedBranchs.get(i);
            for (String key : branch.keySet()) {
                List<String> nodes = branch.get(key);
                int[] coordinate = branchCoordinates.get(index);
                this.paintTotalPercent(gp2d, coordinate, nodes);
                this.paintSingleBranch(gp2d, nodes, coordinate);
                ++index;
            }
        }
    }

    private void paintTotalPercent(Graphics2D gp2d, int[] coordinate, List<String> nodes) {
        String nodeTotalPercentString = this.getNodeTotalPercentString(nodes);
        int x = coordinate[0];
        int y = coordinate[1];
        int ratex = Math.round((float)x - 6.0f * (float)(nodeTotalPercentString.length() / 2));
        this.paintString(gp2d, ratex, y -= 5, nodeTotalPercentString);
    }

    private List<int[]> paintRootBranchLine(Graphics2D gp2d, int branchSize, int[] rootXY) {
        int x = rootXY[0];
        int y = rootXY[1];
        int y2 = y + 40;
        this.paintYaxis(gp2d, x, y, y2);
        this.paintXaxis(gp2d, 75, y2, this.width - 75);
        List<int[]> branchcoordinates = this.getBranchCoordinates(75, x, this.width - 75, y2);
        return branchcoordinates;
    }

    private List<int[]> getBranchCoordinates(int x1, int x2, int x3, int y) {
        ArrayList<int[]> coordinates = new ArrayList<int[]>();
        int[] coordinate = null;
        if (this.branchs.size() == 2) {
            coordinate = this.getCoordinate(x1, y);
            coordinates.add(coordinate);
            coordinate = this.getCoordinate(x3, y);
            coordinates.add(coordinate);
        } else if (this.branchs.size() == 3) {
            coordinate = this.getCoordinate(x1, y);
            coordinates.add(coordinate);
            coordinate = this.getCoordinate(x2, y);
            coordinates.add(coordinate);
            coordinate = this.getCoordinate(x3, y);
            coordinates.add(coordinate);
        } else {
            int size = this.branchs.size();
            int section = this.width / size;
            int x = x1;
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) {
                    coordinate = this.getCoordinate(x3, y);
                    coordinates.add(coordinate);
                    continue;
                }
                coordinate = this.getCoordinate(x, y);
                coordinates.add(coordinate);
                x += section;
            }
        }
        return coordinates;
    }

    private int[] getCoordinate(int x, int y) {
        int[] coordinate = new int[]{x, y};
        return coordinate;
    }

    private int[] paintRootNode(Graphics2D gp2d) {
        List<String> nodes = this.branchs.get("branch0");
        if (nodes != null && !nodes.isEmpty()) {
            String node = nodes.get(0);
            node = node.substring(0, node.indexOf("("));
            String[] nodeArray = node.split("\\_");
            String root = nodeArray[0];
            int x = this.getRootXValue();
            int y = 10;
            int ratex = Math.round((float)x - 6.0f * (float)(this.resultRate.length() / 2));
            this.paintString(gp2d, ratex, y, this.resultRate);
            int rootLength = root.length();
            float xfloat = (float)x - this.CHARACTERSIZE * (float)(rootLength / 2);
            x = Math.round(xfloat);
            y = 25;
            this.paintString(gp2d, x, y, root);
            x = Math.round((float)x + this.CHARACTERSIZE * (float)(rootLength / 2));
            return new int[]{x, y += 5};
        }
        return null;
    }

    private void paintSingleBranch(Graphics2D gp2d, List<String> nodes, int[] XY) {
        if (nodes != null && !nodes.isEmpty()) {
            int nodesSize = nodes.size();
            int x = XY[0];
            int y = XY[1];
            for (int i = 0; i < nodesSize; ++i) {
                int y2 = y + 40;
                String node = nodes.get(i);
                String percent = this.getNodeSinglePercent(node);
                node = node.substring(0, node.indexOf("("));
                String[] nodeArray = node.split("\\_");
                String nodeName = nodeArray[1];
                int nodeNameLength = nodeName.length();
                this.paintYaxis(gp2d, x, y, y2);
                this.paintString(gp2d, x + 5, y + 25, percent);
                y = y2 + 15;
                float xfloat = (float)x - this.CHARACTERSIZE * (float)(nodeNameLength / 2);
                int xint = Math.round(xfloat);
                this.paintString(gp2d, xint, y, nodeName);
                y += 5;
            }
        }
    }

    private int getRootXValue() {
        int length = this.width / 2;
        return length;
    }

    private void paintYaxis(Graphics2D gp2d, int x, int y, int y2) {
        gp2d.drawLine(x, y, x, y2);
    }

    private void paintXaxis(Graphics2D gp2d, int x, int y, int x2) {
        gp2d.drawLine(x, y, x2, y);
    }

    private void paintString(Graphics2D gp2d, int x, int y, String name) {
        gp2d.drawString(name, x, y);
    }

    private String getNodeTotalPercentString(List<String> nodes) {
        BigDecimal percentDecimal = new BigDecimal(1);
        for (int i = 0; i < nodes.size(); ++i) {
            String node = nodes.get(i);
            String percent = this.getNodeSinglePercent(node);
            BigDecimal nodeBigDecimal = this.getDecimal(percent);
            percentDecimal = percentDecimal.multiply(nodeBigDecimal);
        }
        return percentDecimal.toPlainString();
    }

    private String getNodeSinglePercent(String node) {
        int leftSign = node.indexOf(40);
        int rightSign = node.indexOf(41);
        String percent = node.substring(leftSign + 1, rightSign);
        return percent;
    }

    private void splitCalcLog(String calcLogString) {
        String[] calcLogs = calcLogString.split(EQUALSPLIT);
        this.resultRate = this.getDecimalString(calcLogs[0]);
        calcLogString = calcLogs[1];
        this.branchs = new HashMap<String, List<String>>();
        this.orderedBranchs = new ArrayList<Map<String, List<String>>>();
        ArrayList<String> nodes = null;
        if (calcLogString.contains(PLUS)) {
            String[] tree = calcLogString.split(PLUSSPLIT);
            int nodeSize = tree.length;
            for (int i = 0; i < nodeSize; ++i) {
                HashMap<String, ArrayList<String>> branchMap = new HashMap<String, ArrayList<String>>();
                String branch = tree[i].trim();
                nodes = new ArrayList();
                if (branch.contains(MULTIPLY)) {
                    String[] nodeArrays = branch.split(MULTIPLYSPLIT);
                    for (int j = 0; j < nodeArrays.length; ++j) {
                        String node = nodeArrays[j].trim();
                        nodes.add(node);
                    }
                } else {
                    nodes.add(branch);
                }
                branchMap.put("branch" + i, nodes);
                this.orderedBranchs.add(branchMap);
                this.branchs.put("branch" + i, nodes);
            }
        } else if (calcLogString.contains(MULTIPLY)) {
            nodes = new ArrayList<String>();
            String[] nodeArrays = calcLogString.split(MULTIPLYSPLIT);
            for (int j = 0; j < nodeArrays.length; ++j) {
                String node = nodeArrays[j].trim();
                nodes.add(node);
            }
            this.branchs.put("branch0", nodes);
        } else {
            nodes = new ArrayList();
            nodes.add(calcLogString);
            this.branchs.put("branch0", nodes);
        }
    }

    private BigDecimal getDecimal(String number) {
        BigDecimal percentDecimal = new BigDecimal(0);
        if (number.contains(PERCENT)) {
            number = number.replace(PERCENT, "");
            percentDecimal = new BigDecimal(number.trim()).divide(new BigDecimal(100));
        }
        return percentDecimal;
    }

    private String getDecimalString(String number) {
        BigDecimal percentDecimal = this.getDecimal(number);
        String bigDecimalString = percentDecimal.toPlainString();
        return bigDecimalString;
    }
}

