/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaStruct;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDataElement;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.util.enums.IntEnum;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ShowEntityInfo {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ShowEntityInfo.class);
    private Map<String, Object> extendProps = new HashMap<String, Object>(0);
    private DBHandler dao;

    public ShowEntityInfo() {
    }

    public ShowEntityInfo(DBHandler dao) {
        this.dao = dao;
    }

    public String exec(Object obj) {
        try {
            if (obj instanceof DynFormulaDefineInfo) {
                DynFormulaDefineInfo info = (DynFormulaDefineInfo)obj;
                if (BizFormulaDefine.isElimType(info.getFormulaScheme().getItemKey())) {
                    return MessageFormat.format(ResourceDebugUtil.res("assistant.item") + "={0}", info.getAssistName());
                }
                return MessageFormat.format("{0},{1},{2}{3}", ResourceDebugUtil.res("assistant.item") + "=" + info.getAssistName(), info.isIsLevelManualSum() ? ResourceDebugUtil.res("manual.to.fill") : ResourceDebugUtil.res("base.data.to.fill"), info.isIsLevelSum() ? ResourceDebugUtil.res("sum.by.grade") : ResourceDebugUtil.res("sum.by.normal"), info.isIsLevelSum() && info.getLevelName() != null ? info.getLevelName() : "", info.isIsLevelSum() && info.getLevelOrderNum() != null ? info.getLevelOrderNum() : "");
            }
            if (obj instanceof ItemValue) {
                ItemValue itemValue = (ItemValue)obj;
                Map<Integer, String> dataElements = this.getDataElementsForSeq2Name();
                String asstTypeName = ResourceDebugUtil.res("assistant.item");
                if ("LEITEM".equalsIgnoreCase(itemValue.getType())) {
                    asstTypeName = ResourceDebugUtil.res("inner.company");
                } else if ("CEITEM".equalsIgnoreCase(itemValue.getType())) {
                    asstTypeName = ResourceDebugUtil.res("inner.company");
                } else if ("REITEM".equalsIgnoreCase(itemValue.getType())) {
                    asstTypeName = ResourceDebugUtil.res("invested.company");
                }
                String dynaItemName = itemValue.getDynaItemName();
                if (StringUtil.isEmpty((String)itemValue.getDynaItemName())) {
                    dynaItemName = itemValue.getDynaItem();
                }
                return MessageFormat.format(ResourceDebugUtil.res("show.item.with.format"), new BizFormulaDefine().getShowName(itemValue.getType()), itemValue.getContext().getYear() + "", itemValue.getContext().getPeriod(), dataElements.containsKey(itemValue.getContext().getDataElement()) ? dataElements.get(itemValue.getContext().getDataElement()) : Integer.valueOf(itemValue.getContext().getDataElement()), itemValue.getContext().getValueType().getAlias(), !StringUtil.isEmpty((String)itemValue.getDynaItem()) ? "(" + asstTypeName + ":" + dynaItemName + ")" : "");
            }
            if (obj instanceof IFormula) {
                IFormula formula = (IFormula)obj;
                BizFormulaDefine formulaDefine = ActionFactory.get(BizFormulaDefine.class);
                FormulaStruct struct = formulaDefine.getStruct(formula.getName());
                if (struct == null) {
                    LOG.error("UnknowFormula{0}", new Object[]{obj});
                    return obj.toString();
                }
                formula.setParamNames(struct.getParamNames());
                Map<String, String> dataElements = this.getDataElementsForNumber2Name();
                return MessageFormat.format(ResourceDebugUtil.res("show.item.with.format"), new Object[]{struct.getShowName(), formula.getParam("year") + "", formula.getParam("period"), dataElements.containsKey(formula.getParam("dataElement")) ? dataElements.get(formula.getParam("dataElement")) : formula.getParam("dataElement"), ValueTypeEnum.getEnum((String)formula.getParam("valueType")), formula.getParam("dynaItem") != null ? "," + ResourceDebugUtil.res("assistant.item") + ":" + formula.getParam("dynaItem") : ""});
            }
        }
        catch (Exception e) {
            LOG.error("", e);
            return "error:" + obj;
        }
        return "";
    }

    public String exec(Collection<? extends IntEnum> types, String joinChar) {
        StringBuffer sb = new StringBuffer();
        for (IntEnum intEnum : types) {
            sb.append(joinChar);
            sb.append(intEnum.getAlias());
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(joinChar.length());
    }

    protected Map<Integer, String> getDataElementsForSeq2Name() {
        Map<Integer, String> dataElements = (Map<Integer, String>)this.extendProps.get("DataElementsForSeq2Name");
        if (dataElements == null) {
            try {
                dataElements = new QueryDataElement(this.dao).seq2Name();
                this.extendProps.put("DataElementsForSeq2Name", dataElements);
            }
            catch (BOSException e) {
                LOG.error("", e);
                dataElements = new HashMap<Integer, String>(0);
            }
        }
        return dataElements;
    }

    protected Map<String, String> getDataElementsForNumber2Name() {
        Map<String, String> dataElements = (Map<String, String>)this.extendProps.get("DataElementsForNumber2Name");
        if (dataElements == null) {
            try {
                dataElements = new QueryDataElement(this.dao).number2Name();
                this.extendProps.put("DataElementsForNumber2Name", dataElements);
            }
            catch (BOSException e) {
                LOG.error("", e);
                dataElements = new HashMap<String, String>(0);
            }
        }
        return dataElements;
    }

    public void addExtend(String key, Object value) {
        this.extendProps.put(key, value);
    }
}

