/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSumRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptParaMgrStartergy;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptMenuStrategy;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReportProcess;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptMessage;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptParaMgrStartergy;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SumRptEditUI
extends AbstractSumRptEditUI
implements IReportProcess {
    private static final Logger logger = Logger.getLogger(SumRptEditUI.class);
    private static final long serialVersionUID = 2283792968602343207L;
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    public static final int BATCHSAVE_REPEAT = 1;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;
    private Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
    IUIWindow reportUI;
    CslReportInfo curSumReport = null;
    ICSLContext cslCtx = null;
    OrgTreeInfo unitTree;
    OrgUnitInfo company;
    ArrayList allKeyRow = null;
    private PeriodCollection periods = null;
    private boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
    private boolean isCtrlPress = false;
    boolean isSelect = true;

    public void setCurSumReport(CslReportInfo info) {
        this.editData = info;
    }

    public CslReportInfo getCurSumReport() {
        return this.editData;
    }

    public void setData(byte[] data) {
        if (this.getCurSumReport() != null) {
            this.getCurSumReport().setZipData(data);
        }
    }

    public byte[] getData() {
        return this.getCurSumReport().getZipData();
    }

    public IObjectValue getEditDataObject() {
        return this.getCurSumReport();
    }

    public boolean getIsAudited() {
        if (this.getCurSumReport() != null) {
            return this.getCurSumReport().getAuditedStatus().getValue() != 1;
        }
        return false;
    }

    public boolean getIsCacl() {
        return false;
    }

    public String getReportUIName() {
        return SumRptProcessUI.class.getName();
    }

    public RptStrategyManager getRptStrategyManager() {
        RptStrategyManager rptStrategyManager = new RptStrategyManager();
        SumRptMenuStrategy cslMenu = new SumRptMenuStrategy();
        cslMenu.setReportBaseInfo(this.getCurSumReport());
        rptStrategyManager.setCslParamStartegy(true);
        rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)cslMenu);
        CslRptParaMgrStartergy para = new CslRptParaMgrStartergy();
        rptStrategyManager.setRptParaMgrStartergy((RptParaMgrStartergy)para);
        return rptStrategyManager;
    }

    private SelectorItemCollection getRptSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.sumType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    public Object getSheetparam() {
        return this.getCurSumReport().getSheetParam();
    }

    public Object getSheetparam(String sheetId) {
        RptSheetParamCollection params = this.getCurSumReport().getSheetParam();
        if (params != null && params.size() > 0) {
            int paramsSize = params.size();
            for (int i = 0; i < paramsSize; ++i) {
                if (!params.get(i).getSheetID().trim().equals(sheetId)) continue;
                return params.get(i);
            }
        }
        return null;
    }

    public Object getView(String arg0) throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue("id", (Object)this.getCurSumReport().getId().toString());
        TemplateInfo templateInfoView = ((ITemplate)this.getBizInterface()).getTemplateInfo((IObjectPK)pk);
        ReportProcessUI reportProcessUI = new ReportProcessUI();
        RptTablePane viewPane = reportProcessUI.loadReportContent(templateInfoView.getKDF(), true);
        return viewPane;
    }

    public RptMessage checkCreatSheet(List rptSheets, RptSheet currentSheet) {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mapLinkOpenParam = (Map)this.getUIContext().get("KEY_LINKOPENRPT_PARAM");
        this.cslCtx = this.mapLinkOpenParam != null ? CSLContextHelper.getCSLContext(this.mapLinkOpenParam) : CSLContextHelper.getCSLContext();
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(null, this.cslCtx.getCurOrgBound());
        }
        if (this.getUIContext().get("OpenReport") != null) {
            this.openReportUI();
        } else {
            this.unitTree = this.cslCtx.getCurOrgBound();
            this.company = this.cslCtx.getCurOrgGroup();
            this.tblTemplate.checkParsed();
            this.tblTemplate.getSelectManager().setSelectMode(10);
            this.initData();
            this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString("AddNew"));
        }
        this.menuSubmitOption.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        KDTSortManager sm = new KDTSortManager(this.tblTemplate);
        sm.setEnableSortable(true);
        sm.setSortAuto(true);
        sm.setClickCount(1);
        this.tblTemplate.setSortMange(sm);
        this.tblTemplate.getColumn("Template.number").setSortable(true);
        this.tblTemplate.getColumn("Template.name").setSortable(true);
        this.tblTemplate.getColumn("Template.versionNumber").setSortable(true);
        this.tblTemplate.getColumn("Template.templateType").setSortable(true);
        this.tblTemplate.getColumn("template.dynRptType").setSortable(true);
        this.tblTemplate.getColumn("Template.lastUpdateTime").setSortable(true);
        this.tblTemplate.getColumn("Template.periodType").setSortable(true);
        this.tblTemplate.getColumn("Template.description").setSortable(true);
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
        CslRptUIUtil.addTableSelectedListener(this.tblTemplate, "select");
        this.initTableEvent();
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initTableEvent() {
        this.tblTemplate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    SumRptEditUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (SumRptEditUI.this.isCtrlPress) {
                    SumRptEditUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblTemplate.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int count = SumRptEditUI.this.tblTemplate.getRowCount();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        SumRptEditUI.this.tblTemplate.getRow(i).getCell("select").setValue((Object)false);
                    }
                }
            }
        });
        this.tblTemplate.getColumn("select").getStyleAttributes().setLocked(false);
    }

    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setCurrency(this.getCurSumReport().getCurrency());
        newSheetParam.setRelaType(ReportTypeEnum.TEMPLATE);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setStatus(1);
        newSheetParam.setReport((VirtualSheetParamInfo)this.getCurSumReport());
        newSheetParam.setReportClass(CSLReportGroupEnum.COMMON);
        return newSheetParam;
    }

    public VirtualSheetParamInfo save() throws Exception {
        IObjectPK pk = ((ICslReport)this.getBizInterface()).submit((CoreBaseInfo)this.getCurSumReport());
        this.setOprtState(OprtState.EDIT);
        this.setCurSumReport((CslReportInfo)this.getBizInterface().getValue(pk, this.getRptSelectors()));
        return this.getCurSumReport();
    }

    public void switchReport(String reportId) {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getRptSelectors());
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblTemplate.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblTemplate.getRow(rowIndex = selectBlock.getTop())).getCell("Template.id")) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.batchAddReport(this.getSelectedTemplateIdList());
    }

    private List getSelectedTemplateIdList() {
        ArrayList<String> list = new ArrayList<String>();
        int count = this.tblTemplate.getRowCount();
        if (count > 0) {
            boolean isSelect = false;
            for (int i = 0; i < count; ++i) {
                isSelect = (Boolean)this.tblTemplate.getRow(i).getCell("select").getValue();
                if (!isSelect) continue;
                String id = (String)this.tblTemplate.getRow(i).getCell("Template.id").getValue();
                list.add(id);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        if (list.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return list;
    }

    private void batchAddReport(List list) throws Exception {
        int size = list.size();
        ArrayList<TemplateInfo> successLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> repeatLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> failedLst = new ArrayList<TemplateInfo>();
        Date date = (Date)this.datePickerDate.getValue();
        int year = this.cslCtx.getCurRptYear();
        short period = (short)this.cslCtx.getCurRptPeriod();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        for (int i = 0; i < size; ++i) {
            TemplateInfo template = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)list.get(i).toString())), this.getSelectors());
            int ret = this.addNewEditData(template, date, year, period, currency, this.unitTree, this.company);
            if (ret == 1) {
                repeatLst.add(template);
                continue;
            }
            if (ret == 2) {
                failedLst.add(template);
                continue;
            }
            successLst.add(template);
        }
        CslRptUIUtil.displayResult((Object)this, successLst, repeatLst, null, failedLst, ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getName());
    }

    public int addNewEditData(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company) throws Exception {
        try {
            return this.addNewSumRpt(template, date, year, period, currency, unitTree, company);
        }
        catch (ServerException exc) {
            logger.error((Object)"addNewEditData_ServerException", (Throwable)((Object)exc));
            if (ServerException.EXISTS_SAME_RPT.getCode().equals(exc.getSubCode())) {
                return 1;
            }
            return 2;
        }
        catch (Exception exc) {
            logger.error((Object)"addNewEditData_Exception", (Throwable)exc);
            return 2;
        }
    }

    public int addNewSumRpt(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int periodType = template.getPeriodType().getValue();
        int templateType = template.getTemplateType().getValue();
        int reportType = -1;
        switch (templateType) {
            case 1: {
                reportType = 1;
                break;
            }
            case 3: {
                reportType = 2;
                break;
            }
            case 4: {
                reportType = 4;
                break;
            }
            case 5: {
                reportType = 3;
                break;
            }
            case 6: {
                reportType = 1;
                break;
            }
            case 10: {
                reportType = 10;
                break;
            }
            case 11: {
                reportType = 11;
                break;
            }
            case 12: {
                reportType = 12;
                break;
            }
            case 17: {
                reportType = 14;
            }
        }
        if (!this.verifySumReport(unitTree.getId().toString(), company.getId().toString(), periodType, year, period, currency.getId().toString(), template.getGroup(), reportType)) {
            return 1;
        }
        this.editData = (CslReportInfo)this.createNewData();
        this.editData.setYear(year);
        this.editData.setPeriod(period);
        this.editData.setStartDate(FiscalPeriodHelper.getPeriodFirstDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.periods, this.isMergeByFiscalPeriod));
        this.editData.setEndDate(FiscalPeriodHelper.getPeriodLastDate(this.periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.isMergeByFiscalPeriod));
        this.editData.setTemplate(template);
        this.editData.setBook(template.getBook());
        this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        this.editData.getSheetParam().addCollection(sheetParams);
        if (RptTmpTypeEnum.DYNAMICSUMREPORT.equals((Object)this.editData.getTemplate().getTemplateType())) {
            this.editData.setSourceType(RptSrcTypeEnum.DYNAMICSUMREPORT);
            this.editData.setDynaRptType(template.getDynaRptType());
        } else if (RptTmpTypeEnum.MULTIDYNAMICSUMREPORT.equals((Object)this.editData.getTemplate().getTemplateType())) {
            this.editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICSUMREPORT);
            this.editData.setDynaRptType(template.getDynaRptType());
        } else {
            this.editData.setSourceType(RptSrcTypeEnum.SUM);
        }
        this.editData.setOrgTree(unitTree);
        this.editData.setOrgUnit(company);
        this.editData.setCurrency(currency);
        this.editData.setName(template.getName());
        this.editData.setNumber("001");
        this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        this.editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        this.editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        this.editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        if ("true".equals(this.isSupportOtherDS)) {
            DataCollectInfo dataCollect = ctx.getCurDataCollect();
            this.editData.setDataCollect(dataCollect);
            if (dataCollect != null) {
                this.editData.setDataCollectNumber(dataCollect.getNumber());
            }
        }
        this.editData.setReportDate(new Timestamp(date.getTime()));
        Book book = this.editData.getBook();
        book = this.getDynaKeyAndValue(book);
        book = this.setFormulaLocation(book);
        CslRptUtil.clearCellFormulaByDataCollect(book);
        this.editData.setBook(book);
        IObjectPK pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        return 3;
    }

    public CslReportInfo addSingleNewEditData(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company) throws IOException, Exception {
        this.editData = (CslReportInfo)this.createNewData();
        this.editData.setYear(year);
        this.editData.setPeriod(period);
        int periodType = template.getPeriodType().getValue();
        this.editData.setStartDate(FiscalPeriodHelper.getPeriodFirstDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.periods, this.isMergeByFiscalPeriod));
        this.editData.setEndDate(FiscalPeriodHelper.getPeriodLastDate(this.periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), this.isMergeByFiscalPeriod));
        this.editData.setTemplate(template);
        Book tmplbook = template.getBook();
        boolean isAutoCalculate = tmplbook.isAutoCalculate();
        tmplbook.setAutoCalculate(false);
        this.editData.setBook(tmplbook);
        Book book = this.editData.getBook();
        this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        this.editData.getSheetParam().addCollection(sheetParams);
        if (RptTmpTypeEnum.DYNAMICSUMREPORT.equals((Object)this.editData.getTemplate().getTemplateType())) {
            this.editData.setSourceType(RptSrcTypeEnum.DYNAMICSUMREPORT);
            this.editData.setDynaRptType(template.getDynaRptType());
        } else if (RptTmpTypeEnum.MULTIDYNAMICSUMREPORT.equals((Object)this.editData.getTemplate().getTemplateType())) {
            this.editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICSUMREPORT);
            this.editData.setDynaRptType(template.getDynaRptType());
        } else {
            this.editData.setSourceType(RptSrcTypeEnum.SUM);
        }
        this.editData.setOrgTree(unitTree);
        this.editData.setOrgUnit(company);
        this.editData.setCurrency(currency);
        this.editData.setName(template.getName());
        this.editData.setNumber("001");
        this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        this.editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        this.editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        this.editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        this.editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        this.editData.setReportDate(new Timestamp(date.getTime()));
        book = this.getDynaKeyAndValue(book);
        book = this.setFormulaLocation(book);
        CslRptUtil.clearCellFormulaByDataCollect(book);
        this.editData.setBook(book);
        book.setAutoCalculate(isAutoCalculate);
        this.editData.setDataCollect(DataCollectConstant.getActualDC());
        this.editData.setDataCollectNumber("ACTUALDATA");
        IObjectPK pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        return this.editData;
    }

    public Book getDynaKeyAndValue(Book book) throws Exception {
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null) continue;
            HashMap leftKeyColAndAllRow = CslRptUIUtil.getLeftColAndAllLeftRow(sheet, keyZone);
            if (valueZone == null || leftKeyColAndAllRow.get("leftCol") == null) continue;
            this.allKeyRow = (ArrayList)leftKeyColAndAllRow.get("allRow");
            if (this.allKeyRow.size() == 0) continue;
            ArrayList allValueCol = this.getKeyValueCol(sheet, valueZone, this.allKeyRow);
            sheet.setUserObject("allValueCol", (Object)allValueCol);
            sheet.setUserObject("keyLeftCol", (Object)((Integer)leftKeyColAndAllRow.get("leftCol")));
            this.reSaveKeyZoneByRange(sheet, this.allKeyRow, (Integer)leftKeyColAndAllRow.get("leftCol"));
        }
        return book;
    }

    private Book setFormulaLocation(Book book) throws Exception {
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null || valueZone == null) continue;
            this.saveValueFormual(sheet, keyZone, valueZone);
        }
        return book;
    }

    private void saveValueFormual(Sheet sheet, SumcalcRange keyZone, SumcalcRange valueZone) {
        ArrayList allValueCol;
        ArrayList arrayList = allValueCol = sheet.getUserObjectValue("allValueCol") == null ? null : (ArrayList)sheet.getUserObjectValue("allValueCol");
        if (this.allKeyRow == null || this.allKeyRow.size() == 0) {
            return;
        }
        if (allValueCol == null || allValueCol.size() == 0) {
            return;
        }
        HashMap<String, Cloneable> mapAll = new HashMap<String, Cloneable>();
        ArrayList<String> valueList = new ArrayList<String>();
        HashMap<String, Boolean> allHaveFormulaCol = new HashMap<String, Boolean>();
        for (int i = 0; i < keyZone.size(); ++i) {
            CellBlock block = keyZone.getCellBlock(i);
            for (int k = 0; k < allValueCol.size(); ++k) {
                int interRowIndex = -1;
                int index = -1;
                for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                    String formula;
                    ++interRowIndex;
                    Integer valueCol = (Integer)allValueCol.get(k);
                    Range range = sheet.getRange(j, valueCol.intValue());
                    if (range == null || !valueZone.contains(CellBlock.getNewCellBlock((int)j, (int)valueCol)) || range.getFormula() == null || range.getFormula().equals("") || !sheet.getCell(j, valueCol.intValue(), false).hasFormula() || (formula = range.getFormula()) == null || (formula = formula.trim()).equals("")) continue;
                    String dynaValueIndex = formula + "&" + i + "&" + j + "&" + valueCol;
                    valueList.add(dynaValueIndex);
                    ++index;
                }
                if (index != block.getRow2() - block.getRow()) continue;
                allHaveFormulaCol.put(i + "&" + (Integer)allValueCol.get(k), new Boolean(true));
            }
        }
        mapAll.put("allHaveFormulaCol", allHaveFormulaCol);
        mapAll.put("formulaLocation", valueList);
        sheet.setUserObject("fomulaLocation", mapAll);
    }

    private ArrayList getKeyValueCol(Sheet sheet, SumcalcRange zone, ArrayList allRow) {
        ArrayList<Integer> valueCol = new ArrayList<Integer>();
        for (int index = 0; index < zone.size(); ++index) {
            CellBlock block = zone.getCellBlock(index);
            for (int i = block.getCol(); i <= block.getCol2(); ++i) {
                if (valueCol.contains(new Integer(i))) continue;
                valueCol.add(new Integer(i));
            }
        }
        return valueCol;
    }

    private void reSaveKeyZoneByRange(Sheet sheet, ArrayList allKeyRow, Integer keyLeftCol) {
        int beginRow;
        SumcalcRange newKeyZone = new SumcalcRange();
        Object[] o = allKeyRow.toArray();
        Arrays.sort(o);
        int endRow = beginRow = ((Integer)o[0]).intValue();
        for (int i = 0; i <= o.length && i != o.length + 1; ++i) {
            CellBlock cb;
            int row;
            if (i != o.length) {
                row = (Integer)o[i];
                if (endRow == row) {
                    ++endRow;
                    continue;
                }
                cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
                beginRow = row;
                endRow = row + 1;
                newKeyZone.addRange(sheet.getRange(cb));
                continue;
            }
            row = (Integer)o[o.length - 1];
            if (endRow - 1 != row) continue;
            cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
            newKeyZone.addRange(sheet.getRange(cb));
        }
        sheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
    }

    protected IObjectValue createNewData() {
        return new CslReportInfo();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = null;
        try {
            exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            exec.option().isAutoTranslateEnum = true;
            int index = 1;
            exec.setParameter(index++, (Object)this.cslCtx.getCurOrgBound().getId().toString());
            exec.setParameter(index++, (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()));
            exec.setParameter(index++, (Object)this.cslCtx.getCurOrgGroup().getId().toString());
            FilterInfo filter = this.querySumTemplateQuery.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            index = filter.getFilterItems().size();
            StringBuffer maskString = new StringBuffer();
            if (filter.getMaskString() == null || filter.getMaskString().length() == 0) {
                maskString.append(" (#").append(index++);
            } else {
                maskString.append(filter.getMaskString());
                maskString.append(" And (#").append(index++);
            }
            filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(3)));
            maskString.append(" or #").append(index++).append("");
            filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(11)));
            if (this.cslCtx.getCurDataCollect() != null && this.cslCtx.getCurDataCollect().getNumber() != null && this.cslCtx.getCurDataCollect().getNumber().equals("ACTUALDATA")) {
                maskString.append(" or #").append(index++);
                filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(17)));
            }
            maskString.append(")");
            filter.setMaskString(maskString.toString());
            FilterInfo dataPermissionFilter = CslRptUtil.getDataPermissionFilter(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "csl_cslrpttmp_view");
            if (dataPermissionFilter != null) {
                for (int i = 0; i < dataPermissionFilter.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = dataPermissionFilter.getFilterItems().get(i);
                    filterItemInfo.setPropertyName("Template." + filterItemInfo.getPropertyName());
                }
                filter.mergeFilter(dataPermissionFilter, "AND");
            }
            this.querySumTemplateQuery.setFilter(filter);
            exec.setObjectView(this.querySumTemplateQuery);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return exec;
    }

    protected void initData() throws Exception {
        super.setDataObject("querySumTemplateQuery", (IObjectValue)new EntityViewInfo());
        CslClientHelper.initCurrencyCombox((JComboBox)this.comboCurrency);
        Date curDate = this.cslCtx.getCurReportDate();
        this.datePickerDate.setValue((Object)curDate);
        this.datePickerDate.setEditable(false);
        this.datePickerDate.setEnabled(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.tblTemplate.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_EmptyTemplate"));
            SysUtil.abort();
        }
        if (this.tblTemplate.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
    }

    private void openReportUI() throws Exception {
        IUIWindow uiWindow;
        String reportID = (String)this.getUIContext().get("ID");
        this.setCurSumReport(this.getReportInfo(reportID));
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        if (this.getUIContext().get("KeyOrgTree") != null) {
            uiContext.put((Object)"KeyOrgTree", this.getUIContext().get("KeyOrgTree"));
        }
        this.reportUI = uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getReportUIName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.getUIObject().setUITitle(CslRptUIUtil.getUITitle((VirtualSheetParamInfo)this.editData, this.getOprtState()));
        uiWindow.show();
    }

    private boolean verifySumReport(String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateGroupNumber, int reportType) throws Exception {
        String reportId = null;
        if (super.getOprtState() == OprtState.EDIT) {
            reportId = this.editData.getId().toString();
        }
        String dataCollectNumber = "ACTUALDATA";
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        if ("true".equals(this.isSupportOtherDS)) {
            dataCollectNumber = ctx.getCurDataCollect().getNumber();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("treeID", treeID);
        params.put("companyID", companyID);
        params.put("periodType", new Integer(periodType));
        params.put("year", new Integer(year));
        params.put("period", new Integer(period));
        params.put("currencyID", currencyID);
        params.put("templateGroupNumber", templateGroupNumber);
        params.put("reportType", new Integer(reportType));
        params.put("reportId", reportId);
        params.put("dataCollectNumber", dataCollectNumber);
        params.put("isSupportGroupReport", true);
        return !TempletDispenseFactory.getRemoteInstance().isHasSameSumRpt(params);
    }

    public boolean destroyWindow() {
        Object owner;
        if (this.getOprtState().equals("EDIT")) {
            super.releaseObjectLock(this.editData.getId().toString());
        }
        if ((owner = this.getUIContext().get("Owner")) instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    public void submitWorkFlow() throws Exception {
    }

    public PostilCollection getRptPostilColl() {
        for (int i = 0; i < this.editData.getPostils().size(); ++i) {
            if (this.editData.getPostils().get(i).getPostilType().getValue() == 1) continue;
            this.editData.getPostils().removeObject(i);
            --i;
        }
        return this.editData.getPostils();
    }

    public RptMessage checkCreatSheet(List rptSheets) {
        return null;
    }

    @Override
    protected void tblTemplate_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.isSelect = true;
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getSelectedTemplateID());
            this.batchAddReport(list);
            if (this.isSelect) {
                this.destroyWindow();
            }
        } else if (e.getButton() == 1 && e.getClickCount() == 1 && this.isCtrlPress) {
            IRow row = this.tblTemplate.getRow(e.getRowIndex());
            boolean isSelect = (Boolean)row.getCell("select").getValue();
            row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
            this.tblTemplate.checkParsed();
        }
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblTemplate.getColumnIndex("Template.number");
            int colIndex2 = this.tblTemplate.getColumnIndex("Template.name");
            CslRptUIUtil.tableMainLocate(this.tblTemplate, search, new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionDisplay_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay(this.tblTemplate, "select", this.btnDisplay);
    }
}

