/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractTemplateCreateWizardPage2UI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateCreateWizard;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateCreateWizardFilterContainer;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.framework.client.wizard.IWizardPage;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TemplateCreateWizardPage2UI
extends AbstractTemplateCreateWizardPage2UI {
    public void onPageChanged(IWizardPage oldPage, IWizardPage currentPage) {
        super.onPageChanged(oldPage, currentPage);
        TemplateCreateWizardFilterContainer filterContainer = ((TemplateCreateWizard)this.getWizard()).getFilterContainer();
        if (this.cbxShowHisVersion.isSelected()) {
            filterContainer.setVersionStatus(null);
        } else {
            filterContainer.setVersionStatus(VersionStatusEnum.UNVERSION);
        }
        this.updateSelection();
    }

    void updateSelection() {
        if (this.queryTemplateImportQuery == null) {
            this.queryTemplateImportQuery = new EntityViewInfo();
        }
        TemplateCreateWizardFilterContainer filterContainer = ((TemplateCreateWizard)this.getWizard()).getFilterContainer();
        RptTmpTypeEnum templateType = filterContainer.getTemplateType();
        RptPeriodTypeEnum periodType = filterContainer.getPeriodType();
        String name = filterContainer.getName();
        Date dateStart = filterContainer.getDateStart();
        Date dateEnd = filterContainer.getDateEnd();
        AuditedStatusEnum auditedStatus = filterContainer.getAuditedStatus();
        PublishedStatusEnum publishedStatus = filterContainer.getPublishedStatus();
        VersionStatusEnum versionStatus = filterContainer.getVersionStatus();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        if (templateType != null) {
            fic.add(new FilterItemInfo("templateType", (Object)new Integer(templateType.getValue()), CompareType.EQUALS));
            sbFormula.append(" #" + formulaIndex++);
        }
        if (periodType != null) {
            fic.add(new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (name != null) {
            fic.add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
            sbFormula.append(" and #" + formulaIndex++);
        }
        Calendar calendar = Calendar.getInstance();
        if (dateStart != null) {
            calendar.setTime(DateTimeUtils.truncateDate((Date)dateStart));
            fic.add(new FilterItemInfo("lastUpdateTime", (Object)new Timestamp(calendar.getTimeInMillis()), CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (dateEnd != null) {
            calendar.setTime(DateTimeUtils.truncateDate((Date)dateEnd));
            calendar.set(5, calendar.get(5) + 1);
            fic.add(new FilterItemInfo("lastUpdateTime", (Object)new Timestamp(calendar.getTimeInMillis()), CompareType.LESS));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (auditedStatus != null) {
            fic.add(new FilterItemInfo("auditedStatus", (Object)new Integer(auditedStatus.getValue()), CompareType.EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (publishedStatus != null) {
            fic.add(new FilterItemInfo("publishedStatus", (Object)new Integer(publishedStatus.getValue()), CompareType.EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (AuditedStatusEnum.UNAUDITED.equals((Object)auditedStatus)) {
            this.cbxShowHisVersion.setSelected(false);
            this.cbxShowHisVersion.setEnabled(false);
        } else if (AuditedStatusEnum.AUDITED.equals((Object)auditedStatus)) {
            if (versionStatus != null) {
                fic.add(new FilterItemInfo("versionStatus", (Object)new Integer(versionStatus.getValue()), CompareType.EQUALS));
                sbFormula.append(" and #" + formulaIndex++);
            }
            this.cbxShowHisVersion.setEnabled(true);
        } else {
            if (versionStatus != null) {
                fic.add(new FilterItemInfo("auditedStatus", (Object)new Integer(1), CompareType.EQUALS));
                sbFormula.append(" and (#" + formulaIndex++);
                fic.add(new FilterItemInfo("auditedStatus", (Object)new Integer(2), CompareType.EQUALS));
                sbFormula.append(" or #" + formulaIndex++);
                fic.add(new FilterItemInfo("versionStatus", (Object)new Integer(1), CompareType.EQUALS));
                sbFormula.append(" and #" + formulaIndex++).append(")");
            }
            this.cbxShowHisVersion.setEnabled(true);
        }
        boolean includeFreezed = filterContainer.isIncludeFreezed();
        if (!includeFreezed) {
            fic.add(new FilterItemInfo("isFreezed", (Object)new Integer(0), CompareType.EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
        }
        fic.add(new FilterItemInfo("isK3Tpl", (Object)Boolean.FALSE));
        sbFormula.append(" and #" + formulaIndex++);
        fic.add(new FilterItemInfo("easTplIdForK3", null));
        sbFormula.append(" and #" + formulaIndex++);
        filter.setMaskString(sbFormula.toString());
        this.queryTemplateImportQuery.setFilter(filter);
        this.tblTemplate.getSelectManager().setSelectMode(2);
        this.tblTemplate.getStyleAttributes().setLocked(true);
        this.tblTemplate.refresh();
        this.showOrgTypeByTPType(templateType);
    }

    private void showOrgTypeByTPType(RptTmpTypeEnum templateType) {
        if (templateType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            this.tblTemplate.getColumn("orgType").getStyleAttributes().setHided(false);
        } else {
            this.tblTemplate.getColumn("orgType").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemInfo sort = new SorterItemInfo("versionNumber");
        sort.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sort);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public TemplateCreateWizardPage2UI() throws Exception {
        this.cbxShowHisVersion.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TemplateCreateWizardFilterContainer filterContainer = ((TemplateCreateWizard)TemplateCreateWizardPage2UI.this.getWizard()).getFilterContainer();
                if (filterContainer.getAuditedStatus() != null && filterContainer.getAuditedStatus().getValue() == 1) {
                    filterContainer.setVersionStatus(null);
                } else if (TemplateCreateWizardPage2UI.this.cbxShowHisVersion.isSelected()) {
                    filterContainer.setVersionStatus(null);
                } else {
                    filterContainer.setVersionStatus(VersionStatusEnum.UNVERSION);
                }
                TemplateCreateWizardPage2UI.this.updateSelection();
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Icon getImage() {
        return TemplateCreateWizard.getWizardImage();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblTemplate.setColumnMoveable(true);
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    void updateFilter() throws EASBizException, BOSException {
        ITemplate it;
        TemplateInfo info;
        int index = this.tblTemplate.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            MsgBox.showError((String)CslRptUtil.getString("Template_Import_ChooseTemplate"));
            SysUtil.abort();
        }
        if ((info = (it = TemplateFactory.getRemoteInstance()).getTemplateInfo("select id, data, templateType,sumType,group, sheetParam.*, sheetParam.currency.*, sheetParam.dfData.*, sheetParam.postils.*, versionNumber where id = '" + this.tblTemplate.getCell(index, "id").getValue() + "'")).getZipData() == null || info.getZipData().length <= 1) {
            MsgBox.showError((String)CslRptUtil.getString("Template_Import_NullSheet"));
            SysUtil.abort();
        }
        ((TemplateCreateWizard)this.getWizard()).getFilterContainer().setTemplate(info);
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblTemplate.getColumnIndex("number");
            int colIndex2 = this.tblTemplate.getColumnIndex("name");
            CslRptUIUtil.tableMainLocate(this.tblTemplate, search, new int[]{colIndex1, colIndex2});
        }
    }
}

