/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.model.KingdeeListModel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractTemplateCreateWizardPage3UI;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateCreateWizard;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateCreateWizardFilterContainer;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.client.wizard.IWizardPage;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ListModel;

public class TemplateCreateWizardPage3UI
extends AbstractTemplateCreateWizardPage3UI {
    private static final long serialVersionUID = 1419038282928354268L;
    private RptTmpTypeEnum templateType;

    public TemplateCreateWizardPage3UI() throws Exception {
    }

    public TemplateCreateWizardPage3UI(RptTmpTypeEnum templateType) throws Exception {
        this();
        this.templateType = templateType;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Icon getImage() {
        return TemplateCreateWizard.getWizardImage();
    }

    void updateSelection() {
        TemplateCreateWizard wizard = (TemplateCreateWizard)this.getWizard();
        if (wizard == null) {
            MsgBox.showError((String)CslRptUtil.getString("TemplateCreateCannotFindWizard"));
            return;
        }
        TemplateInfo info = wizard.getFilterContainer().getTemplate();
        if (info == null || info.getZipData() == null) {
            MsgBox.showError((String)CslRptUtil.getString("TemplateCreateCannotFindReport"));
            return;
        }
        TemplateCreateWizardFilterContainer filterContainer = ((TemplateCreateWizard)this.getWizard()).getFilterContainer();
        boolean isCsl = RptTmpTypeEnum.CSLREPORT.equals((Object)filterContainer.getCurrentTemplateType());
        isCsl |= RptTmpTypeEnum.SUMREPORT.equals((Object)filterContainer.getCurrentTemplateType());
        isCsl |= RptTmpTypeEnum.DIFFTABLE.equals((Object)filterContainer.getCurrentTemplateType());
        HashMap<String, CSLReportGroupEnum> reportClassMap = new HashMap<String, CSLReportGroupEnum>();
        for (int i = 0; i < info.getSheetParam().size(); ++i) {
            CSLReportGroupEnum reportClass = info.getSheetParam().get(i).getReportClass();
            reportClassMap.put(info.getSheetParam().get(i).getSheetID(), reportClass);
        }
        KingdeeListModel model = new KingdeeListModel();
        Book book = null;
        try {
            book = info.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; book != null && i < book.getSheetCount(); ++i) {
            boolean isElim = false;
            Sheet sheet = book.getSheet(i);
            if (isCsl) {
                CSLReportGroupEnum reportClass = (CSLReportGroupEnum)((Object)reportClassMap.get(sheet.getID()));
                int type = 1;
                if (reportClass != null) {
                    type = reportClass.getValue();
                }
                if (1 != type) {
                    isElim = true;
                }
            }
            if (isElim) continue;
            model.addElement(sheet.getSheetName());
        }
        this.listPages.setModel((ListModel)model);
        this.listPages.setSelectionMode(2);
        this.listPages.setSelectionInterval(0, model.getSize() - 1);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        boolean isCslTemplate = CslRptUtil.isCslTemplate(this.templateType);
        this.chkClearFormula.setSelected(isCslTemplate);
        this.chkClearFormula.setVisible(isCslTemplate);
        this.kDLabel1.setVisible(false);
    }

    public void onPageChanged(IWizardPage oldPage, IWizardPage currentPage) {
        super.onPageChanged(oldPage, currentPage);
        this.updateSelection();
    }

    void updateFilter() throws EASBizException, BOSException {
        Object[] collection = this.listPages.getSelectedValues();
        if (collection.length <= 0) {
            MsgBox.showError((String)CslRptUtil.getString("Template_Import_ChooseSheet"));
            SysUtil.abort();
        }
        TemplateCreateWizardFilterContainer filterContainer = ((TemplateCreateWizard)this.getWizard()).getFilterContainer();
        int n = collection.length;
        for (int i = 0; i < n; ++i) {
            filterContainer.addSheetID((String)collection[i]);
        }
        filterContainer.setOverlay(this.chkIsOverlay.isSelected());
        filterContainer.setClearFormula(this.chkClearFormula.isSelected());
    }
}

