/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractTextMsgBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.log4j.Logger;

public class TextMsgBox
extends AbstractTextMsgBox {
    private static final Logger logger = CoreUIObject.getLogger(TextMsgBox.class);
    private KDFileChooser fileChooser = new KDFileChooser();
    protected FileDialog fileDialog;
    private boolean result = false;

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.textLabel.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        if (this.getUIContext().get("TextMsg") != null) {
            String msg = (String)this.getUIContext().get("TextMsg");
            if (!StringUtils.isEmpty((String)msg)) {
                msg = msg.replaceAll("\\\\r", "\r");
                msg = msg.replaceAll("\\\\n", "\n");
            }
            this.textMsg.setText(msg);
        }
        if (this.getUIContext().get("TextLabel") != null) {
            this.textLabel.setText((String)this.getUIContext().get("TextLabel"));
        }
        if (this.getUIContext().get("Title") != null) {
            this.setUITitle((String)this.getUIContext().get("Title"));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.setResult(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        FileOutputStream fstrm = null;
        OutputStreamWriter out = null;
        try {
            int returnVal = this.fileChooser.showSaveDialog((Component)((Object)this));
            if (returnVal != 0) {
                return;
            }
            File file = this.fileChooser.getSelectedFile();
            fstrm = new FileOutputStream(file);
            out = new OutputStreamWriter(fstrm);
            out.write(this.textMsg.getText().replaceAll("\n", "\r\n"));
            out.flush();
        }
        catch (IOException io) {
            logger.debug((Object)("IOException: " + io.getMessage()));
        }
        finally {
            if (fstrm != null) {
                fstrm.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.textMsg.setCaretPosition(0);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.setResult(true);
    }

    public static boolean showMessageByModel(UIContext uiCtx) {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TextMsgBox.class.getName(), (Map)uiCtx, null);
        }
        catch (UIException uIException) {
            // empty catch block
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
        return ((TextMsgBox)uiWindow.getUIObject()).getResult();
    }
}

