/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.TimeImportReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.UpdateReportTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractTimeImportReportEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.FTPUpDown;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.client.ProgressManager;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class TimeImportReportEditUI
extends AbstractTimeImportReportEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TimeImportReportEditUI.class);
    private boolean isChange = false;
    private String schedule = null;
    private EASWfServiceClient workflowClient = null;
    private ProgressManager procManager = null;

    public TimeImportReportEditUI() throws Exception {
        this.txtTextDisPlay.setEditable(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionSubmitOption.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (UpdateReportTypeEnum.UPF.equals((Object)this.editData.getUpdateReportType())) {
            this.rdoWeb.setSelected(true);
        } else {
            this.rdoExcel.setSelected(true);
        }
        String jobProcessDefId = this.editData.getJobProcessDef();
        if (StringUtils.isEmpty((String)jobProcessDefId)) {
            this.setSchedule(null);
            this.txtTimeArea.setText(null);
            this.scheduleTextChange();
            return;
        }
        try {
            Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(jobProcessDefId);
            ScheduleDef schdef = null;
            if (map != null && !map.isEmpty()) {
                schdef = new ScheduleDef(null);
                String define = (String)map.get("rpt_cacl_scheme_define");
                String[] defines = define.split(":");
                schdef.setType(ScheduleType.getEnum((String)defines[0]));
                schdef.setDefine(defines[1]);
                schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
                schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
                schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
                schdef.setInstructionType(2);
                String scheduleXml = KpdlParser.scheduleToString((ScheduleDef)schdef);
                this.setSchedule(scheduleXml);
                this.txtTimeArea.setText(scheduleXml);
            }
        }
        catch (Exception e) {
            this.setSchedule(null);
            this.txtTimeArea.setText(null);
        }
        this.scheduleTextChange();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            this.txtTextDisPlay.setEditable(false);
            this.txtTimeArea.setEditable(false);
            this.txtServerDir.setEditable(false);
            this.txtServerDir.setEnabled(false);
            this.txtLoginName.setEditable(false);
            this.pwdText.setEditable(false);
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.txtServerAddress.setEditable(false);
        }
        this.initControl();
    }

    private void initControl() {
        this.txtTimeArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TimeImportReportEditUI.this.scheduleTextChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TimeImportReportEditUI.this.scheduleTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TimeImportReportEditUI.this.scheduleTextChange();
            }
        });
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("jobProcessDef"));
        sic.add(new SelectorItemInfo("serverAddr"));
        sic.add(new SelectorItemInfo("currDirectory"));
        sic.add(new SelectorItemInfo("userName"));
        sic.add(new SelectorItemInfo("passPort"));
        sic.add(new SelectorItemInfo("updateReportType"));
        return sic;
    }

    @Override
    public void actionAbolish_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbolish_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        if (this.getOprtState() == OprtState.VIEW) {
            this.getUIWindow().close();
        } else {
            this.verify();
            this.save();
        }
    }

    private void verify() {
        if (this.txtName.getText() == null || this.txtName.getText().trim().equals("")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"698_TimeImportReportEditUI"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"699_TimeImportReportEditUI"));
            SysUtil.abort();
        }
        if (this.getSchedule() == null || this.getSchedule().trim().length() == 0) {
            String strTimeScheme = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.CaclSolutonUI_TimeFrist");
            MsgBox.showInfo((Component)((Object)this), (String)strTimeScheme);
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtServerAddress.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"365_CSLReportImportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtLoginName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"366_CSLReportImportUI"));
            SysUtil.abort();
        }
    }

    private void save() throws EASBizException, BOSException, Exception {
        FunctionObjectInfo function = this.getForewarnFunction();
        OperationInfo operation = function.getOperation().get(0);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        if (this.editData.getId() == null) {
            BOSUuid uuid = BOSUuid.create((BOSObjectType)this.getBizInterface().getType());
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            jobContext.put("pk", pk.toString());
            String jobProcessDefID = this.getWorkflowClient().createJobProcessDef("TimeImportReport-" + this.txtNumber.getText(), function, operation, jobContext, this.getSchedule(), SysContext.getSysContext().getLocale());
            this.editData.setJobProcessDef(jobProcessDefID);
            this.editData.setId(uuid);
            this.setEditData();
            this.editData.setIsForbid(0);
            this.getBizInterface().submit((IObjectPK)pk, (CoreBaseInfo)this.editData);
        } else {
            ObjectUuidPK schemePk = new ObjectUuidPK(this.editData.getId());
            jobContext.put("pk", schemePk.toString());
            this.getWorkflowClient().updateProcessSchedule(this.editData.getJobProcessDef(), this.getSchedule());
            this.setEditData();
            this.getBizInterface().submit((IObjectPK)schemePk, (CoreBaseInfo)this.editData);
        }
        this.setSave(true);
        this.setChange(false);
        String strSave = EASResource.getString((String)"saveSuccessed");
        this.getProgressManager().popMessage(strSave);
        this.getUIWindow().close();
    }

    public ProgressManager getProgressManager() {
        if (this.procManager == null) {
            this.procManager = new ProgressManager((CoreUI)this);
            this.procManager.setMainStatusBar(this.getMainStatusBar());
            this.procManager.setProgressBar(ProgressManager.getProgressBar((CoreUI)this));
            this.procManager.setEstimateTime(5000);
        }
        return this.procManager;
    }

    private void setEditData() {
        this.editData.setName(this.txtName.getText().trim());
        this.editData.setNumber(this.txtNumber.getText().trim());
        this.editData.setServerAddr(this.txtServerAddress.getText().trim());
        this.editData.setCurrDirectory(this.txtServerDir.getText().trim());
        this.editData.setUserName(this.txtLoginName.getText().trim());
        this.editData.setPassPort(this.pwdText.getText().trim());
        if (this.rdoExcel.isSelected()) {
            this.editData.setUpdateReportType(UpdateReportTypeEnum.Excel);
        } else if (this.rdoWeb.isSelected()) {
            this.editData.setUpdateReportType(UpdateReportTypeEnum.UPF);
        }
    }

    private FunctionObjectInfo getForewarnFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.app.TimeImportReportFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    @Override
    public void actionPeriodControl_actionPerformed(ActionEvent e) throws Exception {
        super.actionPeriodControl_actionPerformed(e);
        this.setChange(true);
        String tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)this.getSchedule());
        if (tempSchedule != null) {
            this.setSchedule(tempSchedule);
            this.txtTimeArea.setText(tempSchedule);
        }
    }

    public void setChange(boolean isChange) {
        this.isChange = isChange;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Override
    protected void btnTest_actionPerformed(ActionEvent e) throws Exception {
        super.btnTest_actionPerformed(e);
        super.btnTest_actionPerformed(e);
        HashMap config = this.getServerConfig();
        try {
            new FTPUpDown(config.get("serverAddress").toString(), "", config.get("serverLoginName").toString(), config.get("serverLoginPassword").toString());
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"342_CSLReportImportUI"));
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"343_CSLReportImportUI"));
    }

    private HashMap getServerConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)this.txtServerAddress.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"365_CSLReportImportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtLoginName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"366_CSLReportImportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.pwdText.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"367_CSLReportImportUI"));
            SysUtil.abort();
        }
        config.put("serverAddress", this.txtServerAddress.getText().trim());
        config.put("serverDirectory", this.txtServerDir.getText().trim());
        config.put("serverLoginName", this.txtLoginName.getText().trim());
        config.put("serverLoginPassword", this.pwdText.getText().trim());
        return config;
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return new TimeImportReportInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TimeImportReportFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAbolish.setEnabled(true);
        this.btnOk.setEnabled(true);
        this.btnPeriodControl.setEnabled(true);
        this.btnPeriodControl.setIcon(EASResource.getIcon((String)"imgTbtn_cycattemper"));
        this.menuBiz.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionSubmit.setVisible(false);
    }

    public void scheduleTextChange() {
        if (this.txtTimeArea.getText() == null || this.txtTimeArea.getText().length() == 0) {
            this.txtTextDisPlay.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"CaclSolutonHasNotSchedule"));
        } else {
            this.txtTextDisPlay.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"CaclSolutonHasSchedule"));
        }
    }

    public boolean isModify() {
        return false;
    }
}

