/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IReportClass;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractTradeRptItemFillUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TradeRptItemFillUI
extends AbstractTradeRptItemFillUI {
    private static final Logger logger = CoreUIObject.getLogger(TradeRptItemFillUI.class);
    private List optionalRptItems = new ArrayList();
    private List selectedRptItems = new ArrayList();
    private List selRptItemsKey = new ArrayList();
    private Sheet sheet;
    private RPTItemGroupEnum group = RPTItemGroupEnum.TRADE;

    public TradeRptItemFillUI() throws Exception {
        this.initListeners();
    }

    private void initListeners() {
        this.chxOnlyShowEXItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TradeRptItemFillUI.this.comboItemType.getSelectedIndex() > 0) {
                    TradeRptItemFillUI.this.initOptionalRptItems((ReportClassInfo)TradeRptItemFillUI.this.comboItemType.getSelectedItem());
                } else {
                    TradeRptItemFillUI.this.initOptionalRptItems(null);
                }
            }
        });
        this.tbOptionalRptItems.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() > 1) {
                    try {
                        TradeRptItemFillUI.this.addAction_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.tbSelectedRptItems.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() > 1) {
                    try {
                        TradeRptItemFillUI.this.reduceAction_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.sheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        this.group = (RPTItemGroupEnum)((Object)this.getUIContext().get("itemGroup"));
        this.setUITitle(this.group);
        this.enableControl(this.group);
        this.initDataElement();
        this.initReportClass();
        this.initOptionalRptItems(null);
    }

    private void setUITitle(RPTItemGroupEnum group) {
        this.setUITitle((group.equals((Object)RPTItemGroupEnum.CUSSEND) ? EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"700_TradeRptItemFillUI") : EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"701_TradeRptItemFillUI")) + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"702_TradeRptItemFillUI"));
    }

    private void enableControl(RPTItemGroupEnum group) {
        if (group.equals((Object)RPTItemGroupEnum.CUSSEND)) {
            this.chxOnlyShowEXItem.setVisible(false);
        } else {
            this.chxOnlyShowEXItem.setVisible(true);
        }
    }

    private void initDataElement() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ISUSEDELIM", (Object)1));
        filter = this.getGradeSettingFilter(filter);
        view.setFilter(filter);
        DataElementCollection collection = DataElementFactory.getRemoteInstance().getDataElementCollection(view);
        this.cbxDataElement.addItems(collection.toArray());
        if (this.group.equals((Object)RPTItemGroupEnum.CUSSEND)) {
            for (int i = 0; i < collection.size(); ++i) {
                DataElementInfo e = collection.get(i);
                if (!e.getNumber().equalsIgnoreCase("EndBalance")) continue;
                this.cbxDataElement.setSelectedIndex(i);
                break;
            }
        }
    }

    private FilterInfo getGradeSettingFilter(FilterInfo filterInfo) {
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)"com.kingdee.eas.fi.gr.cslrpt.client.DataElementListUI", null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
    }

    private void initReportClass() throws BOSException {
        this.comboItemType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"));
        IReportClass iReportClass = ReportClassFactory.getRemoteInstance();
        ReportClassCollection collection = iReportClass.getReportClassCollection("select id, name");
        this.comboItemType.addItems(collection.toArray());
        this.comboItemType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    if (TradeRptItemFillUI.this.comboItemType.getSelectedIndex() > 0) {
                        TradeRptItemFillUI.this.initOptionalRptItems((ReportClassInfo)TradeRptItemFillUI.this.comboItemType.getSelectedItem());
                    } else {
                        TradeRptItemFillUI.this.initOptionalRptItems(null);
                    }
                }
            }
        });
    }

    private void initOptionalRptItems(ReportClassInfo reportClass) {
        this.tbOptionalRptItems.checkParsed();
        try {
            this.optionalRptItems.clear();
            RPTItemCollection rptItemCollection = this.getRptItemCollection(reportClass);
            this.tbOptionalRptItems.removeRows();
            this.tbOptionalRptItems.setRowCount(rptItemCollection.size());
            for (int i = 0; i < rptItemCollection.size(); ++i) {
                RPTItemInfo rptItem = rptItemCollection.get(i);
                this.optionalRptItems.add(rptItem);
                IRow row = this.tbOptionalRptItems.addRow(i);
                row.getCell(0).setValue((Object)rptItem.getId());
                row.getCell(1).setValue((Object)rptItem.getNumber());
                row.getCell(2).setValue((Object)rptItem.getName());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getRptItemCollection_BOSException", (Throwable)e);
        }
    }

    private RPTItemCollection getRptItemCollection(ReportClassInfo reportClass) throws BOSException {
        IRPTItem iRptItem = RPTItemFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSumItem", (Object)new Boolean(false)));
        if (this.chxOnlyShowEXItem.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("itemGroup", (Object)new Integer(this.group.getValue())));
        }
        if (reportClass != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportClass", (Object)reportClass.getId().toString()));
        }
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        viewInfo.setFilter(filter);
        try {
            CslGradeManageUtil.filterRptItemGradeManage((EntityViewInfo)viewInfo, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return iRptItem.getRPTItemCollection(viewInfo);
    }

    private int[] getSelectRows(KDTable table) {
        ArrayList<Integer> listRows = new ArrayList<Integer>();
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                listRows.add(new Integer(j));
            }
        }
        int[] rows = new int[listRows.size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (Integer)listRows.get(i);
        }
        listRows.clear();
        listRows = null;
        return rows;
    }

    @Override
    public void addAction_actionPerformed(ActionEvent e) throws Exception {
        super.addAction_actionPerformed(e);
        DataElementInfo dataElement = (DataElementInfo)this.cbxDataElement.getSelectedItem();
        int[] rows = this.getSelectRows(this.tbOptionalRptItems);
        for (int i = 0; i < rows.length; ++i) {
            RPTItemInfo rptItem = (RPTItemInfo)this.optionalRptItems.get(rows[i]);
            String key = rptItem.getNumber() + ";" + dataElement.getNumber();
            if (this.selRptItemsKey.contains(key)) continue;
            IRow row = this.tbSelectedRptItems.addRow(this.selectedRptItems.size());
            row.getCell(0).setValue((Object)rptItem.getId());
            row.getCell(1).setValue((Object)rptItem.getNumber());
            row.getCell(2).setValue((Object)rptItem.getName());
            row.getCell(3).setValue((Object)dataElement.getId());
            row.getCell(4).setValue((Object)dataElement.getName());
            ArrayList<Serializable> fillData = new ArrayList<Serializable>(2);
            fillData.add(rptItem);
            fillData.add(dataElement);
            this.selRptItemsKey.add(key);
            this.selectedRptItems.add(fillData);
        }
    }

    @Override
    public void addAllAction_actionPerformed(ActionEvent e) throws Exception {
        super.addAllAction_actionPerformed(e);
        DataElementInfo dataElement = (DataElementInfo)this.cbxDataElement.getSelectedItem();
        for (int i = 0; i < this.optionalRptItems.size(); ++i) {
            RPTItemInfo rptItem = (RPTItemInfo)this.optionalRptItems.get(i);
            String key = rptItem.getNumber() + ";" + dataElement.getNumber();
            if (this.selRptItemsKey.contains(key)) continue;
            IRow row = this.tbSelectedRptItems.addRow(this.selectedRptItems.size());
            row.getCell(0).setValue((Object)rptItem.getId());
            row.getCell(1).setValue((Object)rptItem.getNumber());
            row.getCell(2).setValue((Object)rptItem.getName());
            row.getCell(3).setValue((Object)dataElement.getId());
            row.getCell(4).setValue((Object)dataElement.getName());
            ArrayList<Serializable> fillData = new ArrayList<Serializable>(2);
            fillData.add(rptItem);
            fillData.add(dataElement);
            this.selRptItemsKey.add(key);
            this.selectedRptItems.add(fillData);
        }
    }

    @Override
    public void reduceAction_actionPerformed(ActionEvent e) throws Exception {
        super.reduceAction_actionPerformed(e);
        int[] rows = this.getSelectRows(this.tbSelectedRptItems);
        for (int i = rows.length - 1; i >= 0; --i) {
            this.tbSelectedRptItems.removeRow(rows[i]);
            List fillData = (List)this.selectedRptItems.remove(rows[i]);
            RPTItemInfo rptItem = (RPTItemInfo)fillData.get(0);
            DataElementInfo dataElement = (DataElementInfo)fillData.get(1);
            String key = rptItem.getNumber() + ";" + dataElement.getNumber();
            this.selRptItemsKey.remove(key);
        }
    }

    @Override
    public void reduceAllAction_actionPerformed(ActionEvent e) throws Exception {
        super.reduceAllAction_actionPerformed(e);
        this.tbSelectedRptItems.removeRows();
        this.selectedRptItems.clear();
        this.selRptItemsKey.clear();
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionMoveDown_actionPerformed(e);
        int[] rows = this.getSelectRows(this.tbSelectedRptItems);
        if (rows.length == 0 || rows[rows.length - 1] == this.selectedRptItems.size() - 1) {
            return;
        }
        for (i = rows.length - 1; i >= 0; --i) {
            if (rows[i] >= this.selectedRptItems.size()) continue;
            this.tbSelectedRptItems.exchangeRow(rows[i], rows[i] + 1);
            this.selectedRptItems.add(rows[i] + 1, this.selectedRptItems.remove(rows[i]));
            int n = i;
            rows[n] = rows[n] + 1;
        }
        if (rows.length == 1) {
            this.tbSelectedRptItems.getSelectManager().select(rows[0], 0);
        } else if (rows.length > 1) {
            this.tbSelectedRptItems.getSelectManager().removeAll(false);
            for (i = 0; i < rows.length; ++i) {
                this.tbSelectedRptItems.getSelectManager().add(rows[i], -1);
            }
        }
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionMoveUp_actionPerformed(e);
        int[] rows = this.getSelectRows(this.tbSelectedRptItems);
        if (rows.length == 0 || rows[0] == 0) {
            return;
        }
        for (i = 0; i < rows.length; ++i) {
            if (rows[i] <= 0) continue;
            this.tbSelectedRptItems.exchangeRow(rows[i], rows[i] - 1);
            this.selectedRptItems.add(rows[i] - 1, this.selectedRptItems.remove(rows[i]));
            int n = i;
            rows[n] = rows[n] - 1;
        }
        if (rows.length == 1) {
            this.tbSelectedRptItems.getSelectManager().select(rows[0], 0);
        } else if (rows.length > 1) {
            this.tbSelectedRptItems.getSelectManager().removeAll(false);
            for (i = 0; i < rows.length; ++i) {
                this.tbSelectedRptItems.getSelectManager().add(rows[i], -1);
            }
        }
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        CslRptUIUtil.fillDealRptItem(this.sheet, this.selectedRptItems, false);
        this.destroyWindow();
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }
}

