/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractUserDefinedRateEditUI;
import com.kingdee.eas.fi.newrpt.CslCustomerExChangeRateTabInfo;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserDefinedRateEditUI
extends AbstractUserDefinedRateEditUI {
    private static final long serialVersionUID = -6932312026310851825L;
    private static final int DEFALSE_PRECISION = 2;
    private CurrencyInfo defaultTargetCurrency = null;
    private DataCollectInfo defaultDataCollect = null;
    private static CslCustomerExChangeRateTabInfo rateInfo = null;

    public UserDefinedRateEditUI() throws Exception {
        this.jbInit();
        this.registerEvent();
    }

    private void jbInit() {
        this.SpCurPeriod.setEnabled(false);
        this.SpCurYear.setEnabled(false);
        this.pkAvailTime.setSupportedEmpty(false);
        this.btnSave.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.SpPrecision.setModel((SpinnerModel)new SpinnerNumberModel(3, 0, 10, 1));
        this.prmtDataElement.setReadOnly(false);
        this.prmtDataElement.setRequired(true);
        this.combCovertMode.setEnabled(false);
    }

    private void registerEvent() {
        this.SpPrecision.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer value = (Integer)UserDefinedRateEditUI.this.SpPrecision.getValue();
                UserDefinedRateEditUI.this.txtConvertRate.setPrecision(value.intValue());
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().containsKey("cslCustomerExChangeRateTabInfo")) {
            rateInfo = (CslCustomerExChangeRateTabInfo)this.getUIContext().get("cslCustomerExChangeRateTabInfo");
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            Map uiContext = this.getUIContext();
            this.prmtSourceCurrency.setValue(uiContext.get("sourceCurrency"));
            this.prmtTargetCurrency.setValue(uiContext.get("targetCurrency"));
            int year = (Integer)uiContext.get("year");
            int period = (Integer)uiContext.get("period");
            int periodType = ((RptPeriodTypeEnum)uiContext.get("periodType")).getValue();
            Date lastDate = (Date)RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType, 0, 0).get(2);
            this.pkAvailTime.setValue((Object)lastDate);
            this.comboPeriodType.setSelectedItem(uiContext.get("periodType"));
            this.SpCurYear.setValue(uiContext.get("year"));
            this.SpCurPeriod.setValue(uiContext.get("period"));
            DataElementInfo dataElementInfo = DataElementFactory.getRemoteInstance().getDataElementInfo("select * WHERE number = 'YTDAMOUNT'");
            this.prmtDataElement.setValue((Object)dataElementInfo);
            if (this.comboPeriodType.getItemCount() > 0) {
                this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            }
        }
        this.setUITitle();
        this.prmtDataElement.setEntityViewInfo(CslGradeManageUtil.filterDataElementGradeManage((EntityViewInfo)this.prmtDataElement.getEntityViewInfo(), null));
        this.combCovertMode.setSelectedItem((Object)ConvertModeEnum.USERDIFINEDEXCHAGERATE);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtSourceCurrency.setValue(this.getUIContext().get("sourceCurrency"));
        }
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.actionCopy.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionAddNew.setEnabled(true);
            this.actionCopy.setEnabled(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("isReversible"));
        sic.add(new SelectorItemInfo("period"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("sourceCurrency.*"));
        } else {
            sic.add(new SelectorItemInfo("sourceCurrency.id"));
            sic.add(new SelectorItemInfo("sourceCurrency.number"));
            sic.add(new SelectorItemInfo("sourceCurrency.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("targetCurrency.*"));
        } else {
            sic.add(new SelectorItemInfo("targetCurrency.id"));
            sic.add(new SelectorItemInfo("targetCurrency.number"));
            sic.add(new SelectorItemInfo("targetCurrency.name"));
        }
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("availTime"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("dataElement.*"));
        } else {
            sic.add(new SelectorItemInfo("dataElement.id"));
            sic.add(new SelectorItemInfo("dataElement.number"));
            sic.add(new SelectorItemInfo("dataElement.name"));
        }
        sic.add(new SelectorItemInfo("dataCollect"));
        sic.add(new SelectorItemInfo("convertRate"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        sic.add(new SelectorItemInfo("rateTabID"));
        sic.add(new SelectorItemInfo("convertMode"));
        return sic;
    }

    private void setUITitle() {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
    }

    @Override
    protected void pkAvailTime0_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo(this.pkAvailTime.getSqlDate());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.prmtSourceCurrency.getData();
        CurrencyInfo targetCurrency = (CurrencyInfo)this.prmtTargetCurrency.getData();
        if (sourceCurrency == null || targetCurrency == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_CurrencyIsNull")));
        }
        if (sourceCurrency.getNumber().equals(targetCurrency.getNumber())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"targetAndSourceCurrencyRepeat").replace("\"{0}\"", "")));
        }
        if (this.prmtDataElement.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElement_Blank")));
        }
        if (this.txtConvertRate.getBigDecimalValue() == null) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGERATE_CONVERTRATE_IS_NULL);
        }
        if (this.txtConvertRate.getBigDecimalValue().compareTo(new BigDecimal("0.000")) <= 0) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGERATE_CONVERTRATE_MUST_GREATER_THAN_ZERO);
        }
    }

    @Override
    protected void listPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.pkAvailTime.getSqlDate());
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.SpCurYear.setValue((Object)new Integer(times.get(0).toString()));
        this.SpCurPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.pkAvailTime.setValue(times.get(2));
    }

    protected IObjectValue createNewData() {
        UserDefinedRateInfo info = new UserDefinedRateInfo();
        info.setPeriodType((RptPeriodTypeEnum)this.getUIContext().get("periodType"));
        int year = (Integer)this.getUIContext().get("year");
        int period = (Integer)this.getUIContext().get("period");
        int periodType = ((RptPeriodTypeEnum)this.getUIContext().get("periodType")).getValue();
        Date lastDate = (Date)RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType, 0, 0).get(2);
        info.setYear(year);
        info.setPeriod(period);
        info.setAvailTime(lastDate);
        this.defaultTargetCurrency = (CurrencyInfo)this.getUIContext().get("targetCurrency");
        this.defaultDataCollect = (DataCollectInfo)this.getUIContext().get("dataCollect");
        info.setTargetCurrency(this.defaultTargetCurrency);
        info.setDataCollect(this.defaultDataCollect == null ? DataCollectConstant.getActualDC() : this.defaultDataCollect);
        info.setPrecision(2);
        info.setConvertMode(ConvertModeEnum.USERDIFINEDEXCHAGERATE);
        if (rateInfo != null) {
            info.setRateTabID(rateInfo);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserDefinedRateFactory.getRemoteInstance();
    }

    public boolean isModify() {
        return super.isModify();
    }

    @Override
    public void storeFields() {
        this.addRateTbl();
        this.addCreatrOrg();
        boolean b = this.editData.isSyncOldValue();
        this.editData.setSyncOldValue(true);
        this.editData.setConvertMode((ConvertModeEnum)((Object)this.combCovertMode.getSelectedItem()));
        this.editData.setSyncOldValue(b);
        super.storeFields();
        this.editData.setAvailTime(this.pkAvailTime.getSqlDate());
        if (OprtState.EDIT.equals(this.getOprtState()) && null != this.editData && this.editData.getDataCollect() == null) {
            this.editData.setDataCollect(this.defaultDataCollect == null ? DataCollectConstant.getActualDC() : this.defaultDataCollect);
        }
    }

    private void addCreatrOrg() {
        boolean b = this.editData.isSyncOldValue();
        this.editData.setSyncOldValue(true);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
        this.editData.setSyncOldValue(b);
    }

    private void addRateTbl() {
        if (this.getUIContext().containsKey("cslCustomerExChangeRateTabInfo")) {
            boolean b = this.editData.isSyncOldValue();
            this.editData.setSyncOldValue(true);
            CslCustomerExChangeRateTabInfo rateInfo = (CslCustomerExChangeRateTabInfo)this.getUIContext().get("cslCustomerExChangeRateTabInfo");
            this.editData.setRateTabID(rateInfo);
            this.editData.setSyncOldValue(b);
        }
    }
}

