/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IUserDefinedRate;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractUserDefinedRateListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ConvertRateArithmeticProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.UserDefinedRateEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.CslCustomerExChangeRateTabCollection;
import com.kingdee.eas.fi.newrpt.CslCustomerExChangeRateTabFactory;
import com.kingdee.eas.fi.newrpt.CslCustomerExChangeRateTabInfo;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.CslCustomerExChangeRateTabListUI;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class UserDefinedRateListUI
extends AbstractUserDefinedRateListUI {
    private static final long serialVersionUID = -5985188528479627178L;
    private static final Logger logger = CoreUIObject.getLogger(UserDefinedRateListUI.class);
    private OrgUnitInfo company = null;
    private Map<String, Object> condition = null;
    private boolean isSupport13Period = false;
    private boolean isMergeByFiscalPeriod = false;
    private TreeMap<Integer, List<Integer>> yearMap = new TreeMap();
    protected CommonQueryDialog dialog = null;
    private boolean isLoaded = false;
    private boolean isConfirm = false;

    public UserDefinedRateListUI() throws Exception {
        this.condition = new HashMap<String, Object>();
        this.company = SysContext.getSysContext().getCurrentOrgUnit();
    }

    public void onLoad() throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = values[0];
        this.isSupport13Period = values[1];
        this.mainQuery = new EntityViewInfo();
        this.init();
        this.actionQuery.setVisible(false);
        super.onLoad();
        this.actionQuery.setVisible(true);
        this.btnUpdateMaintainOrg.setVisible(false);
        this.btnQuery.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.isLoaded = true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    private void changeBtnSateByCreateCompany() {
        Object obj = this.getValueByColName("trackRecordCreatorid");
        if (obj == null) {
            return;
        }
        boolean b = obj.toString().endsWith(this.company.getId().toString());
        this.actionEdit.setEnabled(b);
        this.actionRemove.setEnabled(b);
        this.btnEdit.setEnabled(b);
        this.btnRemove.setEnabled(b);
        this.menuItemEdit.setEnabled(b);
        this.menuItemRemove.setEnabled(b);
    }

    private void updateCreateOrgName(ItemEvent e) {
        String txt = ((CslCustomerExChangeRateTabInfo)e.getItem()).getTrackRecordCreator().getName();
        this.txtCreateOrg.setText(txt);
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            SysUtil.abort();
        }
        this.isConfirm = true;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        boolean isSystem = true;
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                IRow row = this.tblMain.getRow(rowIndex);
                if (row == null) continue;
                ICell cell = row.getCell("isPreinstall");
                if (!Boolean.valueOf(cell.getValue().toString()).booleanValue()) {
                    isSystem = false;
                    continue;
                }
                list.add(rowIndex + 1);
            }
        }
        if (isSystem) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"PRE_CONFIM_NOT_DELETE");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        CslGradeManageUtilClient.judgeAndPromptSelectedRow((KDTable)this.tblMain, (int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (String)"trackRecordCreatorid", (String)this.company.getId().toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), (String)"noeqCreateOrgRemove");
        if (list.size() > 0) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                result.append(i + 1).append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NoCanRemove"), list.get(i))).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"removeBillFailInfo_title"), (String)new String(result), (int)8188);
        }
        super.actionRemove_actionPerformed(e);
    }

    protected boolean confirmRemove() {
        if (this.isConfirm) {
            return true;
        }
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList list = super.getSelectedIdValues();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null && !list.get(i).equals("")) continue;
            list.remove(i);
        }
        return list;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.beforeViewDetail("VIEW");
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeViewDetail("EDIT");
        super.actionEdit_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.beforeViewDetail("EDIT");
            if (e.getType() == 0) {
                return;
            }
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            if (actView.isEnabled()) {
                actView.actionPerformed(evt);
            }
            return;
        }
        super.tblMain_tableClicked(e);
    }

    private void beforeViewDetail(String oprtType) {
        this.checkSelected();
        if (Boolean.valueOf(this.getValueByColName("isPreinstall").toString()).booleanValue()) {
            String msg = "";
            if ("VIEW".equals(oprtType)) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"133_ReportConvtRate_Not_View");
            } else if ("REMOVE".equals(oprtType)) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"PRE_CONFIM_NOT_DELETE");
            } else if ("EDIT".equals(oprtType)) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"PRE_CONFIM_NOT_MODIFY");
            }
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String format;
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = UserDefinedRateListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && !this.isFirstDefaultQuery()) {
            if (this.dialog == null) {
                this.dialog = this.initCommonQueryDialog();
            }
            if (this.dialog.show()) {
                if (this.mainQuery.getSorter() != null) {
                    this.mainQuery.getSorter().clear();
                }
                this.cmbCusExchTable.getSelectedItem();
                this.mainQuery = this.getEntityViewInfo(this.dialog.getEntityViewInfoResult());
                this.doQuery(this.dialog);
                this.setMainOrgForCommonQueryDialog(this.dialog);
                this.refreshList();
            } else {
                SysUtil.abort();
            }
        }
        if ((format = CslRptUIUtil.getNationalDateFormatString()) != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("period").getStyleAttributes().setNumberFormat("@");
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject(null);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setTitle(this.getUITitle());
        return dialog;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                UserDefinedRateListUI.this.fillTable(e);
                int first = e.getFirstRow();
                int count = e.getLastRow() - e.getFirstRow() + 1;
                int indexOfCurPre = UserDefinedRateListUI.this.tblMain.getColumnIndex("precision");
                Object tmp = null;
                int precision = 2;
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                for (int i = first; i < first + count; ++i) {
                    tmp = UserDefinedRateListUI.this.tblMain.getRow(i).getCell(indexOfCurPre).getValue();
                    if (tmp != null && tmp instanceof Integer) {
                        precision = (Integer)tmp;
                    }
                    UserDefinedRateListUI.this.tblMain.getRow(i).getCell("convertRate").getStyleAttributes().setNumberFormat(this.getNumberFormat(precision, true));
                    if (UserDefinedRateListUI.this.tblMain.getRow(i).getCell("creator.name").getValue() != null && !StringUtils.isEmpty((String)UserDefinedRateListUI.this.tblMain.getRow(i).getCell("creator.name").getValue().toString())) continue;
                    UserDefinedRateListUI.this.tblMain.getRow(i).getCell("creator.name").setValue((Object)userInfo.getName());
                    UserDefinedRateListUI.this.tblMain.getRow(i).getCell("lastUpdateUser.name").setValue((Object)userInfo.getName());
                    UserDefinedRateListUI.this.tblMain.getRow(i).getCell("trackRecordCreatorName").setValue((Object)UserDefinedRateListUI.this.company.getName());
                }
            }

            private String getNumberFormat(int scale, boolean needkilobit) {
                StringBuffer sb = new StringBuffer("");
                if (needkilobit) {
                    sb.append("#,##");
                }
                sb.append("0");
                if (scale > 0) {
                    sb.append(".");
                    for (int i = 0; i < scale; ++i) {
                        sb.append("0");
                    }
                }
                sb.append("");
                return sb.toString() + ";(" + sb.toString() + ")";
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    UserDefinedRateListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    UserDefinedRateListUI.this.handUIException(exc);
                }
            }
        });
        this.cmbCusExchTable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    UserDefinedRateListUI.this.updateCreateOrgName(e);
                    UserDefinedRateListUI.this.changeBtnSateByCreateCompany();
                }
            }
        });
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.getExgTabId(true))) {
            this.tblMain.removeRows(false);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"17_Need_Maintain_RateTab"));
            return;
        }
        if (this.F7TargetCurrency.getValue() == null) {
            this.tblMain.removeRows(false);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"132_Need_Select_Currency"));
            return;
        }
        this.refreshTable();
    }

    private void refreshTable() {
        try {
            this.refreshList();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            this.handUIException(e);
        }
    }

    private void init() throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit != null && currentFIUnit.getBaseCurrency() != null) {
            String baseCurrencyId = currentFIUnit.getBaseCurrency().getId().toString();
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyId));
            this.F7TargetCurrency.setValue((Object)currencyInfo);
            CurrencyCollection col = iCurrency.getCurrencyCollection("select id, number, name where id <> '" + baseCurrencyId + "' and deletedStatus = 1 order by number");
            if (col != null && col.size() > 0) {
                this.F7SourceCurrency.setValue((Object)col.get(0));
            }
        }
        this.cmbPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        int[] yearPeriod = this.getCurrentPeriod(currentFIUnit);
        this.spnYear.setValue((Object)yearPeriod[0]);
        this.spnPeriod.setValue((Object)yearPeriod[1]);
        this.initSpinnerVal();
        Object[] custExgRateTabls = this.getCustExchRateTab();
        this.cmbCusExchTable.addItems(custExgRateTabls);
        if (custExgRateTabls.length > 0) {
            this.cmbCusExchTable.setSelectedItem((Object)0);
            this.txtCreateOrg.setText(((CslCustomerExChangeRateTabInfo)custExgRateTabls[0]).getTrackRecordCreator().getName());
        }
    }

    private int[] getCurrentPeriod(CompanyOrgUnitInfo currentFIUnit) throws EASBizException, BOSException {
        PeriodCollection periodCollection = InitDataFacadaFactory.getRemoteInstance().getFiscal((IObjectPK)new ObjectUuidPK(RptNewUIUtil.getDelegateCompany((OrgType)OrgType.Company, (String)currentFIUnit.getId().toString()).getId()));
        this.yearMap.clear();
        if (periodCollection != null && periodCollection.size() > 0) {
            for (int i = 0; i < periodCollection.size(); ++i) {
                Integer year = periodCollection.get(i).getPeriodYear();
                Integer period = periodCollection.get(i).getPeriodNumber();
                List<Integer> periodVec = this.yearMap.get(year);
                if (periodVec == null) {
                    periodVec = new ArrayList<Integer>(12);
                    this.yearMap.put(year, periodVec);
                }
                periodVec.add(period);
            }
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"FiscalPeriodIsNotExist"));
            SysUtil.abort();
        }
        try {
            CompanyOrgUnitInfo company = RptNewUIUtil.getDelegateCompany((OrgType)OrgType.Company, (OrgUnitInfo)currentFIUnit);
            return RptNewUIUtil.getFICurrPeriod((CompanyOrgUnitInfo)company);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    private void setSpinnerMinMaxVal() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (this.isMergeByFiscalPeriod && !RptPeriodTypeEnum.DAILY.equals((Object)periodType) && !RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.spnPeriod, periodType, false);
        } else {
            this.setPeriodRange(this.spnPeriod, periodType.getValue(), (Integer)this.spnYear.getValue());
        }
    }

    protected void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                max = 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        CslRptUIUtil.setSpineRange(sp, min, max);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"targetCurrency", this.F7TargetCurrency.getData());
        uiContext.put((Object)"sourceCurrency", this.F7SourceCurrency.getData());
        uiContext.put((Object)"year", this.spnYear.getValue());
        uiContext.put((Object)"period", this.spnPeriod.getValue());
        uiContext.put((Object)"periodType", this.cmbPeriodType.getSelectedItem());
        uiContext.put((Object)"CustExgTab", (Object)this.cmbCusExchTable);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo newview = this.getNewViewInfo(viewInfo);
        return super.getQueryExecutor(queryPK, newview);
    }

    private EntityViewInfo getNewViewInfo(EntityViewInfo viewInfo) {
        EntityViewInfo newView;
        block12: {
            Object obj = this.F7SourceCurrency.getValue();
            Object obj2 = this.F7TargetCurrency.getValue();
            CurrencyInfo sourceCurrency = null;
            CurrencyInfo targetCurrency = null;
            if (!(obj instanceof CurrencyInfo)) {
                this.F7SourceCurrency.setValue(null);
            } else {
                sourceCurrency = (CurrencyInfo)obj;
            }
            if (!(obj2 instanceof CurrencyInfo)) {
                this.F7TargetCurrency.setValue(null);
            } else {
                targetCurrency = (CurrencyInfo)obj2;
            }
            FilterInfo filter = new FilterInfo();
            if (sourceCurrency != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.number", (Object)sourceCurrency.getNumber()));
            }
            if (targetCurrency != null) {
                filter.getFilterItems().add(new FilterItemInfo("targetCurrency.number", (Object)targetCurrency.getNumber()));
            }
            if (this.cmbPeriodType.getSelectedItem() != null) {
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()).getValue()));
            }
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.spnYear.getIntegerVlaue()));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.spnPeriod.getIntegerVlaue()));
            if (this.cmbCusExchTable.getSelectedItem() != null) {
                String orgId = ((CslCustomerExChangeRateTabInfo)this.cmbCusExchTable.getSelectedItem()).getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("rateTabID.id", (Object)orgId));
            }
            newView = (EntityViewInfo)viewInfo.clone();
            try {
                FilterInfo filter2 = newView.getFilter();
                if (filter2 == null || filter2.getFilterItems().size() == 0) {
                    newView.setFilter(filter);
                } else {
                    filter2.mergeFilter(filter, "and");
                }
            }
            catch (BOSException e) {
                if (!logger.isDebugEnabled()) break block12;
                logger.debug((Object)e);
            }
        }
        return newView;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"convertRate", "sourceCurrency.name"};
        return locateNames;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserDefinedRateFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return UserDefinedRateEditUI.class.getName();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actrionRateMaintain_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String rateTabListUI = CslCustomerExChangeRateTabListUI.class.getName();
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(rateTabListUI, (Map)uiContext);
        window.show();
        if (window.close()) {
            try {
                String id = "";
                Object obj = this.cmbCusExchTable.getSelectedItem();
                if (obj != null && obj instanceof CslCustomerExChangeRateTabInfo) {
                    id = ((CslCustomerExChangeRateTabInfo)obj).getId().toString();
                }
                this.cmbCusExchTable.removeAllItems();
                Object[] items = this.getCustExchRateTab();
                int index = 0;
                if (items != null && items.length > 0) {
                    for (int i = 0; i < items.length; ++i) {
                        if (!(items[i] instanceof CslCustomerExChangeRateTabInfo) || !id.equals(((CslCustomerExChangeRateTabInfo)items[i]).getId().toString())) continue;
                        index = i;
                        break;
                    }
                }
                this.cmbCusExchTable.addItems(items);
                if (items.length > index) {
                    this.cmbCusExchTable.setSelectedIndex(index, false);
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
            catch (ParserException e1) {
                this.handUIException(e1);
            }
        }
    }

    private Object[] getCustExchRateTab() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CslGradeManageUtil.getUpSqlPub((FilterInfo)filter, (String)"trackRecordCreator.id");
        view.setFilter(filter);
        SelectorItemCollection scoll = view.getSelector();
        scoll.add(new SelectorItemInfo("id"));
        scoll.add(new SelectorItemInfo("number"));
        scoll.add(new SelectorItemInfo("name"));
        scoll.add(new SelectorItemInfo("trackRecordCreator.id"));
        scoll.add(new SelectorItemInfo("trackRecordCreator.name"));
        scoll.add(new SelectorItemInfo("exchTable.id"));
        scoll.add(new SelectorItemInfo("exchTable.name"));
        scoll.add(new SelectorItemInfo("exchTable.number"));
        view.setSelector(scoll);
        CslCustomerExChangeRateTabCollection col = CslCustomerExChangeRateTabFactory.getRemoteInstance().getCslCustomerExChangeRateTabCollection(view);
        if (col != null) {
            return col.toArray();
        }
        return new Object[0];
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.cmbCusExchTable.getSelectedItem();
        if (obj == null) {
            return;
        }
        CslCustomerExChangeRateTabInfo info = (CslCustomerExChangeRateTabInfo)obj;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"cslCustomerExChangeRateTabInfo", (Object)info);
        this.getUIContext().putAll(uiContext);
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_UserDefinedRate", (String)"FTrackRecordCreatorID", (ArrayList)this.getSelectedIdValues());
    }

    @Override
    public void actionArithmeticProcess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        this.constructCondition(this.condition);
        ((Map)this.condition.get("KEY_BASE")).put("KEY_SOURCECURRENCY", this.getValueByColName("sourceCurrency.id"));
        ((Map)this.condition.get("KEY_BASE")).put("KEY_BASE_TARGETCY", this.getValueByColName("targetCurrency.id"));
        uiContext.putAll(this.condition);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ConvertRateArithmeticProcessUI.class.getName(), (Map)uiContext);
        window.show();
    }

    @Override
    public void actionCopyRate_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.getExgTabId(true))) {
            this.tblMain.removeRows(false);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"17_Need_Maintain_RateTab"));
            return;
        }
        if (this.F7TargetCurrency.getValue() == null) {
            this.tblMain.removeRows(false);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"132_Need_Select_Currency"));
            return;
        }
        Map map = ((IUserDefinedRate)this.getBizInterface()).copyRate(this.constructCondition(this.condition), -1, false);
        if (map != null && map.keySet().size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"134_CopyRate_Suc", (Object[])new Object[]{map.keySet().size()}));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"135_No_LastRate"));
        }
        this.refreshTable();
    }

    @Override
    protected void cmbPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.isLoaded) {
            this.initSpinnerVal();
        }
    }

    private void setEnabled() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeEnum.DAILY.equals((Object)periodType) || RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            this.contYear.setEnabled(false);
            this.contPeriod.setEnabled(false);
        } else {
            this.contYear.setEnabled(true);
            this.contPeriod.setEnabled(true);
        }
    }

    private void initSpinnerVal() {
        this.setSpinnerMinMaxVal();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (periodType == null) {
            return;
        }
        int[] yearperiod = RPTDateUtil.getPeriod(new Date(), periodType);
        this.spnYear.setValue((Object)yearperiod[0]);
        this.spnPeriod.setValue((Object)yearperiod[1]);
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
        if (!this.isLoaded) {
            return;
        }
        int from = (Integer)e.getParam1();
        try {
            this.constructCondition(this.condition);
            if (StringUtils.isEmpty((String)((Map)this.condition.get("KEY_BASE")).get("KEY_BASE_EXCHANGETABLE").toString())) {
                return;
            }
            if (StringUtils.isEmpty((String)((Map)this.condition.get("KEY_BASE")).get("KEY_BASE_TARGETCY").toString())) {
                return;
            }
            Map result = ((IUserDefinedRate)this.getBizInterface()).getConvertRateData(this.condition);
            List rowData = (List)result.get("rowData");
            Object[][] data = this.wrappedCorrectData(rowData);
            if (data == null) {
                return;
            }
            KDTableUtil.insertRows((Object[][])data, null, (int)from, (KDTable)this.tblMain);
        }
        catch (Exception ex) {
            this.tblMain.setRowCount(0);
            this.handUIExceptionAndAbort(ex);
        }
    }

    private Object[][] wrappedCorrectData(List table) {
        if (table == null) {
            return null;
        }
        if (table.size() <= 0) {
            return null;
        }
        int colCount = ((Map)table.get(0)).keySet().size();
        Object[][] result = new Object[table.size()][colCount];
        KDTColumns columns = this.tblMain.getColumns();
        int cols = Math.min(result[0].length, this.tblMain.getColumnCount());
        int c = table.size();
        for (int i = 0; i < c; ++i) {
            Map row = (Map)table.get(i);
            for (int j = 0; j < cols; ++j) {
                result[i][j] = row.get(columns.getColumn(j).getKey());
            }
        }
        return result;
    }

    private Map<String, Object> constructCondition(Map<String, Object> condition) {
        HashMap<String, String> baseMap = new HashMap<String, String>();
        baseMap.put("KEY_SOURCECURRENCY", this.getCurrencyId(this.F7SourceCurrency));
        baseMap.put("KEY_BASE_TARGETCY", this.getCurrencyId(this.F7TargetCurrency));
        baseMap.put("KEY_BASE_EXCHANGETABLE", this.getExgTabId(true));
        baseMap.put("KEY_BASE_CUSTOMERATETABLE", this.getExgTabId(false));
        baseMap.put("KEY_BASE_SCHEME", "");
        condition.put("KEY_BASE", baseMap);
        condition.put("year", this.spnYear.getValue());
        condition.put("period", this.spnPeriod.getValue());
        condition.put("periodType", (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem());
        condition.put("dataElement", this.getValueByColName("dataElement.interSeq"));
        condition.put("dataElementName", this.getValueByColName("dataElement.name"));
        condition.put("convertMode", this.getValueByColName("convertMode"));
        condition.put("isFromReportsystem", "");
        condition.put("exgTabName", this.getExgTabName());
        condition.put("curCompanyId", this.company.getId().toString());
        condition.put("isPreinstall", this.getValueByColName("isPreinstall"));
        condition.put("convertRate", this.getFormattedValueByColName("convertRate"));
        return condition;
    }

    private Object getValueByColName(String columnName) {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return "";
        }
        return this.tblMain.getRow(selectRow).getCell(columnName).getValue();
    }

    private Object getFormattedValueByColName(String columnName) {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return "";
        }
        return this.tblMain.getRow(selectRow).getCell(columnName).getFormattedValue();
    }

    private String getCurrencyId(KDBizPromptBox f7) {
        Object obj = f7.getValue();
        if (obj != null && obj instanceof CurrencyInfo) {
            return ((CurrencyInfo)obj).getId().toString();
        }
        return "";
    }

    private String getExgTabId(boolean isBase) {
        Object obj = this.cmbCusExchTable.getSelectedItem();
        if (obj != null && obj instanceof CslCustomerExChangeRateTabInfo) {
            ExchangeTableInfo exchTable = ((CslCustomerExChangeRateTabInfo)obj).getExchTable();
            if (isBase) {
                if (exchTable != null) {
                    return exchTable.getId().toString();
                }
            } else {
                return ((CslCustomerExChangeRateTabInfo)obj).getId().toString();
            }
        }
        return "";
    }

    private String getExgTabName() {
        ExchangeTableInfo exchTable;
        Object obj = this.cmbCusExchTable.getSelectedItem();
        if (obj != null && obj instanceof CslCustomerExChangeRateTabInfo && (exchTable = ((CslCustomerExChangeRateTabInfo)obj).getExchTable()) != null) {
            return exchTable.getName();
        }
        return "";
    }

    public ArrayList getSelectedIdValuesArrayList() {
        ArrayList ids = super.getSelectedIdValuesArrayList();
        ArrayList idList = new ArrayList();
        for (Object obj : ids) {
            if (obj == null || StringUtils.isEmpty((String)obj.toString())) continue;
            idList.add(obj);
        }
        return idList;
    }
}

