/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Vector;

public final class Util {
    public static Window getWindow(Component component) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public static Component getComponent(Component component, String targetName) {
        Component child = component;
        Container parent = child.getParent();
        while (parent != null) {
            child = parent;
            String name = child.getClass().getName();
            if (name == null) continue;
            if (name.equalsIgnoreCase(targetName)) {
                return child;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static BOSUuid getOrgID(String queryName) throws BOSException, EASBizException {
        return QueryUtils.getOrgID((String)queryName, null);
    }

    public static QuerySolutionCollection justOneDefaultSolutionVisible(QuerySolutionCollection querySolutionCollection) {
        QuerySolutionCollection ret = new QuerySolutionCollection();
        if (querySolutionCollection != null) {
            boolean addedSystem = false;
            for (int i = 0; i < querySolutionCollection.size(); ++i) {
                QuerySolutionInfo qSolutionInfo = querySolutionCollection.get(i);
                if (!qSolutionInfo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) {
                    ret.add(qSolutionInfo);
                    continue;
                }
                if (!qSolutionInfo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION) || addedSystem) continue;
                ret.add(qSolutionInfo);
                addedSystem = true;
            }
        }
        return ret;
    }

    protected static KDComboBox createShareTypeComboBox(int showShareType, boolean hasOrg) {
        KDComboBox shareTypeComboBox = new KDComboBox();
        Vector<ShareTypeEnum> vect = new Vector<ShareTypeEnum>();
        if (showShareType == 0) {
            vect.add(ShareTypeEnum.USER_LEVEL);
            vect.add(ShareTypeEnum.USER_NOORG_LEVEL);
            vect.add(ShareTypeEnum.ORG_LEVEL);
        } else {
            if ((showShareType & 1) == 1) {
                vect.add(ShareTypeEnum.USER_LEVEL);
            }
            if ((showShareType & 2) == 2) {
                vect.add(ShareTypeEnum.ORG_LEVEL);
            }
            if ((showShareType & 8) == 8) {
                vect.add(ShareTypeEnum.CU_LEVEL);
            }
            if ((showShareType & 4) == 4) {
                vect.add(ShareTypeEnum.PUBLIC_LEVEL);
            }
            if ((showShareType & 0x10) == 16) {
                vect.add(ShareTypeEnum.USER_NOORG_LEVEL);
            }
        }
        if (!hasOrg) {
            shareTypeComboBox.removeItem((Object)ShareTypeEnum.ORG_LEVEL);
        }
        shareTypeComboBox = new KDComboBox(vect);
        return shareTypeComboBox;
    }

    public static QueryInfo getQueryInfo(String queryName) {
        return QueryUtils.getQueryInfo(null, (String)queryName);
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        return QueryUtils.getQueryInfo(null, (IMetaDataPK)queryPK);
    }

    public static SelectorItemCollection getDynSelector(EntityViewInfo evInfo) {
        SelectorItemCollection coll = new SelectorItemCollection();
        SelectorItemCollection oldColl = evInfo.getSelector();
        int size = oldColl.size();
        for (int i = 0; i < size; ++i) {
            String isDynField = oldColl.get(i).getExtendedProperty("isDynQueryField");
            if (isDynField == null || !isDynField.equals("true") || (isDynField = oldColl.get(i).getExtendedProperty("isVisibleInTable")) == null || !isDynField.equals("true")) continue;
            coll.add((SelectorItemInfo)oldColl.get(i).clone());
        }
        return coll;
    }

    public static EntityViewInfo getEntityViewInfoByDynQuery(QueryInfo queryInfo, BOSUuid dynQueryId) {
        return QueryUtils.getEntityViewInfoByDynQuery(null, (QueryInfo)queryInfo, (BOSUuid)dynQueryId);
    }

    public static QueryInfo getDyFilterQuery(QueryInfo queryInfo, EntityViewInfo dynViewInfo) {
        return com.kingdee.eas.base.commonquery.client.Util.getDyFilterQuery((QueryInfo)queryInfo, (EntityViewInfo)dynViewInfo);
    }

    public static void mergeDynQueryEntityViewInfo(EntityViewInfo resultEntityViewInfo, EntityViewInfo dynEntityViewInfo) {
        QueryUtils.mergeDynQueryEntityViewInfo((EntityViewInfo)resultEntityViewInfo, (EntityViewInfo)dynEntityViewInfo);
    }

    protected static String getOrigialTableParams(QueryInfo info, Component owner) {
        return com.kingdee.eas.base.commonquery.client.Util.getOrigialTableParams((QueryInfo)info, (Component)owner);
    }
}

