/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportMenuManager;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;

public class DiffTableMenuManager
extends BaseReportMenuManager {
    public void applyMenuState(ReportMenuState state) {
        super.applyMenuState(state);
        CslReportInfo cslReportInfo = (CslReportInfo)state.getBookProvider().getEditValue();
        if (OprtState.ADDNEW.equals(state.getEditState())) {
            this.initMenuAddState(cslReportInfo);
        } else if (OprtState.EDIT.equals(state.getEditState())) {
            this.initMenuEditState(cslReportInfo);
        } else if (OprtState.VIEW.equals(state.getEditState())) {
            this.initMenuViewState(cslReportInfo);
        }
        this.enableVisibleMenu("menuEdit/menuSumRange", false, false);
        this.enableVisibleMenu("menuData/itemCheckFormula", false, false);
        this.enableVisibleMenu("menuData/itemItemDiffer", false, false);
        this.enableVisibleMenu("menuData/itemCheckAll", false, false);
        this.enableVisibleMenu("menuFind", false, false);
        this.enableVisibleMenu("menuTool/menuItemFormulaFill", false, false);
        this.enableVisibleMenu("menuTool/menuConvert", false, false);
        this.enableVisibleMenu("menuTool/menuReportRound", false, false);
        this.enableVisibleMenu("menuTool/menuItemAttachement", false, false);
        this.enableVisibleMenu("menuTool/menuItemSheeSum", false, false);
    }

    private void initMenuAddState(CslReportInfo cslReportInfo) {
        this.initMenuEditState(cslReportInfo);
    }

    private void initMenuEditState(CslReportInfo cslReportInfo) {
        int dynamicType = cslReportInfo.getTemplate().getDynaRptType().getValue();
        if (dynamicType == DynaEnumRptTypeEnum.DYNAMIC.getValue()) {
            this.enableVisibleMenu("menuTool/itemDynaItemFillWizard", true, true);
        } else {
            this.enableVisibleMenu("menuTool/itemDynaItemFillWizard", false, false);
        }
    }

    private void initMenuViewState(CslReportInfo cslReportInfo) {
    }

    public void applyCommonMenu(ReportMenuState state) {
        super.applyCommonMenu(state);
        this.enableVisibleMenu("menuEdit/menuSumRange", false, false);
        this.enableVisibleMenu("menuView/menuItemViewSumRange", false, false);
        this.enableVisibleMenu("menuData/menuItemCalculateSelectedSheet", true, true);
        this.enableVisibleMenu("menuData/menuMultiCalculate", false, false, true);
        this.enableVisibleMenu("menuFind/findAccount/itemFindIndexData", false, false);
        boolean isView = OprtState.VIEW.equals(state.getEditState());
        this.enableVisibleMenu("menuFile/menuItemImport", !isView, !isView);
        this.enableVisibleMenu("menuFile/itemImportData", !isView, !isView);
        this.enableVisibleMenu("menuData/menuItemAutoFillAndCalculateSelectedSheet", false, false);
        this.enableVisibleMenu("menuData/menuItemAutoFillAndCalculateAllSheet", false, false);
    }

    protected void refreshAuditMenu(ReportMenuState state) {
        super.refreshAuditMenu(state);
        CslReportInfo cslReport = (CslReportInfo)state.getBookProvider().getEditValue();
        boolean isAudited = cslReport.getAuditedStatus().getValue() == 2;
        boolean isUnCommitted = cslReport.getCommittedStatus().getValue() == 1;
        boolean isCommitted = cslReport.getCommittedStatus().getValue() == 2;
        boolean isTopLevel = false;
        try {
            isTopLevel = CslRptUtil.isCslTopLevelAtClient(cslReport);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (isTopLevel) {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, true);
            this.enableVisibleMenu("menuTool/itemRptCommit", false, false);
            this.enableVisibleMenu("menuTool/itemRptUnCommit", false, false);
        } else {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, isUnCommitted);
            this.enableVisibleMenu("menuTool/itemRptCommit", false, false);
            this.enableVisibleMenu("menuTool/itemRptUnCommit", false, false);
        }
    }
}

