/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.RptItemFormulaFillEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.report.WizardCompanyPage;
import com.kingdee.eas.fi.gr.cslrpt.client.report.WizardItemPage;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.client.wizard.Wizard;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class FillSumedCompanyWizardCtrl
extends Wizard {
    private WizardItemPage page1 = null;
    private WizardCompanyPage page2 = null;
    private Sheet sheet;
    private CslReportInfo cslReport;

    FillSumedCompanyWizardCtrl() {
    }

    public void addPages() {
        super.addPages();
        try {
            this.page1 = new WizardItemPage();
            this.page2 = new WizardCompanyPage();
            this.addPage(this.page1);
            this.page2.setPreviousPage(this.page1);
            this.addPage(this.page2);
            this.page1.setSheet(this.sheet);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void setSheet(CslReportInfo cslReport, Sheet sheet2) {
        this.cslReport = cslReport;
        this.sheet = sheet2;
    }

    public boolean performFinish() {
        List result = this.page2.getResult();
        if (result == null || result.size() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"619_FillSumedCompanyWizard"));
            return false;
        }
        int col = this.sheet.getActiveCol();
        int row = this.sheet.getActiveRow();
        OrgTreeInfo orgtree = null;
        try {
            Vector types = this.page1.constructType();
            ArrayList items = this.page1.getRptArrSelected();
            int mycol = col + 1;
            for (int i = 0; i < items.size(); ++i) {
                RPTItemInfo info = (RPTItemInfo)items.get(i);
                for (int j = 0; j < types.size(); ++j) {
                    Cell colHead = this.sheet.getCell(row, mycol, true);
                    RptItemFormulaFillEditUI.ItemType itemType = (RptItemFormulaFillEditUI.ItemType)types.get(j);
                    String type = itemType.getDataElement().getName();
                    if (type == null) {
                        type = "";
                    }
                    colHead.setValue(new Variant((Object)(info.getName() + "(" + type + "\\" + itemType.getValueType().getAlias() + ")")));
                    ++mycol;
                }
            }
            orgtree = CSLContextHelper.getCSLContext().getCurOrgBound();
            int Top_Level = Integer.MAX_VALUE;
            for (int i = 0; i < result.size(); ++i) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)result.get(i);
                int level = info.getLongNumber().split("!").length;
                info.setLevel(level);
                if (level >= Top_Level) continue;
                Top_Level = level;
            }
            int year = this.page1.getYear();
            int period = this.page1.getPeriod();
            for (int i = 0; i < result.size(); ++i) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)result.get(i);
                Cell rowHead = this.sheet.getCell(row + i + 1, col, true);
                int level = info.getLongNumber().split("!").length;
                rowHead.setValue(new Variant((Object)(this.getBlank(level) + info.getName())));
                Cell myrow = this.sheet.getCell(row + i + 1, 0, true);
                myrow.setUserObject("Company_level", (Object)new Integer(level));
                mycol = col + 1;
                for (int j = 0; j < items.size(); ++j) {
                    RPTItemInfo item = (RPTItemInfo)items.get(j);
                    for (int k = 0; k < types.size(); ++k) {
                        RptItemFormulaFillEditUI.ItemType itemType = (RptItemFormulaFillEditUI.ItemType)types.get(k);
                        StringBuffer sb = new StringBuffer();
                        sb.append("=AcctItem(\"").append(orgtree.getNumber()).append("\",\"").append(info.getNumber()).append("\",\"").append(this.cslReport.getSourceCurrency().getNumber()).append("\",\"").append(this.cslReport.getCurrency().getNumber()).append("\",\"").append(item.getNumber()).append("\",\"").append(item.getNumber()).append("\",\"").append(this.cslReport.getPeriodType().getName()).append("\",").append(year).append(",").append(period).append(",").append(period).append(",\"").append(info.isIsUnion() ? RptSrcTypeEnum.CONSOLIDATION.getName() : RptSrcTypeEnum.NORMAL.getName()).append("\",\"").append(itemType.getDataElement().getNumber()).append("\",\"").append(itemType.getValueType().getName()).append("\",False)");
                        Cell cell = this.sheet.getCell(row + i + 1, mycol, true);
                        cell.setFormula(sb.toString());
                        ++mycol;
                        if (level <= Top_Level + 1) continue;
                        this.sheet.getRange(row + i + 1, 0).setRowHidden(true);
                    }
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        return true;
    }

    private String getBlank(int c) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c - 1; ++i) {
            sb.append(' ').append(' ');
        }
        return sb.toString();
    }
}

