/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.template;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IInvestCheck;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ReportSheetManagerListener;
import com.kingdee.eas.fi.newrpt.client.designer.SheetManagerUI;
import com.kingdee.eas.fi.newrpt.client.designer.event.VariableChangeEvent;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CSLReportSheetManagerListener
extends ReportSheetManagerListener {
    public CSLReportSheetManagerListener(Book book) {
        super(book);
    }

    public void applyChange(VariableChangeEvent e) {
        if (!this.checkInput(e)) {
            return;
        }
        ReportVariables oldvariables = ReportVariables.loadFromBook((Book)this.getBook());
        super.applyChange(e);
        List sheets = e.getSheets();
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry en = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            Sheet sheet = this.getBook().getSheet(en.getSheetName());
            if (sheet == null) continue;
            int oldType = oldvariables.getIntValue("SheetClass", en.getOriginalSheetName(), 1);
            int newType = e.getReportVariables().getIntValue("SheetClass", en.getOriginalSheetName(), 1);
            if (this.getBook().getUserObject("PeriodType") != null && !this.getBook().getUserObject("PeriodType").getValue().equals(RptPeriodTypeEnum.MONTHLY) && newType == 40) {
                e.setCancel(true);
                e.setMsg(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"694_CSLReportSheetManagerListener"));
                return;
            }
            if (oldType != newType && (newType == 30 || newType == 40)) {
                this.clearSheet(this.getBook().getSheet(en.getSheetName()));
            }
            if ((oldType == 30 || oldType == 40) && newType != 30 && newType != 40) {
                this.clearSheet(this.getBook().getSheet(en.getSheetName()));
            }
            if (newType == 30 && CslRptUtil.getBasePosition(sheet) == null) {
                try {
                    this.createInvestSheet(sheet, false);
                }
                catch (Exception e1) {
                    e.setCancel(true);
                    e.setMsg(e1.getMessage());
                }
            }
            if (newType != 40 || CslRptUtil.getBasePosition(sheet) != null) continue;
            try {
                this.createInvestSheet(sheet, true);
                continue;
            }
            catch (Exception e1) {
                e.setCancel(true);
                e.setMsg(e1.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSheet(Sheet sheet) {
        boolean benable = this.getBook().getUndoManager().isEnable();
        this.getBook().getUndoManager().enable(false);
        try {
            Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
            while (it.hasNext()) {
                Cell cell = it.next();
                cell.setFormula(null);
                cell.setValue(Variant.nullVariant);
                cell.setUserObject("ITEM", null);
                sheet.getRange(cell).setCellLocked(false);
            }
            sheet.setUserObject("CSL_TEMPLATE_BASEPOSITION", null);
        }
        finally {
            this.getBook().getUndoManager().enable(benable);
        }
    }

    private boolean checkInput(VariableChangeEvent ev) {
        List sheets = ev.getSheets();
        int right_count = 0;
        boolean elim_count = false;
        boolean inter_count = false;
        for (SheetManagerUI.SheetPropertyEntry e : sheets) {
            int type;
            if (e.isDummy() || e.deleted() || (type = ev.getReportVariables().getIntValue("SheetClass", e.getSheetName(), 1)) != 30 && type != 40 || ++right_count < 2) continue;
            ev.setCancel(true);
            ev.setMsg(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Right_Benefit"));
            return false;
        }
        return true;
    }

    protected void applySheets(List sheets) {
        super.applySheets(sheets);
    }

    protected void applyVariables(VariableChangeEvent e, ReportVariables variables) {
        super.applyVariables(e, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInvestSheet(Sheet sheet, boolean isNew) throws Exception {
        Map itemsMap = this.getItemControlInRpt(isNew);
        if (isNew) {
            itemsMap.remove(new Integer(6));
        } else if (itemsMap.get(new Integer(6)) == null) {
            throw new InvestCheckException(InvestCheckException.NOTEXISTS_INVESTDIFF);
        }
        DataElementInfo deEndbalance = DataElementProvider.getDataElementInfo(4);
        DataElementInfo deAmount = DataElementProvider.getDataElementInfo(2);
        DataElementInfo deYtdamount = DataElementProvider.getDataElementInfo(3);
        int iTop = sheet.getActiveRow();
        int iLeft = sheet.getActiveCol();
        Set set = itemsMap.keySet();
        int i = 0;
        sheet.getBook().getUndoManager().startGroup();
        try {
            for (Integer key : set) {
                ItemFormula itemFormula;
                StringBuffer formulaString;
                Range range;
                String nameAndNumber = (String)itemsMap.get(key);
                String itemNumber = nameAndNumber.split("@@@")[1];
                String itemName = nameAndNumber.split("@@@")[0];
                if (key != 9) {
                    range = sheet.getRange(iTop, iLeft + i + 1);
                    formulaString = new StringBuffer();
                    formulaString.append("=Item(\"").append(itemNumber);
                    formulaString.append("\",0,0,\"").append(deEndbalance.getNumber());
                    formulaString.append("\",\"MONEY\")");
                    itemFormula = new ItemFormula(formulaString.toString());
                    range.setUserObject("ITEM", (Object)itemFormula);
                    range.setValue(new Variant((Object)(itemName + "(" + deEndbalance.getName() + ")")));
                    ++i;
                    continue;
                }
                range = sheet.getRange(iTop, iLeft + i + 1);
                formulaString = new StringBuffer();
                formulaString.append("=Item(\"").append(itemNumber);
                formulaString.append("\",0,0,\"").append(deAmount.getNumber());
                formulaString.append("\",\"MONEY\")");
                itemFormula = new ItemFormula(formulaString.toString());
                range.setUserObject("ITEM", (Object)itemFormula);
                range.setValue(new Variant((Object)(itemName + "(" + deAmount.getName() + ")")));
                range = sheet.getRange(iTop, iLeft + ++i + 1);
                formulaString.setLength(0);
                formulaString.append("=Item(\"").append(itemNumber);
                formulaString.append("\",0,0,\"").append(deYtdamount.getNumber());
                formulaString.append("\",\"MONEY\")");
                itemFormula = new ItemFormula(formulaString.toString());
                range.setUserObject("ITEM", (Object)itemFormula);
                range.setValue(new Variant((Object)(itemName + "(" + deYtdamount.getName() + ")")));
                ++i;
            }
            sheet.getRange(iTop, iLeft + 1, iTop, iLeft + i).setCellLocked(true);
            CslRptUtil.saveBasePosition(sheet, iLeft, iTop);
        }
        finally {
            sheet.getBook().getUndoManager().endGroup();
        }
    }

    private Map getItemControlInRpt(boolean isnew) throws Exception {
        IInvestCheck ic = InvestCheckFactory.getRemoteInstance();
        HashMap map = null;
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isNew", new Boolean(isnew));
        map = ic.getItemControlInRpt(params);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }
}

