/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.template;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;

public class TemplateProcessBookProvider
extends IBookProvider {
    public TemplateProcessBookProvider() {
    }

    public TemplateProcessBookProvider(TemplateInfo entityInfo) {
        this.setEditValue((IObjectValue)entityInfo);
    }

    public Book loadBook() throws Exception {
        Book book = null;
        book = this.getTemplateInfo().getBook();
        if (book == null) {
            return null;
        }
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        RptSheetParamCollection sheetParam = this.getTemplateInfo().getSheetParam();
        RptPeriodTypeEnum periodType = this.getTemplateInfo().getPeriodType();
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            VirtualSheetParamInfo info = p.getReport();
            if (info != null && info instanceof TemplateInfo) {
                ((TemplateInfo)info).setTemplateType(this.getTemplateInfo().getTemplateType());
            }
            ReportVariables sheetV = VariablesHelper.sheetParams2Variables((RptSheetParamInfo)p, (RptPeriodTypeEnum)periodType);
            variables.addAll(sheetV, false);
        }
        properties.restoreToBook(book);
        return book;
    }

    public TemplateInfo getTemplateInfo() {
        return (TemplateInfo)this.getEditValue();
    }

    public void restoreBook(Book book) throws Exception {
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        this.getTemplateInfo().getSheetParam().clear();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo info = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            info.setSheetID(sheet.getID());
            info.setRelaType(ReportTypeEnum.TEMPLATE);
            this.getTemplateInfo().getSheetParam().add(info);
            if (this.getTemplateInfo().getTemplateType() != RptTmpTypeEnum.MANUSCRIPT) continue;
            this.verifyItem(sheet);
        }
        RptUtilForClient.prepareReportInfo4Save((IObjectValue)this.getTemplateInfo(), (Book)book);
        this.getTemplateInfo().setBook(book);
    }

    private void verifyItem(Sheet sheet) {
        int left = CslRptUtil.getBasePosition_Left(sheet);
        int top = CslRptUtil.getBasePosition_Top(sheet);
        int rowCount = sheet.getMaxRowIndex() + 1;
        int combineDataSrcColumn = this.getCombineDataSrcColumn(left, top, sheet);
        if (combineDataSrcColumn != -1) {
            for (int i = top + 1; i < rowCount; ++i) {
                ItemFormula baseItem = (ItemFormula)sheet.getRange(i, left).getUserObject("ITEM");
                ItemFormula combineItem = (ItemFormula)sheet.getRange(i, combineDataSrcColumn).getUserObject("ITEM");
                if (combineItem == null && baseItem != null) {
                    sheet.getRange(i, left).setUserObject("ITEM", (Object)baseItem);
                    continue;
                }
                if (baseItem != null && combineItem != null) {
                    baseItem.setItemNumber(combineItem.getItemNumber());
                    continue;
                }
                if (baseItem != null || combineItem == null) continue;
                ItemFormula tmpFormula = new ItemFormula();
                tmpFormula.setItemNumber(combineItem.getItemNumber());
                sheet.getRange(i, left).setUserObject("ITEM", (Object)tmpFormula);
            }
        }
    }

    private int getCombineDataSrcColumn(int left, int top, Sheet sheet) {
        int result = -1;
        int colCount = sheet.getMaxColIndex() + 1;
        String combineTypeString = Integer.toString(CslDataSrcTypeEnum.COMBINE.getValue());
        for (int i = left; i < colCount; ++i) {
            ItemFormula itemFormula;
            String ext;
            Object object = sheet.getRange(top, i).getUserObject("ITEM");
            if (object == null || !(object instanceof ItemFormula) || !combineTypeString.equals(ext = (itemFormula = (ItemFormula)object).getExt("DataSrc"))) continue;
            result = i;
            break;
        }
        return result;
    }

    public void auditTemplate() throws Exception {
        if (this.getTemplateInfo().getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
            ITemplate it = TemplateFactory.getRemoteInstance();
            if (!it.isLastestVersion(this.getTemplateInfo().getId().toString(), true, false)) {
                MsgBox.showError((String)CslRptUtil.getString("GroupNormalTemplateExistsNewVersion"));
                SysUtil.abort();
            }
            CslRptUIUtil.TempleteUnAudit(this.getTemplateInfo());
            this.setEditValue((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.getTemplateInfo().getId().toString()), this.getSelectors()));
        } else {
            CslRptUIUtil.TempleteAudit((Object)this, this.getTemplateInfo());
            this.getTemplateInfo().setAuditedStatus(AuditedStatusEnum.AUDITED);
        }
    }

    public void auditGroupTemplate(Object owner) throws Exception {
        if (this.getTemplateInfo().getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
            CslRptUIUtil.TempleteUnAudit(this.getTemplateInfo());
            this.setEditValue((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.getTemplateInfo().getId().toString()), this.getSelectors()));
        } else {
            CslRptUIUtil.TempleteAudit(owner, this.getTemplateInfo());
            this.getTemplateInfo().setAuditedStatus(AuditedStatusEnum.AUDITED);
        }
    }

    public IObjectValue createNewReport() {
        return null;
    }

    public ICoreBase getBizInterface() throws Exception {
        return TemplateFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("sumType"));
        sic.add(new SelectorItemInfo("versionStatus"));
        sic.add(new SelectorItemInfo("versionNumber"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.template.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.id"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.name"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.number"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("orgSavePoint.relaType"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("groupTemplate"));
        return sic;
    }

    public String getBizFactoryName() {
        return TemplateFactory.class.getName();
    }
}

